/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.config;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelGlobalParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.TableEntity;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelReadJsonFile;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelCommon;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;

public class DataModelConfig {
    public static final Set<String> changeDateFields = Sets.newHashSet((Object[])new String[]{"FMODIFYTIME", "FCREATETIME", "FMODIFYDATE", "FCREATEDATE", "FENDMODIFYTIME", "FSCOPEMODIFYTIME"});
    public static final Set<String> defaultDateFields = Sets.newHashSet((Object[])new String[]{"FSTARTDATE", "FBEGINDATE", "FENDDATE", "FEFFECTIVEDATE", "FEFFDATE", "FEXPDATE", "FDISABLEDATE", "FSTARTTIME", "FENDTIME", "FINVESTDATE", "FCHANGEDATE", "FBEGINTIME", "FDEADLINE", "FBUDGETDATE", "FDATEOFSTART", "FDATEOFEND", "FAUDITDATE", "FCREATEDATEFIELD", "FMODIFYDATEFIELD", "FRELATIONDATE", "FLASTSYNCDATE", "FSYNCDATE", "FSYNCMODIFYDATE"});
    public static final Set<String> defaultUserFields = Sets.newHashSet((Object[])new String[]{"FCREATORID", "FMODIFIERID", "FCREATERID", "FMODIFIERFIELD", "FCREATER", "FMODIFIER", "FASSIGNERID", "FEXECUTORID", "FENDMODIFIER", "FSCOPEMODIFIER", "FADMIN"});
    public static final Set<String> noUpdateUserFields = Sets.newHashSet((Object[])new String[]{"FCREATORID", "FCREATERID", "FCREATER"});
    public static final Set<String> membertable = Sets.newHashSet((Object[])new String[]{"t_eb_structofent", "t_eb_structofaccount", "t_eb_structoffy", "t_eb_structofperiod", "t_eb_structofbperiod", "t_eb_structofversion", "t_eb_structofcurrency", "t_eb_structofaudittrial", "t_eb_structofchangetype", "t_eb_structoficentity", "t_eb_structofdatetype", "t_eb_structofmetric", "t_eb_structofdefined"});
    private Map<String, String> subTableRelateTables = new HashMap<String, String>(16);
    private Map<String, Set<String>> speicalFormId = new HashMap<String, Set<String>>(16);

    public static DataModelConfig getInstance() {
        return InnerClass.instance;
    }

    private DataModelConfig() {
        this.initGlobalVar();
    }

    public Map<String, String> getSubTableRelateTables() {
        return this.subTableRelateTables;
    }

    public Map<String, Set<String>> getSpeicalFormId() {
        return this.speicalFormId;
    }

    private void initGlobalVar() {
        this.subTableRelateTables.put("t_eb_entitynamerecord", "FENTITYID");
        this.subTableRelateTables.put("t_eb_dimpropertysetting", "FID");
        this.subTableRelateTables.put("t_eb_dimpropertyentry", "FENTRYID");
        this.subTableRelateTables.put("t_eb_analyzeschemecols", "FENTRYID");
        this.subTableRelateTables.put("t_eb_custompropertyvalue", "FID");
        this.subTableRelateTables.put("t_eb_dimensionrelation_e", "FENTRYID");
        this.speicalFormId.put("t_eb_structofbperiod", Sets.newHashSet((Object[])new String[]{"FSTARTDATE", "FENDDATE", "FSYNCDATE"}));
        this.speicalFormId.put("t_eb_structofperiod", Sets.newHashSet((Object[])new String[]{"FSTARTDATE", "FENDDATE"}));
    }

    public String getUniqueFieldKeyNumber(DataModelGlobalParam globlaParams, Object fieldValue, String field, boolean fromDB) {
        Map<Long, String> viewJsonMap = globlaParams.getNumberJsonMap().get("t_eb_dimensionview");
        Map<Long, String> viewDBMap = globlaParams.getNumberDBMap().get("t_eb_dimensionview");
        Map<Long, String> dimenstionJsonMap = globlaParams.getNumberJsonMap().get("t_eb_dimension");
        Map<Long, String> dimenstionDBMap = globlaParams.getNumberDBMap().get("t_eb_dimension");
        Map<Long, String> bizModelJsonMap = globlaParams.getNumberJsonMap().get("t_eb_businessmodel");
        Map<Long, String> bizModelDBMap = globlaParams.getNumberDBMap().get("t_eb_businessmodel");
        String number = "";
        switch (field) {
            case "FVIEWID": {
                number = fromDB ? viewDBMap.get(IDUtils.toLong((Object)fieldValue)) : viewJsonMap.get(IDUtils.toLong((Object)fieldValue));
                break;
            }
            case "FDIMENSIONID": {
                number = fromDB ? dimenstionDBMap.get(IDUtils.toLong((Object)fieldValue)) : dimenstionJsonMap.get(IDUtils.toLong((Object)fieldValue));
                break;
            }
            case "FBIZCTRLRANGEID": 
            case "FBUSINESSMODEL": {
                number = fromDB ? bizModelDBMap.get(IDUtils.toLong((Object)fieldValue)) : bizModelJsonMap.get(IDUtils.toLong((Object)fieldValue));
                break;
            }
            case "FNUMBER": {
                number = fieldValue.toString();
            }
        }
        return number == null ? "" : number.toUpperCase(Locale.getDefault());
    }

    public void initMapFromDB(DataModelGlobalParam globalParams, Long modelID) {
        this.initMapFromDB(globalParams, modelID, "eb_dimensionview", globalParams.getNumberDBMap().computeIfAbsent("t_eb_dimensionview", k -> new HashMap(16)));
        this.initMapFromDB(globalParams, modelID, "eb_businessmodel", globalParams.getNumberDBMap().computeIfAbsent("t_eb_businessmodel", k -> new HashMap(16)));
    }

    private void initMapFromDB(DataModelGlobalParam globalParams, Long modelID, String formId, Map<Long, String> dbMap) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelID);
        DynamicObjectCollection list = QueryServiceHelper.query((String)formId, (String)"id,number", (QFilter[])qFilter.toArray());
        list.forEach(view -> dbMap.put(view.getLong("id"), DataModelUtil.getUpperOrLowerFieldValue(formId, view.getString("number"))));
        dbMap.put(0L, "0");
    }

    public void initMapFromJSON(DataModelGlobalParam globalParams, JSONObject allJsonObject) {
        this.initMapFromJSON(globalParams, allJsonObject, "epm_dimension", "t_eb_dimension");
        this.initMapFromJSON(globalParams, allJsonObject, "eb_dimensionview", "t_eb_dimensionview");
        this.initMapFromJSON(globalParams, allJsonObject, "eb_businessmodel", "t_eb_businessmodel");
    }

    private void initMapFromJSON(DataModelGlobalParam globalParams, JSONObject allJsonObject, String formId, String tableName) {
        JSONArray jsonCurTableAllDatas = DataModelReadJsonFile.getInstance().getTableDatasFromJson(allJsonObject, formId, tableName);
        if (jsonCurTableAllDatas == null) {
            return;
        }
        TableEntity tableEntity = DataModelCommon.getInstance().getTableEntity(tableName, jsonCurTableAllDatas);
        Map globalParamsMap = globalParams.getNumberJsonMap().computeIfAbsent(tableName, k -> new HashMap(16));
        for (Object js : jsonCurTableAllDatas) {
            JSONObject curLineData = (JSONObject)js;
            if (null == curLineData || curLineData.size() <= 0 || curLineData.containsKey((Object)"fathertable")) continue;
            Set<String> columnNames = tableEntity.getColumns();
            Long fid = IDUtils.toLong((Object)DataModelCommon.getInstance().getFieldValueFromJson(curLineData, "FID", columnNames));
            String fnumber = DataModelCommon.getInstance().getFieldValueFromJson(curLineData, "FNUMBER", columnNames);
            globalParamsMap.put(fid, fnumber);
        }
        globalParamsMap.put(0L, "0");
    }

    private static class InnerClass {
        private static DataModelConfig instance = new DataModelConfig();

        private InnerClass() {
        }
    }
}

