/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.controller;

import java.util.HashMap;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.dataModelTrans.controller.DataModelTransportLogController;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelExportRequest;
import kd.epm.eb.formplugin.dataModelTrans.enums.DataModelTransportType;
import kd.epm.eb.formplugin.report.excel.controller.ReportExportDataController;

public class DataModelExportController {
    private static final Log log = LogFactory.getLog(ReportExportDataController.class);

    public static DataModelExportController getInstance() {
        return InnerClass.INSTANCE;
    }

    private DataModelExportController() {
    }

    public void exportModel(DataModelExportRequest dataModelExportRequest, IFormView formView, AbstractFormPlugin abstractFormPlugin, String selectNumber, String selectName) {
        if (dataModelExportRequest == null || formView == null || abstractFormPlugin == null) {
            return;
        }
        Long transportLogId = DataModelTransportLogController.getInstance().createLog(selectNumber, selectName, DataModelTransportType.EXPORT.getCode());
        dataModelExportRequest.setTransportLogId(transportLogId);
        dataModelExportRequest.setSelectModelNumber(selectNumber);
        this.dispatchTask(dataModelExportRequest, formView, abstractFormPlugin);
    }

    private JobInfo createJobInfo(DataModelExportRequest dataModelExportRequest, IFormView formView) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname("kd.epm.eb.formplugin.dataModelTrans.async.task.DataModelExportTask");
        String jobName = ResManager.loadKDString((String)"\u4f53\u7cfb\u5bfc\u51fa", (String)"DataModelExportController_01", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        jobInfo.setName(jobName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setCanStop(Boolean.valueOf(true));
        jobInfo.setFailNotify(true);
        jobInfo.setTimeout(3600);
        jobInfo.setOverTime(true);
        jobInfo.setExecuteTime(3600);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
        jobInfo.setAppId(formView.getFormShowParameter().getServiceAppId());
        jobInfo.setFailNotify(true);
        jobInfo.setSuccessNotify(true);
        HashMap<String, String> customParams = new HashMap<String, String>(16);
        customParams.put("pageId", formView.getPageId());
        customParams.put("appId", formView.getFormShowParameter().getServiceAppId());
        FormConfig formConfig = formView.getFormShowParameter().getFormConfig();
        customParams.put("formConfig", formConfig.getEntityTypeId());
        customParams.put("parentPageId", formView.getFormShowParameter().getPageId());
        customParams.put("rootPageId", formView.getFormShowParameter().getRootPageId());
        customParams.put("dataModelExportRequest", SerializationUtils.serializeToBase64((Object)dataModelExportRequest));
        jobInfo.setParams(customParams);
        return jobInfo;
    }

    private JobFormInfo createJobFormInfo(JobInfo jobInfo, IFormView formView, AbstractFormPlugin abstractFormPlugin) {
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setJobInfo(jobInfo);
        String caption = ResManager.loadKDString((String)"\u4f53\u7cfb\u5bfc\u51fa", (String)"DataModelExportController_01", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        jobFormInfo.setCaption(caption);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setTimeout(3600);
        jobFormInfo.setClickClassName("kd.epm.eb.formplugin.dataModelTrans.async.task.DataModelExportTaskClick");
        jobFormInfo.setCloseCallBack(new CloseCallBack((IFormPlugin)abstractFormPlugin, "dataModelExportTaskAction"));
        jobFormInfo.setParentPageId(formView.getFormShowParameter().getPageId());
        jobFormInfo.setRootPageId(formView.getFormShowParameter().getRootPageId());
        return jobFormInfo;
    }

    private void dispatchTask(DataModelExportRequest dataModelExportRequest, IFormView formView, AbstractFormPlugin abstractFormPlugin) {
        JobInfo jobInfo = this.createJobInfo(dataModelExportRequest, formView);
        JobFormInfo jobFormInfo = this.createJobFormInfo(jobInfo, formView, abstractFormPlugin);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)formView);
    }

    private static class InnerClass {
        private static final DataModelExportController INSTANCE = new DataModelExportController();

        private InnerClass() {
        }
    }
}

