/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.controller;

import java.util.HashMap;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.dataModelTrans.controller.DataModelTransportLogController;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportRequest;
import kd.epm.eb.formplugin.dataModelTrans.enums.DataModelTransportType;

public class DataModelImportController {
    public static DataModelImportController getInstance() {
        return InnerClass.INSTANCE;
    }

    private DataModelImportController() {
    }

    public void importModel(DataModelImportRequest request, IFormView formView, AbstractFormPlugin abstractFormPlugin, String modelNumber, String modelName) {
        if (request == null || formView == null || abstractFormPlugin == null) {
            return;
        }
        Long transportLogId = DataModelTransportLogController.getInstance().createLog(modelNumber, modelName, DataModelTransportType.IMPORT.getCode());
        request.setTransportLogId(transportLogId);
        this.dispatchTask(request, formView, abstractFormPlugin);
    }

    private JobInfo createJobInfo(DataModelImportRequest dataModelImportRequest, IFormView formView) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname("kd.epm.eb.formplugin.dataModelTrans.async.task.DataModelImportTask");
        String jobName = ResManager.loadKDString((String)"\u4f53\u7cfb\u5bfc\u5165", (String)"DataModelImportController_01", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        jobInfo.setName(jobName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setCanStop(Boolean.valueOf(true));
        jobInfo.setFailNotify(true);
        jobInfo.setTimeout(3600);
        jobInfo.setOverTime(true);
        jobInfo.setExecuteTime(3600);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
        jobInfo.setAppId(formView.getFormShowParameter().getServiceAppId());
        HashMap<String, String> customParams = new HashMap<String, String>(16);
        customParams.put("pageId", formView.getPageId());
        customParams.put("appId", formView.getFormShowParameter().getServiceAppId());
        FormConfig formConfig = formView.getFormShowParameter().getFormConfig();
        customParams.put("formConfig", formConfig.getEntityTypeId());
        customParams.put("parentPageId", formView.getFormShowParameter().getPageId());
        customParams.put("rootPageId", formView.getFormShowParameter().getRootPageId());
        customParams.put("dataModelImportRequest", SerializationUtils.serializeToBase64((Object)dataModelImportRequest));
        jobInfo.setParams(customParams);
        return jobInfo;
    }

    private JobFormInfo createJobFormInfo(JobInfo jobInfo, IFormView formView, AbstractFormPlugin abstractFormPlugin) {
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setJobInfo(jobInfo);
        String caption = ResManager.loadKDString((String)"\u4f53\u7cfb\u5bfc\u5165", (String)"DataModelImportController_01", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        jobFormInfo.setCaption(caption);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setTimeout(3600);
        jobFormInfo.setClickClassName("kd.epm.eb.formplugin.dataModelTrans.async.task.DataModelExportTaskClick");
        jobFormInfo.setCloseCallBack(new CloseCallBack((IFormPlugin)abstractFormPlugin, "dataModelImportTaskAction"));
        jobFormInfo.setParentPageId(formView.getFormShowParameter().getPageId());
        jobFormInfo.setRootPageId(formView.getFormShowParameter().getRootPageId());
        return jobFormInfo;
    }

    private void dispatchTask(DataModelImportRequest dataModelImportRequest, IFormView formView, AbstractFormPlugin abstractFormPlugin) {
        JobInfo jobInfo = this.createJobInfo(dataModelImportRequest, formView);
        JobFormInfo jobFormInfo = this.createJobFormInfo(jobInfo, formView, abstractFormPlugin);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)formView);
    }

    private static class InnerClass {
        public static final DataModelImportController INSTANCE = new DataModelImportController();

        private InnerClass() {
        }
    }
}

