/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.exportmodel.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.constant.DataModelConstant;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelExportParam;
import kd.epm.eb.formplugin.dataModelTrans.enums.OutputTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.exportmodel.service.DataModelGlobalVar;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.DMSpecialFieldExport;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub.DMMainSubExportJsonService;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelMetaDataFields;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class DataModelExportJsonService {
    protected DataModelExportParam dmParam;
    protected Map<String, Set<Long>> baseDataMap;
    private static Log log = LogFactory.getLog(DataModelExportJsonService.class);
    private ConcurrentHashMap<String, Map<String, JSONArray>> cacheAlreadyQueryDatas;

    public JSONObject getModelJson(DataModelExportParam dmParam) {
        return this.getJsonObject(dmParam, Boolean.FALSE);
    }

    private void iniGlobalParams() {
        if (this.baseDataMap == null) {
            this.baseDataMap = new ConcurrentHashMap<String, Set<Long>>(16);
        }
        if (this.cacheAlreadyQueryDatas == null) {
            this.cacheAlreadyQueryDatas = new ConcurrentHashMap(16);
        }
    }

    public JSONObject getJsonObject(DataModelExportParam dmParam, Boolean isRedim) {
        this.dmParam = dmParam;
        return this.doExportJson(isRedim);
    }

    private Map<String, Set<Long>> reDimFilterNoThread(DataModelExportParam dmParam) {
        this.dmParam = dmParam;
        List<String> dimFromId = DataModelTransEnum.getAllMainTableFormID(dmParam.getExportType().getCode());
        Map<String, Set<Long>> filterMap = dmParam.getFilterMaps();
        this.baseDataMap = new HashMap<String, Set<Long>>(16);
        for (String formid : dimFromId) {
            if (filterMap == null || filterMap.size() == 0) continue;
            String fieldName = DataModelTransEnum.getModelFilterNameByFormId(formid);
            this.dimDataToJson(formid, fieldName, filterMap.get(formid), true);
        }
        return this.baseDataMap;
    }

    public Map<String, Set<Long>> reDimFilter(DataModelExportParam dmParam) {
        if (dmParam.isUseMultiThread()) {
            return this.reDimFilterThread(dmParam);
        }
        return this.reDimFilterNoThread(dmParam);
    }

    private Map<String, Set<Long>> reDimFilterThread(DataModelExportParam dmParam) {
        this.dmParam = dmParam;
        this.iniGlobalParams();
        Map<String, Set<Long>> filterMap = dmParam.getFilterMaps();
        List<String> dimFromIds = DataModelTransEnum.getAllMainTableFormID(dmParam.getExportType().getCode());
        CountDownLatch latch = new CountDownLatch(dimFromIds.size());
        for (String formid : dimFromIds) {
            EpmThreadPools.CommPools.submit(() -> {
                try {
                    if (filterMap != null && filterMap.size() != 0) {
                        String fieldName = DataModelTransEnum.getModelFilterNameByFormId(formid);
                        this.dimDataToJson(formid, fieldName, (Set)filterMap.get(formid), true);
                    }
                }
                catch (Exception e) {
                    log.error(String.format("export_Form_reDimFilter[%s]_error!", formid), (Throwable)e);
                }
                finally {
                    latch.countDown();
                }
                return "";
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("export_Form_reDimFilter_interrupted!", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        return this.baseDataMap;
    }

    protected JSONObject doExportJson(Boolean isRedim) {
        if (this.dmParam.isUseMultiThread()) {
            return this.doExportJsonThread(isRedim);
        }
        return this.doExportJsonNoThread(isRedim);
    }

    private JSONObject doExportJsonNoThread(Boolean isRedim) {
        List<String> dimFromId = DataModelTransEnum.getAllMainTableFormID(this.dmParam.getExportType().getCode());
        if (this.baseDataMap == null) {
            this.baseDataMap = new HashMap<String, Set<Long>>(16);
        }
        JSONObject out_jsonData = new JSONObject(new LinkedHashMap(3 * DataModelConstant.ARRAYDEFAULTSIZE));
        for (String formid : dimFromId) {
            boolean partialFilter = this.dmParam.getExportType().isPartial();
            if (partialFilter && (this.dmParam.getFilterMaps() == null || this.dmParam.getFilterMaps().size() == 0) && !this.isNeedAllTransForm(formid) || this.dmParam.getExportType() != OutputTypeEnum.MAINSUB_TRANSPORT && DataModelTransEnum.mainsubmodelbase.getFormID().equalsIgnoreCase(formid)) continue;
            String fieldName = DataModelTransEnum.getModelFilterNameByFormId(formid);
            JSONObject strJson = this.dimDataToJson(formid, fieldName, partialFilter ? this.dmParam.getFilterMaps().get(formid) : null, isRedim);
            out_jsonData.put(formid, (Object)strJson);
        }
        return out_jsonData;
    }

    private JSONObject doExportJsonThread(Boolean isRedim) {
        this.iniGlobalParams();
        JSONObject returns = new JSONObject(new LinkedHashMap(3 * DataModelConstant.ARRAYDEFAULTSIZE));
        List<String> dimFromIds = DataModelTransEnum.getAllMainTableFormID(this.dmParam.getExportType().getCode());
        ConcurrentHashMap tempJson = new ConcurrentHashMap(3 * dimFromIds.size());
        CountDownLatch latch = new CountDownLatch(dimFromIds.size());
        for (String string : dimFromIds) {
            EpmThreadPools.CommPools.submit(() -> {
                try {
                    JSONObject jsonSingleForm = this.doExportJsonSingleForm(isRedim, formid);
                    if (jsonSingleForm != null) {
                        tempJson.put(formid, jsonSingleForm);
                    }
                }
                catch (Exception e) {
                    log.error(String.format("export_Form_doExportJson[%s]_error!", formid), (Throwable)e);
                    throw e;
                }
                finally {
                    latch.countDown();
                }
                return "";
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("export_Form_doExportJson_interrupted!", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        for (Map.Entry entry : tempJson.entrySet()) {
            returns.put((String)entry.getKey(), entry.getValue());
            tempJson.remove(entry.getKey());
        }
        return returns;
    }

    protected JSONObject doExportJsonSingleForm(Boolean isRedim, String formid) {
        boolean partialFilter = this.dmParam.getExportType().isPartial();
        if (partialFilter && (this.dmParam.getFilterMaps() == null || this.dmParam.getFilterMaps().size() == 0) && !this.isNeedAllTransForm(formid)) {
            return null;
        }
        if (this.dmParam.getExportType() != OutputTypeEnum.MAINSUB_TRANSPORT && DataModelTransEnum.mainsubmodelbase.getFormID().equalsIgnoreCase(formid)) {
            return null;
        }
        String fieldName = DataModelTransEnum.getModelFilterNameByFormId(formid);
        return this.dimDataToJson(formid, fieldName, partialFilter ? this.dmParam.getFilterMaps().get(formid) : null, isRedim);
    }

    protected boolean isNeedAllTransForm(String formid) {
        return false;
    }

    protected Set<Long> getFilterSetByJson(String fieldName, JSONArray jsonArr) {
        HashSet<Long> ids = new HashSet<Long>(16);
        jsonArr.stream().forEach(obj -> {
            JSONObject js = (JSONObject)obj;
            if (!js.containsKey((Object)"fathertable")) {
                Long value = js.getLong(fieldName);
                ids.add(value);
            }
        });
        return ids;
    }

    private JSONArray doCache(String formid, String fieldName, String tableName, Set<Long> filterSet, boolean isRedim) {
        String fieldCacheKey = filterSet != null ? String.join((CharSequence)"_", fieldName, String.join((CharSequence)"-", IDUtils.toStringCollection(filterSet))) : fieldName;
        JSONArray jsonArr = null;
        if (this.dmParam.isUseMultiThread()) {
            Map cacheKeyJson = this.cacheAlreadyQueryDatas.computeIfAbsent(tableName, k -> new HashMap(16));
            jsonArr = (JSONArray)cacheKeyJson.get(fieldCacheKey);
            if (jsonArr == null) {
                jsonArr = this.getJsonByTable(formid, tableName, fieldName, tableName, fieldName, Collections.singleton(this.dmParam.getModelid()), filterSet, isRedim);
                cacheKeyJson.put(fieldCacheKey, jsonArr);
            }
        } else {
            jsonArr = DataModelGlobalVar.getJsonArray(tableName, fieldCacheKey);
            if (jsonArr == null) {
                jsonArr = this.getJsonByTable(formid, tableName, fieldName, tableName, fieldName, Collections.singleton(this.dmParam.getModelid()), filterSet, isRedim);
                DataModelGlobalVar.setJsonArray(tableName, fieldCacheKey, jsonArr);
            }
        }
        return jsonArr;
    }

    protected JSONObject dimDataToJson(String formid, String fieldName, Set<Long> filterSet, boolean isRedim) {
        boolean isReturn;
        formid = formid == null ? "" : formid;
        boolean filterIsEmpty = filterSet == null || filterSet.size() == 0;
        boolean bl = isReturn = isRedim && filterIsEmpty && !this.isNeedAllTransForm(formid);
        if (isReturn) {
            return null;
        }
        if (this.dmParam.getExportType().isPartial() && filterIsEmpty && !this.isNeedAllTransForm(formid)) {
            return null;
        }
        log.info("export_Form:" + formid);
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)formid);
        }
        catch (Exception e) {
            throw new KDBizException(formid + " does not exist.");
        }
        String tableName = dynamicObject.getDataEntityType().getAlias();
        if (null == tableName || isRedim && !DataModelUtil.isMainTable(tableName).booleanValue()) {
            return null;
        }
        log.info(StringUtils.join((Object[])new String[]{"export_Form_beginQeryData:", formid, "_", tableName}));
        JSONArray jsonArr = this.doCache(formid, fieldName, tableName, filterSet, isRedim);
        if (jsonArr.size() <= 0) {
            return null;
        }
        JSONObject jsonObject = new JSONObject(new LinkedHashMap(DataModelConstant.ARRAYDEFAULTSIZE));
        String FID = DataModelTransEnum.getFIDName(tableName);
        Set<Long> valueSet = this.LoopFormFields(jsonObject, dynamicObject, jsonArr, FID, formid, tableName, isRedim);
        if (valueSet != null && !valueSet.isEmpty()) {
            this.putSecondTableRecord(tableName, valueSet, jsonObject, isRedim);
        }
        log.info("export_Form:end" + formid);
        return jsonObject;
    }

    protected Set<Long> LoopFormFields(JSONObject jsonObject_out, DynamicObject dynamicObject, JSONArray jsonArr, String fieldName, String formid, String tableName, Boolean isRedim) {
        Set<Long> valueSet = this.getFilterSetByJson(fieldName, jsonArr);
        if (isRedim.booleanValue()) {
            this.putBaseDataMap(formid, valueSet);
        } else {
            jsonObject_out.put(tableName.toLowerCase(), (Object)jsonArr);
        }
        DataEntityPropertyCollection dataEntityPropertyCollection = dynamicObject.getDataEntityType().getProperties();
        for (IDataEntityProperty iDataEntityProperty : dataEntityPropertyCollection) {
            if (this.isNoNeedQuery(tableName, iDataEntityProperty.getName())) continue;
            if (!isRedim.booleanValue() && iDataEntityProperty instanceof DynamicLocaleProperty) {
                this.putMultiLangeField(formid, tableName, iDataEntityProperty, valueSet, jsonObject_out, isRedim);
            }
            if (iDataEntityProperty instanceof MulBasedataProp) {
                if (!isRedim.booleanValue()) {
                    this.putMultiBaseField(formid, tableName, iDataEntityProperty, valueSet, jsonObject_out, isRedim);
                }
                if (isRedim.booleanValue()) {
                    this.doRedimFilter(iDataEntityProperty, jsonArr, Boolean.TRUE);
                }
            }
            if (iDataEntityProperty instanceof EntryProp) {
                this.putSubEntryField(formid, tableName, iDataEntityProperty, valueSet, jsonObject_out, isRedim);
            }
            if (!isRedim.booleanValue() || !(iDataEntityProperty instanceof BasedataProp)) continue;
            this.doRedimFilter(iDataEntityProperty, jsonArr, Boolean.FALSE);
        }
        return valueSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRedimFilter(IDataEntityProperty iDataEntityProperty, JSONArray jsonArr, Boolean isMultBaseField) {
        Long next;
        Map<String, String> fieldInfoMap = DataModelMetaDataFields.getInstance().getFieldInfoMap(iDataEntityProperty, isMultBaseField);
        if (fieldInfoMap == null || fieldInfoMap.size() == 0) {
            return;
        }
        String filterFieldName = DataModelTransEnum.getFIDName(fieldInfoMap.get("tablename"));
        String contactFieldName = isMultBaseField != false ? filterFieldName : fieldInfoMap.get("fielddbname");
        Set<Long> valueSet = this.getFilterSetByJson(contactFieldName, jsonArr);
        if (CollectionUtils.isEmpty(valueSet)) {
            return;
        }
        if (valueSet.size() == 1 && ((next = valueSet.iterator().next()) == null || "0".equals(next.toString()))) {
            return;
        }
        if (isMultBaseField.booleanValue()) {
            SqlBuilder sqlWhere = new SqlBuilder();
            sqlWhere.append(" select FBASEDATAID from ", new Object[0]).append(fieldInfoMap.get("fielddbname"), new Object[0]).append(" where ", new Object[0]).appendIn(filterFieldName, IDUtils.toLongs(valueSet).toArray());
            valueSet.clear();
            DataSet result = DB.queryDataSet((String)DMMainSubExportJsonService.class.getName(), (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlWhere);
            if (result.hasNext()) {
                try {
                    while (result.hasNext()) {
                        Row rowData = result.next();
                        valueSet.add(rowData.getLong("FBASEDATAID"));
                    }
                }
                finally {
                    result.close();
                }
            }
        }
        this.dimDataToJson(fieldInfoMap.get("fieldtype"), filterFieldName, valueSet, true);
    }

    private void putBaseDataMap(String formId, Set<Long> value) {
        Set<Long> entrySet = this.baseDataMap.get(formId);
        if (entrySet != null) {
            entrySet.addAll(value);
        } else {
            this.baseDataMap.put(formId, value);
        }
    }

    protected void putSecondTableRecord(String tableName, Set<Long> ids, JSONObject out_jsonObject, boolean isRedim) {
        Set<String> secondTableSet = DataModelTransEnum.getSecendTableByMainTable(tableName);
        if (secondTableSet == null || secondTableSet.size() == 0) {
            return;
        }
        for (String secondTable : secondTableSet) {
            String ralationField = DataModelTransEnum.getRelationFieldByTableName(secondTable);
            String formid = DataModelTransEnum.getFormIDByTableName(secondTable);
            log.info(StringUtils.join((Object[])new String[]{"export_Form_SecondTable:", formid, "_", secondTable}));
            if (isRedim) {
                this.dimDataToJson(formid, ralationField, ids, true);
            } else {
                JSONArray jsonArrmulti = this.getJsonByTable(formid, tableName, "FID", secondTable, ralationField, ids, null, isRedim);
                if (jsonArrmulti.size() > 0) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)formid);
                    this.LoopFormFields(out_jsonObject, dynamicObject, jsonArrmulti, "FID", formid, secondTable, isRedim);
                }
            }
            log.info(StringUtils.join((Object[])new String[]{"export_Form_SecondTable_end:", formid, "_", secondTable}));
        }
    }

    private void putJsonObject(String formid, String fatherTableName, String tableLias, Set<Long> ids, JSONObject jsonObject, boolean isRedim) {
        JSONArray jsonArrmulti = this.getJsonByTable(formid, fatherTableName, "FID", tableLias, "FID", ids, null, isRedim);
        jsonObject.put(tableLias.toLowerCase(), (Object)jsonArrmulti);
    }

    private void putMultiLangeField(String formid, String fatherTableName, IDataEntityProperty iDataEntityProperty, Set<Long> ids, JSONObject jsonObject, boolean isRedim) {
        String multialias = ((DynamicLocaleProperty)iDataEntityProperty).getItemType().getAlias();
        this.putJsonObject(formid, fatherTableName, multialias, ids, jsonObject, isRedim);
    }

    private void putMultiBaseField(String formid, String fatherTableName, IDataEntityProperty iDataEntityProperty, Set<Long> ids, JSONObject jsonObject, boolean isRedim) {
        String multialias = ((MulBasedataProp)iDataEntityProperty).getItemType().getAlias();
        if (multialias != null) {
            this.putJsonObject(formid, fatherTableName, multialias, ids, jsonObject, isRedim);
        }
    }

    private void putSubEntryField(String formid, String fatherTableName, IDataEntityProperty iDataEntityProperty, Set<Long> ids, JSONObject jsonObject, Boolean isRedim) {
        String alias = ((EntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType().getAlias();
        if (StringUtils.isEmpty((CharSequence)alias)) {
            return;
        }
        Set<Object> fentryids = new HashSet(ids.size());
        JSONArray jsonArrentry = this.getJsonByTable(formid, fatherTableName, "FID", alias, "FID", ids, null, isRedim);
        if (jsonArrentry.size() <= 0) {
            return;
        }
        String fentryIdName = null;
        List columnNames = DB.getColumnNames((DBRoute)BgFormConstant.DBROUTE, (String)alias);
        if (columnNames.contains("FENTRYID") || columnNames.contains("fentryid")) {
            fentryIdName = "FENTRYID";
            fentryids = this.getFilterSetByJson("FENTRYID", jsonArrentry);
        }
        if (columnNames.contains("FENTITYID") || columnNames.contains("fentityid")) {
            fentryIdName = "FENTITYID";
            fentryids = this.getFilterSetByJson("FENTITYID", jsonArrentry);
        }
        if (!isRedim.booleanValue()) {
            jsonObject.put(alias.toLowerCase(), (Object)jsonArrentry);
        }
        DataEntityPropertyCollection entryCollection = ((EntryProp)iDataEntityProperty).getItemType().getProperties();
        for (IDataEntityProperty entry : entryCollection) {
            JSONArray jsonArrentrymulti;
            String entitymultialias;
            if (!isRedim.booleanValue() && entry instanceof DynamicLocaleProperty && StringUtils.isNotEmpty((CharSequence)(entitymultialias = ((DynamicLocaleProperty)entry).getItemType().getAlias()))) {
                jsonArrentrymulti = this.getJsonByTable(formid, alias.toLowerCase(), fentryIdName, entitymultialias, fentryIdName, fentryids, null, isRedim);
                jsonObject.put(entitymultialias.toLowerCase(), (Object)jsonArrentrymulti);
            }
            if (entry instanceof SubEntryProp) {
                HashSet<Long> fdetailids = new HashSet<Long>(fentryids.size());
                String subentryAlias = ((SubEntryProp)entry).getItemType().getAlias();
                JSONArray jsonArrentrySub = this.getJsonByTable(formid, alias.toLowerCase(), fentryIdName, subentryAlias, "FENTRYID", fentryids, null, isRedim);
                jsonArrentrySub.stream().forEach(obj -> {
                    JSONObject js = (JSONObject)obj;
                    Long value = js.getLong("FDETAILID");
                    fdetailids.add(value);
                });
                jsonObject.put(subentryAlias, (Object)jsonArrentrySub);
                DataEntityPropertyCollection subCols = ((SubEntryProp)entry).getItemType().getProperties();
                for (IDataEntityProperty col : subCols) {
                    if (!isRedim.booleanValue() && col instanceof DynamicLocaleProperty) {
                        String submultialias = ((DynamicLocaleProperty)col).getItemType().getAlias();
                        JSONArray jsonArrentrySubmulti = this.getJsonByTable(formid, alias.toLowerCase(), fentryIdName, submultialias, "FDETAILID", fdetailids, null, isRedim);
                        jsonObject.put(submultialias.toLowerCase(), (Object)jsonArrentrySubmulti);
                    }
                    if (!isRedim.booleanValue() || !(col instanceof BasedataProp)) continue;
                    this.doRedimFilter(col, jsonArrentrySub, Boolean.FALSE);
                }
            }
            if (entry instanceof MulBasedataProp && DataModelTransEnum.epm_dimensionrelation.getFormID().equals(formid) && StringUtils.isNotEmpty((CharSequence)(entitymultialias = ((MulBasedataProp)entry).getItemType().getAlias()))) {
                jsonArrentrymulti = this.getJsonByTable(formid, alias.toLowerCase(), fentryIdName, entitymultialias, fentryIdName, fentryids, null, isRedim);
                jsonObject.put(entitymultialias.toLowerCase(), (Object)jsonArrentrymulti);
            }
            if (!isRedim.booleanValue() || !(entry instanceof BasedataProp)) continue;
            this.doRedimFilter(entry, jsonArrentry, Boolean.FALSE);
        }
    }

    private void putJsonHead(JSONArray array, String fatherTableName, String fatherRelationField) {
        JSONObject jsonObjHead = new JSONObject(new LinkedHashMap(3));
        jsonObjHead.put("fathertable", (Object)fatherTableName.toLowerCase());
        jsonObjHead.put("fatherrelationfield", (Object)fatherRelationField.toUpperCase());
        array.add((Object)jsonObjHead);
    }

    private JSONArray resultSetToJsonArry(String fatherTableName, String fatherRelationField, String table, DataSet result) {
        JSONArray array = new JSONArray();
        this.putJsonHead(array, fatherTableName, fatherRelationField);
        while (result.hasNext()) {
            int rowDataCount;
            int columnCount;
            JSONObject jsonObj = new JSONObject(new LinkedHashMap(16));
            Row rowData = result.next();
            RowMeta row = result.getRowMeta();
            String checkInfo = DMSpecialFieldExport.getInstance().checkDataIsValid(table, rowData);
            if (!StringUtils.isEmpty((CharSequence)checkInfo)) {
                throw new KDBizException(checkInfo);
            }
            if (DMSpecialFieldExport.getInstance().isSkipLine(table, rowData, this.dmParam) || (columnCount = row.getFieldCount()) != (rowDataCount = rowData.size())) continue;
            for (int i = 0; i < columnCount; ++i) {
                String field = row.getFieldName(i).toUpperCase();
                String value = rowData.getString(i);
                if (value == null) {
                    value = "";
                }
                jsonObj.put(field, (Object)value);
            }
            array.add((Object)jsonObj);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONArray getJsonByTable(String formId, String fatherTableName, String fatherRelationField, String table, String whereField, Set<Long> filterParams, Set<Long> filterSet, boolean isRedim) {
        ArrayList filterParamsList = new ArrayList(16);
        int index = 0;
        int partSize = 200000;
        HashSet<Long> filterParamsTemp = new HashSet<Long>(16);
        filterParamsList.add(filterParamsTemp);
        for (Long filterParam : filterParams) {
            if (index < partSize) {
                filterParamsTemp.add(filterParam);
            } else {
                index = 0;
                filterParamsTemp = new HashSet(16);
                filterParamsTemp.add(filterParam);
                filterParamsList.add(filterParamsTemp);
            }
            ++index;
        }
        JSONArray jsonArr = new JSONArray();
        List columnNames = DB.getColumnNames((DBRoute)BgFormConstant.DBROUTE, (String)table);
        log.info(StringUtils.join((Object[])new String[]{"export_Form_beginQeryData_sql:", formId, "_", table}));
        String selectFields = String.join((CharSequence)",", columnNames).toUpperCase();
        for (Set set : filterParamsList) {
            SqlBuilder sqlWhere = this.getWhereCondition(formId, selectFields, table, whereField, set, filterSet, isRedim);
            String whereStringSpecial = this.getSpecialFilter(table);
            if (!whereStringSpecial.isEmpty()) {
                sqlWhere.append(" and " + whereStringSpecial, new Object[0]);
            }
            SqlBuilder sqlB = new SqlBuilder();
            sqlB.append("select ", new Object[0]).append(selectFields, new Object[0]).append(" from ", new Object[0]).append(table, new Object[0]).appendSqlBuilder(sqlWhere);
            if (columnNames.contains("FLEVEL")) {
                sqlB.append(" order by flevel ", new Object[0]);
            }
            log.info(StringUtils.join((Object[])new String[]{"export_Form_beginQeryData_sql_query:", formId, "_", table}));
            DataSet result = this.queryDataSet(sqlB);
            log.info(StringUtils.join((Object[])new String[]{"export_Form_beginQeryData_sql_query_end:", formId, "_", table}));
            if (!result.hasNext()) continue;
            try {
                log.info(StringUtils.join((Object[])new String[]{"export_Form_beginQeryData_sql_ToJson:", formId, "_", table}));
                JSONArray jsonArrTemp = this.resultSetToJsonArry(fatherTableName, fatherRelationField, table, result);
                jsonArr.addAll((Collection)jsonArrTemp);
                log.info(StringUtils.join((Object[])new String[]{"export_Form_beginQeryData_sql_ToJson_end:", formId, "_", table}));
            }
            finally {
                result.close();
            }
        }
        return jsonArr;
    }

    private DataSet queryDataSet(SqlBuilder sqlB) {
        return DB.queryDataSet((String)DataModelExportJsonService.class.getName(), (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlB);
    }

    private void doRedimFilter(String formId, String filterField, Set<Long> filterSet, SqlBuilder sqlWhere, boolean isRedim) {
        if (filterSet == null || filterSet.size() == 0) {
            return;
        }
        this.addWhere2SqlWhere(formId, filterField, filterSet, sqlWhere);
    }

    private SqlBuilder getWhereCondition(String formId, String selectFields, String tableName, String fieldName, Set<Long> filterParams, Set<Long> filterSet, boolean isRedim) {
        SqlBuilder sqlWhere = new SqlBuilder();
        sqlWhere.append(" where 1 = 1 ", new Object[0]);
        String fidName = fieldName;
        if (StringUtils.isEmpty((CharSequence)fieldName) && DataModelUtil.isMainTable(tableName).booleanValue()) {
            return sqlWhere;
        }
        if ((OutputTypeEnum.ALL == this.dmParam.getExportType() || OutputTypeEnum.BIZMODEL == this.dmParam.getExportType() || OutputTypeEnum.PARTIAL_MAINSUB == this.dmParam.getExportType()) && DataModelTransEnum.dimensionviewgroup.getTableName().equals(tableName)) {
            return sqlWhere.append(" and " + DataModelTransEnum.dimensionviewgroup.getFilterModelField() + " = ? ", new Object[]{this.dmParam.getModelid()});
        }
        if (DataModelUtil.isMainTable(tableName).booleanValue()) {
            fidName = DataModelTransEnum.getFIDName(tableName);
            boolean empty = this.checkIsEmpty(formId, filterSet);
            if (!empty) {
                this.doRedimFilter(formId, fidName, filterSet, sqlWhere, isRedim);
            }
            this.getTableFilter(tableName, sqlWhere);
            String modelFilterName = DataModelTransEnum.getModelFilterNameByTableName(tableName);
            if (empty || modelFilterName.equalsIgnoreCase(fieldName)) {
                sqlWhere.append(" and " + fieldName + " = " + filterParams.iterator().next(), new Object[0]);
            }
            return sqlWhere;
        }
        if (filterParams != null && filterParams.size() > 1) {
            if (selectFields.contains(fieldName.toUpperCase())) {
                this.addWhere2SqlWhere(formId, fieldName, filterParams, sqlWhere);
                this.doRedimFilter(formId, fieldName, filterSet, sqlWhere, isRedim);
            } else {
                this.addWhere2SqlWhere(formId, "fentityid", filterParams, sqlWhere);
                this.doRedimFilter(formId, "fentityid", filterSet, sqlWhere, isRedim);
            }
        } else if (filterParams != null && filterParams.size() == 1) {
            if (selectFields.contains(fieldName.toUpperCase())) {
                this.addWhere2SqlWhere(formId, fieldName, filterParams, sqlWhere);
                this.doRedimFilter(formId, fieldName, filterSet, sqlWhere, isRedim);
            } else {
                this.addWhere2SqlWhere(formId, "fentityid", filterParams, sqlWhere);
                this.doRedimFilter(formId, "fentityid", filterSet, sqlWhere, isRedim);
            }
        }
        this.getTableFilter(tableName, sqlWhere);
        if (isRedim) {
            this.getSelectedScopeFilter(formId, tableName, sqlWhere, filterSet);
        }
        return sqlWhere;
    }

    private boolean checkIsEmpty(String formId, Set<Long> filterSet) {
        Long next;
        boolean empty = CollectionUtils.isEmpty(filterSet);
        if (empty) {
            return empty;
        }
        return filterSet.size() == 1 && ((next = filterSet.iterator().next()) == null || "0".equals(next.toString()));
    }

    private void addWhere2SqlWhere(String formId, String fieldName, Set<Long> filterValue, SqlBuilder sqlWhere) {
        if (filterValue == null || filterValue.size() == 0 || filterValue.iterator().next() == null) {
            return;
        }
        if (filterValue.size() > 1) {
            sqlWhere.append(" and ", new Object[0]).appendIn(fieldName, filterValue.toArray());
        } else {
            sqlWhere.append(" and ", new Object[0]).append(fieldName + " = '" + filterValue.iterator().next() + "'", new Object[0]);
        }
    }

    private void getSelectedScopeFilter(String formId, String tableName, SqlBuilder sqlWhere, Set<Long> filterSet) {
        if (filterSet == null || filterSet.size() == 0) {
            return;
        }
        if (filterSet == null || filterSet.size() == 0) {
            return;
        }
        String fid = DataModelTransEnum.getFIDName(tableName.toLowerCase());
        sqlWhere.append(" and ", new Object[0]).appendIn(fid, filterSet.toArray());
    }

    protected void getTableFilter(String tableName, SqlBuilder sqlWhere) {
        String filterCondition = DataModelTransEnum.getFilterConditionByTableName(tableName);
        if (filterCondition == null || filterCondition.length() == 0) {
            return;
        }
        sqlWhere.append(" and " + filterCondition, new Object[0]);
    }

    protected String getSpecialFilter(String table) {
        return DMSpecialFieldExport.getInstance().getSpeicalFilterStr(table, this.dmParam);
    }

    protected boolean isNoNeedQuery(String table, String ormFieldName) {
        return false;
    }
}

