/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.exportmodel.service;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.utils.compress.CompressUtils;
import kd.epm.eb.formplugin.dataModelTrans.async.task.DataModelExportTask;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelExportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelExportRequest;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportResult;
import kd.epm.eb.formplugin.dataModelTrans.enums.ImportModelTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.enums.OutputTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.exportmodel.service.DataModelExportJsonService;
import kd.epm.eb.formplugin.dataModelTrans.exportmodel.service.DataModelGlobalVar;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportDetail;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelReadJsonFile;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelCommon;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;

public class DataModelExportMain {
    private static Log log = LogFactory.getLog(DataModelExportMain.class);
    private DataModelExportTask abstractTask;

    public DataModelImportResult dataModelExport(DataModelExportParam dmParam) {
        Map<String, Set<Long>> modelMap = dmParam.getFilterMaps();
        Long modelId = dmParam.getModelid();
        if (modelMap != null && modelMap.size() > 0) {
            DataModelExportJsonService dataTransObj = new DataModelExportJsonService();
            Map<String, Set<Long>> redimFilterMap = dataTransObj.reDimFilter(dmParam);
            this.viewMemberHandler(modelId, redimFilterMap);
            dmParam.setFilterMaps(redimFilterMap);
            return this.doExport(dmParam);
        }
        return this.doExport(dmParam);
    }

    private DataModelImportResult doExport(DataModelExportParam dmParam) {
        DataModelExportJsonService dataTransObj = new DataModelExportJsonService();
        JSONObject json = dataTransObj.getModelJson(dmParam);
        DataModelUtil.doLog("export_Form_Finish_begin_checkDataValiad:" + dmParam.getModelNumber(), log);
        DataModelImportResult result = this.checkDataValiad(dmParam, json);
        DataModelUtil.doLog("export_Form_Finish_end_checkDataValiad:" + dmParam.getModelNumber(), log);
        String url = "";
        if (!dmParam.isBreakOutput() || result.getTipInfos().size() <= 0) {
            String encodeToString;
            if (dmParam.isUseEncry()) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    String jsonStr = objectMapper.writeValueAsString((Object)json);
                    url = DataModelCommon.getInstance().downloadJsonFile(CompressUtils.get().compressByDeflater((Object)jsonStr), dmParam.getModelNumber());
                }
                catch (JsonProcessingException e) {
                    throw new KDBizException(e.getMessage());
                }
            }
            try {
                DataModelUtil.doLog("export_Form_Finish_begin_serializeToBase64:" + dmParam.getModelNumber(), log);
                encodeToString = SerializationUtils.serializeToBase64((Object)json.toJSONString());
                DataModelUtil.doLog("export_Form_Finish_begin_serializeToBase64_end:" + dmParam.getModelNumber(), log);
            }
            catch (Exception e) {
                result.setHasErrorData(true);
                result.getTipInfos().add(String.join((CharSequence)"|", "Service.DataModelExportMain.doExport", e.getMessage()));
                return result;
            }
            url = DataModelCommon.getInstance().downloadJsonFile(encodeToString, dmParam.getModelNumber());
            DataModelUtil.doLog("export_Form_Finish_downloadJsonFile:" + dmParam.getModelNumber(), log);
        }
        result.setOutFileUrl(url);
        return result;
    }

    public DataModelExportMain(DataModelExportTask abstractTask) {
        this.abstractTask = abstractTask;
    }

    public DataModelExportMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataModelImportResult exportMainSubModel(DataModelExportRequest dataModelExportRequest) throws IOException {
        String url;
        DataModelImportResult result;
        block75: {
            boolean mkdirs;
            result = new DataModelImportResult();
            if (dataModelExportRequest == null) {
                DataModelUtil.doLog("exportMainSubModel dataModelExportRequest is null,", log);
                return result;
            }
            List<DataModelExportParam> dataModelExportParamList = dataModelExportRequest.getDataModelExportParamList();
            if (CollectionUtils.isEmpty(dataModelExportParamList)) {
                DataModelUtil.doLog("exportMainSubModel dataModelExportParamList is null,", log);
                return result;
            }
            ArrayList<String> tempFileNameList = new ArrayList<String>(16);
            long timeStamp = TimeServiceHelper.getTimeStamp();
            int size = dataModelExportParamList.size();
            int progressIndex = 1;
            int progressSize = 2 * size;
            int index = 1;
            url = null;
            File directoryFile = new File(DataModelReadJsonFile.export_temp_file_prefix, FilenameUtils.getName((String)(timeStamp + "")));
            if (!directoryFile.exists() && !(mkdirs = directoryFile.mkdirs())) {
                DataModelUtil.doLog("export mkdir is failed.", log);
            }
            try {
                ArrayList<String> hasErrorDataModelNumbers = new ArrayList<String>(16);
                HashSet<String> hasWriteFileNames = new HashSet<String>(16);
                String firstModelNumber = dataModelExportRequest.getSelectModelNumber();
                for (DataModelExportParam dataModelExportParam : dataModelExportParamList) {
                    boolean taskStop = this.abstractTask.isTaskStop();
                    if (taskStop) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u5bfc\u51fa\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DataModelExportMain_001", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    dataModelExportParam.setExportType(OutputTypeEnum.MAINSUB_TRANSPORT);
                    JSONObject json = new DataModelExportJsonService().getModelJson(dataModelExportParam);
                    DataModelImportResult dataModelImportResult = this.checkDataValiad(dataModelExportParam, json);
                    if (dataModelExportParam.isBreakOutput() && dataModelImportResult.getTipInfos().size() > 0) {
                        DataModelUtil.doLog("export break.", log);
                        tempFileNameList.clear();
                        hasErrorDataModelNumbers.add(dataModelExportParam.getModelNumber());
                        continue;
                    }
                    HashMap<String, Number> maskInfoMap = new HashMap<String, Number>(16);
                    maskInfoMap.put("id", timeStamp);
                    maskInfoMap.put("size", size);
                    json.put("mask", maskInfoMap);
                    Object suffix = dataModelExportParam.getModelNumber() + ".json";
                    String tempFilePath = DataModelReadJsonFile.export_temp_file_prefix + timeStamp + "/" + (String)suffix;
                    String lowerCaseModelNumber = dataModelExportParam.getModelNumber().toLowerCase();
                    if (hasWriteFileNames.contains(lowerCaseModelNumber)) {
                        suffix = dataModelExportParam.getModelNumber() + "_" + index + ".json";
                        tempFilePath = DataModelReadJsonFile.export_temp_file_prefix + timeStamp + "/" + dataModelExportParam.getModelNumber() + "_" + index + ".json";
                        ++index;
                    }
                    hasWriteFileNames.add(lowerCaseModelNumber);
                    try (FileWriter fileWriter = new FileWriter(DataModelReadJsonFile.export_temp_file_prefix + FilenameUtils.getName((String)(timeStamp + "")) + "/" + FilenameUtils.getName((String)suffix));){
                        fileWriter.write(json.toJSONString());
                    }
                    tempFileNameList.add(tempFilePath);
                    DataModelGlobalVar.clear();
                    int progress = (int)(100.0 * (double)progressIndex / (double)progressSize);
                    this.abstractTask.feedBackExportProgress(progress);
                    ++progressIndex;
                }
                if (CollectionUtils.isNotEmpty(hasErrorDataModelNumbers)) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u201c%1\u201d\u5bfc\u51fa\u5b58\u5728\u9519\u8bef\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u9519\u8bef\u65e5\u5fd7\u4fee\u590d\u6570\u636e\u540e\u91cd\u8bd5\u3002", (String)"DataModelExportMain_002", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)";", hasErrorDataModelNumbers)}));
                }
                if (!CollectionUtils.isNotEmpty(tempFileNameList)) break block75;
                DataModelUtil.doLog("begin export zip.", log);
                File exportZipTempFile = null;
                try {
                    boolean mkdirs2;
                    File directory = new File(DataModelReadJsonFile.zipFileNamePrefix);
                    if (!directory.exists() && !(mkdirs2 = directory.mkdirs())) {
                        DataModelUtil.doLog("export mkdir is failed 1.", log);
                    }
                    exportZipTempFile = new File(DataModelReadJsonFile.zipFileNamePrefix, FilenameUtils.getName((String)(timeStamp + ".zip")));
                    Path path = exportZipTempFile.toPath();
                    OutputStream outStream = null;
                    ZipOutputStream zipOutputStream = null;
                    try {
                        outStream = Files.newOutputStream(path, new OpenOption[0]);
                        zipOutputStream = new ZipOutputStream(outStream);
                        DataModelUtil.doLog("export zip tempFileNameList:" + SerializationUtils.toJsonString(tempFileNameList), log);
                        for (String tempFilePath : tempFileNameList) {
                            String[] split = tempFilePath.split("/");
                            File file = new File(FilenameUtils.getName((String)split[0]) + "/" + FilenameUtils.getName((String)split[1]), FilenameUtils.getName((String)split[2]));
                            if (!file.exists()) {
                                DataModelUtil.doLog("export zip temp file is not exist,tempFilePath:" + tempFilePath, log);
                                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u4f53\u7cfb\u538b\u7f29\u5305\u65f6\u4e34\u65f6\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"DataModelExportMain_004", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            }
                            String tempFileName = tempFilePath.substring(tempFilePath.lastIndexOf("/") + 1);
                            zipOutputStream.putNextEntry(new ZipEntry(tempFileName));
                            try (FileInputStream fileInputStream = new FileInputStream(file);){
                                int len;
                                byte[] buf = new byte[1024];
                                while ((len = fileInputStream.read(buf)) > 0) {
                                    zipOutputStream.write(buf, 0, len);
                                }
                            }
                            zipOutputStream.closeEntry();
                            int progress = (int)(100.0 * (double)progressIndex / (double)progressSize);
                            this.abstractTask.feedBackExportProgress(progress);
                            ++progressIndex;
                        }
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                    finally {
                        if (outStream != null) {
                            try {
                                outStream.close();
                            }
                            catch (IOException e) {
                                log.error((Throwable)e);
                            }
                        }
                        if (zipOutputStream != null) {
                            try {
                                zipOutputStream.close();
                            }
                            catch (IOException e) {
                                log.error((Throwable)e);
                            }
                        }
                    }
                    String mainSubModelZipFileName = ResManager.loadResFormat((String)"\u4e3b\u5b50\u4f53\u7cfb\u5bfc\u51fa_%1.zip", (String)"DataModelExportMain_003", (String)"epm-eb-formplugin", (Object[])new Object[]{firstModelNumber + "_" + timeStamp});
                    try (InputStream inStream = Files.newInputStream(path, new OpenOption[0]);){
                        url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(mainSubModelZipFileName, inStream, 43200);
                    }
                }
                catch (Exception e) {
                    try {
                        log.error((Throwable)e);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        DataModelReadJsonFile.deleteFile(exportZipTempFile);
                        throw throwable;
                    }
                }
                DataModelReadJsonFile.deleteFile(exportZipTempFile);
            }
            finally {
                DataModelReadJsonFile.deleteFile(directoryFile);
            }
        }
        result.setOutFileUrl(url);
        return result;
    }

    protected DataModelImportResult checkDataValiad(DataModelExportParam dmParam, JSONObject json) {
        DataModelImportResult result = new DataModelImportResult();
        if (dmParam.isCheckDataValiad()) {
            DataModelImportParam importParam = this.getImportParam(dmParam);
            importParam.setJsonAllObject(json);
            result = new DataModelImportDetail().importDataLoop(importParam);
        }
        return result;
    }

    private DataModelImportParam getImportParam(DataModelExportParam dmParam) {
        DataModelImportParam ImportParam = new DataModelImportParam(false, "3", ImportModelTypeEnum.DEFAULT);
        ImportParam.setOnlyCheckDataValiad(true);
        ImportParam.setFromModelID(dmParam.getModelid());
        ImportParam.setToModelID(dmParam.getModelid());
        ImportParam.setDatasourceId(1L);
        ImportParam.setFileUrl(null);
        ImportParam.setExist(false);
        ImportParam.setFileName(dmParam.getModelNumber() + ".json");
        ImportParam.setBreakImport(true);
        ImportParam.setSkipErrData(true);
        ImportParam.setSqlBatch(8888);
        this.setImportParams(ImportParam);
        return ImportParam;
    }

    public String dataModelJsonForAPI(DataModelExportParam dmParam) {
        Map<String, Set<Long>> modelMap = dmParam.getFilterMaps();
        Long modelId = dmParam.getModelid();
        if (modelMap != null && modelMap.size() > 0) {
            DataModelExportJsonService dataTransObj = new DataModelExportJsonService();
            Map<String, Set<Long>> redimFilterMap = dataTransObj.reDimFilter(dmParam);
            this.viewMemberHandler(modelId, redimFilterMap);
            dmParam.setFilterMaps(redimFilterMap);
            return this.doExportJSONForAPI(dmParam);
        }
        return this.doExportJSONForAPI(dmParam);
    }

    private String doExportJSONForAPI(DataModelExportParam dmParam) {
        DataModelExportJsonService dataTransObj = new DataModelExportJsonService();
        JSONObject json = dataTransObj.getModelJson(dmParam);
        return json.toJSONString();
    }

    protected void viewMemberHandler(Long modelId, Map<String, Set<Long>> redimFilterMap) {
        Set<Long> viewSet = redimFilterMap.get("eb_dimensionview");
        if (viewSet != null && viewSet.size() > 0) {
            QFilter idQf;
            DynamicObjectCollection dimenions;
            HashSet viewSetIds = new HashSet(16);
            viewSet.forEach(e -> viewSetIds.add(e));
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            QFilter qFilter1 = new QFilter("id", "in", viewSetIds);
            DynamicObjectCollection views = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,dimension,source", (QFilter[])new QFilter[]{qFilter, qFilter1});
            HashSet<Long> dimIdSet = new HashSet<Long>(16);
            for (DynamicObject member2 : views) {
                if (member2.getLong("source") != 0L) continue;
                dimIdSet.add(member2.getLong("dimension"));
            }
            if (dimIdSet.size() > 0) {
                QFilter qFilter2 = new QFilter("dimension", "in", dimIdSet);
                QFilter qFilter3 = new QFilter("source", "=", (Object)"1");
                DynamicObjectCollection baseViews = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,dimension,source", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3});
                viewSet.addAll(baseViews.stream().map(v -> v.getLong("id")).collect(Collectors.toSet()));
            }
            QFilter qFilter4 = new QFilter("view", "in", viewSetIds);
            DynamicObjectCollection members = QueryServiceHelper.query((String)"eb_viewmember", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter4});
            Set memberIdSet = members.stream().map(member -> member.getLong("id")).collect(Collectors.toSet());
            redimFilterMap.put("eb_viewmember", memberIdSet);
            if (dimIdSet.size() > 0 && (dimenions = QueryServiceHelper.query((String)"epm_dimension", (String)"id,membermodel", (QFilter[])new QFilter[]{idQf = new QFilter("id", "in", dimIdSet)})) != null) {
                for (DynamicObject dimenion : dimenions) {
                    this.getDimensionMember(dimenion.getString("membermodel"), dimenion.getLong("id"), redimFilterMap);
                }
            }
        }
    }

    private void getDimensionMember(String entity, Long dimId, Map<String, Set<Long>> redimFilterMap) {
        QFilter dimIdQf = new QFilter("dimension", "=", (Object)dimId);
        DynamicObjectCollection members = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{dimIdQf});
        if (members == null || members.size() == 0) {
            return;
        }
        Set set = redimFilterMap.getOrDefault(entity, new HashSet(16));
        for (DynamicObject member : members) {
            set.add(member.getLong("id"));
        }
        redimFilterMap.put(entity, set);
    }

    protected void setImportParams(DataModelImportParam dmParam) {
    }
}

