/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.exportmodel.service;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.enums.OutputTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelCommon;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelMetaDataFields;
import kd.epm.eb.olap.impl.execute.dao.RuleManageJsonUtil;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import org.apache.commons.lang.StringUtils;

public class DataModelExportService {
    private static final String CON_VAR_VARKEY = "variable";
    private static final String MAP_FEILD_VAR = "variableid";
    private static final int COLLECTION_SIZE = 16;
    private static final String[] ENTITY_NAME_LIST = new String[]{"eb_templateentity", "eb_examine", "eb_bizruleset", "eb_offsetrule", "eb_task", "eb_currencyconvertschem"};
    private static final Set<String> hasNoNameForms = Sets.newHashSet((Object[])new String[]{"eb_applytemplate_config"});
    private static final String ANALYSIS_CANVAS = "analysiscanvas";

    public static DataModelExportService getInstance() {
        return DataModelExportServiceHandler.getDataModelExportService();
    }

    private DataModelExportService() {
    }

    public String getSelectFields(String entityName, List<String> fields) {
        String defaultFields = "id,name,number";
        StringBuilder sb = new StringBuilder(defaultFields);
        switch (entityName) {
            case "eb_templateentity": {
                sb.append(",data,templatetype");
                break;
            }
            case "eb_examine": {
                sb.append(",formula,isconntemp,ebtemplates");
                break;
            }
            case "eb_bizruleset": {
                sb.append(",usescope,status");
                break;
            }
            case "eb_task": {
                sb.append(",description, begintime, time, deadline, entryentity.templateid, entryentity.templatetype, entryentity.seq");
                break;
            }
            case "eb_currencyconvertschem": {
                sb.append(",entityrang_tag");
                break;
            }
        }
        if (fields != null && fields.size() > 0) {
            for (String field : fields) {
                if (StringUtils.equalsIgnoreCase((String)entityName, (String)"eb_examine")) {
                    if (StringUtils.endsWithIgnoreCase((String)field, (String)"entity")) {
                        field = "createorg";
                    }
                    if (StringUtils.endsWithIgnoreCase((String)field, (String)"group")) {
                        field = "group";
                        sb.append(',').append(field);
                        sb.append(',').append(field).append(".code");
                        sb.append(',').append(field).append(".name");
                        continue;
                    }
                }
                if (StringUtils.endsWithIgnoreCase((String)entityName, (String)"eb_bizruleset") && StringUtils.endsWithIgnoreCase((String)field, (String)"dataset")) {
                    field = "datasetid";
                }
                if (StringUtils.endsWithIgnoreCase((String)entityName, (String)"eb_task") && StringUtils.endsWithIgnoreCase((String)field, (String)"task")) continue;
                if (StringUtils.endsWithIgnoreCase((String)entityName, (String)"eb_currencyconvertschem") && StringUtils.endsWithIgnoreCase((String)field, (String)"currency")) {
                    List<String> stringList = Arrays.asList("currencyraw", "currencyrate");
                    for (String str : stringList) {
                        sb.append(',').append(str);
                        sb.append(',').append(str).append(".number");
                        sb.append(',').append(str).append(".name");
                    }
                    continue;
                }
                sb.append(',').append(field);
                sb.append(',').append(field).append(".number");
                sb.append(',').append(field).append(".name");
            }
        }
        return sb.toString();
    }

    public Map<String, Set<String>> getDimScopeFromFix(String json, Long modelId) {
        HashMap<String, Set<String>> returnMap = new HashMap<String, Set<String>>(16);
        DynamicInfoCollection dynamicInfo = RuleManageJsonUtil.getDyInfoCollection((String)json);
        for (DynamicInfoCollection.InfoObject memb : dynamicInfo.getValues()) {
            String dimN = (String)memb.getValueByPropName("dimNum");
            String membN = (String)memb.getValueByPropName("number");
            if (returnMap.get(dimN) != null) {
                ((Set)returnMap.get(dimN)).add(membN);
                continue;
            }
            HashSet<String> subSet = new HashSet<String>();
            subSet.add(membN);
            returnMap.put(dimN, subSet);
        }
        return returnMap;
    }

    public List<String> getbaseFields(String entityName) {
        ArrayList<String> fields = new ArrayList<String>(16);
        DataModelTransEnum dataModelEnumEntity = DataModelTransEnum.getEnumByFormID(entityName);
        if (null == dataModelEnumEntity) {
            return fields;
        }
        Map<String, String> baseFieldMap = DataModelMetaDataFields.getInstance().getBaseFieldByFormID(entityName, null);
        if (baseFieldMap != null && baseFieldMap.size() > 0) {
            fields.addAll(baseFieldMap.keySet());
        }
        return fields;
    }

    private Map<String, Set<String>> member2Map(Map<String, Collection<Member>> dimMaps) {
        if (dimMaps == null || dimMaps.size() == 0) {
            return null;
        }
        HashMap<String, Set<String>> returnMap = new HashMap<String, Set<String>>(dimMaps.size());
        for (Map.Entry<String, Collection<Member>> entry : dimMaps.entrySet()) {
            Collection<Member> dimCols = entry.getValue();
            HashSet dimSet = new HashSet(dimCols.size());
            dimCols.forEach(v -> dimSet.add(String.valueOf(v.getNumber())));
            returnMap.put(entry.getKey(), dimSet);
        }
        return returnMap;
    }

    public Map<Long, Map<String, Set<String>>> getTemplateDimMap(Long tempId, String tempType, String tempData, Long modelId) {
        HashMap<Long, Map<String, Set<String>>> tempDimMap = new HashMap<Long, Map<String, Set<String>>>(16);
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)tempData);
        Map dimMaps = templateModel.retrieveQuoteMembersWithScope();
        tempDimMap.put(tempId, this.member2Map(dimMaps));
        return tempDimMap;
    }

    public void getExamineRelationTemplate(Map<String, Set<String>> dimMap, Long examineId, Long modelId) {
        QFilter qf1 = new QFilter("id", "=", (Object)examineId);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_examine", (String)"id, name, number, ebtemplates", (QFilter[])new QFilter[]{qf1});
        if (load != null) {
            HashSet<Long> tempidSet = new HashSet<Long>(16);
            HashSet<String> tempNumSet = new HashSet<String>(16);
            for (DynamicObject object : load) {
                DynamicObjectCollection ebtemplates = object.getDynamicObjectCollection("ebtemplates");
                if (ebtemplates != null) {
                    for (DynamicObject temp : ebtemplates) {
                        if (temp.get("FBasedataId") == null) continue;
                        tempidSet.add(temp.getLong("FBasedataId.id"));
                        tempNumSet.add(temp.getString("FBasedataId.number"));
                    }
                }
                dimMap.put(DataModelTransEnum.templateentity.getNumber(), tempNumSet);
            }
            if (null == tempidSet || tempidSet.size() == 0) {
                return;
            }
            QFilter qf = new QFilter("model", "=", (Object)modelId);
            QFilter qf2 = new QFilter("id", "in", tempidSet);
            DynamicObjectCollection list = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,name,number,data,templatetype", (QFilter[])new QFilter[]{qf, qf2});
            for (DynamicObject object : list) {
                String tempData = object.getString("data");
                if (StringUtils.isEmpty((String)tempData)) continue;
                Long tempId = object.getLong("id");
                String tempType = object.getString("templatetype");
                Map<Long, Map<String, Set<String>>> tempDimMap = this.getTemplateDimMap(tempId, tempType, tempData, modelId);
                this.sumMap(dimMap, tempDimMap.get(tempId));
            }
        }
    }

    public void getFormulaAcc(Map<String, Set<String>> dimMap, Long ruleId, Long modelId) {
        String selectFields = "ruleid,account,isleft,memberkey,dimenstionjsonfix,dimenstionjsonvar";
        QFilter accqf = new QFilter("ruleid", "=", (Object)ruleId);
        QFilter accqf1 = new QFilter("isleft", "in", Arrays.asList("0", "1"));
        DynamicObjectCollection list = QueryServiceHelper.query((String)"eb_bizrulesetacc", (String)selectFields, (QFilter[])new QFilter[]{accqf, accqf1});
        if (null == list || list.size() == 0) {
            return;
        }
        for (DynamicObject object : list) {
            String fixJson = object.getString("dimenstionjsonfix");
            Map<String, Set<String>> fixMap = this.getDimScopeFromFix(fixJson, modelId);
            this.sumMap(dimMap, fixMap);
        }
    }

    public Map<String, Set<String>> getBizOrg(Long modelId) {
        HashMap<String, Set<String>> dimMap = new HashMap<String, Set<String>>(16);
        HashSet<String> orgNumberSet = new HashSet<String>(16);
        String selectFields = "id,number,name,parent,mergernode,dseq,isleaf,level";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter filter = new QFilter("number", "!=", (Object)"RatePreset");
        QFilter[] filters = new QFilter[]{fmodelid, filter};
        DynamicObjectCollection entitys = QueryServiceHelper.query((String)"epm_entitymembertree", (String)selectFields, (QFilter[])filters);
        for (DynamicObject entity : entitys) {
            if (entity.getBoolean("isleaf") && entity.getInt("level") == 2) continue;
            orgNumberSet.add(entity.getString("number"));
        }
        dimMap.put(DataModelTransEnum.Entity.getNumber(), orgNumberSet);
        return dimMap;
    }

    private boolean containsKey(Map<String, Set<String>> dimMap, String field, DynamicObject obj, String key) {
        for (Map.Entry<String, Set<String>> entry : dimMap.entrySet()) {
            if (!StringUtils.equalsIgnoreCase((String)entry.getKey(), (String)field)) continue;
            entry.getValue().add(obj.getString(field + key));
            return true;
        }
        return false;
    }

    public void getCurrentNodeChildren(TreeNode node, Long modelId) {
        DataModelTransEnum dataModel = DataModelTransEnum.getEnumByNumber(node.getLongNumber());
        if (null == dataModel) {
            Map<String, String> userDefineNumberMap = this.getUserDefineNumberMap(modelId);
            if (!userDefineNumberMap.containsKey(node.getLongNumber())) {
                return;
            }
            dataModel = DataModelTransEnum.userdefine;
        }
        if (ANALYSIS_CANVAS.equalsIgnoreCase(dataModel.getNumber())) {
            return;
        }
        List<String> formIds = DataModelTransEnum.getMainTableFormIDByLevel(2, OutputTypeEnum.DEFAULT.getCode());
        StringBuilder fields = new StringBuilder("id,number");
        if (!hasNoNameForms.contains(dataModel.getFormID())) {
            fields.append(",name");
        }
        if (formIds.contains(dataModel.getFormID())) {
            fields.append(",isleaf,parent,dimension");
        }
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection list = QueryServiceHelper.query((String)dataModel.getFormID(), (String)fields.toString(), (QFilter[])new QFilter[]{qf});
        if (null == list || list.size() == 0) {
            return;
        }
        if (formIds.contains(dataModel.getFormID())) {
            this.getDimessionMemberRootNode(list, node, dataModel.getFormID());
            if (node.getChildren() != null) {
                for (TreeNode treeNode : node.getChildren()) {
                    this.getDimessionMemberChildren(list, treeNode);
                }
            }
        } else {
            ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
            for (DynamicObject obj : list) {
                TreeNode childNode2 = this.newChildTreeNode(obj, node);
                childNode2.setType(dataModel.getFormID());
                treeNodes.add(childNode2);
            }
            if (treeNodes.isEmpty()) {
                return;
            }
            node.setChildren(treeNodes);
            if (StringUtils.equalsIgnoreCase((String)dataModel.getFormID(), (String)"epm_dimension")) {
                treeNodes.forEach(childNode -> this.getCurrentNodeChildren((TreeNode)childNode, modelId));
            } else if (StringUtils.equalsIgnoreCase((String)dataModel.getFormID(), (String)"eb_dimensionview")) {
                this.getDimessionViewTreeNode(node, modelId);
            }
        }
    }

    private void getDimessionViewTreeNode(TreeNode node, Long modelId) {
        QFilter viewqf = new QFilter("model", "=", (Object)modelId);
        List collect = node.getChildren().stream().mapToLong(treeNode -> Long.parseLong(treeNode.getId())).boxed().collect(Collectors.toList());
        QFilter viewqf1 = new QFilter("view", "in", collect);
        DynamicObjectCollection viewList = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,name,number,isleaf,parent,view,dimension", (QFilter[])new QFilter[]{viewqf, viewqf1});
        if (null == viewList || viewList.size() == 0) {
            return;
        }
        for (TreeNode treeNode2 : node.getChildren()) {
            DynamicObjectCollection memberList = new DynamicObjectCollection();
            for (DynamicObject obj : viewList) {
                if (!StringUtils.equalsIgnoreCase((String)treeNode2.getId(), (String)obj.getString("view"))) continue;
                memberList.add((Object)obj);
            }
            this.getDimessionMemberRootNode(memberList, treeNode2, "eb_viewmember");
            if (treeNode2.getChildren() == null) continue;
            for (TreeNode child : treeNode2.getChildren()) {
                this.getDimessionMemberChildren(memberList, child);
            }
        }
    }

    private void getDimessionMemberRootNode(DynamicObjectCollection list, TreeNode node, String formId) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        for (DynamicObject obj : list) {
            if (!StringUtils.equalsIgnoreCase((String)obj.getString("parent"), (String)"0") || !StringUtils.equalsIgnoreCase((String)obj.getString("dimension"), (String)node.getId())) continue;
            TreeNode childNode = this.newChildTreeNode(obj, node);
            childNode.setType(formId);
            childNode.setLeaf(obj.getBoolean("isleaf"));
            treeNodes.add(childNode);
        }
        if (treeNodes.isEmpty()) {
            return;
        }
        node.setChildren(treeNodes);
    }

    private void getDimessionMemberChildren(DynamicObjectCollection list, TreeNode node) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        for (DynamicObject obj : list) {
            if (!StringUtils.equalsIgnoreCase((String)obj.getString("parent"), (String)node.getId())) continue;
            TreeNode childNode2 = this.newChildTreeNode(obj, node);
            childNode2.setLeaf(obj.getBoolean("isleaf"));
            treeNodes.add(childNode2);
        }
        if (treeNodes.isEmpty()) {
            return;
        }
        node.setChildren(treeNodes);
        treeNodes.forEach(childNode -> this.getDimessionMemberChildren(list, (TreeNode)childNode));
    }

    private TreeNode newChildTreeNode(DynamicObject obj, TreeNode node) {
        TreeNode childNode = new TreeNode();
        childNode.setId(obj.getString("id"));
        childNode.setText(obj.getDataEntityType().getProperties().get((Object)"name") == null ? "" : obj.getString("name"));
        childNode.setLongNumber(obj.getString("number"));
        childNode.setParentid(node.getId());
        childNode.setType(node.getType());
        HashMap<String, String> data1 = new HashMap<String, String>();
        data1.put("id", obj.getString("id"));
        data1.put("name", obj.getDataEntityType().getProperties().get((Object)"name") == null ? "" : obj.getString("name"));
        data1.put("number", obj.getString("number"));
        Map data = (Map)node.getData();
        data1.put("level", String.valueOf(Integer.parseInt((String)data.get("level")) + 1));
        childNode.setData(data1);
        return childNode;
    }

    public Map<String, String> getUserDefineNumberMap(Long modelId) {
        HashMap<String, String> definedNumberMap = new HashMap<String, String>(16);
        DataSet defineDimSet = DataModelCommon.getInstance().queryUserDefinDim(modelId);
        if (defineDimSet != null) {
            for (Row row : defineDimSet) {
                definedNumberMap.put(row.getString("number"), row.getString("name"));
            }
        }
        return definedNumberMap;
    }

    private DynamicObjectCollection query(Long modelId, Set<String> numberSet, String entityName, List<String> fields) {
        String selectField = this.getSelectFields(entityName, fields);
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        QFilter qf1 = new QFilter("number", "in", numberSet);
        return QueryServiceHelper.query((String)entityName, (String)selectField, (QFilter[])new QFilter[]{qf, qf1});
    }

    private void removeBaseField(List<String> fields) {
        if (fields == null || fields.size() == 0) {
            return;
        }
        fields.remove("FBASEDATAID");
    }

    public Map<String, Set<Long>> sumAllMemberMap(Long modelId, Map<String, Set<Long>> memberMap) {
        return memberMap;
    }

    public void addCustomProperty2EntityMap(Long modelId, Map<String, Set<String>> entityMap) {
        QFilter qd;
        DynamicObjectCollection list;
        Set userdefineIdSet;
        QFilter qnumber1;
        DynamicObjectCollection userdefines;
        Set<String> userdefineSet;
        QFilter qd2;
        DynamicObjectCollection list2;
        QFilter qnumber;
        DynamicObject dimension;
        QFilter qmodel = new QFilter("model", "=", (Object)modelId);
        Set<String> entitySet = entityMap.get("epm_entitymembertree");
        if (entitySet != null && entitySet.size() > 0 && (dimension = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id,number", (QFilter[])new QFilter[]{qmodel, qnumber = new QFilter("number", "=", (Object)SysDimensionEnum.Entity.getNumber())})) != null && dimension.getLong("id") != 0L && (list2 = QueryServiceHelper.query((String)"eb_customproperty", (String)"id,number", (QFilter[])new QFilter[]{qmodel, qd2 = new QFilter("dimension", "=", (Object)dimension.getLong("id"))})) != null && list2.size() > 0) {
            Set numberSet = list2.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
            entityMap.put("eb_customproperty", numberSet);
        }
        if ((userdefineSet = entityMap.get("epm_userdefinedmembertree")) != null && userdefineSet.size() > 0 && (userdefines = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"id,number,dimension", (QFilter[])new QFilter[]{qmodel, qnumber1 = new QFilter("number", "in", userdefineSet)})) != null && userdefines.size() > 0 && (userdefineIdSet = userdefines.stream().map(e -> e.getLong("dimension")).collect(Collectors.toSet())) != null && userdefineIdSet.size() > 0 && (list = QueryServiceHelper.query((String)"eb_customproperty", (String)"id,number", (QFilter[])new QFilter[]{qmodel, qd = new QFilter("dimension", "in", userdefineIdSet)})) != null && list.size() > 0) {
            Set numberSet = list.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
            Set<String> entityNumberSet = entityMap.get("eb_customproperty");
            if (entityNumberSet != null) {
                entityNumberSet.addAll(numberSet);
            } else {
                entityMap.put("eb_customproperty", numberSet);
            }
        }
    }

    private void specialHalder(String entityName, Map<String, Set<String>> dimMap) {
        if (StringUtils.equalsIgnoreCase((String)entityName, (String)"eb_examine")) {
            Set<String> group;
            Set<String> examinecategorySet;
            Set<String> createorg = dimMap.remove("createorg");
            if (createorg != null && createorg.contains(null)) {
                createorg.remove(null);
            }
            if ((examinecategorySet = dimMap.get("examinecategory")) == null) {
                examinecategorySet = new HashSet<String>(16);
                dimMap.put("examinecategory", examinecategorySet);
            }
            if ((group = dimMap.remove("group")) != null) {
                if (group.contains(null)) {
                    group.remove(null);
                }
                examinecategorySet.addAll(group);
            }
        }
    }

    private void sumMap(Map<String, Set<String>> outputMap, Map<String, Set<String>> inputMap) {
        for (Map.Entry<String, Set<String>> entry : outputMap.entrySet()) {
            if (!inputMap.containsKey(entry.getKey())) continue;
            entry.getValue().addAll((Collection<String>)inputMap.get(entry.getKey()));
            inputMap.remove(entry.getKey());
        }
        outputMap.putAll(inputMap);
    }

    private Map<String, Set<String>> convertNumberMap2EntityMap(Map<String, Set<String>> memberMap, Long modelId) {
        HashMap<String, Set<String>> entityMap = new HashMap<String, Set<String>>(16);
        Map<String, String> userDefineNumberMap = this.getUserDefineNumberMap(modelId);
        for (Map.Entry<String, Set<String>> entry : memberMap.entrySet()) {
            if (null == entry.getKey() || null == entry.getValue() || entry.getValue().size() == 0) continue;
            if (DataModelTransEnum.includeFormid(entry.getKey())) {
                entityMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (userDefineNumberMap.containsKey(entry.getKey())) {
                HashSet userDefineNumberSet = (HashSet)entityMap.get("epm_userdefinedmembertree");
                if (null == userDefineNumberSet) {
                    userDefineNumberSet = new HashSet(16);
                    entityMap.put("epm_userdefinedmembertree", userDefineNumberSet);
                }
                userDefineNumberSet.addAll(entry.getValue());
                continue;
            }
            if (!DataModelTransEnum.includeNumber(entry.getKey())) continue;
            entityMap.put(DataModelTransEnum.getEnumByNumber(entry.getKey()).getFormID(), entry.getValue());
        }
        return entityMap;
    }

    private static class DataModelExportServiceHandler {
        private static DataModelExportService dataModelExportService = new DataModelExportService();

        private DataModelExportServiceHandler() {
        }

        private static DataModelExportService getDataModelExportService() {
            return dataModelExportService;
        }
    }
}

