/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.importmodel.service;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelReadJsonFile;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelCommon;
import org.apache.commons.lang3.StringUtils;

public class DataModelImportCheck {
    public static DataModelImportCheck getInstance() {
        return InnerClass.instance;
    }

    private DataModelImportCheck() {
    }

    public boolean checkImportParams(DataModelImportParam importParam) {
        if (importParam == null) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)importParam.getFileUrl()) && importParam.getJsonAllObject() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"fileUrl\u548cjsonObject\u4e0d\u80fd\u5168\u4e3a\u7a7a\u3002", (String)"DataModelImportCheck_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (importParam.getJsonAllObject() != null) {
            importParam.setFileName("api_" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            this.apiCheckAndSetImportParam(importParam);
        }
        return true;
    }

    private void apiCheckAndSetImportParam(DataModelImportParam importParam) {
        JSONObject modelJsons = DataModelReadJsonFile.getInstance().readJsonFile(importParam, "epm_model");
        if (modelJsons == null) {
            throw new KDBizException(ResManager.loadKDString((String)"json\u4e2d\u6ca1\u6709\u4f53\u7cfb\u8868\u7684\u6570\u636e\u3002", (String)"DataModelImportCheck_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        int count = modelJsons.getJSONArray("t_eb_model").size();
        if (count > 1) {
            JSONObject modelSingleLineData = (JSONObject)modelJsons.getJSONArray("t_eb_model").get(1);
            String modelIdJson = modelSingleLineData.getString("FID");
            String modelNumberJson = modelSingleLineData.getString("FSHOWNUMBER");
            if (StringUtils.isEmpty((CharSequence)modelIdJson) || StringUtils.isEmpty((CharSequence)modelNumberJson)) {
                throw new KDBizException(ResManager.loadKDString((String)"json\u4e2d\u7684\u4f53\u7cfbid\u6216\u8005number\u4e3a\u7a7a\u3002", (String)"DataModelImportCheck_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            importParam.setFromModelID(StringUtils.isEmpty((CharSequence)modelIdJson) ? null : Long.valueOf(modelIdJson));
            if (importParam.getToModelID() == null || importParam.getToModelID().compareTo(0L) == 0) {
                this.apiCheckAndSetImportParamNoExist(importParam, modelSingleLineData);
            } else {
                this.apiCheckAndSetImportParamExist(importParam, modelSingleLineData);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"json\u4e2d\u6ca1\u6709\u4f53\u7cfb\u8868\u7684\u6570\u636e\u6216\u8005\u4f53\u7cfb\u8868\u7684\u6570\u636e\u6ca1\u6709fathertable\u884c\u3002", (String)"DataModelImportCheck_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        modelJsons = null;
    }

    private void apiCheckAndSetImportParamExist(DataModelImportParam importParam, JSONObject modelSingleLineData) {
        importParam.setExist(true);
        if (!DataModelCommon.getInstance().isModelExist(importParam.getToModelID())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u76ee\u6807\u4f53\u7cfbtoModelID\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"DataModelImportCheck_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void apiCheckAndSetImportParamNoExist(DataModelImportParam importParam, JSONObject modelSingleLineData) {
        importParam.setExist(false);
        Long modelIdDB = DataModelCommon.getInstance().isExistAndModelID(modelSingleLineData.getString("FSHOWNUMBER"), null, modelSingleLineData.getString("MODELTYPE"));
        if (!modelIdDB.toString().equalsIgnoreCase("0")) {
            throw new KDBizException(ResManager.loadKDString((String)"json\u4e2d\u7684\u4f53\u7cfbnumber\u5df2\u7ecf\u5b58\u5728\uff0c\u5374\u6ca1\u6709\u4f20\u5165toModelId\uff0c\u4e0d\u80fd\u8fdb\u884c\u65b0\u589e\u5bfc\u5165\u3002", (String)"DataModelImportCheck_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (importParam.getDatasourceId() == null || importParam.getDatasourceId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u589e\u4f53\u7cfb\u5bfc\u5165\uff0c\u4f46\u6ca1\u6709\u4f20\u5165\u6570\u636e\u6e90\u4fe1\u606f\u3002", (String)"DataModelImportCheck_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (!importParam.getImportType().equalsIgnoreCase("3")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u589e\u4f53\u7cfb\u5bfc\u5165\uff0c\u4f46\u5374\u4e0d\u662f\u65b0\u589e\u5bfc\u5165\u65b9\u5f0f\u3002", (String)"DataModelImportCheck_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private static class InnerClass {
        private static DataModelImportCheck instance = new DataModelImportCheck();

        private InnerClass() {
        }
    }
}

