/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.importmodel.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelCurrentLine;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelGlobalParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportResult;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelInnerParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.TableEntity;
import kd.epm.eb.formplugin.dataModelTrans.enums.OutputTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportJsonService;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportPrepare;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelOlapCheck;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelReadJsonFile;
import kd.epm.eb.formplugin.dataModelTrans.part.DataModelThread;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.DMSpecialFeildImport;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.DMSpecialFeildModel;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelCommon;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelMetaDataFields;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class DataModelImportDetail {
    private static final Log log = LogFactory.getLog(DataModelImportDetail.class);
    private Map<String, String> mainSecondTableRelates;

    public DataModelImportResult importDataLoop(DataModelImportParam importParam) {
        DataModelUtil.doLog("import_From_before_readJsonFile", log);
        JSONObject jsonAllObject = DataModelReadJsonFile.getInstance().readJsonFile(importParam, null);
        if (jsonAllObject == null) {
            return null;
        }
        DataModelUtil.doLog("import_From_before_getTableEntitys", log);
        ConcurrentHashMap<String, TableEntity> tableEntitys = DataModelThread.getInstance().getTableEntitys(jsonAllObject);
        DataModelUtil.doLog("import_From_before_prepareData", log);
        DataModelGlobalParam globlaParams = DataModelImportPrepare.getInstance().prepareData(importParam, jsonAllObject, tableEntitys);
        DataModelUtil.doLog("import_From_before_preparePKIDData", log);
        DataModelThread.getInstance().preparePKIDData(importParam, jsonAllObject, globlaParams, tableEntitys);
        this.reSetModelID(globlaParams, importParam);
        DataModelUtil.doLog("import_From_before_checkGlobalVarForAlreadyUsedDimen", log);
        DataModelOlapCheck.getInstance().checkAlreadyUsedDimen(importParam, globlaParams);
        DataModelUtil.doLog("import_From_before_save_importDataLoop", log);
        return this.importDataLoop(importParam, jsonAllObject, tableEntitys, globlaParams);
    }

    private Set<String> getDBTableNames() {
        List dbTables = DB.getTables((DBRoute)BgFormConstant.DBROUTE);
        HashSet<String> returns = new HashSet<String>(dbTables.size() / 2);
        for (String dbTable : dbTables) {
            String dbTmp = dbTable.toLowerCase(Locale.getDefault());
            if (!dbTmp.startsWith("t_eb_") || dbTmp.startsWith("t_eb_log") || dbTmp.startsWith("t_eb_rows") || dbTmp.startsWith("t_eb_tmp_")) continue;
            returns.add(dbTmp);
        }
        return returns;
    }

    protected DataModelImportResult importDataLoop(DataModelImportParam importParam, JSONObject jsonAllObject, Map<String, TableEntity> tableEntitys, DataModelGlobalParam globlaParams) {
        DataModelInnerParam innerParam = this.iniInnerParam(importParam);
        DataModelImportJsonService importJsonService = this.getImportJsonService(innerParam);
        List<String> dimFromId = DataModelTransEnum.getAllMainTableFormID(OutputTypeEnum.DEFAULT.getCode());
        Set<String> dbTableNames = this.getDBTableNames();
        this.mainSecondTableRelates = new HashMap<String, String>(16);
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            Set<String> excludeImportFormIds = importParam.getMainSubImportParam().getExcludeImportFormIds();
            if (CollectionUtils.isNotEmpty(excludeImportFormIds)) {
                if (excludeImportFormIds.contains(DataModelTransEnum.templateentity.getFormID())) {
                    excludeImportFormIds.add(DataModelTransEnum.templatecatalog.getFormID());
                } else if (excludeImportFormIds.contains(DataModelTransEnum.examine.getFormID())) {
                    excludeImportFormIds.add(DataModelTransEnum.examinecategory.getFormID());
                } else if (excludeImportFormIds.contains(DataModelTransEnum.bizruleset.getFormID())) {
                    excludeImportFormIds.add(DataModelTransEnum.bizrulesetacc.getFormID());
                }
            }
            for (String strEntityName : dimFromId) {
                JSONObject entityData;
                if (CollectionUtils.isNotEmpty(excludeImportFormIds) && excludeImportFormIds.contains(strEntityName)) continue;
                DataModelTransEnum enumByFormID = DataModelTransEnum.getEnumByFormID(strEntityName);
                if (importParam.getMainSubImportParam().getSubSync().booleanValue() && (enumByFormID == null || enumByFormID.getIsMainSubModel() != 1) || (entityData = jsonAllObject.getJSONObject(strEntityName)) == null) continue;
                innerParam.getCurMainTableErrIds().clear();
                String mainTableThisTime = null;
                for (Map.Entry entry : entityData.entrySet()) {
                    String table = (String)entry.getKey();
                    DataModelUtil.doLog("import_From_before_importDataSingleTable:" + table, log);
                    if (!dbTableNames.contains(table.toLowerCase(Locale.getDefault()))) {
                        throw new KDBizException(table + " does not exist.");
                    }
                    JSONArray jsonCurTableAllDatas = (JSONArray)entry.getValue();
                    if (jsonCurTableAllDatas == null || jsonCurTableAllDatas.size() == 0) continue;
                    mainTableThisTime = DataModelUtil.isMainTable(table) != false ? table : ((JSONObject)jsonCurTableAllDatas.get(0)).getString("fathertable");
                    this.addMainSecondTableRelates(mainTableThisTime, table);
                    innerParam.setCurrentLine(this.iniCurrentLineObj(mainTableThisTime, strEntityName, table, tableEntitys));
                    this.setGlobalParams(globlaParams, innerParam, jsonAllObject);
                    importJsonService.importDataSingleTable(globlaParams, jsonCurTableAllDatas);
                    DataModelUtil.doLog("import_From_after_importDataSingleTable:" + table, log);
                }
                this.afterFormIdLoop(importParam, globlaParams, jsonAllObject, strEntityName);
            }
            innerParam.getResult().getTipInfos().addAll(innerParam.getResult().getTipInfosMust());
            if (DataModelCommon.getInstance().isBreakImport(innerParam.getResult(), importParam)) {
                tx.markRollback();
                DataModelImportResult dataModelImportResult = innerParam.getResult();
                return dataModelImportResult;
            }
            try {
                DMSpecialFeildModel.getInstance().updateModelError(innerParam);
                this.beforeCommitTrans(importParam);
                innerParam.getResult().setCreateSuc(true);
            }
            catch (Throwable e1) {
                log.error(e1);
                tx.markRollback();
                DataModelUtil.doLog(e1.getMessage() + DataModelCommon.getInstance().getStackTraceStr(e1), log);
                throw new KDBizException(ResManager.loadResFormat((String)"\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7[%1]\u3002", (String)"DataModelImportDetail_01", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
            }
        }
        return innerParam.getResult();
    }

    protected void afterFormIdLoop(DataModelImportParam importParam, DataModelGlobalParam globalParam, JSONObject jsonAllObject, String formId) {
    }

    protected void beforeCommitTrans(DataModelImportParam importParam) {
    }

    private void addMainSecondTableRelates(String mainTableThisTime, String secondTable) {
        String mainSecondTableRalatesValue;
        if (!DataModelUtil.isMainTable(mainTableThisTime).booleanValue()) {
            this.mainSecondTableRelates.put(secondTable, mainTableThisTime);
        }
        if ((mainSecondTableRalatesValue = this.mainSecondTableRelates.get(mainTableThisTime)) != null) {
            this.mainSecondTableRelates.put(secondTable, mainSecondTableRalatesValue);
        }
    }

    private DataModelInnerParam iniInnerParam(DataModelImportParam importParam) {
        DataModelInnerParam innerParam = new DataModelInnerParam();
        innerParam.setImportParam(importParam);
        innerParam.setResult(this.iniVar());
        innerParam.setCurMainTableErrIds(new HashSet<Long>(16));
        return innerParam;
    }

    private void setGlobalParams(DataModelGlobalParam globlaParams, DataModelInnerParam innerParam, JSONObject jsonAllObject) {
        globlaParams.setSpecialMapFromJson(DMSpecialFeildImport.getInstance().prepareSpecialMapFromJson(innerParam, jsonAllObject));
    }

    protected void reSetModelID(DataModelGlobalParam globlaParams, DataModelImportParam importParam) {
        Map<String, Map<Long, Long>> needUpdatePKIDMap = globlaParams.getNeedUpdatePKIDMap();
        if (!importParam.isExist() && needUpdatePKIDMap.size() > 0) {
            importParam.setFromModelID(needUpdatePKIDMap.get("t_eb_model").keySet().iterator().next());
            importParam.setToModelID(needUpdatePKIDMap.get("t_eb_model").get(importParam.getFromModelID()));
        }
    }

    private DataModelCurrentLine iniCurrentLineObj(String mainTableThisTime, String strEntityName, String table, Map<String, TableEntity> tableEntitys) {
        DataModelCurrentLine currentLine = new DataModelCurrentLine();
        currentLine.setFormID(strEntityName);
        currentLine.setMainTableName(mainTableThisTime);
        currentLine.setTableName(table);
        currentLine.setTableEntity(this.getTableEntitysByTableName(tableEntitys, table));
        currentLine.setFieldAndTypeMap(DataModelMetaDataFields.getInstance().getFieldAndTypeMap(table));
        if (!mainTableThisTime.equalsIgnoreCase(table)) {
            currentLine.getFieldAndTypeMap().putAll(DataModelMetaDataFields.getInstance().getFieldAndTypeMap(mainTableThisTime));
            if (this.mainSecondTableRelates.get(table) != null) {
                currentLine.getFieldAndTypeMap().putAll(DataModelMetaDataFields.getInstance().getFieldAndTypeMap(this.mainSecondTableRelates.get(table)));
            }
        }
        return currentLine;
    }

    private TableEntity getTableEntitysByTableName(Map<String, TableEntity> tableEntitys, String tableName) {
        if (tableEntitys == null) {
            return null;
        }
        return tableEntitys.get(tableName.toLowerCase(Locale.getDefault()));
    }

    private DataModelImportResult iniVar() {
        DataModelImportResult result = new DataModelImportResult();
        LinkedHashMap<String, Integer> addMap = new LinkedHashMap<String, Integer>(16);
        LinkedHashMap<String, Integer> updateMap = new LinkedHashMap<String, Integer>(16);
        LinkedHashMap<String, List<Object[]>> sqlValues = new LinkedHashMap<String, List<Object[]>>(16);
        LinkedHashSet<Object> tipInfos = new LinkedHashSet<Object>(16);
        LinkedHashSet<Object> tipInfosMust = new LinkedHashSet<Object>(16);
        result.setAddMap(addMap);
        result.setUpdateMap(updateMap);
        result.setSqlValues(sqlValues);
        result.setTipInfos(tipInfos);
        result.setTipInfosMust(tipInfosMust);
        return result;
    }

    protected DataModelImportJsonService getImportJsonService(DataModelInnerParam innerParam) {
        return new DataModelImportJsonService(innerParam);
    }
}

