/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.importmodel.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.sonmodel.MainSubModelEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelConfig;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelCurrentLine;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelGlobalParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelInnerParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.TableEntity;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportGetNewValue;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportPrepare;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportPrepareSpecial;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportSql;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.DMDataCheckFile;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.DMSpecialFeildImport;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.DMSpecialFieldExecAnalysisCanvas;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelCommon;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelLogUtil;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class DataModelImportJsonService {
    protected DataModelInnerParam innerParam;
    protected DataModelGlobalParam globlaParams;
    protected Map<String, List<Long>> notNeedUpdateFidMap;
    private static Log log = LogFactory.getLog(DataModelImportJsonService.class);
    private Set<String> updateMainTableSet = new HashSet<String>(16);

    public DataModelImportJsonService(DataModelInnerParam innerParam) {
        this.innerParam = innerParam;
    }

    public void importDataSingleTable(DataModelGlobalParam globlaParams, JSONArray jsonCurTableAllDatas) {
        this.iniGloblaParams(globlaParams);
        DataModelCurrentLine currentLine = this.innerParam.getCurrentLine();
        if (this.isUpdateModel(this.innerParam.getImportParam().isExist(), currentLine.getTableName()) && !this.isNullObject(jsonCurTableAllDatas).booleanValue()) {
            ArrayList<Long> cachePkIds = new ArrayList<Long>(16);
            DataModelUtil.doLog("import_From_before_linesLoop:" + currentLine.getTableName(), log);
            Map<String, List<Object[]>> sqlValues = this.linesLoop(this.innerParam, jsonCurTableAllDatas, cachePkIds);
            Map<String, String> sqlStrs = this.getImportSqlInstance().iniSqlStrs(jsonCurTableAllDatas, DataModelConfig.getInstance().getSubTableRelateTables(), this.innerParam);
            DataModelLogUtil.doSizeLog(this.innerParam, currentLine, sqlValues, sqlStrs, globlaParams);
            DataModelUtil.doLog("import_From_after_linesLoop:" + currentLine.getTableName(), log);
            if (!this.innerParam.getImportParam().isOnlyCheckDataValiad()) {
                this.doSave(currentLine.getTableName(), jsonCurTableAllDatas, sqlStrs, sqlValues);
                DataModelUtil.doLog("import_From_before_saveRecord_updateCache:" + currentLine.getTableName(), log);
                this.updateCache(currentLine.getMainTableName(), cachePkIds);
            }
        }
    }

    private void iniGloblaParams(DataModelGlobalParam globlaParams) {
        this.globlaParams = globlaParams;
        this.notNeedUpdateFidMap = new HashMap<String, List<Long>>(16);
    }

    private Map<String, List<Object[]>> linesLoop(DataModelInnerParam innerParam, JSONArray jsonCurTableAllDatas, List<Long> cachePkIds) {
        Map<String, List<Object[]>> sqlValues = DataModelImportSql.getInstance().iniSqlValues();
        TableEntity tableEntity = innerParam.getCurrentLine().getTableEntity();
        if (tableEntity.getPkids() == null || tableEntity.getPkids().size() == 0) {
            throw new KDBizException(tableEntity.getTableName() + " has no pkid.");
        }
        for (Object jsonCurLineObj : jsonCurTableAllDatas) {
            JSONObject jsonCurLineDate = (JSONObject)jsonCurLineObj;
            if (jsonCurLineDate.containsKey((Object)"fathertable") && jsonCurLineDate.keySet().size() <= 2) continue;
            this.cachePKId(jsonCurLineDate, tableEntity, cachePkIds);
            this.setCurrentLinePara(jsonCurLineDate);
            if (DMSpecialFeildImport.getInstance().isSkipLine(innerParam, this.globlaParams)) continue;
            DataModelImportPrepare.getInstance().putSpecJsonMaps(this.globlaParams, jsonCurLineDate, tableEntity);
            if (this.isNotNeedTable(innerParam, this.updateMainTableSet)) continue;
            this.fieldsLoop(sqlValues);
        }
        return sqlValues;
    }

    private void cachePKId(JSONObject jsonCurLineDate, TableEntity tableEntity, List<Long> cachePkIds) {
        if (DataModelUtil.isMainTable(tableEntity.getTableName()).booleanValue()) {
            cachePkIds.add(Long.parseLong(jsonCurLineDate.getString(tableEntity.getPkids().get(0))));
        }
    }

    private void setCurrentLinePara(JSONObject jsonCurLineDate) {
        this.innerParam.getCurrentLine().setLineJsonObj(jsonCurLineDate);
        this.innerParam.getCurrentLine().setUpdate(this.isUpdateSql(this.innerParam.getCurrentLine()));
        this.innerParam.getCurrentLine().setSkip(false);
        this.innerParam.getCurrentLine().setFieldPart("");
    }

    private void fieldsLoop(Map<String, List<Object[]>> sqlValues) {
        DataModelCurrentLine currentLine = this.innerParam.getCurrentLine();
        if (currentLine == null || currentLine.getLineJsonObj() == null) {
            return;
        }
        Long id = IDUtils.toLong((Object)DataModelCommon.getInstance().getFieldValueFromJson(currentLine.getLineJsonObj(), DataModelTransEnum.getFIDName(currentLine.getTableName()), currentLine.getTableEntity().getColumns()));
        if (this.getDetailInfo(id)) {
            return;
        }
        String tableName = currentLine.getTableEntity().getTableName();
        ArrayList<Object> valueLst = new ArrayList<Object>(currentLine.getTableEntity().getFields().size());
        boolean isMainTable = DataModelUtil.isMainTable(tableName);
        for (FieldInfo fieldInfo : currentLine.getTableEntity().getFields()) {
            String fieldName = fieldInfo.getFieldName();
            currentLine.setFieldName(fieldName);
            currentLine.setValue(currentLine.getLineJsonObj().getString(fieldName));
            currentLine.setFieldPart("");
            Object field = null;
            if (!currentLine.isUpdate() ? !this.getFeildImportInstance().isInsertField(this.innerParam.getImportParam(), tableName, fieldName) : !this.getFeildImportInstance().isUpdateField(this.innerParam, tableName, fieldName) || isMainTable && currentLine.getTableEntity().getPkids().contains(fieldName)) continue;
            if (currentLine.getTableEntity().getPkids().contains(fieldName)) {
                field = DataModelImportGetNewValue.getInstance().update2NewPKID(this.globlaParams, this.innerParam);
                if (!this.innerParam.getCurrentLine().getMainTableName().equalsIgnoreCase(this.innerParam.getCurrentLine().getTableName())) {
                    if ("t_eb_mainsubmodel_rele".equals(tableName)) {
                        Long freleid = currentLine.getLineJsonObj().getLong("FRELEDATAID");
                        String freletype = currentLine.getLineJsonObj().getString("FRELETYPE");
                        MainSubModelEnum enumByNumber = MainSubModelEnum.getEnumByTree((String)freletype);
                        if (enumByNumber != null) {
                            Map mainsubmodelReleMap = this.innerParam.getResult().getMainSubModelUpdateMap().computeIfAbsent("t_eb_mainsubmodel_rele", t -> new HashMap(16));
                            Map reledataidFieldMap = mainsubmodelReleMap.computeIfAbsent("freledataid", t -> new HashMap(16));
                            Map reledataid = reledataidFieldMap.computeIfAbsent(enumByNumber.getEntity(), t -> new HashMap(16));
                            Set longs = reledataid.computeIfAbsent(freleid, t -> new HashSet(16));
                            longs.add(IDUtils.toLong((Object)field));
                        }
                    } else if ("t_eb_mainsubmodel_bizmode".equals(tableName)) {
                        Long fbasedataid = currentLine.getLineJsonObj().getLong("FBASEDATAID");
                        Map mainsubmodelBizmode = this.innerParam.getResult().getMainSubModelUpdateMap().computeIfAbsent("t_eb_mainsubmodel_bizmode", t -> new HashMap(16));
                        Map mainsubmodelBizmodeField = mainsubmodelBizmode.computeIfAbsent("fbasedataid", t -> new HashMap(16));
                        Map basedataid = mainsubmodelBizmodeField.computeIfAbsent(DataModelTransEnum.bizmodel.getFormID(), t -> new HashMap(16));
                        Set longs = basedataid.computeIfAbsent(fbasedataid, t -> new HashSet(16));
                        longs.add(IDUtils.toLong((Object)field));
                    }
                }
                if (DataModelTransEnum.mainsubmodelsynclog.getTableName().equalsIgnoreCase(tableName)) {
                    Long fsubmodel = currentLine.getLineJsonObj().getLong("FSUBMODEL");
                    Long fmainmodel = currentLine.getLineJsonObj().getLong("FMAINMODEL");
                    Map submodelsyncLog = this.innerParam.getResult().getMainSubModelUpdateMap().computeIfAbsent(DataModelTransEnum.mainsubmodelsynclog.getTableName(), t -> new HashMap(16));
                    Map submodelField = submodelsyncLog.computeIfAbsent("fsubmodel", t -> new HashMap(16));
                    Map subModel = submodelField.computeIfAbsent(DataModelTransEnum.model.getFormID(), t -> new HashMap(16));
                    Set subModelId = subModel.computeIfAbsent(fsubmodel, t -> new HashSet(16));
                    subModelId.add(IDUtils.toLong((Object)field));
                    Map mainmodelField = submodelsyncLog.computeIfAbsent("fmainmodel", t -> new HashMap(16));
                    Map mainModel = mainmodelField.computeIfAbsent(DataModelTransEnum.model.getFormID(), t -> new HashMap(16));
                    Set mainModelId = mainModel.computeIfAbsent(fmainmodel, t -> new HashSet(16));
                    mainModelId.add(IDUtils.toLong((Object)field));
                } else if (DataModelTransEnum.mainsubmodelbase.getTableName().equalsIgnoreCase(tableName)) {
                    if (IDUtils.isEmptyLong((Long)IDUtils.toLong((Object)field)).booleanValue()) continue;
                    Long fmainmodel = currentLine.getLineJsonObj().getLong("FMAINMODEL");
                    Map mainsubmodelbase = this.innerParam.getResult().getMainSubModelUpdateMap().computeIfAbsent(DataModelTransEnum.mainsubmodelbase.getTableName(), t -> new HashMap(16));
                    Map mainmodelField = mainsubmodelbase.computeIfAbsent("fmainmodel", t -> new HashMap(16));
                    Map mainModel = mainmodelField.computeIfAbsent(DataModelTransEnum.model.getFormID(), t -> new HashMap(16));
                    Set mainModelId = mainModel.computeIfAbsent(fmainmodel, t -> new HashSet(16));
                    mainModelId.add(IDUtils.toLong((Object)field));
                }
            } else {
                field = DataModelImportGetNewValue.getInstance().updated2TargetValue(DataModelConfig.getInstance().getSubTableRelateTables(), this.globlaParams, this.innerParam);
            }
            currentLine.setValue(DataModelUtil.getFieldByInfo(this.innerParam, currentLine, fieldInfo, field));
            DataModelImportPrepareSpecial.getInstance().putSubTableRelate(DataModelConfig.getInstance().getSubTableRelateTables(), currentLine, this.globlaParams.getNeedUpdateNumberMap());
            currentLine.setValue(DataModelUtil.getFieldByInfo(this.innerParam, currentLine, fieldInfo, this.getSpecialValues(fieldInfo, this.innerParam)));
            valueLst.add(currentLine.getValue());
        }
        if (this.innerParam.getCurrentLine().isSkip()) {
            return;
        }
        this.getSqlValues(id, sqlValues, valueLst);
    }

    private void getSqlValues(Long id, Map<String, List<Object[]>> sqlValues, List<Object> valueLst) {
        DataModelCurrentLine currentLine = this.innerParam.getCurrentLine();
        Boolean isMainTable = DataModelUtil.isMainTable(currentLine.getTableName());
        if (currentLine.isUpdate()) {
            if (isMainTable.booleanValue()) {
                valueLst.add(this.globlaParams.getNeedUpdateNumberMap().get(currentLine.getTableName()).get(id));
                sqlValues.get("update").add(valueLst.toArray());
                DataModelLogUtil.doSizeLog(this.globlaParams, this.innerParam, currentLine, id, valueLst, "update");
            }
        } else {
            Map<Long, Long> entryMap = this.globlaParams.getNeedUpdateNumberMap().get(currentLine.getMainTableName());
            if (!isMainTable.booleanValue() && entryMap != null && entryMap.get(id) != null && entryMap.get(id).compareTo(0L) != 0) {
                Object[] whereValue = new Object[]{entryMap.get(id)};
                sqlValues.get("delete").add(whereValue);
                DataModelLogUtil.doSizeLog(this.globlaParams, this.innerParam, currentLine, id, valueLst, "delete");
            }
            if (DataModelTransEnum.viewmember.getTableName().equalsIgnoreCase(currentLine.getTableName())) {
                Map<String, Set<String>> dimensionVirtualViewMemberMap = this.globlaParams.getDimensionVirtualViewMemberMap();
                String importType = this.innerParam.getImportParam().getImportType();
                if (!"3".equalsIgnoreCase(importType) && dimensionVirtualViewMemberMap.size() > 0) {
                    Set<String> numbers;
                    Map<Long, String> dimensionIdNumberMapFromJson;
                    String fmembersource = currentLine.getLineJsonObj().getString("FMEMBERSOURCE");
                    String fnumber = currentLine.getLineJsonObj().getString("FNUMBER");
                    Long fdimension = currentLine.getLineJsonObj().getLong("FDIMENSIONID");
                    Map<String, Map<Long, String>> numberJsonMap = this.globlaParams.getNumberJsonMap();
                    String dimensionNumFromJson = "";
                    if (numberJsonMap != null && (dimensionIdNumberMapFromJson = numberJsonMap.get(DataModelTransEnum.dimension.getTableName())) != null) {
                        dimensionNumFromJson = dimensionIdNumberMapFromJson.get(fdimension);
                    }
                    if (MemberSourceEnum.PRESET.getIndex().equalsIgnoreCase(fmembersource) && CollectionUtils.isNotEmpty(numbers = dimensionVirtualViewMemberMap.get(dimensionNumFromJson)) && numbers.contains(fnumber)) {
                        this.innerParam.getResult().setHasErrorData(true);
                        this.innerParam.getImportParam().setOnlyCheckDataValiad(true);
                        this.innerParam.getResult().getTipInfosMust().add(ResManager.loadResFormat((String)"\u865a\u62df\u6210\u5458\u201c%1\u201d\u5728\u76ee\u6807\u4f53\u7cfb\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff0c\u76f8\u540c\u7ef4\u5ea6\u4e0b\u4e0d\u540c\u7684\u89c6\u56fe\u4e0d\u5141\u8bb8\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u865a\u62df\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataModelImportJsonService_001", (String)"epm-eb-formplugin", (Object[])new Object[]{fnumber}));
                        return;
                    }
                }
            }
            sqlValues.get("insert").add(valueLst.toArray());
            DataModelLogUtil.doSizeLog(this.globlaParams, this.innerParam, currentLine, id, valueLst, "insert");
        }
    }

    private Boolean isNullObject(Object data) {
        JSONArray jsonArr = (JSONArray)data;
        return jsonArr == null || jsonArr.size() == 0;
    }

    private boolean isUpdateModel(Boolean isExist, String table) {
        return isExist == false || DMSpecialFeildImport.getInstance().isUpdateTable(table);
    }

    private void updateCache(String mainTableThisTime, List<Long> cachePkIds) {
        if (cachePkIds.size() == 0) {
            return;
        }
        String formid = DataModelTransEnum.getFormIDByTableName(mainTableThisTime);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formid));
        cacheManager.removeByPrimaryKey(new Object[]{cachePkIds});
        BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formid));
    }

    public void doSave(String table, JSONArray jsonCurTableAllDatas, Map<String, String> sqlStrs, Map<String, List<Object[]>> sqlValues) {
        DMSpecialFeildImport.getInstance().beforeSave(table, sqlStrs, sqlValues);
        DataModelUtil.doLog("import_From_before_doSave:" + table, log);
        this.doSaveBatch(sqlStrs.get("delete"), sqlValues.get("delete"));
        this.doSaveBatch(sqlStrs.get("insert"), sqlValues.get("insert"));
        this.doSaveBatch(sqlStrs.get("update"), sqlValues.get("update"));
        DMDataCheckFile.getInstance().doDelErrMainTableDatas(this.innerParam, this.globlaParams);
        DMSpecialFeildImport.getInstance().afterSave(table, jsonCurTableAllDatas, this.innerParam, this.globlaParams);
        DataModelUtil.doLog("import_From_after_doSave:" + table, log);
    }

    public void doSaveBatch(String sql, List<Object[]> sqlList) {
        if (CollectionUtils.isEmpty(sqlList) || StringUtils.isEmpty((CharSequence)sql)) {
            return;
        }
        if (sqlList.size() > 0 && !sqlList.isEmpty()) {
            int fetchSize;
            int n = fetchSize = this.innerParam.getImportParam().getSqlBatch() == 0 ? 6000 : this.innerParam.getImportParam().getSqlBatch();
            for (int pos = 0; pos <= sqlList.size() && fetchSize > 0; pos += fetchSize) {
                if (fetchSize > sqlList.size() - pos) {
                    fetchSize = sqlList.size() - pos;
                }
                if (fetchSize <= 0) continue;
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sql, sqlList.subList(pos, pos + fetchSize));
            }
        }
    }

    private boolean getDetailInfo(Long id) {
        List<Long> list;
        String importType = this.innerParam.getImportParam().getImportType();
        String tableName = this.innerParam.getCurrentLine().getTableName();
        Boolean isMainTable = DataModelUtil.isMainTable(tableName);
        if (isMainTable.booleanValue()) {
            if (this.innerParam.getCurrentLine().isUpdate()) {
                if ("2".equals(importType)) {
                    List<Long> list2 = this.notNeedUpdateFidMap.get(tableName);
                    if (list2 == null) {
                        list2 = new ArrayList<Long>(16);
                        this.notNeedUpdateFidMap.put(tableName, list2);
                    }
                    list2.add(id);
                    return true;
                }
                this.detailMapAddValue(this.innerParam.getResult().getUpdateMap(), tableName);
            } else {
                this.detailMapAddValue(this.innerParam.getResult().getAddMap(), tableName);
            }
        }
        if (!isMainTable.booleanValue() && "2".equals(importType) && (list = this.notNeedUpdateFidMap.get(this.innerParam.getCurrentLine().getMainTableName())) != null && list.contains(id)) {
            this.putSubTableRelate();
            return true;
        }
        return false;
    }

    private void putSubTableRelate() {
        DataModelCurrentLine currentLine = this.innerParam.getCurrentLine();
        Map<String, String> languageChild = DataModelConfig.getInstance().getSubTableRelateTables();
        if (languageChild.containsKey(currentLine.getTableName())) {
            currentLine.setValue(currentLine.getLineJsonObj().getString(languageChild.get(currentLine.getTableName())));
            DataModelImportPrepareSpecial.getInstance().putSubTableRelate(languageChild, currentLine, this.globlaParams.getNeedUpdateNumberMap());
        }
    }

    private void detailMapAddValue(Map<String, Integer> map, String key) {
        Integer count = map.get(key);
        if (count != null) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            map.put(key, count);
        } else {
            map.put(key, 1);
        }
    }

    private boolean isUpdateSql(DataModelCurrentLine currentLine) {
        Map<Long, Long> targetValueMap = this.globlaParams.getNeedUpdateNumberMap().get(currentLine.getTableName());
        if (targetValueMap == null || targetValueMap.size() == 0 || !DataModelUtil.isMainTable(currentLine.getTableName()).booleanValue()) {
            return false;
        }
        Set<String> columnNames = currentLine.getTableEntity().getColumns();
        String tableName = currentLine.getTableName();
        Long id = IDUtils.toLong((Object)DataModelCommon.getInstance().getFieldValueFromJson(currentLine.getLineJsonObj(), DataModelTransEnum.getFIDName(tableName), columnNames));
        if ("t_eb_analysiscanvas".equalsIgnoreCase(tableName)) {
            return DMSpecialFieldExecAnalysisCanvas.getInstance().checkSameModelId(this.innerParam);
        }
        return DataModelUtil.isMainTable(tableName) != false && targetValueMap.get(id) != null;
    }

    protected Object getSpecialValues(FieldInfo fieldInfo, DataModelInnerParam innerParam) {
        DataModelCurrentLine currentLine = innerParam.getCurrentLine();
        Object returnObject = currentLine.getValue();
        String field = currentLine.getFieldName();
        String table = currentLine.getTableName();
        if (fieldInfo.getDataType().startsWith("timestamp") && !DataModelConfig.changeDateFields.contains(field.toUpperCase(Locale.getDefault())) && !DataModelConfig.defaultDateFields.contains(field.toUpperCase(Locale.getDefault()))) {
            returnObject = null;
        }
        if (DataModelConfig.changeDateFields.contains(field.toUpperCase())) {
            if (!"t_eb_currencyconvertlist".equalsIgnoreCase(table)) {
                returnObject = this.getCurrentTime();
            } else if ("t_eb_currencyconvertlist".equalsIgnoreCase(table) && "FENDMODIFYTIME".equalsIgnoreCase(field) && (currentLine.getValue() == null || currentLine.getValue().toString().isEmpty())) {
                returnObject = null;
            } else if ("t_eb_currencyconvertlist".equalsIgnoreCase(table) && "FENDMODIFYTIME".equalsIgnoreCase(field) && currentLine.getValue() != null && !currentLine.getValue().toString().isEmpty()) {
                returnObject = this.strToDate(currentLine.getLineJsonObj().getString(field));
            }
        } else if (DataModelConfig.defaultDateFields.contains(field.toUpperCase())) {
            if (currentLine.getValue() != null && StringUtils.isNotEmpty((CharSequence)currentLine.getValue().toString())) {
                Set<String> entrySet = DataModelConfig.getInstance().getSpeicalFormId().get(table);
                if (entrySet == null || entrySet != null && entrySet.contains(field)) {
                    returnObject = this.strToDate(currentLine.getValue().toString());
                }
            } else {
                returnObject = null;
            }
        }
        if (DataModelConfig.getInstance().getSpeicalFormId().containsKey(table) && ("FEFFDATE".equalsIgnoreCase(field) || "FEXPDATE".equalsIgnoreCase(field))) {
            returnObject = currentLine.getLineJsonObj().getString(field);
        }
        if (DataModelConfig.defaultUserFields.contains(field.toUpperCase()) && (!"t_eb_currencyconvertlist".equalsIgnoreCase(table) || "t_eb_currencyconvertlist".equalsIgnoreCase(table) && "FENDMODIFIER".equalsIgnoreCase(field) && currentLine.getValue() != null && !currentLine.getValue().toString().equalsIgnoreCase("0"))) {
            returnObject = this.getUserId();
        }
        return returnObject;
    }

    private Date getCurrentTime() {
        return Convert.toDate((Object)System.currentTimeMillis());
    }

    private Date strToDate(String str) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        Long time = null;
        try {
            try {
                time = Long.parseLong(str);
            }
            catch (NumberFormatException e) {
                time = format.parse(str).getTime();
            }
            date = Convert.toDate((Object)time);
        }
        catch (ParseException e) {
            DataModelUtil.doLog("import_From_strToDate:" + str, log);
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        return date;
    }

    protected Long getUserId() {
        return UserUtils.getUserId();
    }

    protected boolean isNotNeedTable(DataModelInnerParam innerParam, Set<String> updateMainTableSet) {
        return false;
    }

    protected DataModelImportSql getImportSqlInstance() {
        return DataModelImportSql.getInstance();
    }

    protected DMSpecialFeildImport getFeildImportInstance() {
        return DMSpecialFeildImport.getInstance();
    }
}

