/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.importmodel.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.examine.ExamineServiceHelper;
import kd.epm.eb.business.utils.PermControlDimUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportResult;
import kd.epm.eb.formplugin.dataModelTrans.enums.ImportModelTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportCheck;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportDetail;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportGetNewValue;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.DMSpecialFeildQuote;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelCommon;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelIsLeafUtil;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;
import kd.epm.epbs.business.bd.model.ModelSyncHelper;

public class DataModelImportMain {
    private static Log log = LogFactory.getLog(DataModelImportMain.class);

    public DataModelImportResult doSave(DataModelImportParam importParam) {
        if (importParam == null) {
            return null;
        }
        DataModelUtil.doLog("import_From_before_checkImportParams", log);
        if (!DataModelImportCheck.getInstance().checkImportParams(importParam)) {
            return null;
        }
        DataModelUtil.doLog("import_From_before_saveJson", log);
        DataModelImportResult result = this.saveJson(importParam);
        if (DataModelCommon.getInstance().isBreakImport(result, importParam)) {
            return result;
        }
        this.logErrInfo(result, importParam);
        DataModelUtil.doLog("import_From_before_save_updateModelCache", log);
        this.updateModelCache(importParam.getToModelID());
        ModelSyncHelper.saveEpbsModel((Long)importParam.getToModelID(), (String)BusinessDataServiceHelper.loadSingle((Object)importParam.getToModelID(), (String)"epm_model").getString("reporttype"));
        DataModelUtil.doLog("import_From_before_save_SyncProcess", log);
        if (importParam.getImportModelTypeEnum() != ImportModelTypeEnum.MAINSUB) {
            this.SyncProcess(result, importParam);
            this.SyncProcessOther(result, importParam);
        }
        DataModelUtil.doLog("import_From_after_save_OlapCheckService", log);
        return result;
    }

    private void modifyPerm(DataModelImportParam importParam) {
        try (TXHandle tx = TX.requiresNew((String)"modifyPerm");){
            try {
                DataModelUtil.doLog("import_From_prepare_changeModelPerm", log);
                if (!importParam.isExist()) {
                    List<Long> longs = Collections.singletonList(this.getUserId(importParam));
                    DataModelUtil.doLog("import_From_begin_delPermByUser", log);
                    FunPermissionHelper.delPermByUser((Long)importParam.getToModelID(), longs);
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"addEPMPermByUsers", (Object[])new Object[]{importParam.getToModelID(), longs});
                    DataModelUtil.doLog("import_From_after_delPermByUser", log);
                }
            }
            catch (Throwable e1) {
                tx.markRollback();
                DataModelUtil.doLog(e1.getMessage(), log);
            }
        }
    }

    protected DataModelImportResult save(DataModelImportParam importParam) {
        if (importParam == null) {
            return null;
        }
        DataModelImportDetail DMImport = new DataModelImportDetail();
        DataModelImportResult result = DMImport.importDataLoop(importParam);
        return result;
    }

    private DataModelImportResult saveJson(DataModelImportParam importParam) {
        if (importParam == null) {
            return null;
        }
        DataModelImportResult result = null;
        try {
            DataModelUtil.doLog("import_From_begin_DataModelImportParam", log);
            result = this.save(importParam);
            DataModelUtil.doLog("import_From_after_DataModelImportParam", log);
            if (!importParam.isExist()) {
                DataModelUtil.doLog("import_From_begin_changeModelPerm", log);
                this.changeModelPerm(importParam);
                DataModelUtil.doLog("import_From_after_changeModelPerm", log);
            }
        }
        catch (Throwable e1) {
            log.error("\u6a21\u578b\u4f20\u8f93\u9519\u8bef:", e1);
            DataModelUtil.doLog(e1.getMessage(), log);
            throw e1;
        }
        finally {
            DataModelImportGetNewValue.modelCacheHelperThreadLocal.remove();
        }
        return result;
    }

    protected void changeModelPerm(DataModelImportParam importParam) {
        Long modelid = importParam.getToModelID();
        QFilter filter = new QFilter("model", "=", (Object)modelid);
        DynamicObject modelPerm = BusinessDataServiceHelper.loadSingle((String)"epm_modelperm", (String)"id,model,username,createtime,modifytime,creator,modifier,modelpermentry,modelpermentry.seq,modelpermentry.etype,modelpermentry.eusers", (QFilter[])new QFilter[]{filter});
        if (modelPerm == null) {
            modelPerm = BusinessDataServiceHelper.newDynamicObject((String)"epm_modelperm");
            modelPerm.set("id", (Object)DBServiceHelper.genGlobalLongId());
            modelPerm.set("model", (Object)modelid);
        }
        Date time = TimeServiceHelper.now();
        modelPerm.set("username", (Object)this.getUserName(importParam));
        modelPerm.set("createtime", (Object)time);
        modelPerm.set("modifytime", (Object)time);
        modelPerm.set("creator", (Object)this.getUserId(importParam));
        modelPerm.set("modifier", (Object)this.getUserId(importParam));
        DynamicObjectCollection permEntrys = modelPerm.getDynamicObjectCollection("modelpermentry");
        permEntrys.clear();
        DynamicObject permEntry = new DynamicObject(permEntrys.getDynamicObjectType());
        permEntry.set("id", (Object)DBServiceHelper.genGlobalLongId());
        permEntry.set("seq", (Object)1);
        permEntry.set("etype", (Object)"bos_user");
        permEntry.set("eusers", (Object)this.getUserId(importParam));
        permEntrys.add((Object)permEntry);
        BusinessDataWriter.save((IDataEntityType)modelPerm.getDataEntityType(), (Object[])new Object[]{modelPerm});
    }

    private void updateModelCache(Long modelId) {
        ModelCacheContext.getOrCreate((Long)modelId, (boolean)true);
        MemberPropCacheService.rebulid((Long)modelId);
    }

    private void syncOlapData(DataModelImportParam importParam) {
        Long modelId = importParam.getToModelID();
        DynamicObject modelObj = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"epm_model");
        ArrayList<Dataset> datasets = new ArrayList<Dataset>(10);
        ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((DynamicObject)modelObj);
        if (ModelServiceHelper.isEBModel((DynamicObject)modelObj)) {
            datasets.add(new Dataset(modelId, modelObj.getString("shownumber")));
        } else if (ShrekOlapServiceHelper.needDMLOlap((DynamicObject)modelObj)) {
            datasets = DatasetServiceHelper.getAllDatasets((Long)modelId);
        }
        this.olapLog(importParam, datasets, modelObj);
        Model model = Model.of((DynamicObject)modelObj);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        try {
            for (Dataset dataset : datasets) {
                if (!ShrekOlapServiceHelper.existCube((Model)model, (Dataset)dataset)) {
                    ShrekOlapServiceHelper.createCube((Model)model, (Dataset)dataset, (IModelCacheHelper)modelCacheHelper, (ShrekConfig)config);
                    continue;
                }
                ShrekOlapServiceHelper.updateCube((Model)model, (Dataset)dataset, (IModelCacheHelper)modelCacheHelper, (ShrekConfig)config);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u6216\u65b0\u5efacube\u4e0d\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u89c6\u56fe\u3001\u6570\u636e\u96c6\u4e0b\u662f\u5426\u6709\u660e\u7ec6\u6210\u5458\u3002", (String)"DataModelImportMain_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void olapLog(DataModelImportParam importParam, List<Dataset> datasets, DynamicObject modelObj) {
        DataModelUtil.doLog("import_From_begin_olapLog.", log);
        String dataSource = modelObj == null ? " modelObj is null " : (modelObj.get("datasource") == null ? " modelObj.get(datasource) is null " : modelObj.get("datasource.id").toString());
        String logInfoHead = StringUtils.join((Object[])new Serializable[]{"olapLog:", importParam.getFileName(), "_", importParam.getToModelID(), "_", importParam.isExist() ? "has" : "new", "_", dataSource, " _ dataset.size :", Integer.valueOf(datasets.size()), " || "});
        StringBuilder str = new StringBuilder();
        str.append(logInfoHead);
        for (Dataset ds : datasets) {
            str.append(StringUtils.join((Object[])new Serializable[]{ds.getId(), " || ", ds.getNumber(), "\n"}));
        }
        DataModelUtil.doLog(str.toString(), log);
    }

    protected Long getUserId(DataModelImportParam importParam) {
        return UserUtils.getUserId();
    }

    protected String getUserName(DataModelImportParam importParam) {
        return UserUtils.getUserName();
    }

    public void SyncProcess(DataModelImportResult result, DataModelImportParam importParam) {
        try {
            try {
                DataModelUtil.doLog("import_From_before_save_upgradeExamineRangeData", log);
                ExamineServiceHelper.getInstance().upgradeExamineRangeData(importParam.getToModelID());
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            try {
                DataModelUtil.doLog("import_From_before_save_repairDimMemberLeafStatus", log);
                DataModelIsLeafUtil.repairDimMemberLeafStatus(importParam.getToModelID(), true);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            try {
                DataModelUtil.doLog("import_From_before_save_syncOlapData", log);
                this.syncOlapData(importParam);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            try {
                DataModelUtil.doLog("import_From_before_save_OlapCheckService", log);
                CubeUtils.updateCubeVersion((Long)importParam.getToModelID());
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            EpmThreadPools.CommPools.submit(() -> {
                DMSpecialFeildQuote.getInstance().doQuoteAfterModelImport(result, importParam);
                String _modelId = IDUtils.toString((Object)importParam.getToModelID());
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"LanguageUpgradeService", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{_modelId, null, null, null});
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"LanguageDimUpgradeService", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{_modelId, null, null, null});
                DataModelUtil.doLog("LanguageUpgradeService executed", log);
                return "";
            });
        }
        catch (Exception e) {
            this.doErrLog(importParam, e.getMessage());
        }
    }

    public void SyncProcessOther(DataModelImportResult result, DataModelImportParam importParam) {
        try {
            if ("3".equals(importParam.getImportType())) {
                DataModelUtil.doLog("import_From_before_prePermControlDim", log);
                PermControlDimUtil.prePermControlDim((Long)importParam.getToModelID());
            }
            DataModelUtil.doLog("import_From_before_modifyPerm", log);
            this.modifyPerm(importParam);
        }
        catch (Exception e) {
            this.doErrLog(importParam, e.getMessage());
        }
    }

    private void doErrLog(DataModelImportParam importParam, String ExceptionString) {
        try {
            DynamicObject object = DataModelUtil.createErrLog(importParam, "Exception", "Exception", ExceptionString);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
        catch (Exception e1) {
            DataModelUtil.doLog("import_From_SyncProcessOther" + e1.getMessage(), log);
        }
    }

    private void logErrInfo(DataModelImportResult result, DataModelImportParam importParam) {
        Set<Object> tipInfos = result.getTipInfos();
        if (tipInfos != null && tipInfos.size() > 0) {
            DynamicObject[] needSaves = new DynamicObject[tipInfos.size()];
            int i = 0;
            for (Object tipInfo : tipInfos) {
                DynamicObject object;
                needSaves[i] = object = DataModelUtil.createErrLog(importParam, "metename", "basedata", tipInfo.toString());
                ++i;
            }
            SaveServiceHelper.save((DynamicObject[])needSaves);
            result.getTipInfos().clear();
            result.setTipInfos(result.getTipInfosMust());
        }
    }
}

