/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.importmodel.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.sonmodel.MainSubModelEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelConfig;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.constant.DataModelConstant;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelGlobalParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.TableEntity;
import kd.epm.eb.formplugin.dataModelTrans.enums.OutputTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportPrepareSpecial;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelReadJsonFile;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.DMSpecialFeildTemplate;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelCommon;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelImportUtil;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.cache.TemplateCache;
import org.apache.commons.collections4.CollectionUtils;

public class DataModelImportPrepare {
    public static DataModelImportPrepare getInstance() {
        return InnerClass.instance;
    }

    private DataModelImportPrepare() {
    }

    public DataModelGlobalParam prepareData(DataModelImportParam importParam, JSONObject allJsonObject, Map<String, TableEntity> tableEntitys) {
        DataModelGlobalParam globalParams = new DataModelGlobalParam();
        this.initGlobalParams(globalParams);
        if (importParam.isUseSync()) {
            this.SyncprePareData(globalParams, allJsonObject);
        }
        this.initDBMap(globalParams, importParam);
        this.initJsonMap(globalParams, allJsonObject);
        this.initQuoteBaseData(tableEntitys, allJsonObject, globalParams);
        return globalParams;
    }

    private void SyncprePareData(DataModelGlobalParam globalParam, JSONObject allJsonObject) {
        EBThreadPoolExecutor.executeOnce(() -> {
            try {
                JSONArray currentTableData = DataModelReadJsonFile.getInstance().getTableDatasFromJson(allJsonObject, "eb_templateentity", "t_eb_template");
                DMSpecialFeildTemplate.getInstance().prepareTemplate(currentTableData, globalParam);
            }
            finally {
                TemplateCache.remove();
            }
        }, (String)"DataModelImportPrepare.SyncprePareData");
        for (MainSubModelEnum mainSubModelEnum : MainSubModelEnum.values()) {
        }
    }

    private void initGlobalParams(DataModelGlobalParam globalParams) {
        HashMap<String, Map<Long, Long>> needUpdateNumberMap = new HashMap<String, Map<Long, Long>>(DataModelConstant.ARRAYDEFAULTSIZE);
        HashMap<String, Map<Long, Long>> needUpdatePKIDMap = new HashMap<String, Map<Long, Long>>(DataModelConstant.ARRAYDEFAULTSIZE);
        HashMap<String, Map<Long, String>> jsonDimNumberMap = new HashMap<String, Map<Long, String>>(DataModelConstant.ARRAYDEFAULTSIZE);
        HashMap<String, Map<Long, Boolean>> jsonDimNumberIsLeaf = new HashMap<String, Map<Long, Boolean>>(DataModelConstant.ARRAYDEFAULTSIZE);
        ConcurrentHashMap<String, CopyOnWriteArraySet<Long>> jsonDimMemberIsAreadyUsed = new ConcurrentHashMap<String, CopyOnWriteArraySet<Long>>(DataModelConstant.ARRAYDEFAULTSIZE);
        HashMap<String, Map<Long, Long>> jsonDimMemberAndParent = new HashMap<String, Map<Long, Long>>(DataModelConstant.ARRAYDEFAULTSIZE);
        ArrayList<Map<String, Object>> specialMapFromJson = new ArrayList<Map<String, Object>>(DataModelConstant.ARRAYDEFAULTSIZE);
        HashMap<String, Map<Long, String>> numberDBMap = new HashMap<String, Map<Long, String>>(DataModelConstant.ARRAYDEFAULTSIZE);
        HashMap<String, Map<Long, String>> numberJsonMap = new HashMap<String, Map<Long, String>>(DataModelConstant.ARRAYDEFAULTSIZE);
        HashMap<String, Integer> dimenstionDseqMap = new HashMap<String, Integer>(DataModelConstant.ARRAYDEFAULTSIZE);
        HashMap<Long, String> dimenstionMap = new HashMap<Long, String>(DataModelConstant.ARRAYDEFAULTSIZE);
        HashMap<String, String> dimenstionNumberMap = new HashMap<String, String>(DataModelConstant.ARRAYDEFAULTSIZE);
        HashMap<String, Set<Long>> memberJsonMap = new HashMap<String, Set<Long>>(DataModelConstant.ARRAYDEFAULTSIZE);
        ConcurrentHashMap<Long, ITemplateModel> templataModels = new ConcurrentHashMap<Long, ITemplateModel>(DataModelConstant.ARRAYDEFAULTSIZE);
        ConcurrentHashMap<String, Set<Long>> rubishDatas = new ConcurrentHashMap<String, Set<Long>>(DataModelConstant.ARRAYDEFAULTSIZE);
        globalParams.setNumberDBMap(numberDBMap);
        globalParams.setNumberJsonMap(numberJsonMap);
        globalParams.setDimenstionDseqMap(dimenstionDseqMap);
        globalParams.setJsonDimNumberMap(jsonDimNumberMap);
        globalParams.setJsonDimNumberIsLeaf(jsonDimNumberIsLeaf);
        globalParams.setJsonDimMemberIsAreadyUsed(jsonDimMemberIsAreadyUsed);
        globalParams.setJsonDimParentAndMember(jsonDimMemberAndParent);
        globalParams.setNeedUpdateNumberMap(needUpdateNumberMap);
        globalParams.setNeedUpdatePKIDMap(needUpdatePKIDMap);
        globalParams.setSpecialMapFromJson(specialMapFromJson);
        globalParams.setDimenstionMap(dimenstionMap);
        globalParams.setDimenstionNumberMap(dimenstionNumberMap);
        globalParams.setMemberJsonMap(memberJsonMap);
        globalParams.setTemplataModels(templataModels);
        globalParams.setRubishDatas(rubishDatas);
    }

    public void putSpecJsonMaps(DataModelGlobalParam globalParams, JSONObject jsonCurLineDate, TableEntity tableEntity) {
        String table = tableEntity.getTableName();
        Set<String> columnNames = tableEntity.getColumns();
        if (table.equalsIgnoreCase("t_eb_dimension")) {
            Map<Long, String> dimenstionMap = globalParams.getDimenstionMap();
            Map<String, String> dimenstionNumberMap = globalParams.getDimenstionNumberMap();
            Long fid = IDUtils.toLong((Object)DataModelCommon.getInstance().getFieldValueFromJson(jsonCurLineDate, "FID", columnNames));
            String fnumber = DataModelCommon.getInstance().getFieldValueFromJson(jsonCurLineDate, "FNUMBER", columnNames);
            String fmemberTable = DataModelCommon.getInstance().getFieldValueFromJson(jsonCurLineDate, "FMEMBERTABLE", columnNames);
            if (fmemberTable != null) {
                dimenstionMap.put(fid, fmemberTable.toLowerCase());
                dimenstionNumberMap.put(fnumber, fmemberTable.toLowerCase());
            }
        } else if (DataModelConfig.membertable.contains(table)) {
            Map<String, Set<Long>> memberJsonMap = globalParams.getMemberJsonMap();
            Long fid = IDUtils.toLong((Object)DataModelCommon.getInstance().getFieldValueFromJson(jsonCurLineDate, "FID", columnNames));
            Set<Long> memberSet = memberJsonMap.get(table);
            if (null == memberSet) {
                memberSet = new HashSet<Long>(16);
                memberJsonMap.put(table.toLowerCase(), memberSet);
            }
            memberSet.add(fid);
        }
    }

    public void preparePKIDData(DataModelImportParam importParam, String formId, JSONObject jsonCurFormDate, DataModelGlobalParam globlaParams, Map<String, TableEntity> tableEntitys) {
        if (jsonCurFormDate == null) {
            return;
        }
        Map<String, Map<Long, Long>> needUpdateNumberMap = globlaParams.getNeedUpdateNumberMap();
        Map<String, Map<Long, Long>> needUpdatePKIDMap = globlaParams.getNeedUpdatePKIDMap();
        for (Map.Entry entry : jsonCurFormDate.entrySet()) {
            Map<Long, Long> targetPKIDMap;
            DataModelTransEnum dataM;
            String table = ((String)entry.getKey()).toLowerCase();
            if (entry.getValue() == null || (dataM = DataModelTransEnum.getEnumByTableName(table)) == null || dataM.getIsMainTable() == 0) continue;
            JSONArray jsonCurTableAllDatas = (JSONArray)entry.getValue();
            Map<Long, Long> numberExistsIds = this.getToNumberMapByTableName(importParam, tableEntitys.get(table), jsonCurTableAllDatas, globlaParams);
            if (numberExistsIds != null && numberExistsIds.size() > 0) {
                needUpdateNumberMap.put(table, numberExistsIds);
            }
            if ((targetPKIDMap = this.getToPKIDMapByTableName(importParam, tableEntitys.get(table), jsonCurTableAllDatas, numberExistsIds, globlaParams)) == null || targetPKIDMap.size() <= 0) continue;
            needUpdatePKIDMap.put(table, targetPKIDMap);
        }
    }

    private Map<Long, Long> getToNumberMapByTableName(DataModelImportParam importParam, TableEntity tableEntity, JSONArray jsonCurTableAllDatas, DataModelGlobalParam globlaParams) {
        String tableName = tableEntity.getTableName();
        Map<Long, Long> returnMap = new HashMap<Long, Long>(16);
        if (tableName.equalsIgnoreCase("t_eb_model")) {
            if (importParam.isExist()) {
                returnMap.put(importParam.getFromModelID(), importParam.getToModelID());
            }
        } else {
            String FNUMBER = DataModelTransEnum.getFnumberName(tableName);
            String FID = DataModelTransEnum.getFIDName(tableName);
            if (StringUtils.isEmpty((String)FNUMBER)) {
                return null;
            }
            Map<String, Long> uniqueFieldsMap = this.getUniqueFieldsSetByJson(tableEntity, FID, FNUMBER, jsonCurTableAllDatas, globlaParams);
            if (uniqueFieldsMap == null || uniqueFieldsMap.size() == 0) {
                return null;
            }
            Set<String> numberSet = DataModelImportPrepareSpecial.getInstance().getNumberSet(uniqueFieldsMap);
            if (!importParam.isOnlyCheckDataValiad()) {
                returnMap = this.getValiadNumberMaps(uniqueFieldsMap, numberSet, importParam, globlaParams, tableName, FID, FNUMBER);
            }
        }
        return returnMap;
    }

    private Map<Long, Long> getValiadNumberMaps(Map<String, Long> uniqueFieldsMap, Set<String> numberSet, DataModelImportParam importParam, DataModelGlobalParam globlaParams, String tableName, String FID, String FNUMBER) {
        HashMap<Long, Long> returnMap = new HashMap<Long, Long>(16);
        Long modelID = importParam.getToModelID();
        Row dataRow = null;
        try (DataSet dataset = DataModelCommon.getInstance().queryRecordByTableName(modelID, tableName);){
            if (dataset != null) {
                returnMap = new HashMap(DataModelConstant.ARRAYDEFAULTSIZE);
                while (dataset.hasNext()) {
                    String number;
                    dataRow = dataset.next();
                    String formId = null;
                    DataModelTransEnum enumByTableName = DataModelTransEnum.getEnumByTableName(tableName);
                    if (enumByTableName != null) {
                        formId = enumByTableName.getFormID();
                    }
                    if (!this.checkNumberIsExist(formId, number = DataModelUtil.getUpperOrLowerFieldValue(formId, dataRow.getString(FNUMBER)), numberSet)) continue;
                    Long jsonId = DataModelImportPrepareSpecial.getInstance().getJsonId(globlaParams, dataRow, uniqueFieldsMap, tableName, number);
                    if (!importParam.getFromModelID().equals(importParam.getToModelID()) && "t_eb_analysiscanvas".equalsIgnoreCase(tableName)) {
                        returnMap.put(jsonId, DBServiceHelper.genGlobalLongId());
                        continue;
                    }
                    if (jsonId == null || jsonId.compareTo(0L) <= 0) continue;
                    returnMap.put(jsonId, dataRow.getLong(FID));
                }
            }
        }
        return returnMap;
    }

    private Map<Long, Long> getToPKIDMapByTableName(DataModelImportParam importParam, TableEntity tableEntity, JSONArray jsonCurTableAllDatas, Map<Long, Long> numberExistsIds, DataModelGlobalParam globlaParams) {
        String tableName = tableEntity.getTableName();
        String FID = DataModelTransEnum.getFIDName(tableName);
        Set<Long> ids = this.getIdSetByJson(tableEntity, FID, jsonCurTableAllDatas);
        if (ids == null || ids.size() == 0) {
            return null;
        }
        HashMap<Long, Long> returnMap = new HashMap<Long, Long>(DataModelConstant.ARRAYDEFAULTSIZE);
        long[] globalIds = importParam.isOnlyCheckDataValiad() ? new long[1] : DBServiceHelper.genLongIds((String)tableName, (int)ids.size());
        int i = 0;
        for (Long id : ids) {
            if (!importParam.getFromModelID().equals(importParam.getToModelID()) && "t_eb_analysiscanvas".equalsIgnoreCase(tableName) && numberExistsIds != null && numberExistsIds.get(id) != null) {
                returnMap.put(id, numberExistsIds.get(id));
                continue;
            }
            if (numberExistsIds != null && numberExistsIds.containsKey(id) || DataModelImportUtil.isRubishData(tableName, id, globlaParams)) continue;
            if (importParam.isOnlyCheckDataValiad()) {
                returnMap.put(id, id);
                continue;
            }
            returnMap.put(id, globalIds[i]);
            ++i;
        }
        return returnMap;
    }

    private Map<String, Long> getUniqueFieldsSetByJson(TableEntity tableEntity, String fidName, String fNumberName, JSONArray jsonCurTableAllDatas, DataModelGlobalParam globlaParams) {
        HashMap<String, Long> returnMap = new HashMap<String, Long>(DataModelConstant.ARRAYDEFAULTSIZE);
        Set rubishDatas = globlaParams.getRubishDatas().computeIfAbsent(tableEntity.getTableName(), k -> new HashSet(16));
        String formId = null;
        DataModelTransEnum enumByTableName = DataModelTransEnum.getEnumByTableName(tableEntity.getTableName());
        if (enumByTableName != null) {
            formId = enumByTableName.getFormID();
        }
        for (Object js : jsonCurTableAllDatas) {
            JSONObject curLineData = (JSONObject)js;
            if (null == curLineData || curLineData.size() <= 0 || curLineData.containsKey((Object)"fathertable")) continue;
            String uniqueFieldsKey = DataModelUtil.getUpperOrLowerFieldValue(formId, curLineData.getString(fNumberName));
            uniqueFieldsKey = DataModelImportPrepareSpecial.getInstance().getUniqueFieldsKeyByJson(globlaParams, uniqueFieldsKey, tableEntity, curLineData);
            Long fid = curLineData.getLong(fidName);
            if (!DataModelImportUtil.isRubishData(tableEntity.getTableName(), fid, globlaParams) && !returnMap.containsKey(uniqueFieldsKey)) {
                returnMap.put(uniqueFieldsKey, fid);
                continue;
            }
            rubishDatas.add(fid);
        }
        return returnMap;
    }

    private void initQuoteBaseDataMap(JSONObject curLineData, TableEntity tableEntity, DataModelGlobalParam globlaParams) {
        Map<Long, Long> dimMemberAndParent;
        Map<Long, Boolean> stringBooleanMap;
        String table = tableEntity.getTableName();
        Map<Long, String> dimNumbers = globlaParams.getJsonDimNumberMap().get(table);
        if (dimNumbers == null) {
            dimNumbers = new HashMap<Long, String>(16);
            globlaParams.getJsonDimNumberMap().put(table, dimNumbers);
        }
        if ((stringBooleanMap = globlaParams.getJsonDimNumberIsLeaf().get(table)) == null) {
            stringBooleanMap = new HashMap<Long, Boolean>(16);
            globlaParams.getJsonDimNumberIsLeaf().put(table, stringBooleanMap);
        }
        if ((dimMemberAndParent = globlaParams.getJsonDimParentAndMember().get(table)) == null) {
            dimMemberAndParent = new HashMap<Long, Long>(16);
            globlaParams.getJsonDimParentAndMember().put(table, dimMemberAndParent);
        }
        Long fid = IDUtils.toLong((Object)DataModelCommon.getInstance().getFieldValueFromJson(curLineData, "FID", tableEntity.getColumns()));
        String fnumber = DataModelCommon.getInstance().getFieldValueFromJson(curLineData, "FNUMBER", tableEntity.getColumns());
        String fisleaf = DataModelCommon.getInstance().getFieldValueFromJson(curLineData, "FISLEAF", tableEntity.getColumns());
        Long fparentid = IDUtils.toLong((Object)DataModelCommon.getInstance().getFieldValueFromJson(curLineData, "FPARENTID", tableEntity.getColumns()));
        Long fdimensionId = IDUtils.toLong((Object)DataModelCommon.getInstance().getFieldValueFromJson(curLineData, "FDIMENSIONID", tableEntity.getColumns()));
        dimNumbers.put(fid, fnumber + (table.equalsIgnoreCase("t_eb_structofdefined") ? "!" + fdimensionId : ""));
        stringBooleanMap.put(fid, fisleaf.equalsIgnoreCase("1"));
        dimMemberAndParent.put(fparentid, fid);
    }

    private boolean checkNumberIsExist(String formId, String number, Set<String> numberSet) {
        if (DataModelTransEnum.customproperty.getFormID().equalsIgnoreCase(formId) || DataModelTransEnum.custompropertyvalue.getFormID().equalsIgnoreCase(formId)) {
            return numberSet.contains(number);
        }
        return numberSet.contains(number.toUpperCase());
    }

    private Set<Long> getIdSetByJson(TableEntity tableEntity, String fidName, JSONArray jsonCurTableAllDatas) {
        String tableName = tableEntity.getTableName();
        DataModelTransEnum dataM = DataModelTransEnum.getEnumByTableName(tableName);
        if (dataM == null) {
            return null;
        }
        if (dataM.getIsMainTable() == 0) {
            return null;
        }
        HashSet<Long> ids = new HashSet<Long>(DataModelConstant.ARRAYDEFAULTSIZE);
        for (Object js : jsonCurTableAllDatas) {
            JSONObject jsonbj = (JSONObject)js;
            if (null == jsonbj || jsonbj.size() <= 0 || jsonbj.containsKey((Object)"fathertable")) continue;
            ids.add(jsonbj.getLong(fidName));
        }
        return ids;
    }

    private void initDBMap(DataModelGlobalParam globalParams, DataModelImportParam importParam) {
        if (!importParam.isExist()) {
            return;
        }
        this.initDimenstionDBMap(globalParams, importParam.getToModelID());
        DataModelConfig.getInstance().initMapFromDB(globalParams, importParam.getToModelID());
    }

    private void initVirtualMemberDBMap(DataModelGlobalParam globalParams, Long toModelID) {
        Map<String, Set<String>> dimensionVirtualViewMemberMap = globalParams.getDimensionVirtualViewMemberMap();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_viewmember", (String)"dimension.number, number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)toModelID), new QFilter("membersource", "=", (Object)MemberSourceEnum.PRESET.getIndex())});
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject dynamicObject : query) {
                Set strings = dimensionVirtualViewMemberMap.computeIfAbsent(dynamicObject.getString("dimension.number"), t -> new HashSet(16));
                strings.add(dynamicObject.getString("number"));
            }
        }
    }

    private void initDimenstionDBMap(DataModelGlobalParam globalParams, Long modelID) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelID);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"epm_dimension", (String)"id,number,dseq,version,shortnumber,fieldmapped", (QFilter[])qFilter.toArray());
        int maxSeq = 0;
        int maxFieldMapping = 0;
        Map dimenstionDBMap = globalParams.getNumberDBMap().computeIfAbsent("t_eb_dimension", k -> new HashMap(16));
        for (DynamicObject dim : list) {
            Integer mapping;
            String fieldMapping;
            dimenstionDBMap.put(dim.getLong("id"), DataModelUtil.getUpperOrLowerFieldValue(null, dim.getString("number")));
            Integer dseq = dim.getInt("dseq");
            if (dseq != null && dseq > maxSeq) {
                maxSeq = dseq;
            }
            if (StringUtils.isEmpty((String)(fieldMapping = dim.getString("fieldmapped"))) || (mapping = Integer.valueOf(fieldMapping.replaceAll("dim", ""))) == null || mapping <= maxFieldMapping) continue;
            maxFieldMapping = mapping;
        }
        Map<String, Integer> dimenstionDseqMap = globalParams.getDimenstionDseqMap();
        dimenstionDseqMap.put("t_eb_dimension_seq", maxSeq);
        dimenstionDseqMap.put("t_eb_dimension_fieldmapping", maxFieldMapping);
    }

    private void initQuoteBaseData(Map<String, TableEntity> tableEntitys, JSONObject allJsonObject, DataModelGlobalParam globlaParams) {
        List<String> dimFromId = DataModelTransEnum.getAllMainTableFormID(OutputTypeEnum.DEFAULT.getCode());
        for (String strEntityName : dimFromId) {
            JSONObject entityData = DataModelReadJsonFile.getInstance().getFormDatasFromJson(allJsonObject, strEntityName);
            if (entityData == null) continue;
            for (Map.Entry entry : entityData.entrySet()) {
                String table = ((String)entry.getKey()).toLowerCase();
                DataModelTransEnum dataM = DataModelTransEnum.getEnumByTableName(table);
                if (dataM == null || dataM.getIsMainTable() == 0 || !DataModelConfig.membertable.contains(table)) continue;
                JSONArray jsonCurTableAllDatas = (JSONArray)entry.getValue();
                if (jsonCurTableAllDatas == null) {
                    return;
                }
                for (Object js : jsonCurTableAllDatas) {
                    JSONObject curLineData = (JSONObject)js;
                    if (null == curLineData || curLineData.size() <= 0 || curLineData.containsKey((Object)"fathertable")) continue;
                    this.initQuoteBaseDataMap(curLineData, tableEntitys.get(table), globlaParams);
                }
            }
        }
    }

    private void initJsonMap(DataModelGlobalParam globlaParams, JSONObject allJsonObject) {
        DataModelConfig.getInstance().initMapFromJSON(globlaParams, allJsonObject);
    }

    public Map<String, TableEntity> getTableEntitys(JSONObject jsonFormData) {
        HashMap<String, TableEntity> returns = new HashMap<String, TableEntity>(16);
        if (jsonFormData == null) {
            return returns;
        }
        for (Map.Entry entry : jsonFormData.entrySet()) {
            String table = ((String)entry.getKey()).toLowerCase();
            JSONArray jsonCurTableAllDatas = (JSONArray)entry.getValue();
            TableEntity tableEntity = DataModelCommon.getInstance().getTableEntity(table, jsonCurTableAllDatas);
            returns.put(table, tableEntity);
        }
        return returns;
    }

    private static class InnerClass {
        private static DataModelImportPrepare instance = new DataModelImportPrepare();

        private InnerClass() {
        }
    }
}

