/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.importmodel.service;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelConfig;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelCurrentLine;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelGlobalParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.TableEntity;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelCommon;
import org.apache.commons.lang3.StringUtils;

public class DataModelImportPrepareSpecial {
    public static DataModelImportPrepareSpecial getInstance() {
        return InnerClass.instance;
    }

    private DataModelImportPrepareSpecial() {
    }

    public Set<String> getNumberSet(Map<String, Long> numberValueMap) {
        HashSet<String> returns = new HashSet<String>(numberValueMap.size());
        for (Map.Entry<String, Long> numberValue : numberValueMap.entrySet()) {
            String[] numberArr = numberValue.getKey().split(",");
            returns.add(numberArr[0]);
        }
        return returns;
    }

    public String getUniqueFieldsKeyByJson(DataModelGlobalParam globlaParams, String numberValue, TableEntity tableEntity, JSONObject curLineData) {
        String tableName = tableEntity.getTableName();
        Set<String> columns = tableEntity.getColumns();
        DataModelTransEnum enumObj = DataModelTransEnum.getEnumByTableName(tableName);
        String uniqueFields = enumObj.getUniqueFields();
        Set rubishDatas = globlaParams.getRubishDatas().computeIfAbsent(tableName, k -> new HashSet(16));
        if (StringUtils.isEmpty((CharSequence)uniqueFields)) {
            return numberValue;
        }
        String[] fields = uniqueFields.split(",");
        String fieldKey = numberValue;
        for (String field : fields) {
            String fieldValue = DataModelCommon.getInstance().getFieldValueFromJson(curLineData, field, columns);
            String uniqueStr = DataModelConfig.getInstance().getUniqueFieldKeyNumber(globlaParams, fieldValue, field, false);
            fieldKey = StringUtils.join((Object[])new String[]{fieldKey, ",", uniqueStr});
            if (!StringUtils.isEmpty((CharSequence)uniqueStr)) continue;
            rubishDatas.add(IDUtils.toLong((Object)DataModelCommon.getInstance().getFieldValueFromJson(curLineData, "FID", columns)));
        }
        return fieldKey;
    }

    public Long getJsonId(DataModelGlobalParam globlaParams, Row dataRow, Map<String, Long> uniqueFieldsMap, String tableName, String number) {
        DataModelTransEnum enumObj = DataModelTransEnum.getEnumByTableName(tableName);
        String uniqueFields = enumObj.getUniqueFields();
        String fieldKey = number;
        if (!StringUtils.isEmpty((CharSequence)uniqueFields)) {
            String[] fields;
            for (String field : fields = uniqueFields.split(",")) {
                fieldKey = StringUtils.join((Object[])new String[]{fieldKey, ",", DataModelConfig.getInstance().getUniqueFieldKeyNumber(globlaParams, dataRow.getLong(field), field, true)});
            }
        }
        return uniqueFieldsMap.get(fieldKey);
    }

    public void putSubTableRelate(Map<String, String> subTableRelateTables, DataModelCurrentLine currentLine, Map<String, Map<Long, Long>> needUpdateNumberMap) {
        if (subTableRelateTables.containsKey(currentLine.getTableName()) && subTableRelateTables.get(currentLine.getTableName()).contains(currentLine.getFieldName())) {
            Map<Long, Long> nameMap = needUpdateNumberMap.get(currentLine.getTableName());
            if (null == nameMap) {
                nameMap = new HashMap<Long, Long>(16);
                needUpdateNumberMap.put(currentLine.getTableName(), nameMap);
            }
            nameMap.put(currentLine.getLineJsonObj().getLong(subTableRelateTables.get(currentLine.getTableName())), IDUtils.toLong((Object)currentLine.getValue()));
        }
    }

    private static class InnerClass {
        private static DataModelImportPrepareSpecial instance = new DataModelImportPrepareSpecial();

        private InnerClass() {
        }
    }
}

