/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.importmodel.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.FieldInfo;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelInnerParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.TableEntity;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.DMSpecialFeildImport;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class DataModelImportSql {
    public static DataModelImportSql getInstance() {
        return InnerClass.instance;
    }

    protected DataModelImportSql() {
    }

    public Map<String, String> iniSqlStrs(JSONArray jsonCurTableAllDatas, Map<String, String> languageChildTableMap, DataModelInnerParam innerParam) {
        HashMap<String, String> returns = new HashMap<String, String>(16);
        TableEntity tableEntity = innerParam.getCurrentLine().getTableEntity();
        String sqlInsert = this.getInsertSql(tableEntity.getFields(), tableEntity.getTableName(), innerParam.getImportParam());
        String sqlDelete = this.getDeleteSql(languageChildTableMap, tableEntity.getTableName(), jsonCurTableAllDatas, innerParam.getCurrentLine().getMainTableName());
        String sqlUpdate = this.getUpdateSql(jsonCurTableAllDatas, tableEntity.getFields(), tableEntity.getTableName(), tableEntity.getPkids(), innerParam);
        if (StringUtils.isNotBlank((CharSequence)sqlInsert)) {
            returns.put("insert", sqlInsert);
        }
        if (StringUtils.isNotBlank((CharSequence)sqlDelete)) {
            returns.put("delete", sqlDelete);
        }
        if (StringUtils.isNotBlank((CharSequence)sqlUpdate)) {
            returns.put("update", sqlUpdate);
        }
        return returns;
    }

    public Map<String, List<Object[]>> iniSqlValues() {
        HashMap<String, List<Object[]>> sqlValues = new HashMap<String, List<Object[]>>(16);
        ArrayList insertSqlList = new ArrayList(16);
        ArrayList deleteSqlList = new ArrayList(16);
        ArrayList updateSqlList = new ArrayList(16);
        sqlValues.put("insert", insertSqlList);
        sqlValues.put("delete", deleteSqlList);
        sqlValues.put("update", updateSqlList);
        return sqlValues;
    }

    public String getDeleteSql(Map<String, String> languageChildTableMap, String table, JSONArray jsonCurTableAllDatas, String mainTableThisTime) {
        if (languageChildTableMap.containsKey(mainTableThisTime)) {
            JSONObject jsonobj = (JSONObject)jsonCurTableAllDatas.get(0);
            String relationfield = jsonobj.getString("fatherrelationfield");
            return this.getDeleteSql(table, relationfield);
        }
        return this.getDeleteSql(table, null);
    }

    private String getDeleteSql(String table, String relationfield) {
        String fid = relationfield;
        if (StringUtils.isEmpty((CharSequence)fid)) {
            fid = DataModelTransEnum.getFIDName(table);
        }
        String sql = "delete from " + table + " where " + fid + " = ? ";
        return sql;
    }

    public String getUpdateSql(JSONArray jsonCurTableAllDatas, List<FieldInfo> columnNames, String table, List<String> pkid, DataModelInnerParam innerParam) {
        Boolean isMainTable = DataModelUtil.isMainTable(table);
        if (!isMainTable.booleanValue()) {
            return null;
        }
        StringBuilder strflag = new StringBuilder();
        if (CollectionUtils.isEmpty(columnNames)) {
            return "";
        }
        for (FieldInfo col : columnNames) {
            if (!this.getFeildImportInstance().isUpdateField(innerParam, table, col.getFieldName()) || isMainTable.booleanValue() && pkid.contains(col.getFieldName())) continue;
            strflag.append(StringUtils.join((Object[])new String[]{col.getFieldName(), " = ?,"}));
        }
        String values = strflag.substring(0, strflag.length() - 1);
        String FID = DataModelTransEnum.getFIDName(table);
        String where = " where " + FID + " = ? ";
        String sql = "update " + table + " set " + values + where;
        return sql;
    }

    public String getInsertSql(List<FieldInfo> fieldInfos, String table, DataModelImportParam importParam) {
        StringJoiner joiner = new StringJoiner(",");
        StringBuilder strflag = new StringBuilder();
        if (CollectionUtils.isEmpty(fieldInfos)) {
            return "";
        }
        for (FieldInfo fieldInfo : fieldInfos) {
            if (!this.getFeildImportInstance().isInsertField(importParam, table, fieldInfo.getFieldName())) continue;
            strflag.append("?,");
            joiner.add(fieldInfo.getFieldName());
        }
        String values = strflag.substring(0, strflag.length() - 1);
        String sql = "insert into " + table + " (" + joiner.toString() + ")  values (" + values + ")";
        return sql;
    }

    protected DMSpecialFeildImport getFeildImportInstance() {
        return DMSpecialFeildImport.getInstance();
    }

    private static class InnerClass {
        private static DataModelImportSql instance = new DataModelImportSql();

        private InnerClass() {
        }
    }
}

