/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.importmodel.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelConfig;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelGlobalParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import org.apache.commons.collections4.CollectionUtils;

public class DataModelOlapCheck {
    private static final Log log = LogFactory.getLog(DataModelOlapCheck.class);

    public static DataModelOlapCheck getInstance() {
        return InnerClass.instance;
    }

    private DataModelOlapCheck() {
    }

    public void checkAlreadyUsedDimen(DataModelImportParam importParam, DataModelGlobalParam globlaParams) {
        if ("3".equals(importParam.getImportType())) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(DataModelConfig.membertable.size());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)importParam.getToModelID());
        for (String table : DataModelConfig.membertable) {
            EpmThreadPools.CommPools.submit(() -> {
                try {
                    this.doCheckAlreadyUsedDimen(table, modelCacheHelper, importParam, globlaParams);
                }
                catch (Exception e) {
                    log.error(String.format("[%s]_DataModelOlapCheck_error!", table), (Throwable)e);
                }
                finally {
                    latch.countDown();
                }
                return "";
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("getExamDims_MianSubThread_interrupted!", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private void doCheckAlreadyUsedDimen(String tableName, IModelCacheHelper modelCacheHelper, DataModelImportParam importParam, DataModelGlobalParam globlaParams) {
        if (!"3".equals(importParam.getImportType())) {
            Dimension dimension;
            String dimensionNumber;
            Map<String, Map<Long, String>> jsonDimNumberMap = globlaParams.getJsonDimNumberMap();
            Map<String, Map<Long, Boolean>> numberIsLeaf = globlaParams.getJsonDimNumberIsLeaf();
            ConcurrentHashMap<String, CopyOnWriteArraySet<Long>> memberIsAreadyUsed = globlaParams.getJsonDimMemberIsAreadyUsed();
            Long modelId = importParam.getToModelID();
            Map<Long, String> dimens = jsonDimNumberMap.get(tableName);
            if (dimens == null || dimens.size() == 0) {
                return;
            }
            Map<Long, Boolean> leafMap = numberIsLeaf.get(tableName);
            CopyOnWriteArraySet longSet = memberIsAreadyUsed.computeIfAbsent(tableName, k -> new CopyOnWriteArraySet());
            String string = dimensionNumber = SysDimensionEnum.getEnumByMemberTreeTable((String)tableName) == null ? "" : SysDimensionEnum.getEnumByMemberTreeTable((String)tableName);
            if (StringUtils.isEmpty((Object)dimensionNumber)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868\u201c%1$s\u201d\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4e0d\u5b58\u5728", (String)"DataModelOlapCheck_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), tableName));
            }
            HashMap<Long, Set> memberIdMap = new HashMap<Long, Set>(16);
            HashMap<String, Long> jsonNumberToId = new HashMap<String, Long>(16);
            for (Map.Entry<Long, String> entry : dimens.entrySet()) {
                Member member;
                Long fid = entry.getKey();
                String number = "";
                if (tableName.equalsIgnoreCase("t_eb_structofdefined")) {
                    number = entry.getValue().split("!")[0];
                    dimensionNumber = globlaParams.getNumberJsonMap().get("t_eb_dimension").get(IDUtils.toLong((Object)entry.getValue().split("!")[1]));
                    if (StringUtils.isEmpty((Object)dimensionNumber)) {
                        continue;
                    }
                } else {
                    number = entry.getValue();
                }
                if (fid == null || globlaParams.getNumberJsonMap().get("t_eb_dimension").containsKey(fid)) continue;
                jsonNumberToId.put(number, fid);
                boolean isLeaf = leafMap.get(fid);
                if (isLeaf || (dimension = modelCacheHelper.getDimension(dimensionNumber)) == null || (member = dimension.getStructOfMember(number)) == null || !member.isLeaf()) continue;
                memberIdMap.computeIfAbsent(member.getDimension().getId(), k -> new HashSet(16)).add(member.getId());
            }
            for (Map.Entry entry : memberIdMap.entrySet()) {
                Long dimenId = (Long)entry.getKey();
                Set memberIdSet = (Set)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)memberIdSet) || (dimension = modelCacheHelper.getDimension(dimenId)) == null) continue;
                CheckQuote checkQuote = QuoteBuilder.build((Long)modelId, (Long)dimenId, (Set)memberIdSet);
                Set quoteSet = MemberQuote.get().checkDataQuote(checkQuote);
                if (CollectionUtils.isNotEmpty((Collection)quoteSet)) {
                    Set<Long> transJsonIdSet = this.transJsonMemberNumberSet(quoteSet, modelCacheHelper, dimension.getNumber(), jsonNumberToId, checkQuote.getViewId());
                    for (Long memberId : transJsonIdSet) {
                        this.addSubMemberIds(globlaParams.getJsonDimParentAndMember().get(tableName), longSet, memberId);
                    }
                }
                jsonNumberToId.clear();
            }
        }
    }

    private Set<Long> transJsonMemberNumberSet(Set<Long> quoteSet, IModelCacheHelper modelCacheHelper, String dimenNumber, Map<String, Long> jsonNumberToId, Long viewId) {
        HashSet<String> tmpNumberSet = new HashSet<String>((int)((double)quoteSet.size() * 1.75 + 1.0));
        for (Long quoteId : quoteSet) {
            Member member = modelCacheHelper.getMember(dimenNumber, viewId, quoteId);
            if (member == null) continue;
            tmpNumberSet.add(member.getNumber());
        }
        if (CollectionUtils.isEmpty(tmpNumberSet)) {
            return new HashSet<Long>(0);
        }
        return tmpNumberSet.stream().filter(number -> IDUtils.isNotNull((Long)((Long)jsonNumberToId.get(number)))).map(number -> (Long)jsonNumberToId.get(number)).collect(Collectors.toSet());
    }

    private void addSubMemberIds(Map<Long, Long> parentAndMember, Set<Long> targetSet, Long memberId) {
        if (parentAndMember == null || parentAndMember.size() == 0) {
            return;
        }
        if (IDUtils.isNotNull((Long)memberId)) {
            if (targetSet.contains(memberId)) {
                return;
            }
            targetSet.add(memberId);
            Long childrenId = parentAndMember.get(memberId);
            if (childrenId == null) {
                return;
            }
            this.addSubMemberIds(parentAndMember, targetSet, childrenId);
        }
    }

    private static class InnerClass {
        private static DataModelOlapCheck instance = new DataModelOlapCheck();

        private InnerClass() {
        }
    }
}

