/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.importmodel.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.exception.KDBizException;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.utils.compress.CompressUtils;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class DataModelReadJsonFile {
    private static final Log log = LogFactory.getLog(DataModelReadJsonFile.class);
    public static String export_temp_file_prefix = "epm-eb-temp-datamodel-transport-export/";
    public static String zipFileNamePrefix = "epm-eb-temp-datamodel-transport-export-zip/";
    public static long timeout_delete_temp_file = 0x6DDD00L;

    public static DataModelReadJsonFile getInstance() {
        return InnerClass.instance;
    }

    private DataModelReadJsonFile() {
    }

    public static void deleteTimeOutFile(String path) {
        File[] files;
        long timeStamp = TimeServiceHelper.getTimeStamp();
        String[] split = path.split("/");
        File dirFile = new File(FilenameUtils.getName((String)split[0]));
        if (split.length > 1) {
            dirFile = new File(FilenameUtils.getName((String)split[0]) + "/", FilenameUtils.getName((String)split[1]));
        }
        if ((files = dirFile.listFiles()) != null) {
            for (File file : files) {
                long l;
                if (file.isFile()) continue;
                String name = file.getName();
                try {
                    l = Long.parseLong(name);
                }
                catch (NumberFormatException ex) {
                    DataModelUtil.doLog("timeout parse file name is failed.", log);
                    log.error((Throwable)ex);
                    continue;
                }
                long offset = timeStamp - l;
                if (offset < timeout_delete_temp_file) continue;
                DataModelReadJsonFile.deleteFile(file);
            }
        }
    }

    public static void deleteFile(File deleteFile) {
        log.info("begin delete temp file.");
        if (deleteFile == null) {
            return;
        }
        if (!deleteFile.exists()) {
            return;
        }
        log.info("begin delete temp file name:" + deleteFile.getName());
        File[] files = deleteFile.listFiles();
        if (files == null) {
            boolean delete;
            if (deleteFile.exists() && !(delete = deleteFile.delete())) {
                DataModelUtil.doLog("temp file delete is failed1.", log);
            }
        } else {
            boolean delete;
            for (File file : files) {
                boolean delete2;
                if (!file.exists()) continue;
                DataModelReadJsonFile.deleteFile(file);
                if (!file.exists() || (delete2 = file.delete())) continue;
                DataModelUtil.doLog("temp file delete is failed.", log);
            }
            if (deleteFile.exists() && !(delete = deleteFile.delete())) {
                DataModelUtil.doLog("temp file delete is failed2.", log);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readJsonTempFileNamesFromZipFile(String fileUrl, Long timeStamp) {
        String[] queryParams;
        ArrayList<String> result = new ArrayList<String>(16);
        try {
            queryParams = new URL(fileUrl).getQuery().split("&");
        }
        catch (MalformedURLException e) {
            return result;
        }
        LinkedHashMap<String, String> downloadFileParams = new LinkedHashMap<String, String>(queryParams.length);
        for (String queryParam : queryParams) {
            String[] p = queryParam.split("=");
            downloadFileParams.put(p[0], p[1]);
        }
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        InputStream inStream = content.getInputStream();
        InputStream inputStream = null;
        try {
            ZipEntry zipEntry;
            ZipInputStream zipArchiveInputStream = new ZipInputStream(inStream);
            while ((zipEntry = zipArchiveInputStream.getNextEntry()) != null) {
                boolean directory = zipEntry.isDirectory();
                if (directory) {
                    log.info("in zip first is directory.");
                    List<String> list = null;
                    return list;
                }
                String name = zipEntry.getName();
                if (!name.endsWith(".json")) {
                    List<String> list = null;
                    return list;
                }
                String zipName = this.compressFile(name, zipArchiveInputStream);
                inputStream = Files.newInputStream(Paths.get(FilenameUtils.getName((String)new File(FilenameUtils.getName((String)zipName)).getPath()), new String[0]), new OpenOption[0]);
                result.add(CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipName, inputStream, 7200));
                DataModelReadJsonFile.deleteFile(new File(FilenameUtils.getName((String)zipName)));
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
            List<String> list = null;
            return list;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return result;
    }

    public String unCompressFile(ZipInputStream zipInputStream) throws IOException {
        ZipEntry entry;
        byte[] buffer = new byte[1024];
        String fileName = null;
        long timeStamp = TimeServiceHelper.getTimeStamp();
        while ((entry = zipInputStream.getNextEntry()) != null) {
            fileName = timeStamp + "-" + entry.getName();
            File outputFile = new File(FilenameUtils.getName((String)fileName));
            if (entry.isDirectory()) continue;
            try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
                int bytesRead;
                while ((bytesRead = zipInputStream.read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, bytesRead);
                }
            }
            zipInputStream.closeEntry();
        }
        return fileName;
    }

    public String compressFile(String tempFileName, InputStream inputStream) {
        long timeStamp = TimeServiceHelper.getTimeStamp();
        String zipFileName = timeStamp + "-" + tempFileName + ".zip";
        File file = new File(FilenameUtils.getName((String)zipFileName));
        if (!file.exists()) {
            try {
                boolean newFile = file.createNewFile();
                if (!newFile) {
                    log.info("compressFile delete file failed.");
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(Paths.get(FilenameUtils.getName((String)file.getPath()), new String[0]), new OpenOption[0]));){
            this.addToZipFile(tempFileName, zipOutputStream, inputStream);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        return zipFileName;
    }

    private void addToZipFile(String fileName, ZipOutputStream zipOutputStream, InputStream inputStream) throws IOException {
        int len;
        ZipEntry entry = new ZipEntry(fileName);
        zipOutputStream.putNextEntry(entry);
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) > 0) {
            zipOutputStream.write(buf, 0, len);
        }
        zipOutputStream.closeEntry();
    }

    public JSONObject readJsonFile(DataModelImportParam importParam, String formID) {
        JSONObject jsonObject;
        String fileUrl = importParam.getFileUrl();
        JSONObject apiJsonObject = importParam.getJsonAllObject();
        if (apiJsonObject != null) {
            return StringUtils.isEmpty((String)formID) ? apiJsonObject : apiJsonObject.getJSONObject(formID);
        }
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inStream = null;
        try {
            String sourceJson;
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            LinkedHashMap<String, String> downloadFileParams = new LinkedHashMap<String, String>(queryParams.length);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            inStream = content.getInputStream();
            DataModelUtil.doLog("readJsonFile_JSONObject.parseObject", log);
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)inStream);
                sourceJson = CompressUtils.get().unCompressByInflater(bytes);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
                inStream = content.getInputStream();
                sourceJson = IOUtils.toString((InputStream)inStream, (Charset)StandardCharsets.UTF_8);
            }
            if (sourceJson == null) {
                JSONObject e = null;
                return e;
            }
            Object jsonObj = this.getEncryptJson(sourceJson);
            jsonObject = jsonObj instanceof String ? JSONObject.parseObject((String)((String)jsonObj), (Feature[])new Feature[]{Feature.OrderedField}) : (JSONObject)jsonObj;
            DataModelUtil.doLog("readJsonFile_after_JSONObject.parseObject", log);
            if (!StringUtils.isEmpty((String)formID)) {
                jsonObject = jsonObject == null ? null : jsonObject.getJSONObject(formID);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7[%1]", (String)"DataModelReadJsonFile_001", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return jsonObject;
    }

    public Object getEncryptJson(String sourceJson) {
        Object encryPtJson = null;
        try {
            if (sourceJson.startsWith("MH")) {
                encryPtJson = EncrypterFactory.getAesEncrypter().decrypt(sourceJson);
            }
            if (sourceJson.startsWith("ey")) {
                byte[] decode = Base64.getDecoder().decode(sourceJson);
                encryPtJson = new String(decode, "UTF-8");
            }
            if (sourceJson.startsWith("rO")) {
                encryPtJson = SerializationUtils.deSerializeFromBase64((String)sourceJson);
            }
            if (sourceJson.startsWith("{\"")) {
                encryPtJson = sourceJson;
            }
            if (sourceJson.startsWith("\"rO")) {
                encryPtJson = SerializationUtils.deSerializeFromBase64((String)sourceJson.substring(1, sourceJson.length() - 1));
            }
        }
        catch (Exception e) {
            DataModelUtil.doLog("getEncryptJson_Base64." + e.getMessage(), log);
            throw new KDBizException(ResManager.loadResFormat((String)"\u683c\u5f0f\u9519\u8bef\u6216\u8005\u79d8\u94a5\u4e0d\u5bf9\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa\u4f53\u7cfb\u540e\u518d\u5bfc\u5165\u3002", (String)"DataModelReadJsonFile_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return encryPtJson;
    }

    public String transEncryptStr(String sourceJson) {
        try {
            sourceJson = EncrypterFactory.getAesEncrypter().decrypt(sourceJson);
            return sourceJson;
        }
        catch (Exception e) {
            return sourceJson;
        }
    }

    public JSONObject getFormDatasFromJson(JSONObject allJsonObject, String formID) {
        if (allJsonObject == null) {
            return null;
        }
        return allJsonObject.getJSONObject(formID);
    }

    public JSONArray getTableDatasFromJson(JSONObject allJsonObject, String formID, String tableName) {
        JSONObject formIdDatas = this.getFormDatasFromJson(allJsonObject, formID);
        if (formIdDatas == null) {
            return null;
        }
        return formIdDatas.getJSONArray(tableName);
    }

    private static class InnerClass {
        private static final DataModelReadJsonFile instance = new DataModelReadJsonFile();

        private InnerClass() {
        }
    }
}

