/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.part;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.formplugin.dataModelTrans.part.DataModelConfig;
import org.apache.commons.lang3.StringUtils;

public class DataModelICUtil {
    public static DataModelICUtil getInstance() {
        return InnerClass.instance;
    }

    private DataModelICUtil() {
    }

    public void addICInfos(Long modelId, Map<Long, Set<Long>> entityViewMemberIds, boolean queryDefaultIcMember, Map<String, Set<Long>> outs) {
        if (queryDefaultIcMember) {
            this.addBaseViewDefaults(modelId, outs);
        }
        this.getICByEntitys(modelId, queryDefaultIcMember, entityViewMemberIds, outs);
    }

    private void addBaseViewDefaults(Long modelId, Map<String, Set<Long>> outs) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("membersource", "=", (Object)Character.valueOf('1'));
        String formId = "epm_icmembertree";
        DynamicObject query = QueryServiceHelper.queryOne((String)formId, (String)"id,number", (QFilter[])qFilter.toArray());
        if (query != null) {
            Set entrys = outs.computeIfAbsent(formId, k -> new HashSet(16));
            entrys.add(query.getLong("id"));
        }
    }

    private Map<Long, Long> getEntityICViewIdMap(Long modelId, Map<Long, Set<Long>> entityViewMemberIds, Map<String, Set<Long>> outs) {
        if (entityViewMemberIds == null) {
            return null;
        }
        HashMap<String, Long> EntityViewNumberIds = new HashMap<String, Long>(entityViewMemberIds.size());
        SqlBuilder sqlFilters = new SqlBuilder();
        sqlFilters.append(StringUtils.join((Object[])new Serializable[]{"select fid,fnumber,fdimensionid,fsource from t_eb_dimensionview where fmodelid = ", modelId}), new Object[0]);
        sqlFilters.appendIn(" and ( fid ", entityViewMemberIds.keySet().toArray());
        sqlFilters.append("         or fnumber = 'E001' ", new Object[0]);
        sqlFilters.append(" ) ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)DataModelICUtil.class.getName(), (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlFilters);){
            while (ds.hasNext()) {
                Row row = ds.next();
                EntityViewNumberIds.put(StringUtils.join((Object[])new String[]{"IC_", row.getString("fnumber")}), row.getLong("fid"));
            }
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "in", EntityViewNumberIds.keySet());
        DynamicObjectCollection querys = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,number,dimension,source", (QFilter[])qFilter.toArray());
        if (querys == null) {
            return null;
        }
        Set icViews = outs.computeIfAbsent("eb_dimensionview", k -> new HashSet(16));
        HashMap<String, Long> ICViewNumberIds = new HashMap<String, Long>(16);
        for (DynamicObject query : querys) {
            icViews.add(query.getLong("id"));
            ICViewNumberIds.put(query.getString("number"), query.getLong("id"));
        }
        HashMap<Long, Long> entityIcViewIdMap = new HashMap<Long, Long>(EntityViewNumberIds.size());
        for (Map.Entry entry : EntityViewNumberIds.entrySet()) {
            entityIcViewIdMap.put((Long)entry.getValue(), (Long)ICViewNumberIds.get(entry.getKey()));
        }
        return entityIcViewIdMap;
    }

    public Long getOneBaseViewId(Long modelId, String baseViewNumber) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "=", (Object)baseViewNumber);
        DynamicObject querys = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id,number,dimension,source", (QFilter[])qFilter.toArray());
        if (querys != null) {
            return querys.getLong("id");
        }
        return 0L;
    }

    public Map<Long, Set<String>> getMemberNumberByIds(String dimensionNumber, Long modelId, Map<Long, Set<Long>> entityViewMemberIds) {
        if (entityViewMemberIds == null || entityViewMemberIds.size() == 0) {
            return null;
        }
        HashMap<Long, Set<String>> returns = new HashMap<Long, Set<String>>(entityViewMemberIds.size());
        SqlBuilder sqlFilters = new SqlBuilder();
        sqlFilters.append(StringUtils.join((Object[])new Serializable[]{"select fid,fnumber,fviewid,fdimensionid from t_eb_viewmember where fmodelid = ", modelId}), new Object[0]);
        int i = 0;
        boolean hasKuoHao = false;
        Long baseViewId = this.getOneBaseViewId(modelId, "IC_E001");
        for (Map.Entry<Long, Set<Long>> entityStr : entityViewMemberIds.entrySet()) {
            Long viewId = entityStr.getKey();
            if (viewId.compareTo(0L) == 0 || viewId.compareTo(baseViewId) == 0) {
                Long viewIdKey = 0L;
                if (viewId.compareTo(baseViewId) == 0) {
                    viewIdKey = baseViewId;
                }
                Set memberIds = returns.computeIfAbsent(viewIdKey, k -> new HashSet(16));
                this.addBaseViewMemberNumbers("t_eb_structofent", modelId, entityStr.getValue(), memberIds);
                continue;
            }
            if (i == 0) {
                hasKuoHao = true;
                sqlFilters.append(StringUtils.join((Object[])new Serializable[]{" and ( fviewid = ", viewId}), new Object[0]);
                sqlFilters.appendIn(" and fid ", entityStr.getValue().toArray());
            } else {
                sqlFilters.append(StringUtils.join((Object[])new Serializable[]{" or fviewid = ", viewId}), new Object[0]);
                sqlFilters.appendIn(" and fid ", entityStr.getValue().toArray());
            }
            ++i;
        }
        if (hasKuoHao) {
            sqlFilters.append(" ) ", new Object[0]);
            try (DataSet ds = DB.queryDataSet((String)DataModelICUtil.class.getName(), (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlFilters);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Set entitys = returns.computeIfAbsent(row.getLong("fviewid"), k -> new HashSet(16));
                    entitys.add(row.getString("fnumber"));
                }
            }
        }
        return returns;
    }

    private void getICByEntitys(Long modelId, boolean queryDefaultIcMember, Map<Long, Set<Long>> entityViewMemberIds, Map<String, Set<Long>> outs) {
        if (entityViewMemberIds == null || entityViewMemberIds.size() == 0) {
            return;
        }
        Map<Long, Long> entityIcViewIdMap = this.getEntityICViewIdMap(modelId, entityViewMemberIds, outs);
        Map<Long, Set<String>> entityViewMemberNums = this.getMemberNumberByIds("Entity", modelId, entityViewMemberIds);
        Long entityBaseViewId = this.getOneBaseViewId(modelId, "E001");
        SqlBuilder sqlFilters = new SqlBuilder();
        sqlFilters.append(StringUtils.join((Object[])new Serializable[]{"select fid,fnumber,fviewid,fdimensionid from t_eb_viewmember where fmodelid = ", modelId}), new Object[0]);
        int i = 0;
        boolean hasKuoHao = false;
        for (Map.Entry<Long, Set<String>> entrys : entityViewMemberNums.entrySet()) {
            Long entityViewId = entrys.getKey();
            if (entityViewId == null || entrys.getValue() == null) continue;
            HashSet<String> entityMembers = new HashSet<String>(16);
            if (queryDefaultIcMember) {
                entityMembers.addAll(DataModelConfig.icDefaults);
            }
            entityMembers.addAll((Collection)entrys.getValue());
            if (entityViewId.compareTo(0L) == 0 || entityViewId.compareTo(entityBaseViewId) == 0) {
                Set memberIds = outs.computeIfAbsent("epm_icmembertree", k -> new HashSet(16));
                this.addBaseViewMemberIds("t_eb_structoficentity", modelId, entityMembers, memberIds);
                continue;
            }
            Long icViewId = entityIcViewIdMap.get(entityViewId);
            if (icViewId == null) continue;
            if (i == 0) {
                hasKuoHao = true;
                sqlFilters.append(StringUtils.join((Object[])new Serializable[]{" and ( fviewid = ", icViewId}), new Object[0]);
                sqlFilters.appendIn(" and fnumber ", entityMembers.toArray());
            } else {
                sqlFilters.append(StringUtils.join((Object[])new Serializable[]{" or fviewid = ", icViewId}), new Object[0]);
                sqlFilters.appendIn(" and fnumber ", entityMembers.toArray());
            }
            ++i;
        }
        if (hasKuoHao) {
            sqlFilters.append(" ) ", new Object[0]);
            Set icViewMembers = outs.computeIfAbsent("eb_viewmember", k -> new HashSet(16));
            try (DataSet ds = DB.queryDataSet((String)DataModelICUtil.class.getName(), (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlFilters);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    icViewMembers.add(row.getLong("fid"));
                }
            }
            this.addEntityAndIcBaseViewMembers(modelId, entityViewMemberNums, outs);
        }
    }

    private void addEntityAndIcBaseViewMembers(Long modelId, Map<Long, Set<String>> entityViewMemberNums, Map<String, Set<Long>> outs) {
        if (entityViewMemberNums == null || entityViewMemberNums.size() == 0) {
            return;
        }
        HashSet<String> entityMembers = new HashSet<String>(16);
        for (Map.Entry<Long, Set<String>> entrys : entityViewMemberNums.entrySet()) {
            entityMembers.addAll(DataModelConfig.icDefaults);
            entrys.getValue().forEach(e -> entityMembers.add((String)e));
        }
        if (entityMembers == null || entityMembers.size() == 0) {
            return;
        }
        Set viewIds = outs.computeIfAbsent("eb_dimensionview", k -> new HashSet(16));
        viewIds.add(this.getOneBaseViewId(modelId, "E001"));
        viewIds.add(this.getOneBaseViewId(modelId, "IC_E001"));
        Set icMemberIds = outs.computeIfAbsent("epm_icmembertree", k -> new HashSet(16));
        this.addBaseViewMemberIds("t_eb_structoficentity", modelId, entityMembers, icMemberIds);
        Set entityMemberIds = outs.computeIfAbsent("epm_entitymembertree", k -> new HashSet(16));
        this.addBaseViewMemberIds("t_eb_structofent", modelId, entityMembers, entityMemberIds);
    }

    public Map<Long, Set<Long>> getEntityByICs(Long modelId, Map<Long, Set<String>> ICs) {
        boolean bl;
        HashMap<Long, Set<Long>> returns = new HashMap<Long, Set<Long>>(16);
        if (ICs == null || ICs.size() == 0) {
            return returns;
        }
        HashMap<String, Long> icViewNumberIds = new HashMap<String, Long>(ICs.size());
        SqlBuilder sqlFilters = new SqlBuilder();
        sqlFilters.append(StringUtils.join((Object[])new Serializable[]{"select fid,fnumber,fdimensionid,fsource from t_eb_dimensionview where fmodelid = ", modelId}), new Object[0]);
        sqlFilters.appendIn(" and ( fid ", ICs.keySet().toArray());
        sqlFilters.append("         or fnumber = 'IC_E001' ", new Object[0]);
        sqlFilters.append(" ) ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)DataModelICUtil.class.getName(), (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlFilters);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Object icViewNumber = row.getString("fnumber");
                icViewNumber = ((String)icViewNumber).substring("IC_".length());
                icViewNumberIds.put((String)icViewNumber, row.getLong("fid"));
            }
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "in", icViewNumberIds.keySet());
        DynamicObjectCollection querys = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,number,dimension,source", (QFilter[])qFilter.toArray());
        if (querys == null) {
            return returns;
        }
        HashMap<String, Long> entityViewNumberIds = new HashMap<String, Long>(16);
        for (Object query : querys) {
            entityViewNumberIds.put(query.getString("number"), query.getLong("id"));
        }
        HashMap icEntityViewIdMap = new HashMap(icViewNumberIds.size());
        for (Map.Entry entry : icViewNumberIds.entrySet()) {
            icEntityViewIdMap.put(entry.getValue(), entityViewNumberIds.get(entry.getKey()));
        }
        sqlFilters = new SqlBuilder();
        sqlFilters.append(StringUtils.join((Object[])new Serializable[]{"select fid,fnumber,fviewid,fdimensionid from t_eb_viewmember where fmodelid = ", modelId}), new Object[0]);
        int i = 0;
        boolean bl2 = false;
        Long entityBaseViewId = this.getOneBaseViewId(modelId, "E001");
        Long icBaseViewId = this.getOneBaseViewId(modelId, "IC_E001");
        for (Map.Entry<Long, Set<String>> entrys : ICs.entrySet()) {
            Long icViewId = entrys.getKey();
            if (icViewId == null || entrys.getValue() == null) continue;
            HashSet<String> entityMembers = new HashSet<String>(16);
            entityMembers.addAll(DataModelConfig.icDefaults);
            entrys.getValue().forEach(e -> entityMembers.add((String)e));
            if (icViewId.compareTo(0L) == 0 || icViewId.compareTo(icBaseViewId) == 0) {
                Long viewIdKey = 0L;
                if (icViewId.compareTo(icBaseViewId) == 0) {
                    viewIdKey = entityBaseViewId;
                }
                Set memberIds = returns.computeIfAbsent(viewIdKey, k -> new HashSet(16));
                this.addBaseViewMemberIds("t_eb_structofent", modelId, entityMembers, memberIds);
                continue;
            }
            Long entityViewId = (Long)icEntityViewIdMap.get(icViewId);
            if (entityViewId == null) continue;
            if (i == 0) {
                bl = true;
                sqlFilters.append(StringUtils.join((Object[])new Serializable[]{" and ( fviewid = ", entityViewId}), new Object[0]);
                sqlFilters.appendIn(" and fnumber ", entityMembers.toArray());
            } else {
                sqlFilters.append(StringUtils.join((Object[])new Serializable[]{" or fviewid = ", entityViewId}), new Object[0]);
                sqlFilters.appendIn(" and fnumber ", entityMembers.toArray());
            }
            ++i;
        }
        if (bl) {
            sqlFilters.append(" ) ", new Object[0]);
            try (DataSet ds = DB.queryDataSet((String)DataModelICUtil.class.getName(), (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlFilters);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Set entitys = returns.computeIfAbsent(row.getLong("fviewid"), k -> new HashSet(16));
                    entitys.add(row.getLong("fid"));
                }
            }
        }
        return returns;
    }

    private void addBaseViewMemberIds(String tableName, Long modelId, Set<String> memberNumers, Set<Long> memberIds) {
        if (memberNumers == null || memberNumers.size() == 0) {
            return;
        }
        SqlBuilder sqlFilters = new SqlBuilder();
        sqlFilters.append(StringUtils.join((Object[])new Serializable[]{"select fid,fnumber from ", tableName, " where fmodelid = ", modelId}), new Object[0]);
        sqlFilters.append(" and ", new Object[0]);
        sqlFilters.appendIn("fnumber", memberNumers.toArray());
        try (DataSet ds = DB.queryDataSet((String)DataModelICUtil.class.getName(), (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlFilters);){
            while (ds.hasNext()) {
                Row row = ds.next();
                memberIds.add(row.getLong("fid"));
            }
        }
    }

    private void addBaseViewMemberNumbers(String tableName, Long modelId, Set<Long> memberNumers, Set<String> memberIds) {
        if (memberNumers == null || memberNumers.size() == 0) {
            return;
        }
        SqlBuilder sqlFilters = new SqlBuilder();
        sqlFilters.append(StringUtils.join((Object[])new Serializable[]{"select fid,fnumber from ", tableName, " where fmodelid = ", modelId}), new Object[0]);
        sqlFilters.append(" and ", new Object[0]);
        sqlFilters.appendIn("fid", memberNumers.toArray());
        try (DataSet ds = DB.queryDataSet((String)DataModelICUtil.class.getName(), (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlFilters);){
            while (ds.hasNext()) {
                Row row = ds.next();
                memberIds.add(row.getString("fnumber"));
            }
        }
    }

    private static class InnerClass {
        private static DataModelICUtil instance = new DataModelICUtil();

        private InnerClass() {
        }
    }
}

