/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.part;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.examine.ExamineServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelGlobalParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.TableEntity;
import kd.epm.eb.formplugin.dataModelTrans.enums.OutputTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportPrepare;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelReadJsonFile;
import kd.epm.eb.formplugin.sonmodel.entity.MainSubDimsEntity;
import kd.epm.eb.formplugin.sonmodel.service.MainSubModelService;
import org.apache.commons.collections4.CollectionUtils;

public class DataModelThread {
    private static final Log log = LogFactory.getLog(DataModelThread.class);

    public static DataModelThread getInstance() {
        return InnerClass.instance;
    }

    private DataModelThread() {
    }

    public Vector<MainSubDimsEntity> getTemplateDims(Map<Long, DynamicObject> map) {
        if (map == null || map.size() == 0) {
            return new Vector<MainSubDimsEntity>(1);
        }
        Vector<MainSubDimsEntity> returns = new Vector<MainSubDimsEntity>(map.size());
        CountDownLatch latch = new CountDownLatch(map.size());
        for (Map.Entry<Long, DynamicObject> entry : map.entrySet()) {
            EpmThreadPools.CommPools.submit(() -> {
                try {
                    String tempData = ((DynamicObject)entry.getValue()).getString("data");
                    Map<String, Map<Long, Collection<String>>> singleDims = MainSubModelService.getInstance().getTemplateDimMap(tempData, ((DynamicObject)entry.getValue()).getLong("dataset.id"));
                    HashMap<String, Map<Long, Set<String>>> dims = new HashMap<String, Map<Long, Set<String>>>(16);
                    for (Map.Entry<String, Map<Long, Collection<String>>> refMemberEntry : singleDims.entrySet()) {
                        HashMap tem = new HashMap(16);
                        Map<Long, Collection<String>> refMembers = refMemberEntry.getValue();
                        for (Map.Entry<Long, Collection<String>> refMember : refMembers.entrySet()) {
                            HashSet dimSet = new HashSet(16);
                            refMember.getValue().forEach(e -> dimSet.add(e));
                            tem.put(refMember.getKey(), dimSet);
                        }
                        dims.put(refMemberEntry.getKey(), tem);
                    }
                    MainSubDimsEntity single = new MainSubDimsEntity();
                    single.setDataId(((DynamicObject)entry.getValue()).getLong("id"));
                    single.setDataNumber(((DynamicObject)entry.getValue()).getString("number"));
                    single.setRefMembers(dims);
                    returns.add(single);
                }
                catch (Exception e2) {
                    log.error(String.format("template[%s]_MianSubThread_error!", ((DynamicObject)entry.getValue()).getString("number")), (Throwable)e2);
                    throw e2;
                }
                finally {
                    latch.countDown();
                }
                return "";
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("getTemplateDims_MianSubThread_interrupted!", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        return returns;
    }

    public Vector<MainSubDimsEntity> getExamDims(Long modelId, Map<Long, DynamicObject> map) {
        if (map == null || map.size() == 0) {
            return new Vector<MainSubDimsEntity>(1);
        }
        Vector<MainSubDimsEntity> returns = new Vector<MainSubDimsEntity>(map.size());
        CountDownLatch latch = new CountDownLatch(map.size());
        for (Map.Entry<Long, DynamicObject> entry : map.entrySet()) {
            EpmThreadPools.CommPools.submit(() -> {
                try {
                    Map singDims = ExamineServiceHelper.parseDimViewRangeStr2Map((Long)modelId, (Long)((DynamicObject)entry.getValue()).getLong("group.businessmodel.id"), (String)((DynamicObject)entry.getValue()).getString("rangediminfo"), (String)((DynamicObject)entry.getValue()).getString("formula"));
                    MainSubDimsEntity single = new MainSubDimsEntity();
                    single.setDataId(((DynamicObject)entry.getValue()).getLong("id"));
                    single.setDataNumber(((DynamicObject)entry.getValue()).getString("number"));
                    single.setRefMembers(singDims);
                    returns.add(single);
                }
                catch (Exception e) {
                    log.error(String.format("examin[%s]_MianSubThread_error!", ((DynamicObject)entry.getValue()).getString("number")), (Throwable)e);
                    throw e;
                }
                finally {
                    latch.countDown();
                }
                return "";
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("getExamDims_MianSubThread_interrupted!", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        return returns;
    }

    public ConcurrentHashMap<Long, List<Long>> getBizByTemplate(Set<Long> templateIds, Long modelId) {
        if (templateIds == null || templateIds.size() == 0) {
            return new ConcurrentHashMap<Long, List<Long>>(1);
        }
        ConcurrentHashMap<Long, List<Long>> returns = new ConcurrentHashMap<Long, List<Long>>(templateIds.size() * 2);
        CountDownLatch latch = new CountDownLatch(templateIds.size());
        Map<Long, Set<String>> assignTemplateAndEntityNumberMap = this.getAssignTemplateAndEntityNumberMap(templateIds, modelId);
        for (Long templateId : templateIds) {
            EpmThreadPools.CommPools.submit(() -> {
                try {
                    List ruleRefMember = RuleRelationService.getInstance().getTemplateRelationRuleWithNoVar(templateId.longValue(), assignTemplateAndEntityNumberMap);
                    returns.put(templateId, ruleRefMember);
                }
                catch (Exception e) {
                    log.error(String.format("getBizByTemplate[%s]_MianSubThread_error!", templateId), (Throwable)e);
                    throw e;
                }
                finally {
                    latch.countDown();
                }
                return "";
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("getBizByTemplate_MianSubThread_interrupted!", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        return returns;
    }

    private Map<Long, Set<String>> getAssignTemplateAndEntityNumberMap(Set<Long> templateIds, Long modelId) {
        Set orgNumbers;
        String cacheKey;
        HashMap<Long, Set<String>> result = new HashMap<Long, Set<String>>(16);
        if (CollectionUtils.isEmpty(templateIds)) {
            return result;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<String, Set<String>> orgRangeParseMap = new HashMap<String, Set<String>>(16);
        QFilter qFilter = new QFilter("scheme.model", "in", (Object)modelId);
        qFilter.and("template", "in", templateIds);
        DynamicObjectCollection templateOrgList = QueryServiceHelper.query((String)"eb_templateorg", (String)"template, org, org.number, orgrange, scheme.orgview", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)templateOrgList)) {
            for (DynamicObject dynamicObject : templateOrgList) {
                long template = dynamicObject.getLong("template");
                long org = dynamicObject.getLong("org");
                String orgNumber = dynamicObject.getString("org.number");
                String orgrange = dynamicObject.getString("orgrange");
                long orgViewId = dynamicObject.getLong("scheme.orgview");
                cacheKey = org + "#" + orgrange + "#" + orgViewId;
                orgNumbers = (Set)orgRangeParseMap.get(cacheKey);
                this.addDispatchOrgNumberToResult(cacheKey, orgNumbers, orgRangeParseMap, orgNumber, orgViewId, template, modelCacheHelper, result);
            }
        }
        String sql = "select a.ftemplateid as template, b.forgviewid as orgViewId, b.forgid as org, b.frangevalue as orgrange from t_eb_taskreftemplate a, t_eb_taskdistorg b where a.fid = b.ftask and ";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(sql, new Object[0]);
        sqlBuilder.appendIn(" a.ftemplateid ", templateIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryTaskDispatchOrgTemplate", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                log.info("task has assign.");
                Row next = ds.next();
                long template = next.getLong("template");
                long org = next.getLong("org");
                String orgrange = next.getString("orgrange");
                long orgViewId = next.getLong("orgViewId");
                cacheKey = org + "#" + orgrange + "#" + orgViewId;
                orgNumbers = (Set)orgRangeParseMap.get(cacheKey);
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(orgViewId), Long.valueOf(org));
                if (member == null) {
                    log.info("member is null.");
                    continue;
                }
                String orgNumber = member.getNumber();
                this.addDispatchOrgNumberToResult(cacheKey, orgNumbers, orgRangeParseMap, orgNumber, orgViewId, template, modelCacheHelper, result);
            }
        }
        return result;
    }

    private void addDispatchOrgNumberToResult(String cacheKey, Set<String> orgNumbers, Map<String, Set<String>> orgRangeParseMap, String orgNumber, Long orgViewId, Long template, IModelCacheHelper modelCacheHelper, Map<Long, Set<String>> result) {
        if (CollectionUtils.isEmpty(orgNumbers)) {
            orgNumbers = orgRangeParseMap.computeIfAbsent(cacheKey, t -> new HashSet(16));
            orgNumbers.add(orgNumber);
        }
        Set dispatchOrgNumbers = result.computeIfAbsent(template, t -> new HashSet(16));
        dispatchOrgNumbers.addAll(orgNumbers);
    }

    public void preparePKIDData(DataModelImportParam importParam, JSONObject allJsonObject, DataModelGlobalParam globlaParams, Map<String, TableEntity> tableEntitys) {
        List<String> dimFromIds = DataModelTransEnum.getAllMainTableFormID(OutputTypeEnum.DEFAULT.getCode());
        CountDownLatch latch = new CountDownLatch(dimFromIds.size());
        for (String dimFromId : dimFromIds) {
            EpmThreadPools.CommPools.submit(() -> {
                try {
                    DataModelImportPrepare.getInstance().preparePKIDData(importParam, dimFromId, DataModelReadJsonFile.getInstance().getFormDatasFromJson(allJsonObject, dimFromId), globlaParams, tableEntitys);
                }
                catch (Exception e) {
                    log.error(String.format("DataModelThread[%s]_preparePKIDData_error!", dimFromId), (Throwable)e);
                    throw e;
                }
                finally {
                    latch.countDown();
                }
                return "";
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("DataModelThread_interrupted!", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public ConcurrentHashMap<String, TableEntity> getTableEntitys(JSONObject allJsonObject) {
        HashSet<String> formIds = new HashSet<String>(30);
        formIds.addAll(DataModelTransEnum.getAllMainTableFormID(OutputTypeEnum.DEFAULT.getCode()));
        formIds.addAll(DataModelTransEnum.getSecendTables());
        ConcurrentHashMap<String, TableEntity> returns = new ConcurrentHashMap<String, TableEntity>(formIds.size() * 2);
        CountDownLatch latch = new CountDownLatch(formIds.size());
        for (String dimFromId : formIds) {
            EpmThreadPools.CommPools.submit(() -> {
                try {
                    Map<String, TableEntity> dims = DataModelImportPrepare.getInstance().getTableEntitys(DataModelReadJsonFile.getInstance().getFormDatasFromJson(allJsonObject, dimFromId));
                    returns.putAll(dims);
                }
                catch (Exception e) {
                    log.error(String.format("DataModelThread[%s]_preparePKIDData_error!", dimFromId), (Throwable)e);
                }
                finally {
                    latch.countDown();
                }
                return "";
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("DataModelThread_interrupted!", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        return returns;
    }

    private static class InnerClass {
        private static DataModelThread instance = new DataModelThread();

        private InnerClass() {
        }
    }
}

