/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.part;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.enums.OutputTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.part.DataModelConfig;
import kd.epm.eb.formplugin.dataModelTrans.part.DataModelICUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DataModelViewUtil {
    public static DataModelViewUtil getInstance() {
        return InnerClass.instance;
    }

    private DataModelViewUtil() {
    }

    public void getViewAndDataSetDefaultIds(Long modelId, Map<String, Set<Long>> out) {
        if (out == null) {
            return;
        }
        Map<Long, Long> baseViewIds = this.queryBaseViewIds(modelId);
        this.addDimensionIds(modelId, out);
        this.addDefaultDataSetId(modelId, out);
        Set<String> rootNumbers = this.addBizModelViewIds(modelId, IDUtils.toLongs(out.get("eb_businessmodel")), out);
        this.addViewIds(baseViewIds, out);
        this.addViewAndDataSetDefaultIds(modelId, out, rootNumbers);
    }

    private void addDimensionIds(Long modelId, Map<String, Set<Long>> out) {
        Set dimenstionIds = out.computeIfAbsent("epm_dimension", k -> new HashSet(16));
        SqlBuilder sqlFilters = new SqlBuilder();
        sqlFilters.append(StringUtils.join((Object[])new Serializable[]{"select fid,fnumber from t_eb_dimension where fmodelid = ", modelId}), new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)DataModelICUtil.class.getName(), (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlFilters);){
            while (ds.hasNext()) {
                Row row = ds.next();
                dimenstionIds.add(row.getLong("fid"));
            }
        }
    }

    private void addDefaultDataSetId(Long modelId, Map<String, Set<Long>> out) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "=", (Object)"default");
        DynamicObject queryone = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"id,number", (QFilter[])qFilter.toArray());
        if (queryone != null) {
            Set dataset = out.computeIfAbsent("eb_dataset", k -> new HashSet(16));
            dataset.add(queryone.getLong("id"));
        }
    }

    private Set<String> addBizModelViewIds(Long modelId, Set<Long> busModelIds, Map<String, Set<Long>> out) {
        HashSet<String> rootNumbers = new HashSet<String>(16);
        if (CollectionUtils.isEmpty(busModelIds)) {
            return rootNumbers;
        }
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        Set viewIds = out.computeIfAbsent("eb_dimensionview", k -> new HashSet(16));
        for (Long busModelId : busModelIds) {
            Map viewsByBusModel = orCreate.getViewsByBusModel(busModelId);
            viewIds.addAll(viewsByBusModel.values());
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("source", "=", (Object)"1");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview_group", (String)"id,defaultview,dimension", (QFilter[])qFilter.toArray());
        for (DynamicObject dynamicObject : query) {
            Set longs = out.computeIfAbsent("eb_dimensionview", v -> new HashSet(16));
            Long defaultview = dynamicObject.getLong("defaultview");
            if (!IDUtils.isNotNull((Long)defaultview)) continue;
            longs.add(defaultview);
            Dimension dimension = orCreate.getDimension(Long.valueOf(dynamicObject.getLong("dimension")));
            View view = dimension.getView(defaultview);
            if (view == null || "1".equals(view.getSource())) continue;
            rootNumbers.add(dimension.getNumber() + "_" + view.getNumber());
        }
        return rootNumbers;
    }

    private void addViewIds(Map<Long, Long> baseViewIds, Map<String, Set<Long>> out) {
        QFilter qFilter;
        DynamicObjectCollection query;
        if (baseViewIds == null || baseViewIds.size() == 0) {
            return;
        }
        HashSet<Long> filterViewIds = new HashSet<Long>(baseViewIds.size());
        for (Map.Entry<Long, Long> entry : baseViewIds.entrySet()) {
            filterViewIds.add(entry.getValue());
        }
        if (out.get("eb_dimensionview") != null) {
            out.get("eb_dimensionview").forEach(e -> filterViewIds.add((Long)e));
        }
        if ((query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,number,dimension,source", (QFilter[])(qFilter = new QFilter("id", "in", filterViewIds)).toArray())) == null) {
            return;
        }
        Set views = out.computeIfAbsent("eb_dimensionview", k -> new HashSet(16));
        for (DynamicObject q : query) {
            views.add(q.getLong("id"));
        }
    }

    private Map<Long, Long> queryBaseViewIds(Long modelId) {
        HashMap<Long, Long> baseViewIds = new HashMap<Long, Long>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("source", "=", (Object)"1");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id,number,dimension,source", (QFilter[])qFilter.toArray());
        if (query == null) {
            return baseViewIds;
        }
        for (DynamicObject q : query) {
            baseViewIds.put(q.getLong("dimension"), q.getLong("id"));
        }
        return baseViewIds;
    }

    private void addViewAndDataSetDefaultIds(Long modelId, Map<String, Set<Long>> out, Set<String> rootNumbers) {
        Set<String> defaultNumbers = this.getBaseViewDefaultIds(modelId, out);
        defaultNumbers.addAll(rootNumbers);
        this.getNoBaseViewDefaultIds(modelId, defaultNumbers, out);
    }

    private void getNoBaseViewDefaultIds(Long modelId, Set<String> defaultNumbers, Map<String, Set<Long>> out) {
        if (out == null || out.size() == 0) {
            return;
        }
        defaultNumbers.addAll(DataModelConfig.icDefaults);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "in", defaultNumbers);
        qFilter.and("view", "in", out.get("eb_dimensionview"));
        DynamicObjectCollection viewMembers = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,number,view.id ", (QFilter[])qFilter.toArray());
        Set ids = out.computeIfAbsent("eb_viewmember", k -> new HashSet(16));
        for (DynamicObject viewMember : viewMembers) {
            ids.add(viewMember.getLong("id"));
        }
    }

    private Set<String> getBaseViewDefaultIds(Long modelId, Map<String, Set<Long>> out) {
        HashSet<String> returns = new HashSet<String>(16);
        List<String> forms = DataModelTransEnum.getMainTableFormIDByLevel(2, OutputTypeEnum.PARTIAL.getCode());
        for (String form : forms) {
            if (!DataModelConfig.needForms.contains(form)) continue;
            returns.addAll(this.getBaseViewDefaultIds(modelId, form, out));
        }
        return returns;
    }

    private Set<String> getBaseViewDefaultIds(Long modelId, String formId, Map<String, Set<Long>> out) {
        HashSet<String> returns = new HashSet<String>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("membersource", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection viewMembers = QueryServiceHelper.query((String)formId, (String)"id,number ", (QFilter[])qFilter.toArray());
        Set ids = out.computeIfAbsent(formId, k -> new HashSet(16));
        for (DynamicObject viewMember : viewMembers) {
            ids.add(viewMember.getLong("id"));
            returns.add(viewMember.getString("number"));
        }
        return returns;
    }

    private static class InnerClass {
        private static DataModelViewUtil instance = new DataModelViewUtil();

        private InnerClass() {
        }
    }
}

