/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.specialfeild;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelGlobalParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelInnerParam;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportGetNewValue;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportJsonService;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub.DMMainSubCheck;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub.DMMainSubSpecial;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelCommon;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;

public class DMDataCheckFile {
    private static final Log log = LogFactory.getLog(DMDataCheckFile.class);
    private static final Set<String> SKIPTABLE = Sets.newHashSet((Object[])new String[]{"t_eb_template", "t_eb_bizruleset", "t_eb_broadcase", "t_eb_examine", "t_eb_offsetrule", "t_eb_currencyconvertschem", "t_eb_dimensionrelation", "t_eb_customproperty", "t_eb_diffanalyzescheme", "t_eb_structofaccount"});

    public static DMDataCheckFile getInstance() {
        return InnerClass.instance;
    }

    private DMDataCheckFile() {
    }

    public void logValiadData(DataModelInnerParam innerParam, DataModelGlobalParam globlaParams) {
        innerParam.getCurrentLine().setSkip(true);
        if (DataModelUtil.isMainTable(innerParam.getCurrentLine().getTableName()).booleanValue()) {
            String fnumber = innerParam.getCurrentLine().getLineJsonObj().getString("FNUMBER");
            if (fnumber == null) {
                fnumber = innerParam.getCurrentLine().getLineJsonObj().getString("FNAME");
            }
            fnumber = StringUtils.join((Object[])new String[]{this.getChineseName(innerParam), StringUtils.isEmpty((CharSequence)fnumber) ? "" : " \u3010", fnumber + "\u3011"});
            String errorInfo = String.format(ResManager.loadKDString((String)"%1$s,\u5728json\u6587\u4ef6\u4e2d\u91cd\u590d\u6216\u8005\u662f\u5783\u573e\u6570\u636e\uff0c\u81ea\u52a8\u8df3\u8fc7\u3002", (String)"DMSpecialFeildImport_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), fnumber);
            innerParam.getResult().getTipInfosMust().add(errorInfo);
        }
    }

    public Long logValiadData(Long value, String partTableName, String curTableName, String fieldName, DataModelInnerParam innerParam, DataModelGlobalParam globlaParams, boolean isRubish) {
        if (DMMainSubCheck.getInstance().isSyncNotNeedUpdate(value.toString(), innerParam)) {
            return IDUtils.toLong((Object)value);
        }
        String rubish = "";
        if (isRubish) {
            rubish = ResManager.loadKDString((String)"\u5728\u5783\u573e\u6570\u636e\u6216\u91cd\u590d\u6570\u636e\u4e2d\u3002", (String)"DMSpecialFeildImport_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        String repairInfo = this.getRepairInfo(innerParam);
        String number = this.getMainTableNumber(innerParam, globlaParams);
        try {
            String errorInfo = ResManager.loadResFormat((String)"%1\u8868%2\u7684\u5b57\u6bb5%3\u4e2d\u7684\u503c%4,\u4e0d\u5728\u8868%5\u4e2d.%6%7", (String)"DMSpecialFeildImport_4", (String)"epm-eb-formplugin", (Object[])new Object[]{number, curTableName, fieldName, value, partTableName, rubish, repairInfo});
            innerParam.getResult().getTipInfos().add(errorInfo);
            DMMainSubSpecial.getInstance().setSyncLogInfo(errorInfo, innerParam, curTableName);
        }
        catch (Exception e) {
            log.error(ThrowableHelper.toString((Exception)e));
        }
        return IDUtils.toLong((Object)value);
    }

    private String getRepairInfo(DataModelInnerParam innerParam) {
        String mainTableName = innerParam.getCurrentLine().getMainTableName();
        if (SKIPTABLE.contains(mainTableName)) {
            this.setSkip(innerParam);
            String tipInfoHead = "";
            if (innerParam.getImportParam().isSkipErrData()) {
                tipInfoHead = ResManager.loadResFormat((String)"\u672c\u6b21\u8df3\u8fc7\u8be5%1$s,\u6216\u8005", (String)"DMSpecialFeildImport_5", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getChineseName(innerParam)});
            } else {
                innerParam.getResult().setHasErrorData(true);
            }
            return ResManager.loadResFormat((String)"\u3010\u4fee\u590d\u5efa\u8bae\u3011\uff1a%1$s\u5728\u6e90\u4f53\u7cfb\u91cd\u65b0\u9009\u62e9\u76f8\u5e94\u7ef4\u5ea6\u540e\u4fdd\u5b58\u3002", (String)"DMSpecialFeildImport_6", (String)"epm-eb-formplugin", (Object[])new Object[]{tipInfoHead});
        }
        if ("t_eb_viewmember".equalsIgnoreCase(mainTableName)) {
            innerParam.getResult().setHasErrorData(true);
            return ResManager.loadKDString((String)"\u3010\u4fee\u590d\u5efa\u8bae\u3011\uff1a\u5728\u6e90\u4f53\u7cfb\u5220\u9664\u8be5\u89c6\u56fe\u4e0b\u6240\u6709\u660e\u7ec6\u6210\u5458\u540e\u91cd\u65b0\u6dfb\u52a0", (String)"DMSpecialFeildImport_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (innerParam.getCurrentLine().getTableName().equalsIgnoreCase("t_eb_membersaveselect")) {
            innerParam.getResult().setHasErrorData(true);
            return ResManager.loadKDString((String)"\u3010\u4fee\u590d\u5efa\u8bae\u3011\uff1a\u5728\u6e90\u4f53\u7cfb\u5220\u9664\u8be5\u89c6\u56fe\u4e0b\u6240\u6709\u660e\u7ec6\u6210\u5458\u540e\u91cd\u65b0\u6dfb\u52a0", (String)"DMSpecialFeildImport_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        innerParam.getResult().setHasErrorData(true);
        return ResManager.loadKDString((String)"\u4fee\u590d\u4e0d\u4e86,\u9700\u8981\u65b0\u5efa\u4f53\u7cfb", (String)"DMSpecialFeildImport_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    public String getMainTableNumber(DataModelInnerParam innerParam, DataModelGlobalParam globlaParams) {
        String fnumber = "";
        if (DataModelUtil.isMainTable(innerParam.getCurrentLine().getTableName()).booleanValue()) {
            fnumber = innerParam.getCurrentLine().getLineJsonObj().getString("FNUMBER");
            if (SKIPTABLE.contains(innerParam.getCurrentLine().getMainTableName())) {
                this.addTableErrIds(innerParam, innerParam.getCurrentLine().getLineJsonObj().getLong("FID"));
            }
        } else if (SKIPTABLE.contains(innerParam.getCurrentLine().getMainTableName())) {
            String fidField = DataModelTransEnum.getFIDName(innerParam.getCurrentLine().getTableName());
            Long fid = innerParam.getCurrentLine().getLineJsonObj().getLong(fidField);
            if (innerParam.getCurMainTableErrIds().contains(fid)) {
                this.setSkip(innerParam);
            }
            switch (innerParam.getCurrentLine().getMainTableName()) {
                case "t_eb_template": {
                    this.addTableErrIds(innerParam, fid);
                    fnumber = globlaParams.getSpecialMapFromJson().get(0).get(fid.toString()).toString();
                    break;
                }
                case "t_eb_bizruleset": {
                    this.addTableErrIds(innerParam, fid);
                    fnumber = this.getNumberFromSpecMap(fidField, innerParam, globlaParams);
                    break;
                }
                case "t_eb_broadcase": {
                    this.addTableErrIds(innerParam, fid);
                    fnumber = this.getNumberFromSpecMap(fidField, innerParam, globlaParams);
                    break;
                }
                default: {
                    this.addTableErrIds(innerParam, fid);
                    fnumber = globlaParams.getSpecialMapFromJson() == null ? "" : globlaParams.getSpecialMapFromJson().get(0).get(fid.toString()).toString();
                }
            }
        }
        fnumber = StringUtils.isEmpty((CharSequence)fnumber) ? "" : " \u3010" + fnumber + "\u3011";
        return this.getChineseName(innerParam) + fnumber;
    }

    private String getChineseName(DataModelInnerParam innerParam) {
        DataModelTransEnum enumByTableName;
        String mainTableName = innerParam.getCurrentLine().getMainTableName();
        if ("t_eb_entitynamerecord".equals(mainTableName)) {
            mainTableName = "t_eb_structofent";
        }
        if ((enumByTableName = DataModelTransEnum.getEnumByTableName(mainTableName)) == null) {
            enumByTableName = DataModelTransEnum.getEnumByFormID(innerParam.getCurrentLine().getFormID());
        }
        return enumByTableName.getChineseName();
    }

    private String getNumberFromSpecMap(String fieldName, DataModelInnerParam innerParam, DataModelGlobalParam globlaParams) {
        if (globlaParams.getSpecialMapFromJson().size() > 1 && globlaParams.getSpecialMapFromJson().get(1).get(innerParam.getCurrentLine().getLineJsonObj().getString(fieldName)) != null) {
            return globlaParams.getSpecialMapFromJson().get(1).get(innerParam.getCurrentLine().getLineJsonObj().getString(fieldName)).toString();
        }
        return "";
    }

    public void doDelErrMainTableDatas(DataModelInnerParam innerParam, DataModelGlobalParam globlaParams) {
        if (innerParam.getCurMainTableErrIds().size() == 0) {
            return;
        }
        DataModelUtil.doLog("DMDataCheckFile.doDelErrDatas: ", log);
        String sqlDel = "delete from " + innerParam.getCurrentLine().getMainTableName() + " where fid = ? ";
        List<Object[]> valueDelLst = this.getDelIDs(innerParam, globlaParams);
        this.logDeleteSql(innerParam, sqlDel, valueDelLst);
        DataModelImportJsonService jsonService = new DataModelImportJsonService(innerParam);
        if (valueDelLst != null && valueDelLst.size() > 0) {
            jsonService.doSaveBatch(sqlDel, valueDelLst);
        }
    }

    private void logDeleteSql(DataModelInnerParam innerParam, String sqlDel, List<Object[]> valueDelLst) {
        if (DataModelCommon.getInstance().isSpecSqlBatch(innerParam.getImportParam())) {
            innerParam.getResult().getSqlValues().put(sqlDel, valueDelLst);
        }
    }

    private List<Object[]> getDelIDs(DataModelInnerParam innerParam, DataModelGlobalParam globlaParams) {
        Set<Long> errDelIds = innerParam.getCurMainTableErrIds();
        ArrayList<Object[]> returns = new ArrayList<Object[]>(errDelIds.size());
        HashSet<Long> temps = new HashSet<Long>(errDelIds.size());
        for (Long errDelId : errDelIds) {
            Long newId = DataModelImportGetNewValue.getInstance().getTargetValue(errDelId.toString(), innerParam.getCurrentLine().getMainTableName(), globlaParams, innerParam);
            if (newId != null && newId.compareTo(0L) == 0 && !temps.contains(newId)) {
                returns.add(new Object[]{newId});
            }
            temps.add(newId);
        }
        return returns;
    }

    public boolean checkJsonDataIsValid(DataModelInnerParam innerParam, DataModelGlobalParam globlaParams) {
        String tableName = innerParam.getCurrentLine().getTableName();
        Set<String> columnNames = innerParam.getCurrentLine().getTableEntity().getColumns();
        JSONObject jsonbj = innerParam.getCurrentLine().getLineJsonObj();
        if ("t_eb_viewmember".equalsIgnoreCase(tableName)) {
            String fieldName = innerParam.getCurrentLine().getFieldName();
            Long jsonModelId = IDUtils.toLong((Object)DataModelCommon.getInstance().getFieldValueFromJson(jsonbj, "FMODELID", columnNames));
            if (fieldName.equalsIgnoreCase("FMODELID") && jsonModelId.compareTo(innerParam.getImportParam().getFromModelID()) != 0) {
                innerParam.getResult().getTipInfos().add(ResManager.loadResFormat((String)"json\u6587\u4ef6\u4e2d\u7684\u8868t_eb_viewmember\u7684\u4f53\u7cfb%1$s,\u4e0d\u662f\u6e90\u4f53\u7cfb%2$s\u3002", (String)"DMSpecialFeildImport_9", (String)"epm-eb-formplugin", (Object[])new Object[]{jsonModelId, innerParam.getImportParam().getFromModelID()}));
                innerParam.getResult().setHasErrorData(true);
                return false;
            }
            Long jsonViewId = IDUtils.toLong((Object)DataModelCommon.getInstance().getFieldValueFromJson(jsonbj, "FVIEWID", columnNames));
            if (fieldName.equalsIgnoreCase("FVIEWID") && !globlaParams.getNumberJsonMap().get("t_eb_dimensionview").containsKey(jsonViewId)) {
                innerParam.getResult().setHasErrorData(true);
                this.logValiadData(jsonViewId, "t_eb_dimensionview", "t_eb_viewmember", "FViewId", innerParam, globlaParams, false);
                return false;
            }
            Long jsonDimensionlId = IDUtils.toLong((Object)DataModelCommon.getInstance().getFieldValueFromJson(jsonbj, "FDIMENSIONID", columnNames));
            if (fieldName.equalsIgnoreCase("FDIMENSIONID") && !globlaParams.getDimenstionMap().containsKey(jsonDimensionlId)) {
                innerParam.getResult().setHasErrorData(true);
                this.logValiadData(jsonDimensionlId, "t_eb_dimenstion", "t_eb_viewmember", "FDIMENSIONID", innerParam, globlaParams, false);
                return false;
            }
            Long jsonMemberId = IDUtils.toLong((Object)DataModelCommon.getInstance().getFieldValueFromJson(jsonbj, "FMEMBERID", columnNames));
            String memberTable = globlaParams.getDimenstionMap().get(jsonDimensionlId);
            if (fieldName.equalsIgnoreCase("FMEMBERID") && (globlaParams.getMemberJsonMap().get(memberTable) == null || !globlaParams.getMemberJsonMap().get(memberTable).contains(jsonMemberId))) {
                innerParam.getResult().setHasErrorData(true);
                this.logValiadData(jsonMemberId, memberTable, "t_eb_viewmember", "FMEMBERID", innerParam, globlaParams, false);
                return false;
            }
        }
        return true;
    }

    private void setSkip(DataModelInnerParam innerParam) {
        if (innerParam.getImportParam().isSkipErrData()) {
            innerParam.getCurrentLine().setSkip(true);
        }
    }

    private void addTableErrIds(DataModelInnerParam innerParam, Long fid) {
        if (innerParam.getImportParam().isSkipErrData()) {
            innerParam.getCurMainTableErrIds().add(fid);
        }
    }

    private static class InnerClass {
        private static DMDataCheckFile instance = new DMDataCheckFile();

        private InnerClass() {
        }
    }
}

