/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.specialfeild;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;

public class DMSpecialFieldDatasetDimSave {
    public static DMSpecialFieldDatasetDimSave getInstance() {
        return InnerClass.instance;
    }

    private DMSpecialFieldDatasetDimSave() {
    }

    public void datasetDimDelete(Map<String, String> sqlStrs, Map<String, List<Object[]>> sqlValues) {
        List<Object[]> deleteArr = sqlValues.get("delete");
        List<Object[]> insertArr = sqlValues.get("insert");
        HashMap<Long, Set<Long>> tmpMap = new HashMap<Long, Set<Long>>(16);
        this.arrangeNoDeleteData(insertArr, tmpMap);
        this.execDeleteDatasetDim(sqlStrs, deleteArr, tmpMap);
        sqlValues.remove("delete");
    }

    private void arrangeNoDeleteData(List<Object[]> insertArr, Map<Long, Set<Long>> tmpMap) {
        for (Object[] objects : insertArr) {
            if (objects == null || objects.length < 4) continue;
            Long datasetId = this.loadId(objects[0]);
            Long dimId = this.loadId(objects[3]);
            if (IDUtils.isNull((Long)dimId) || IDUtils.isNull((Long)datasetId)) continue;
            Set<Long> dbDimenIds = tmpMap.get(datasetId);
            if (dbDimenIds == null) {
                QFilter qFilter = new QFilter("id", "=", (Object)datasetId);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)DataModelTransEnum.dataset.getFormID(), (String)"entryentity.datasetdim.id", (QFilter[])qFilter.toArray());
                if (collection.size() == 0) continue;
                dbDimenIds = collection.stream().map(dynamicObject -> dynamicObject.getLong("entryentity.datasetdim.id")).collect(Collectors.toSet());
            }
            dbDimenIds.remove(dimId);
            tmpMap.put(datasetId, dbDimenIds);
        }
    }

    private void execDeleteDatasetDim(Map<String, String> sqlStrs, List<Object[]> deleteArr, Map<Long, Set<Long>> tmpMap) {
        String initSql = sqlStrs.get("delete");
        SqlBuilder sql = new SqlBuilder();
        ArrayList<Object[]> initParams = new ArrayList<Object[]>(deleteArr.size() * 2 + 1);
        for (Object[] objects : deleteArr) {
            if (objects == null || objects.length == 0) continue;
            Long datasetId = this.loadId(objects[0]);
            Set<Long> dimIdSet = tmpMap.get(datasetId);
            if (dimIdSet == null || dimIdSet.size() == 0) {
                initParams.add(objects);
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(initSql);
            stringBuilder.append(" and fdatasetdim not in (");
            ArrayList<String> placeholders = new ArrayList<String>(dimIdSet.size() * 2 + 1);
            ArrayList<Object> paramList = new ArrayList<Object>(dimIdSet.size() * 2 + 1);
            for (Long dimId : dimIdSet) {
                placeholders.add("?");
                paramList.add(dimId);
            }
            stringBuilder.append(String.join((CharSequence)",", placeholders));
            stringBuilder.append(");");
            paramList.add(0, objects[0]);
            sql.append(stringBuilder.toString(), paramList);
        }
        if (initParams.size() > 0) {
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)initSql, initParams);
        }
        if (!sql.isEmpty()) {
            DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        }
    }

    private Long loadId(Object object1) {
        Object object = object1;
        if (!(object instanceof Long)) {
            return null;
        }
        Long dimId = (Long)object;
        return dimId;
    }

    private static class InnerClass {
        private static DMSpecialFieldDatasetDimSave instance = new DMSpecialFieldDatasetDimSave();

        private InnerClass() {
        }
    }
}

