/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.specialfeild;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.execanalyse.SchemeDimension;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelCurrentLine;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelGlobalParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelInnerParam;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportGetNewValue;

public class DMSpecialFieldExecAnalyse {
    private static final DMSpecialFieldExecAnalyse instance = new DMSpecialFieldExecAnalyse();

    public static DMSpecialFieldExecAnalyse getInstance() {
        return instance;
    }

    public void getSpecialFieldString_Import(DataModelInnerParam innerParam, DataModelGlobalParam globalParams) {
        DataModelCurrentLine currentLine = innerParam.getCurrentLine();
        Object value = currentLine.getValue();
        if (value == null || StringUtils.isEmpty((String)value.toString())) {
            return;
        }
        SchemeDimension schemeDimension = (SchemeDimension)SerializationUtils.deSerializeFromBase64((String)value.toString());
        this.replaceDimensionInfos(schemeDimension.getPageDimensions(), innerParam, globalParams);
        this.replaceDimensionInfos(schemeDimension.getColDimensions(), innerParam, globalParams);
        this.replaceDimensionInfos(schemeDimension.getRowDimensions(), innerParam, globalParams);
        innerParam.getCurrentLine().setValue(SerializationUtils.serializeToBase64((Object)schemeDimension));
    }

    private void replaceDimensionInfos(List<Dimension> dimensions, DataModelInnerParam innerParam, DataModelGlobalParam globalParams) {
        for (Dimension dimension : dimensions) {
            dimension.setId(DataModelImportGetNewValue.getInstance().getTargetValue(dimension.getId().toString(), "t_eb_dimension", globalParams, innerParam));
            this.replaceMemberIds(dimension, globalParams, innerParam);
        }
    }

    private void replaceMemberIds(Dimension dimension, DataModelGlobalParam globalParams, DataModelInnerParam innerParam) {
        String number = dimension.getNumber();
        String table = SysDimensionEnum.getMemberTableByNumber((String)number);
        for (Member member : dimension.getMembers()) {
            member.setId(DataModelImportGetNewValue.getInstance().getTargetValue(member.getId().toString(), table, globalParams, innerParam));
        }
    }
}

