/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.specialfeild;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.orm.util.CollectionUtils;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasService;
import kd.epm.eb.business.analysiscanvas.AnalysisCanvasUtils;
import kd.epm.eb.business.analysiscanvas.model.BaseModel;
import kd.epm.eb.business.analysiscanvas.model.BizModel;
import kd.epm.eb.business.analysiscanvas.model.ChartModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DupontModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.analysiscanvas.model.SplitModel;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelCurrentLine;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelExportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelGlobalParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelInnerParam;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportGetNewValue;

public class DMSpecialFieldExecAnalysisCanvas {
    private static final DMSpecialFieldExecAnalysisCanvas instance = new DMSpecialFieldExecAnalysisCanvas();

    public static DMSpecialFieldExecAnalysisCanvas getInstance() {
        return instance;
    }

    public void getSpecialFieldString_Import(DataModelInnerParam innerParam, DataModelGlobalParam globalParams) {
        DataModelCurrentLine currentLine = innerParam.getCurrentLine();
        Object value = currentLine.getValue();
        if (value == null || StringUtils.isEmpty((String)value.toString())) {
            return;
        }
        List customItems = JSON.parseArray((String)AnalysisCanvasUtils.unCompressData((String)value.toString()), CustomItem.class);
        customItems.forEach(customItem -> {
            BaseModel baseModel = ModelHelper.getModel((CustomItem)customItem);
            if (baseModel == null) {
                return;
            }
            this.commonProcess(baseModel, innerParam, globalParams);
            if (baseModel instanceof ChartModel && !"map".equals(((ChartModel)baseModel).getType())) {
                List chartConfig = ((ChartModel)baseModel).getChartConfig();
                chartConfig.forEach(chartConfigModel -> {
                    Long dataset;
                    if (chartConfigModel.getDimensionViews() != null) {
                        for (Map.Entry entry : chartConfigModel.getDimensionViews().entrySet()) {
                            Long dimensionView = DataModelImportGetNewValue.getInstance().getTargetValue(entry.getValue().toString(), "t_eb_dimensionview", globalParams, innerParam);
                            if (dimensionView == null || dimensionView.compareTo(0L) <= 0) continue;
                            entry.setValue(dimensionView.toString());
                        }
                    }
                    if (StringUtils.isNotEmpty((String)chartConfigModel.getDataset()) && (dataset = DataModelImportGetNewValue.getInstance().getTargetValue(chartConfigModel.getDataset(), "t_eb_dataset", globalParams, innerParam)) != null && dataset.compareTo(0L) > 0) {
                        chartConfigModel.setDataset(dataset.toString());
                    }
                });
                ArrayList barTypes = Lists.newArrayList((Object[])new String[]{"gauge", "bar", "line", "barLine", "sortbar"});
                if (barTypes.contains(((ChartModel)baseModel).getType())) {
                    this.specialProcessGauge((CustomItem)customItem, innerParam, globalParams);
                }
            }
            if (baseModel instanceof BizModel) {
                List bizConfig = ((BizModel)baseModel).getBizConfig();
                bizConfig.forEach(bizValue -> {
                    if (bizValue.getDimensionViews() != null) {
                        for (Map.Entry entry : bizValue.getDimensionViews().entrySet()) {
                            Long dimensionView = DataModelImportGetNewValue.getInstance().getTargetValue(entry.getValue().toString(), "t_eb_dimensionview", globalParams, innerParam);
                            if (dimensionView == null || dimensionView.compareTo(0L) <= 0) continue;
                            entry.setValue(dimensionView.toString());
                        }
                    }
                });
            }
            if (baseModel instanceof DupontModel) {
                List dupontConfig = ((DupontModel)baseModel).getDupontConfig();
                dupontConfig.forEach(bizValue -> {
                    if (bizValue.getDimensionViews() != null) {
                        for (Map.Entry entry : bizValue.getDimensionViews().entrySet()) {
                            Long dimensionView = DataModelImportGetNewValue.getInstance().getTargetValue(entry.getValue().toString(), "t_eb_dimensionview", globalParams, innerParam);
                            if (dimensionView == null || dimensionView.compareTo(0L) <= 0) continue;
                            entry.setValue(dimensionView.toString());
                        }
                    }
                });
            }
            if (baseModel instanceof ReportModel) {
                String tempId = ((ReportModel)baseModel).getTempId();
                Long newTempId = DataModelImportGetNewValue.getInstance().getTargetValue(tempId, "t_eb_template", globalParams, innerParam);
                ((ReportModel)baseModel).setTempId(newTempId.toString());
            }
            ModelHelper.updateModel((CustomItem)customItem, (BaseModel)baseModel);
        });
        currentLine.setValue(AnalysisCanvasUtils.compressData((String)JSON.toJSONString((Object)customItems)));
    }

    private void specialProcessGauge(CustomItem customItem, DataModelInnerParam innerParam, DataModelGlobalParam globalParams) {
        List splitConfigs = ModelHelper.getSplitConfigs((CustomItem)customItem);
        splitConfigs.forEach(config -> {
            SplitModel splitModel = config.getSplitModel();
            this.commonProcess((BaseModel)splitModel, innerParam, globalParams);
        });
        ModelHelper.putSplitConfigs((CustomItem)customItem, (List)splitConfigs);
    }

    private void commonProcess(BaseModel baseModel, DataModelInnerParam innerParam, DataModelGlobalParam globalParams) {
        Long dataset;
        if (baseModel == null) {
            return;
        }
        Long modelId = DataModelImportGetNewValue.getInstance().getTargetValue(baseModel.getModel(), "t_eb_model", globalParams, innerParam);
        if (modelId != null && modelId.compareTo(0L) > 0) {
            baseModel.setModel(modelId.toString());
        }
        if ((dataset = DataModelImportGetNewValue.getInstance().getTargetValue(baseModel.getDataset(), "t_eb_dataset", globalParams, innerParam)) != null && dataset.compareTo(0L) > 0) {
            baseModel.setDataset(dataset.toString());
        }
        if (baseModel.getDimensionViews() != null) {
            for (Map.Entry entry : baseModel.getDimensionViews().entrySet()) {
                Long dimensionView = DataModelImportGetNewValue.getInstance().getTargetValue(entry.getValue().toString(), "t_eb_dimensionview", globalParams, innerParam);
                if (dimensionView == null || dimensionView.compareTo(0L) <= 0) continue;
                entry.setValue(dimensionView.toString());
            }
        }
    }

    public void getNameFieldString_Import(DataModelInnerParam innerParam) {
        DataModelCurrentLine currentLine = innerParam.getCurrentLine();
        String number = currentLine.getLineJsonObj().getString("FNUMBER");
        String name = (String)currentLine.getValue();
        Set nameSet = AnalysisCanvasService.getInstance().getCopyNameSet(number, "name");
        String copyName = AnalysisCanvasService.getInstance().getCopyName(name, nameSet);
        if (StringUtils.isNotEmpty((String)copyName)) {
            currentLine.setValue(copyName);
        }
    }

    public void getNumberFieldString_Import(DataModelInnerParam innerParam) {
        DataModelCurrentLine currentLine = innerParam.getCurrentLine();
        String number = (String)currentLine.getValue();
        Set numberSet = AnalysisCanvasService.getInstance().getCopyNameSet(number, "number");
        String copyName = AnalysisCanvasService.getInstance().getCopyName(number, numberSet);
        if (StringUtils.isNotEmpty((String)copyName)) {
            currentLine.setValue(copyName);
        }
    }

    public boolean checkAllItemMatchCurrenModel(Row rowData, DataModelExportParam dmParam) {
        String modelId = dmParam.getModelid().toString();
        List customItems = JSON.parseArray((String)AnalysisCanvasUtils.unCompressData((String)rowData.getString("FITEM")), CustomItem.class);
        if (CollectionUtils.isEmpty((Collection)customItems) || customItems.stream().allMatch(customItem -> ModelHelper.getModel((CustomItem)customItem) == null)) {
            return true;
        }
        return !customItems.stream().filter(customItem -> ModelHelper.getModel((CustomItem)customItem) != null).allMatch(customItem -> {
            BaseModel baseModel = ModelHelper.getModel((CustomItem)customItem);
            return baseModel != null && modelId.equals(baseModel.getModel());
        });
    }

    public boolean checkAnalysisCanvasNumber(DataModelInnerParam innerParam) {
        return this.checkSameModelId(innerParam);
    }

    public boolean checkAnalysisCanvasBoxExisted(DataModelInnerParam innerParam) {
        return this.checkSameModelId(innerParam);
    }

    public boolean checkSameModelId(DataModelInnerParam innerParam) {
        Long toModelID = innerParam.getImportParam().getToModelID();
        Long fromModelID = innerParam.getImportParam().getFromModelID();
        return Objects.equals(toModelID, fromModelID);
    }
}

