/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.specialfeild;

import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelCurrentLine;

public class DataModelRepairPeriod {
    public static DataModelRepairPeriod getInstance() {
        return InnerClass.instance;
    }

    private DataModelRepairPeriod() {
    }

    public boolean periodDateFields(DataModelCurrentLine currentLine) {
        if (currentLine.getLineJsonObj().getString("FNUMBER").equals("BudgetPeriod")) {
            return false;
        }
        Object value = currentLine.getValue();
        String fieldName = currentLine.getFieldName();
        if ("FSTARTDATE".equals(fieldName) && (value == null || StringUtils.isEmpty((CharSequence)value.toString()))) {
            currentLine.setValue(this.calcStartAndEndDate(currentLine.getLineJsonObj(), true));
            return true;
        }
        if ("FENDDATE".equals(fieldName) && (value == null || StringUtils.isEmpty((CharSequence)value.toString()))) {
            currentLine.setValue(this.calcStartAndEndDate(currentLine.getLineJsonObj(), false));
            return true;
        }
        return false;
    }

    private Date calcStartAndEndDate(JSONObject jsonbj, boolean isStart) {
        String number = jsonbj.getString("FNUMBER");
        int year = Integer.parseInt(number.substring(0, 6).substring(2));
        int startMonth = jsonbj.getIntValue("FEFFMONTH");
        int endMonth = jsonbj.getIntValue("FEXPMONTH");
        int startDay = jsonbj.getIntValue("FEFFDAY");
        int endDay = jsonbj.getIntValue("FEXPDAY");
        Date dd = null;
        dd = isStart ? DataModelRepairPeriod.calcDate(year, startMonth - 1, startDay, true) : DataModelRepairPeriod.calcDate(year, endMonth - 1, endDay, false);
        return dd;
    }

    public boolean repairPeriod(long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"epm_bperiodmembertree", (String)"id,number,effmonth,expmonth,effday,expday,startdate,enddate ", (QFilter[])qFilter.toArray());
        if (datas == null || datas.length == 0) {
            return true;
        }
        ArrayList<DynamicObject> needSaveRpts = new ArrayList<DynamicObject>(16);
        for (DynamicObject row : datas) {
            String number = row.getString("number");
            if (number.equals("BudgetPeriod")) continue;
            Date startDate = null;
            Date enddate = null;
            if (row.getDate("startdate") == null) {
                startDate = this.calcStartAndEndDate(row, true);
                row.set("startdate", (Object)startDate);
            }
            if (row.getDate("enddate") == null) {
                enddate = this.calcStartAndEndDate(row, false);
                row.set("enddate", (Object)enddate);
            }
            if (startDate == null && enddate == null) continue;
            needSaveRpts.add(row);
        }
        if (needSaveRpts.size() > 0) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)needSaveRpts.iterator().next()).getDataEntityType(), (Object[])needSaveRpts.toArray(new Object[0]));
        }
        return true;
    }

    private Date calcStartAndEndDate(DynamicObject row, boolean isStart) {
        int year = Integer.parseInt(row.getString("number").substring(0, 6).substring(2));
        int startMonth = row.getInt("effmonth");
        int endMonth = row.getInt("expmonth");
        int startDay = row.getInt("effday");
        int endDay = row.getInt("expday");
        Date dd = null;
        dd = isStart ? DataModelRepairPeriod.calcDate(year, startMonth - 1, startDay, true) : DataModelRepairPeriod.calcDate(year, endMonth - 1, endDay, false);
        return dd;
    }

    private static Date calcDate(int year, int month, int day, boolean isStart) {
        if (month == 2 && day == 29 && !DataModelRepairPeriod.isLeapYear(year)) {
            day = 28;
        }
        Timestamp date = null;
        Calendar calendar = Calendar.getInstance();
        if (isStart) {
            calendar.set(year, month, day, 0, 0, 0);
            date = new Timestamp(calendar.getTimeInMillis());
            date.setNanos(0);
        } else {
            calendar.set(year, month, day, 23, 59, 59);
            date = new Timestamp(calendar.getTimeInMillis());
            date.setNanos(999);
        }
        return date;
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    private static class InnerClass {
        private static DataModelRepairPeriod instance = new DataModelRepairPeriod();

        private InnerClass() {
        }
    }
}

