/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.enums.OutputTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.exportmodel.service.DataModelExportJsonService;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub.DMMainSubConfig;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub.DMMainSubExportSpecialFilter;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub.DMMainSubSpecial;
import kd.epm.eb.formplugin.sonmodel.entity.MainSubModelPoJo;

public class DMMainSubExportJsonService
extends DataModelExportJsonService {
    private MainSubModelPoJo modelEntity;

    public DMMainSubExportJsonService(MainSubModelPoJo modelEntity) {
        this.modelEntity = modelEntity;
    }

    @Override
    protected boolean isNeedAllTransForm(String formid) {
        return DMMainSubConfig.mainSubAllData.contains(formid);
    }

    @Override
    protected void getTableFilter(String tableName, SqlBuilder sqlWhere) {
        Set<Long> dimsFilter;
        super.getTableFilter(tableName, sqlWhere);
        if ("t_eb_bizruleset".equalsIgnoreCase(tableName)) {
            sqlWhere.append(" and frulebatch = 0  ", new Object[0]);
        }
        if (this.modelEntity == null && this.dmParam.getFilterMaps() == null) {
            return;
        }
        boolean isPart = this.dmParam.getExportType().isPartial();
        if ("t_eb_templaterelation".equalsIgnoreCase(tableName)) {
            sqlWhere.append(" and 1!=1 ", new Object[0]);
        }
        if (tableName.equalsIgnoreCase("t_eb_membersaveselect") && isPart && ((dimsFilter = this.getMemberSaveSelectFilter(sqlWhere)) == null || dimsFilter.isEmpty())) {
            sqlWhere.append(" and 1 != 1", new Object[0]);
        }
        if (tableName.equalsIgnoreCase("t_eb_template") && isPart) {
            if (this.modelEntity == null || this.modelEntity.getDataMap() == null || this.modelEntity.getDataMap().get("Template") == null) {
                return;
            }
            if (this.modelEntity.getDataMap().get("Template").size() > 0 && !this.modelEntity.getDataMap().get("Template").isEmpty()) {
                sqlWhere.append(" and ", new Object[0]).appendIn("fid", this.modelEntity.getDataMap().get("Template").toArray());
            }
        }
        if (tableName.equalsIgnoreCase("t_eb_examine_temp") && isPart) {
            if (this.modelEntity == null || this.modelEntity.getDataMap() == null || this.modelEntity.getDataMap().get("Template") == null) {
                return;
            }
            if (this.modelEntity.getDataMap().get("Template").size() > 0 && !this.modelEntity.getDataMap().get("Template").isEmpty()) {
                sqlWhere.append(" and ", new Object[0]).appendIn("FBASEDATAID", this.modelEntity.getDataMap().get("Template").toArray());
            }
        }
    }

    private Set<Long> getMemberSaveSelectFilter(SqlBuilder sqlWhere) {
        if (this.modelEntity != null) {
            return this.getFilterFromModelEntity(sqlWhere);
        }
        return this.getFilterFromParaFilters(sqlWhere);
    }

    private Set<Long> getFilterFromModelEntity(SqlBuilder sqlWhere) {
        HashSet<Long> dimsFilter = new HashSet<Long>(16);
        Map<String, String> dims = this.modelEntity.getUpDimensionMap();
        if (dims == null) {
            sqlWhere.append(" and 1 != 1", new Object[0]);
            return dimsFilter;
        }
        for (Map.Entry<String, String> dim : dims.entrySet()) {
            String serialize = dim.getValue();
            Map entitys = (Map)SerializationUtils.deSerializeFromBase64((String)serialize);
            if (entitys == null) continue;
            for (Map.Entry entry : entitys.entrySet()) {
                dimsFilter.addAll((Collection)entry.getValue());
            }
        }
        return dimsFilter;
    }

    private Set<Long> getFilterFromParaFilters(SqlBuilder sqlWhere) {
        HashSet<Long> dimsFilter = new HashSet<Long>(16);
        Map<String, Set<Long>> dims = this.dmParam.getFilterMaps();
        if (this.dmParam.getFilterMaps() == null) {
            return null;
        }
        if (dims == null) {
            sqlWhere.append(" and 1 != 1", new Object[0]);
            return null;
        }
        List<String> mainSubForms = DataModelTransEnum.getMainTableFormIDByLevel(2, 1);
        mainSubForms.remove("epm_bperiodmembertree");
        for (Map.Entry<String, Set<Long>> dim : dims.entrySet()) {
            if (!mainSubForms.contains(dim.getKey())) continue;
            dimsFilter.addAll((Collection<Long>)dim.getValue());
        }
        return dimsFilter;
    }

    @Override
    protected String getSpecialFilter(String table) {
        String filter = super.getSpecialFilter(table);
        boolean specialFilter = OutputTypeEnum.values(this.dmParam.getExportType().getCode()).isSpecialFilter();
        if (specialFilter || this.dmParam.getMainSubExportParam().isSubModelSync() || this.dmParam.getMainSubExportParam().isSyncSpecialFilter()) {
            filter = DMMainSubExportSpecialFilter.getInstance().addSpecialFilter(filter, table, this.dmParam);
        }
        return filter;
    }

    @Override
    protected boolean isNoNeedQuery(String table, String ormFieldName) {
        return DMMainSubSpecial.getInstance().noNeedQuery(table, ormFieldName);
    }
}

