/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelExportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportResult;
import kd.epm.eb.formplugin.dataModelTrans.entity.ModelParam;
import kd.epm.eb.formplugin.dataModelTrans.enums.OutputTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.exportmodel.service.DataModelExportMain;
import kd.epm.eb.formplugin.dataModelTrans.exportmodel.service.DataModelGlobalVar;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub.DMMainSubExportJsonService;
import kd.epm.eb.formplugin.sonmodel.entity.MainSubModelPoJo;

public class DMMainSubExportMain
extends DataModelExportMain {
    private static final Log log = LogFactory.getLog(DMMainSubExportMain.class);
    private MainSubModelPoJo modelEntity;

    public DMMainSubExportMain(MainSubModelPoJo modelEntity) {
        this.modelEntity = modelEntity;
    }

    public Map<String, Object> loadDataModelExport(LoadDataModelExportParam loadDataModelExportParam) {
        IModelCacheHelper modelCacheHelper = loadDataModelExportParam.getTargetModelCacheHelper();
        Map<String, Set<Long>> filterMap = loadDataModelExportParam.getFilterMap();
        OutputTypeEnum transType = loadDataModelExportParam.getTransType();
        boolean isSubModelSync = loadDataModelExportParam.isSubModelSync();
        boolean isSyncSpecialFilter = loadDataModelExportParam.isSyncSpecialFilter();
        Date syncDate = loadDataModelExportParam.getSyncDate();
        try {
            boolean isRedim;
            Model model = modelCacheHelper.getModelobj();
            DataModelExportParam dmParam = new DataModelExportParam();
            dmParam.setModelid(model.getId());
            dmParam.setFilterMaps(filterMap);
            dmParam.setModelNumber(model.getNumber());
            dmParam.setCheckDataValiad(false);
            dmParam.setExportType(transType);
            dmParam.getMainSubExportParam().setSubModelSync(isSubModelSync);
            dmParam.getMainSubExportParam().setSyncSpecialFilter(isSyncSpecialFilter);
            dmParam.getMainSubExportParam().setSyncDate(syncDate);
            this.supplementBizmodelParam(dmParam, modelCacheHelper);
            DMMainSubExportJsonService dataTransObj = new DMMainSubExportJsonService(this.modelEntity);
            if (transType.isPartial()) {
                isRedim = false;
                Map<String, Set<Long>> redimFilterMap = dataTransObj.reDimFilter(dmParam);
                redimFilterMap.put(DataModelTransEnum.viewmember.getFormID(), filterMap.get(DataModelTransEnum.viewmember.getFormID()));
                dmParam.setFilterMaps(redimFilterMap);
            } else {
                isRedim = false;
            }
            JSONObject json = dataTransObj.getJsonObject(dmParam, isRedim);
            DataModelImportResult result = this.checkDataValiad(dmParam, json);
            HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
            resultMap.put("data", json);
            resultMap.put("result", result);
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            if (isSubModelSync) {
                throw e;
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0cTrace ID\uff1a%1\u3002", (String)"DMMainSubExportMain_01", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
        finally {
            DataModelGlobalVar.clear();
        }
    }

    private void supplementBizmodelParam(DataModelExportParam dmParam, IModelCacheHelper modelCacheHelper) {
        boolean specialFilter = dmParam.getExportType().isSpecialFilter();
        if (!specialFilter) {
            return;
        }
        Map<String, Set<Long>> filterMaps = dmParam.getFilterMaps();
        if (filterMaps == null) {
            return;
        }
        Set<Long> bizmodelSet = filterMaps.get(DataModelTransEnum.bizmodel.getFormID());
        if (bizmodelSet == null || bizmodelSet.size() == 0) {
            return;
        }
        Long modelId = modelCacheHelper.getModelobj().getId();
        ModelParam modelParam = new ModelParam();
        modelParam.setModels(Collections.singleton(modelId.toString()));
        Set<Long> bizmodels = bizmodelSet;
        Set<Long> datasets = this.loadDatasetIdsByBizmodel(modelId, bizmodels);
        modelParam.setBizmodels(bizmodels.stream().map(bizmodel -> bizmodel.toString()).collect(Collectors.toSet()));
        modelParam.setDatasets(datasets.stream().map(datasetId -> datasetId.toString()).collect(Collectors.toSet()));
        dmParam.setModelParam(modelParam);
    }

    private Set<Long> loadDatasetIdsByBizmodel(Long modelId, Set<Long> bizmodels) {
        QFilter qFilter = new QFilter("businessmodel", "in", bizmodels);
        qFilter.and(new QFilter("model", "=", (Object)modelId));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)DataModelTransEnum.dataset.getFormID(), (String)"id", (QFilter[])qFilter.toArray());
        return dynamicObjects.stream().map(dynamic -> dynamic.getLong("id")).collect(Collectors.toSet());
    }

    @Override
    protected void setImportParams(DataModelImportParam dmParam) {
        dmParam.getMainSubImportParam().setMainSubModel(true);
    }

    public static class LoadDataModelExportParam {
        private IModelCacheHelper targetModelCacheHelper;
        private Map<String, Set<Long>> filterMap;
        private OutputTypeEnum transType;
        private boolean isSubModelSync;
        private boolean isSyncSpecialFilter;
        private Date syncDate;
        private boolean isNeedLoadViewMember = false;

        public IModelCacheHelper getTargetModelCacheHelper() {
            return this.targetModelCacheHelper;
        }

        public void setTargetModelCacheHelper(IModelCacheHelper targetModelCacheHelper) {
            this.targetModelCacheHelper = targetModelCacheHelper;
        }

        public Map<String, Set<Long>> getFilterMap() {
            return this.filterMap;
        }

        public void setFilterMap(Map<String, Set<Long>> filterMap) {
            this.filterMap = filterMap;
        }

        public OutputTypeEnum getTransType() {
            return this.transType;
        }

        public void setTransType(OutputTypeEnum transType) {
            this.transType = transType;
        }

        public boolean isSubModelSync() {
            return this.isSubModelSync;
        }

        public void setSubModelSync(boolean subModelSync) {
            this.isSubModelSync = subModelSync;
        }

        public boolean isSyncSpecialFilter() {
            return this.isSyncSpecialFilter;
        }

        public void setSyncSpecialFilter(boolean syncSpecialFilter) {
            this.isSyncSpecialFilter = syncSpecialFilter;
        }

        public Date getSyncDate() {
            return this.syncDate;
        }

        public void setSyncDate(Date syncDate) {
            this.syncDate = syncDate;
        }

        public boolean isNeedLoadViewMember() {
            return this.isNeedLoadViewMember;
        }

        public void setNeedLoadViewMember(boolean needLoadViewMember) {
            this.isNeedLoadViewMember = needLoadViewMember;
        }
    }
}

