/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelExportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.ModelParam;
import kd.epm.eb.formplugin.dataModelTrans.enums.OutputTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub.DMMainSubConfig;
import org.apache.commons.lang3.StringUtils;

public class DMMainSubExportSpecialFilter {
    private static final DMMainSubExportSpecialFilter instance = new DMMainSubExportSpecialFilter();

    private DMMainSubExportSpecialFilter() {
    }

    public static DMMainSubExportSpecialFilter getInstance() {
        return instance;
    }

    public String addSpecialFilter(String filterSql, String table, DataModelExportParam dmParam) {
        if (dmParam.getExportType().getCode() == OutputTypeEnum.BIZMODEL.getCode()) {
            return this.addSpecialFilterDataSet(filterSql, table, dmParam);
        }
        if (dmParam.getExportType().getCode() == OutputTypeEnum.PARTIAL_MAINSUB.getCode()) {
            return this.addSpecialFilterPart(filterSql, table, dmParam);
        }
        return "";
    }

    private String addSpecialFilterPart(String filterSql, String table, DataModelExportParam dmParam) {
        ModelParam modelParam;
        if (StringUtils.isBlank((CharSequence)table)) {
            return filterSql;
        }
        if (StringUtils.isBlank((CharSequence)filterSql)) {
            filterSql = " 1 = 1 ";
        }
        if ((modelParam = dmParam.getModelParam()) == null && !dmParam.getMainSubExportParam().isSyncSpecialFilter() && !dmParam.getMainSubExportParam().isSubModelSync()) {
            filterSql = filterSql + " and 1 != 1";
            return filterSql;
        }
        DataModelTransEnum transEnum = DataModelTransEnum.getEnumByTableName(table);
        if (transEnum == null) {
            return filterSql;
        }
        if (modelParam != null) {
            switch (transEnum) {
                case customproperty: 
                case periodvariable: 
                case dimensionvariable: {
                    filterSql = this.addFilterStr(modelParam.getModels(), transEnum.getFilterModelField(), filterSql);
                    Set<Long> dimenstionids = dmParam.getFilterMaps().get("epm_dimension");
                    if (dimenstionids == null || dimenstionids.size() <= 0) break;
                    filterSql = filterSql + String.format(" and fdimensionid in (" + String.join((CharSequence)",", IDUtils.toStringCollection(dimenstionids)) + ") ", new Object[0]);
                    break;
                }
                case dimensionviewgroup: 
                case applicationscenario: {
                    filterSql = this.addFilterStr(modelParam.getModels(), transEnum.getFilterModelField(), filterSql);
                    break;
                }
            }
        }
        return this.getSyncFilter(filterSql, table, dmParam, transEnum);
    }

    private String addSpecialFilterDataSet(String filterSql, String table, DataModelExportParam dmParam) {
        ModelParam modelParam;
        if (StringUtils.isBlank((CharSequence)table)) {
            return filterSql;
        }
        if (StringUtils.isBlank((CharSequence)filterSql)) {
            filterSql = " 1 = 1 ";
        }
        if ((modelParam = dmParam.getModelParam()) == null && !dmParam.getMainSubExportParam().isSyncSpecialFilter() && !dmParam.getMainSubExportParam().isSubModelSync()) {
            filterSql = filterSql + " and 1 != 1";
            return filterSql;
        }
        DataModelTransEnum transEnum = DataModelTransEnum.getEnumByTableName(table);
        if (transEnum == null) {
            return filterSql;
        }
        if (modelParam != null) {
            switch (transEnum) {
                case customproperty: 
                case periodvariable: 
                case dimensionvariable: 
                case dimensionviewgroup: 
                case applicationscenario: {
                    filterSql = " 1 = 1 ";
                    filterSql = this.addFilterStr(modelParam.getModels(), transEnum.getFilterModelField(), filterSql);
                    break;
                }
                case bizmodel: {
                    filterSql = this.addFilterStr(modelParam.getBizmodels(), "fid", filterSql);
                    break;
                }
                case dataset: {
                    filterSql = this.addFilterStr(modelParam.getBizmodels(), "fbizmodelid", filterSql);
                    break;
                }
                case templateentity: {
                    filterSql = this.addFilterStr(modelParam.getDatasets(), "fdatasetid", filterSql);
                    break;
                }
                case examine: {
                    StringBuilder str = new StringBuilder("select fid from t_eb_examinecategory where ");
                    Object[] objects = modelParam.getModels().toArray();
                    str.append("FMODELID = ").append(objects[0]);
                    str.append(String.format(StringUtils.join((Object[])new String[]{" and %s in (", String.join((CharSequence)",", modelParam.getBizmodels()), ") "}), "fbusinessmodel"));
                    filterSql = String.format(StringUtils.join((Object[])new String[]{" %s in (", str.toString(), ") "}), "fgroup");
                    break;
                }
                case examinecategory: {
                    filterSql = this.addFilterStr(modelParam.getBizmodels(), "fbusinessmodel", filterSql);
                    break;
                }
                case bizruleset: {
                    filterSql = this.addFilterStr(modelParam.getBizmodels(), "fbizctrlrangeid", filterSql);
                    break;
                }
                case Account: {
                    HashSet<String> accounts = new HashSet<String>(16);
                    accounts.addAll(modelParam.getDatasets());
                    accounts.add("0");
                    filterSql = this.addFilterStr(accounts, "fdataset", filterSql);
                    break;
                }
                case offsetrule: 
                case offsetentry: 
                case offsetrulecatalog: {
                    filterSql = this.addFilterStr(modelParam.getBizmodels(), "fbusmodelid", filterSql);
                    break;
                }
                case diffanalyzescheme: {
                    filterSql = this.addFilterStr(modelParam.getDatasets(), "fdatasetid", filterSql);
                    break;
                }
                case execanalyzescheme: {
                    filterSql = this.addFilterStr(modelParam.getBizmodels(), "fbizmodelid", filterSql);
                    break;
                }
            }
        }
        return this.getSyncFilter(filterSql, table, dmParam, transEnum);
    }

    private String getSyncFilter(String filterSql, String table, DataModelExportParam dmParam, DataModelTransEnum transEnum) {
        DynamicObject dynamicObject;
        if (dmParam.getMainSubExportParam().isSubModelSync() && DMMainSubConfig.subModelSyncFormIds.contains(transEnum.getFormID())) {
            if (DMMainSubConfig.subModelCanEditNumberFormIdSet.contains(transEnum.getFormID())) {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)transEnum.getFormID());
                DynamicProperty syncmainnumber = dynamicObject.getDynamicObjectType().getProperty("syncmainnumber");
                if (syncmainnumber != null) {
                    filterSql = filterSql + " and (fsyncstatus != '1' or " + syncmainnumber.getAlias() + " != ' ')";
                }
            } else {
                filterSql = filterSql + " and fsyncstatus != '1'";
            }
        }
        if (dmParam.getMainSubExportParam().isSyncSpecialFilter()) {
            if (DataModelTransEnum.model.getTableName().equalsIgnoreCase(table)) {
                return filterSql;
            }
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)transEnum.getFormID());
            if (dynamicObject != null) {
                DynamicProperty createdate = dynamicObject.getDynamicObjectType().getProperty("createdate");
                if (createdate == null) {
                    createdate = dynamicObject.getDynamicObjectType().getProperty("createtime");
                }
                if (createdate == null) {
                    DynamicProperty modifydate = dynamicObject.getDynamicObjectType().getProperty("modifydate");
                    if (modifydate == null) {
                        modifydate = dynamicObject.getDynamicObjectType().getProperty("modifytime");
                    }
                    createdate = modifydate;
                }
                if (createdate != null) {
                    filterSql = filterSql + " and " + createdate.getAlias() + " > '" + dmParam.getMainSubExportParam().getSyncDate() + "'";
                }
            }
        }
        return filterSql;
    }

    private String addFilterStr(Set<String> paramSet, String fieldName, String filterSql) {
        filterSql = paramSet == null || paramSet.size() == 0 ? filterSql + " and 1 != 1" : filterSql + String.format(" and %s in (" + String.join((CharSequence)",", paramSet) + ") ", fieldName);
        return filterSql;
    }
}

