/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.orm.EbBizrulesetStatusEnum;
import kd.epm.eb.common.pojo.RuleReleaseChangePojo;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelGlobalParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelInnerParam;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportDetail;
import kd.epm.eb.formplugin.dataModelTrans.importmodel.service.DataModelImportJsonService;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub.DMMainSubImportJsonService;
import kd.epm.eb.formplugin.dataModelTrans.specialfeild.mainsub.DMMainSubImportParam;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import kd.epm.eb.formplugin.sonmodel.MainSubModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DMMainSubImportDetail
extends DataModelImportDetail {
    private static Log log = LogFactory.getLog(DataModelImportJsonService.class);

    @Override
    protected DMMainSubImportJsonService getImportJsonService(DataModelInnerParam innerParam) {
        return new DMMainSubImportJsonService(innerParam);
    }

    @Override
    protected void afterFormIdLoop(DataModelImportParam importParam, DataModelGlobalParam globalParam, JSONObject jsonAllObject, String formId) {
        if (jsonAllObject == null || StringUtils.isBlank((CharSequence)formId) || globalParam == null || importParam == null) {
            return;
        }
        if (DataModelTransEnum.bizruleset.getFormID().equalsIgnoreCase(formId)) {
            Boolean subSync = importParam.getMainSubImportParam().getSubSync();
            if (!subSync.booleanValue()) {
                return;
            }
            JSONObject bizObject = jsonAllObject.getJSONObject(DataModelTransEnum.bizruleset.getFormID());
            if (bizObject == null) {
                return;
            }
            Map<String, Map<Long, Long>> needUpdatePKIDMap = globalParam.getNeedUpdatePKIDMap();
            String enableStatus = EbBizrulesetStatusEnum.ENABLE.getDbStatusString();
            JSONArray jsonArray = bizObject.getJSONArray(DataModelTransEnum.bizruleset.getTableName());
            HashSet<Long> hasSaveRuleIds = new HashSet<Long>(16);
            HashMap<Long, String> idNumberMap = new HashMap<Long, String>(16);
            Map<Long, Long> oldAndNewIdMap = null;
            if (needUpdatePKIDMap != null) {
                oldAndNewIdMap = needUpdatePKIDMap.get(DataModelTransEnum.bizruleset.getTableName());
            }
            int index = 0;
            Long newRuleId = null;
            for (Object o : jsonArray) {
                if (index++ == 0) continue;
                JSONObject jsonObject = (JSONObject)o;
                String fsyncstatus = jsonObject.getString("FSYNCSTATUS");
                String fstatus = jsonObject.getString("FSTATUS");
                if (!enableStatus.equals(fstatus)) continue;
                Long oldRuleId = jsonObject.getLong("FID");
                String fnumber = jsonObject.getString("FNUMBER");
                if (StringUtils.isNotBlank((CharSequence)fsyncstatus)) {
                    newRuleId = oldRuleId;
                }
                if (oldAndNewIdMap != null) {
                    newRuleId = oldAndNewIdMap.get(oldRuleId);
                }
                if (newRuleId == null) continue;
                hasSaveRuleIds.add(newRuleId);
                idNumberMap.put(newRuleId, fnumber);
            }
            if (CollectionUtils.isNotEmpty(hasSaveRuleIds)) {
                log.info("mainsubmodel sync bizrule hasSaveRuleId:" + SerializationUtils.toJsonString(hasSaveRuleIds));
                HashSet<Long> toDeleteRuleIds = new HashSet<Long>(16);
                for (Long hasSaveRuleId : hasSaveRuleIds) {
                    try {
                        RuleUtils.cancelRelease(Collections.singletonList(hasSaveRuleId));
                        log.info("mainsubmodel sync cancelrelease success.");
                    }
                    catch (KDBizException e1) {
                        log.info("mainsubmodel sync cancelrelease bizrule has exception.");
                        log.error((Throwable)e1);
                    }
                    catch (Exception e1) {
                        log.error("mainsubmodel sync cancelrelease bizrule exception.");
                        log.error((Throwable)e1);
                    }
                    try {
                        List<RuleReleaseChangePojo> ruleReleaseChangePojoList = RuleUtils.release(Collections.singletonList(hasSaveRuleId));
                        if (CollectionUtils.isEmpty(ruleReleaseChangePojoList)) {
                            log.info("mainsubmodel sync bizrule all publish failed.");
                        }
                        log.info("mainsubmodel sync release success.");
                    }
                    catch (KDBizException e) {
                        log.info("mainsubmodel sync release bizrule has exception.");
                        log.error((Throwable)e);
                        DMMainSubImportParam mainSubImportParam = importParam.getMainSubImportParam();
                        Map longSetMap = mainSubImportParam.getErrorTransFormDataDesc().computeIfAbsent(DataModelTransEnum.bizruleset.getFormID(), t -> new HashMap(16));
                        String number = (String)idNumberMap.get(hasSaveRuleId);
                        Set strings = longSetMap.computeIfAbsent(number, t -> new HashSet(16));
                        strings.add(e.getMessage());
                        toDeleteRuleIds.add(hasSaveRuleId);
                    }
                    catch (Exception e) {
                        log.info("mainsubmodel sync release bizrule exception.");
                        log.error((Throwable)e);
                    }
                }
                if (CollectionUtils.isNotEmpty(toDeleteRuleIds)) {
                    try {
                        RuleUtils.deleteRule(importParam.getToModelID(), toDeleteRuleIds);
                    }
                    catch (Exception e) {
                        log.info("mainsubmodel sync delete bizrule exception.");
                        log.error((Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    protected void beforeCommitTrans(DataModelImportParam importParam) {
        MainSubModelUtil.getInstance().modifyMainModel(importParam);
    }
}

