/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.constant.DataModelConstant;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportResult;
import kd.epm.eb.formplugin.dataModelTrans.entity.TableEntity;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;
import org.apache.commons.lang3.StringUtils;

public class DataModelCommon {
    private static final Log log = LogFactory.getLog(DataModelCommon.class);
    public static final int logBatch = 8886;
    private static final Map<String, Map<String, String>> defaultTableFieldsMap = new HashMap<String, Map<String, String>>(16);

    public static DataModelCommon getInstance() {
        return InnerClass.instance;
    }

    private DataModelCommon() {
    }

    public DataSet queryUserDefinDim(Long modelID) {
        String selectFields = "id,number,shortnumber,name,membermodel as formid,membertable as tablename ";
        QFilter qFilter = new QFilter("model", "=", (Object)modelID);
        qFilter.and(new QFilter("issysdimension", "=", (Object)Boolean.FALSE));
        String formID = "epm_dimension";
        return QueryServiceHelper.queryDataSet((String)DataModelConstant.CLASSNAME, (String)formID, (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    public DataSet queryRecordByTableName(Long modelID, String tableName) {
        DataModelTransEnum enumObj = DataModelTransEnum.getEnumByTableName(tableName);
        if (enumObj == null || modelID == null) {
            DataModelUtil.doLog("queryRecordByTableName getEnumByTableName is null.", log);
            return null;
        }
        String FmodelID = enumObj.getFilterModelField();
        String FID = enumObj.getFID();
        String FNumber = enumObj.getFnumber();
        String selectFields = FID + "," + FNumber;
        selectFields = selectFields + (StringUtils.isEmpty((CharSequence)enumObj.getUniqueFields()) ? "" : "," + enumObj.getUniqueFields());
        SqlBuilder whereB = new SqlBuilder();
        whereB.append(" where 1=1 ", new Object[0]);
        if (FmodelID.length() > 0) {
            whereB.append(" and ", new Object[0]).append(FmodelID, new Object[0]).append(" = ", new Object[0]).append(modelID.toString(), new Object[0]);
        }
        SqlBuilder sqlB = new SqlBuilder();
        sqlB.append(" select ", new Object[0]).append(selectFields, new Object[0]).append(" from ", new Object[0]).append(tableName, new Object[0]).appendSqlBuilder(whereB);
        return DB.queryDataSet((String)DataModelConstant.CLASSNAME, (DBRoute)BgFormConstant.DBROUTE, (SqlBuilder)sqlB);
    }

    public TableEntity getTableEntity(String table, JSONArray jsonCurTableAllDatas) {
        List fieldInfo;
        try {
            fieldInfo = DB.getFieldInfo((DBRoute)BgFormConstant.DBROUTE, (String)table);
        }
        catch (Exception e) {
            return this.getTableEntityForDM(table, jsonCurTableAllDatas);
        }
        TableEntity tableEntity = new TableEntity();
        List<String> pkids = DB.getPrimaryKeys((DBRoute)BgFormConstant.DBROUTE, (String)table);
        pkids = pkids.stream().map(String::toUpperCase).collect(Collectors.toList());
        tableEntity.setPkids(pkids);
        tableEntity.setTableName(table);
        HashSet<String> columnNameReturn = new HashSet<String>(16);
        ArrayList<FieldInfo> fieldInfoReturn = new ArrayList<FieldInfo>(16);
        tableEntity.setColumns(columnNameReturn);
        tableEntity.setFields(fieldInfoReturn);
        List columnNames = DB.getColumnNames((DBRoute)BgFormConstant.DBROUTE, (String)table);
        JSONObject jsonobj = null;
        int count = jsonCurTableAllDatas.size();
        if (count > 1) {
            jsonobj = (JSONObject)jsonCurTableAllDatas.get(1);
            if (table.equalsIgnoreCase("t_eb_structofbperiod")) {
                jsonobj = (JSONObject)jsonCurTableAllDatas.get(2);
            }
        }
        if (jsonobj == null) {
            return tableEntity;
        }
        for (String columnName : columnNames) {
            if (!jsonobj.containsKey((Object)columnName.toUpperCase())) continue;
            columnNameReturn.add(columnName.toUpperCase());
        }
        HashSet<String> colKeySet = new HashSet<String>(16);
        for (FieldInfo info : fieldInfo) {
            String fieldName = info.getFieldName().toUpperCase();
            if (colKeySet.contains(fieldName) || !jsonobj.containsKey((Object)fieldName)) continue;
            fieldInfoReturn.add(new FieldInfo(fieldName, info.getDataType()));
            colKeySet.add(fieldName);
        }
        return tableEntity;
    }

    public TableEntity getTableEntityForDM(String table, JSONArray jsonCurTableAllDatas) {
        TableEntity tableEntity;
        block17: {
            String fieldName;
            JSONObject jsonobj;
            ArrayList<FieldInfo> fieldInfoReturn;
            block18: {
                HashSet<String> fieldSet;
                String dataType;
                List columnNames;
                block16: {
                    log.info("begin getTableEntityForDM.");
                    tableEntity = new TableEntity();
                    List<String> pkids = DB.getPrimaryKeys((DBRoute)BgFormConstant.DBROUTE, (String)table);
                    pkids = pkids.stream().map(String::toUpperCase).collect(Collectors.toList());
                    tableEntity.setPkids(pkids);
                    tableEntity.setTableName(table);
                    HashSet<String> columnNameReturn = new HashSet<String>(16);
                    fieldInfoReturn = new ArrayList<FieldInfo>(16);
                    tableEntity.setColumns(columnNameReturn);
                    tableEntity.setFields(fieldInfoReturn);
                    columnNames = DB.getColumnNames((DBRoute)BgFormConstant.DBROUTE, (String)table);
                    jsonobj = null;
                    int count = jsonCurTableAllDatas.size();
                    if (count > 1) {
                        jsonobj = (JSONObject)jsonCurTableAllDatas.get(1);
                        if (table.equalsIgnoreCase("t_eb_structofbperiod")) {
                            jsonobj = (JSONObject)jsonCurTableAllDatas.get(2);
                        }
                    }
                    if (jsonobj == null) {
                        return tableEntity;
                    }
                    for (String columnName : columnNames) {
                        if (!jsonobj.containsKey((Object)columnName.toUpperCase())) continue;
                        columnNameReturn.add(columnName.toUpperCase());
                    }
                    DataModelTransEnum enumByTableName = DataModelTransEnum.getEnumByTableName(table);
                    dataType = null;
                    fieldSet = new HashSet<String>(16);
                    if (enumByTableName == null) break block16;
                    DataModelUtil.doLog("getTableEntity table:" + table, log);
                    MainEntityType type = EntityMetadataCache.getDataEntityType((String)enumByTableName.getFormID());
                    DataEntityPropertyCollection properties = type.getProperties();
                    for (IDataEntityProperty property : properties) {
                        LongProp longProp;
                        fieldName = property.getAlias();
                        if (property instanceof LongProp && (longProp = (LongProp)property).isRefId()) continue;
                        if (property instanceof LongProp || property instanceof BasedataProp || property instanceof BigIntProp) {
                            dataType = "bigint";
                        } else if (property instanceof TimeProp || property instanceof DateTimeProp) {
                            dataType = "timestamp";
                        } else if (property instanceof DecimalProp) {
                            dataType = "numeric";
                            if (property instanceof IntegerProp) {
                                dataType = "int";
                            }
                        } else if (property instanceof TextProp || property instanceof VarcharProp || property instanceof ComboProp || property instanceof BooleanProp) {
                            dataType = "varchar";
                        }
                        if (dataType == null) {
                            DataModelUtil.doLog("table:" + table + ";property fieldname:" + fieldName, log);
                            continue;
                        }
                        if (!jsonobj.containsKey((Object)fieldName.toUpperCase()) || fieldSet.contains(fieldName.toUpperCase())) continue;
                        fieldSet.add(fieldName.toUpperCase());
                        fieldInfoReturn.add(new FieldInfo(fieldName.toUpperCase(), dataType));
                    }
                    break block17;
                }
                if (!table.endsWith("_l")) break block18;
                for (String columnName : columnNames) {
                    fieldName = columnName.toUpperCase();
                    dataType = "FID".equalsIgnoreCase(fieldName) || "FPKID".equalsIgnoreCase(fieldName) || "FENTITYID".equalsIgnoreCase(fieldName) ? "bigint" : "varchar";
                    if (!jsonobj.containsKey((Object)fieldName) || fieldSet.contains(fieldName)) continue;
                    fieldSet.add(fieldName);
                    fieldInfoReturn.add(new FieldInfo(fieldName, dataType));
                }
                break block17;
            }
            Map<String, String> fieldTypeMap = defaultTableFieldsMap.get(table);
            if (fieldTypeMap == null) break block17;
            for (Map.Entry<String, String> entry : fieldTypeMap.entrySet()) {
                fieldName = entry.getKey().toUpperCase();
                String fieldType = entry.getValue();
                if (!jsonobj.containsKey((Object)fieldName)) continue;
                fieldInfoReturn.add(new FieldInfo(fieldName, fieldType));
            }
        }
        return tableEntity;
    }

    public String getFieldValueFromJson(JSONObject curLineData, String fieldName, Set<String> columnNames) {
        String value = null;
        if (columnNames.contains(fieldName)) {
            value = curLineData.getString(fieldName);
        }
        return value;
    }

    public boolean isModelExist(Long modelId) {
        QFilter filter = new QFilter("id", "=", (Object)modelId);
        return QueryServiceHelper.exists((String)"epm_model", (QFilter[])filter.toArray());
    }

    public Long isExistAndModelID(String fromModeNumber, String fromModelName, String reportType) {
        log.info("DatamodelCommon isExistAndModelID fromModeNumber:" + fromModeNumber);
        QFilter filter = new QFilter("shownumber", "=", (Object)fromModeNumber);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"epm_model", (String)"id", (QFilter[])new QFilter[]{filter});
        if (dy != null) {
            log.info("DatamodelCommon isExistAndModelID dy != null.");
            return dy.getLong("id");
        }
        log.info("DatamodelCommon isExistAndModelID dy == null.");
        return 0L;
    }

    public boolean isSpecSqlBatch(DataModelImportParam importParam) {
        return importParam.getSqlBatch() == 8886;
    }

    public boolean isBreakImport(DataModelImportResult result, DataModelImportParam importParam) {
        return importParam.isBreakImport() && result.isHasErrorData() || importParam.isOnlyCheckDataValiad();
    }

    public String downloadJsonFile(Object jsonData, String fileName) {
        return ImportAndExportUtil.downloadJsonFile((Object)jsonData, (String)fileName);
    }

    public String getStackTraceStr(Throwable e) {
        StackTraceElement[] arr = e.getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage()).append("\r\n");
        for (StackTraceElement ele : arr) {
            sb.append(ele.toString()).append("\r\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadZipFile(IFormView formView, List<JSONObject> jsonObjectList) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(outStream);
        try {
            String fileName = ResManager.loadKDString((String)"\u4e3b\u5b50\u4f53\u7cfb\u5bfc\u5165\u9519\u8bef\u65e5\u5fd7\u6587\u4ef6", (String)"DataModelCommon_01", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            for (JSONObject jsonObject : jsonObjectList) {
                int len;
                String entryFileName = jsonObject.getString("modelNumber");
                zipOutputStream.putNextEntry(new ZipEntry(entryFileName + ".json"));
                jsonObject.remove((Object)"modelNumber");
                ByteArrayInputStream inStream = new ByteArrayInputStream(jsonObject.toString().getBytes("utf-8"));
                byte[] buf = new byte[1024];
                while ((len = inStream.read(buf)) > 0) {
                    zipOutputStream.write(buf, 0, len);
                }
                inStream.close();
            }
            zipOutputStream.close();
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".zip", (InputStream)new ByteArrayInputStream(outStream.toByteArray()), 10000);
            return string;
        }
        finally {
            try {
                outStream.close();
                zipOutputStream.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    static {
        Map t_eb_changetypeformula = defaultTableFieldsMap.computeIfAbsent("t_eb_changetypeformula", t -> new HashMap(16));
        t_eb_changetypeformula.put("FID", "bigint");
        t_eb_changetypeformula.put("FENTRYID", "bigint");
        t_eb_changetypeformula.put("FSEQ", "bigint");
        t_eb_changetypeformula.put("FFORMULVIEWID", "bigint");
        t_eb_changetypeformula.put("FFORMULA", "varchar");
        t_eb_changetypeformula.put("FFORMULANAME", "varchar");
        Map t_eb_structofmetric_enum = defaultTableFieldsMap.computeIfAbsent("t_eb_structofmetric_enum", t -> new HashMap(16));
        t_eb_structofmetric_enum.put("FID", "bigint");
        t_eb_structofmetric_enum.put("FMODEL", "bigint");
        t_eb_structofmetric_enum.put("FENTRYID", "bigint");
        t_eb_structofmetric_enum.put("FSEQ", "bigint");
        t_eb_structofmetric_enum.put("FENUMNAME", "varchar");
        t_eb_structofmetric_enum.put("FENUMNUMBER", "varchar");
        t_eb_structofmetric_enum.put("FDIMID", "bigint");
        Map t_eb_analyzeschemecols = defaultTableFieldsMap.computeIfAbsent("t_eb_analyzeschemecols", t -> new HashMap(16));
        t_eb_analyzeschemecols.put("FID", "bigint");
        t_eb_analyzeschemecols.put("FENTRYID", "bigint");
        t_eb_analyzeschemecols.put("FSEQ", "bigint");
        t_eb_analyzeschemecols.put("FISCOLHIDDEN", "varchar");
        t_eb_analyzeschemecols.put("FCOLNAME", "varchar");
        t_eb_analyzeschemecols.put("FCOLTYPE", "varchar");
        t_eb_analyzeschemecols.put("FCOLCONFIGJSON", "varchar");
        Map t_eb_examine_temp = defaultTableFieldsMap.computeIfAbsent("t_eb_examine_temp", t -> new HashMap(16));
        t_eb_examine_temp.put("FID", "bigint");
        t_eb_examine_temp.put("FBASEDATAID", "bigint");
        t_eb_examine_temp.put("FPKID", "bigint");
        Map t_eb_scenarioentry = defaultTableFieldsMap.computeIfAbsent("t_eb_scenarioentry", t -> new HashMap(16));
        t_eb_scenarioentry.put("FID", "bigint");
        t_eb_scenarioentry.put("FAPPSCENARIOID", "bigint");
        t_eb_scenarioentry.put("FSYNCSTATUS", "varchar");
        t_eb_scenarioentry.put("FSYNCDATE", "timestamp");
        t_eb_scenarioentry.put("FENTRYID", "bigint");
        t_eb_scenarioentry.put("FSEQ", "bigint");
        Map t_eb_entitynamerecord = defaultTableFieldsMap.computeIfAbsent("t_eb_entitynamerecord", t -> new HashMap(16));
        t_eb_entitynamerecord.put("FID", "bigint");
        t_eb_entitynamerecord.put("FEFFDATE", "timestamp");
        t_eb_entitynamerecord.put("FMODIFIER", "bigint");
        t_eb_entitynamerecord.put("FENTITYID", "bigint");
        t_eb_entitynamerecord.put("FEXPDATE", "timestamp");
        t_eb_entitynamerecord.put("FSEQ", "bigint");
        t_eb_entitynamerecord.put("FMODIFYTIME", "timestamp");
        Map t_eb_offsetruleaccounts = defaultTableFieldsMap.computeIfAbsent("t_eb_offsetruleaccounts", t -> new HashMap(16));
        t_eb_offsetruleaccounts.put("FID", "bigint");
        t_eb_offsetruleaccounts.put("FSENDERACCOUNT", "varchar");
        t_eb_offsetruleaccounts.put("FACCOUNTID", "bigint");
        t_eb_offsetruleaccounts.put("FENTRYID", "bigint");
        t_eb_offsetruleaccounts.put("FSEQ", "bigint");
        Map t_eb_datasetdim = defaultTableFieldsMap.computeIfAbsent("t_eb_datasetdim", t -> new HashMap(16));
        t_eb_datasetdim.put("FID", "bigint");
        t_eb_datasetdim.put("FENTRYID", "bigint");
        t_eb_datasetdim.put("FSEQ", "bigint");
        t_eb_datasetdim.put("FDATASETDIM", "bigint");
        Map t_eb_accountmetric = defaultTableFieldsMap.computeIfAbsent("t_eb_accountmetric", t -> new HashMap(16));
        t_eb_accountmetric.put("FID", "bigint");
        t_eb_accountmetric.put("FENTRYID", "bigint");
        t_eb_accountmetric.put("FSEQ", "bigint");
        t_eb_accountmetric.put("FISTOPOLY", "varchar");
        t_eb_accountmetric.put("FDATABYTIME", "varchar");
        t_eb_accountmetric.put("FSKIP", "varchar");
        t_eb_accountmetric.put("FCHANGE", "varchar");
        t_eb_accountmetric.put("FMETRIC", "bigint");
        t_eb_accountmetric.put("FMETRICDESCRIPTION", "varchar");
        Map t_eb_dimensionrelation_e = defaultTableFieldsMap.computeIfAbsent("t_eb_dimensionrelation_e", t -> new HashMap(16));
        t_eb_dimensionrelation_e.put("FID", "bigint");
        t_eb_dimensionrelation_e.put("FENTRYID", "bigint");
        t_eb_dimensionrelation_e.put("FSEQ", "bigint");
        t_eb_dimensionrelation_e.put("FDIMENSION", "bigint");
        t_eb_dimensionrelation_e.put("FDIMVIEW", "bigint");
        t_eb_dimensionrelation_e.put("FDIMPROPERTY", "bigint");
        Map t_eb_dimpropertyentry = defaultTableFieldsMap.computeIfAbsent("t_eb_dimpropertyentry", t -> new HashMap(16));
        t_eb_dimpropertyentry.put("FID", "bigint");
        t_eb_dimpropertyentry.put("FENTRYID", "bigint");
        t_eb_dimpropertyentry.put("FSEQ", "bigint");
        t_eb_dimpropertyentry.put("FDIMENSIONID", "bigint");
        Map t_eb_viewentry = defaultTableFieldsMap.computeIfAbsent("t_eb_viewentry", t -> new HashMap(16));
        t_eb_viewentry.put("FID", "bigint");
        t_eb_viewentry.put("FENTRYID", "bigint");
        t_eb_viewentry.put("FSEQ", "bigint");
        t_eb_viewentry.put("FDIMENSIONID", "bigint");
        t_eb_viewentry.put("FVIEWID", "bigint");
        t_eb_viewentry.put("FSYNCSTATUS", "varchar");
        t_eb_viewentry.put("FSYNCDATE", "timestamp");
        Map t_eb_memberpropertyvalue = defaultTableFieldsMap.computeIfAbsent("t_eb_memberpropertyvalue", t -> new HashMap(16));
        t_eb_memberpropertyvalue.put("FID", "bigint");
        t_eb_memberpropertyvalue.put("FENTRYID", "bigint");
        t_eb_memberpropertyvalue.put("FSEQ", "bigint");
        t_eb_memberpropertyvalue.put("FSYNCSTATUS", "varchar");
        t_eb_memberpropertyvalue.put("FPROPERTYVALUEID", "bigint");
        t_eb_memberpropertyvalue.put("FSYNCDATE", "timestamp");
        Map t_eb_entitybizrecord = defaultTableFieldsMap.computeIfAbsent("t_eb_entitybizrecord", t -> new HashMap(16));
        t_eb_entitybizrecord.put("FID", "bigint");
        t_eb_entitybizrecord.put("FENTITYID", "bigint");
        t_eb_entitybizrecord.put("FSEQ", "bigint");
        t_eb_entitybizrecord.put("FEFFDATE", "timestamp");
        t_eb_entitybizrecord.put("FMODIFIER", "bigint");
        t_eb_entitybizrecord.put("FEXPDATE", "timestamp");
        t_eb_entitybizrecord.put("FMODIFYTIME", "timestamp");
        t_eb_entitybizrecord.put("FCHANGETYPE", "varchar");
        Map t_eb_examine_dimgrop = defaultTableFieldsMap.computeIfAbsent("t_eb_examine_dimgrop", t -> new HashMap(16));
        t_eb_examine_dimgrop.put("FID", "bigint");
        t_eb_examine_dimgrop.put("FBASEDATAID", "bigint");
        t_eb_examine_dimgrop.put("FPKID", "bigint");
        Map t_eb_offsetruleorgs = defaultTableFieldsMap.computeIfAbsent("t_eb_offsetruleorgs", t -> new HashMap(16));
        t_eb_offsetruleorgs.put("FID", "bigint");
        t_eb_offsetruleorgs.put("FENTRYID", "bigint");
        t_eb_offsetruleorgs.put("FSEQ", "bigint");
        t_eb_offsetruleorgs.put("FORGID", "bigint");
        Map t_eb_dimpropertysubentry = defaultTableFieldsMap.computeIfAbsent("t_eb_dimpropertysubentry", t -> new HashMap(16));
        t_eb_dimpropertysubentry.put("FDETAILID", "bigint");
        t_eb_dimpropertysubentry.put("FENTRYID", "bigint");
        t_eb_dimpropertysubentry.put("FSEQ", "bigint");
        t_eb_dimpropertysubentry.put("FCUSTOMPROPERTYID", "bigint");
        t_eb_dimpropertysubentry.put("FDSEQ", "bigint");
        Map t_eb_templaterelation = defaultTableFieldsMap.computeIfAbsent("t_eb_templaterelation", t -> new HashMap(16));
        t_eb_templaterelation.put("FID", "bigint");
        t_eb_templaterelation.put("FBASEDATAID", "bigint");
        t_eb_templaterelation.put("FPKID", "bigint");
    }

    private static class InnerClass {
        private static DataModelCommon instance = new DataModelCommon();

        private InnerClass() {
        }
    }
}

