/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelGlobalParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportResult;
import kd.epm.eb.formplugin.dataModelTrans.enums.ImportModelTypeEnum;
import kd.epm.eb.formplugin.dataModelTrans.enums.ImportTypeEnum;

public class DataModelImportUtil {
    public static Long loadModelIdByNumber(String modelNumber) {
        QFilter qFilter = new QFilter("shownumber", "=", (Object)modelNumber);
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((String)"epm_model", (String)"id", (QFilter[])qFilter.toArray());
        if (loadSingle != null) {
            Long id = loadSingle.getLong("id");
            return id;
        }
        return 0L;
    }

    private static void dealResultObj(DataModelImportResult[] resultArr, MultiLangEnumBridge bridge) {
        resultArr[0] = new DataModelImportResult();
        resultArr[0].setHasErrorData(true);
        resultArr[0].setTipInfos(Collections.singleton(bridge));
    }

    public static DataModelImportParam getImportParam(String json, String modelNumber, Long newModelId, String toModelName, Long datasourceId, String importType) {
        Boolean isExist = false;
        DataModelImportParam importParam = new DataModelImportParam(isExist, importType, ImportModelTypeEnum.DEFAULT);
        Map<String, String> fromJson = DataModelImportUtil.getModelIdFromJson(json);
        String jsonModelId = fromJson.get("FID");
        ImportTypeEnum importTypeEnum = ImportTypeEnum.getImportTypeEnumByCode(importType);
        if (importTypeEnum != null && !importTypeEnum.getCode().equals(ImportTypeEnum.ADD.getCode())) {
            importParam.setToModelID(newModelId);
        } else {
            if (IDUtils.isNotNull((Long)newModelId) && !newModelId.toString().equals(jsonModelId)) {
                json = json.replaceAll(jsonModelId, newModelId.toString());
            }
            String jsonModelNumber = fromJson.get("FNUMBER");
            if (StringUtils.isNotEmpty((String)modelNumber) && !jsonModelNumber.equals(modelNumber)) {
                json = DataModelImportUtil.getReplaceJsonValue(json, modelNumber, "FNUMBER", "t_eb_model");
                json = DataModelImportUtil.getReplaceJsonValue(json, modelNumber, "FSHOWNUMBER", "t_eb_model");
            }
            if (StringUtils.isNotEmpty((String)toModelName)) {
                json = DataModelImportUtil.getReplaceJsonValue(json, toModelName, "FNAME", "t_eb_model");
                json = DataModelImportUtil.getReplaceJsonValue(json, toModelName, "FNAME", "t_eb_model_l");
            }
        }
        JSONObject jsonObject = JSONObject.parseObject((String)json, (Feature[])new Feature[]{Feature.OrderedField});
        importParam.setDatasourceId(datasourceId);
        importParam.setJsonAllObject(jsonObject);
        importParam.setSkipErrData(false);
        importParam.setBreakImport(false);
        importParam.setSqlBatch(999);
        return importParam;
    }

    private static String getReplaceJsonValue(String json, String value, String fieldKey, String tableName) {
        JSONObject jsonObject = JSONObject.parseObject((String)json, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject modelObj = (JSONObject)jsonObject.get((Object)"epm_model");
        int count = modelObj.getJSONArray(tableName).size();
        JSONObject jsonobj = count > 1 ? (JSONObject)modelObj.getJSONArray(tableName).get(1) : (JSONObject)modelObj.getJSONArray(tableName).get(0);
        jsonobj.put(fieldKey, (Object)value);
        return jsonObject.toJSONString();
    }

    public static Long createModelId() {
        long modelId = DB.genGlobalLongId();
        QFilter qFilter = new QFilter("id", "=", (Object)modelId);
        DynamicObject object = QueryServiceHelper.queryOne((String)"epm_model", (String)"datasource", (QFilter[])qFilter.toArray());
        if (object == null) {
            return modelId;
        }
        return DataModelImportUtil.createModelId();
    }

    private static Map<String, String> getModelIdFromJson(String json) {
        HashMap<String, String> returnMap = new HashMap<String, String>(16);
        JSONObject jsonObject = JSONObject.parseObject((String)json, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject modelObj = (JSONObject)jsonObject.get((Object)"epm_model");
        int count = modelObj.getJSONArray("t_eb_model").size();
        JSONObject jsonobj = count > 1 ? (JSONObject)modelObj.getJSONArray("t_eb_model").get(1) : (JSONObject)modelObj.getJSONArray("t_eb_model").get(0);
        returnMap.put("FID", jsonobj.getString("FID"));
        returnMap.put("FNUMBER", jsonobj.getString("FSHOWNUMBER"));
        return returnMap;
    }

    public static boolean isRubishData(String tableName, Long fid, DataModelGlobalParam globlaParams) {
        if (tableName == null || globlaParams.getRubishDatas() == null) {
            return false;
        }
        Set<Long> rubishDatas = globlaParams.getRubishDatas().get(tableName);
        return rubishDatas != null && rubishDatas.contains(fid);
    }
}

