/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public class DataModelIsLeafUtil {
    public static final String LEAF = "leaf";
    public static final String NOTLEAF = "notleaf";

    public static void repairDimMemberLeafStatus(Long modelId, Boolean isRefreshCache) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map dimensions = modelCacheHelper.getDimensions();
        int initSize = (int)((double)dimensions.size() * 1.75 + 1.0);
        for (Map.Entry next : dimensions.entrySet()) {
            Dimension dimension = (Dimension)next.getValue();
            String dimensionNumber = dimension.getNumber();
            String entityName = SysDimensionEnum.getMemberTreemodelByNumberIgnoreCase((String)dimensionNumber);
            HashSet<Long> parentIdSet = new HashSet<Long>(initSize);
            Set<Long> ids = DataModelIsLeafUtil.loadDBParentIdAndNotLeafSet(modelCacheHelper, dimension, parentIdSet, entityName);
            DataModelIsLeafUtil.updateIsLeafStatus(entityName, parentIdSet, ids);
        }
        if (Boolean.TRUE.equals(isRefreshCache)) {
            ModelCacheContext.getOrCreate((Long)modelId, (boolean)true);
        }
    }

    private static Set<Long> loadDBParentIdAndNotLeafSet(IModelCacheHelper modelCacheHelper, Dimension dimension, Set<Long> parentIdSet, String entityName) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        Long modelId = modelCacheHelper.getModelobj().getId();
        QFilter qFilter = new QFilter("model.id", "=", (Object)modelId);
        qFilter.and(new QFilter("dimension.id", "=", (Object)dimension.getId()));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)entityName, (String)entityName, (String)"id,parent.id,isleaf", (QFilter[])qFilter.toArray(), (String)"");){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                parentIdSet.add(row.getLong("parent.id"));
                Long id = row.getLong("id");
                if (!IDUtils.isNotNull((Long)id)) continue;
                idSet.add(id);
            }
        }
        return idSet;
    }

    private static void updateIsLeafStatus(String entityName, Set<Long> parentIdSet, Set<Long> pkIds) {
        Map<String, Set<Long>> needUpdateIds = DataModelIsLeafUtil.getNeedUpdateSets(parentIdSet, pkIds);
        if (needUpdateIds == null) {
            return;
        }
        DataModelIsLeafUtil.queryAndModifyIsleaf(entityName, needUpdateIds.get(LEAF), true);
        DataModelIsLeafUtil.queryAndModifyIsleaf(entityName, needUpdateIds.get(NOTLEAF), false);
    }

    private static Map<String, Set<Long>> getNeedUpdateSets(Set<Long> parentIdSet, Set<Long> pkIds) {
        HashMap<String, Set<Long>> returns = new HashMap<String, Set<Long>>(5);
        HashSet<Long> notLeafs = new HashSet<Long>(16);
        HashSet<Long> leafs = new HashSet<Long>(16);
        if (CollectionUtils.isEmpty(pkIds)) {
            return null;
        }
        for (Long pkId : pkIds) {
            if (parentIdSet.contains(pkId)) {
                notLeafs.add(pkId);
                continue;
            }
            leafs.add(pkId);
        }
        returns.put(LEAF, leafs);
        returns.put(NOTLEAF, notLeafs);
        return returns;
    }

    private static void queryAndModifyIsleaf(String entityName, Set<Long> pkIds, boolean isLeaf) {
        if (CollectionUtils.isEmpty(pkIds)) {
            return;
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)"id,isleaf", (QFilter[])new QFilter("id", "in", pkIds).toArray());
        for (int i = 0; i < dynamicObjects.length; ++i) {
            dynamicObjects[i].set("isleaf", (Object)isLeaf);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
    }
}

