/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.FieldInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelCurrentLine;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelGlobalParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelInnerParam;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelCommon;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;

public class DataModelLogUtil {
    private static Log log = LogFactory.getLog(DataModelLogUtil.class);

    public static void doSizeLog(DataModelInnerParam innerParam, DataModelCurrentLine currentLine, Map<String, List<Object[]>> sqlValues, Map<String, String> sqlStrs, DataModelGlobalParam globlaParams) {
        String table = currentLine.getTableName();
        DataModelUtil.doLog(StringUtils.join((Object[])new Serializable[]{"before_saveRecord_doSave:", table, " || updateCounts: ", Integer.valueOf(sqlValues.get("update").size()), " || insertCounts: ", Integer.valueOf(sqlValues.get("insert").size()), " || deleteCounts: ", Integer.valueOf(sqlValues.get("delete").size())}), log);
        if (DataModelCommon.getInstance().isSpecSqlBatch(innerParam.getImportParam())) {
            innerParam.getResult().getAddMap().put(table + "_" + "insert", sqlValues.get("insert").size());
            innerParam.getResult().getAddMap().put(table + "_" + "update", sqlValues.get("update").size());
            innerParam.getResult().getAddMap().put(table + "_" + "delete", sqlValues.get("delete").size());
        }
        if (DataModelCommon.getInstance().isSpecSqlBatch(innerParam.getImportParam())) {
            List logInfos = innerParam.getResult().getSqlValues().computeIfAbsent(currentLine.getTableName(), k -> new ArrayList(16));
            Object[] values = new Object[]{sqlStrs.get("delete"), sqlStrs.get("insert"), sqlStrs.get("update")};
            logInfos.add(values);
            Object[] fields = new Object[]{StringUtils.join((Object[])new String[]{table, "tableFields:", StringUtils.join((Object[])currentLine.getTableEntity().getFields().parallelStream().map(FieldInfo::getFieldName).collect(Collectors.toList()).toArray(), (String)",")})};
            logInfos.add(fields);
            Object[] pkids = new Object[]{StringUtils.join((Object[])new String[]{table, "tablePKIDS:", StringUtils.join((Object[])currentLine.getTableEntity().getPkids().toArray(), (String)",")})};
            logInfos.add(pkids);
            Map<Long, Long> insertIDs = globlaParams.getNeedUpdatePKIDMap().get(table);
            HashSet<String> insertIdSet = new HashSet<String>(16);
            if (insertIDs != null) {
                for (Map.Entry<Long, Long> id : insertIDs.entrySet()) {
                    insertIdSet.add(StringUtils.join((Object[])new Serializable[]{id.getKey(), " -> ", id.getValue()}));
                }
            }
            Object[] insert = new Object[]{StringUtils.join((Object[])new String[]{table, "insertIds:", StringUtils.join((Object[])insertIdSet.toArray(), (String)",")})};
            logInfos.add(insert);
            Map<Long, Long> updateIDs = globlaParams.getNeedUpdateNumberMap().get(table);
            HashSet<String> updateIDSet = new HashSet<String>(16);
            if (updateIDs != null) {
                for (Map.Entry<Long, Long> id : updateIDs.entrySet()) {
                    updateIDSet.add(StringUtils.join((Object[])new Serializable[]{id.getKey(), " -> ", id.getValue()}));
                }
            }
            Object[] update = new Object[]{StringUtils.join((Object[])new String[]{table, "updateIds:", StringUtils.join((Object[])updateIDSet.toArray(), (String)",")})};
            logInfos.add(update);
        }
    }

    public static void doSizeLog(DataModelGlobalParam globlaParams, DataModelInnerParam innerParam, DataModelCurrentLine currentLine, Long currentLineOldFid, List<Object> valueLst, String sqlMark) {
        if (DataModelCommon.getInstance().isSpecSqlBatch(innerParam.getImportParam())) {
            Map<Long, Long> entryMap;
            String tableName = currentLine.getTableName();
            String mark = StringUtils.join((Object[])new String[]{sqlMark, ":", tableName, ":"});
            String newId = " NewId ";
            if (!currentLine.isUpdate()) {
                entryMap = globlaParams.getNeedUpdatePKIDMap().get(currentLine.getMainTableName());
                if (entryMap != null && entryMap.get(currentLineOldFid) != null) {
                    newId = StringUtils.join((Object[])new Serializable[]{"-insertNewId-", entryMap.get(currentLineOldFid)});
                }
            } else {
                entryMap = globlaParams.getNeedUpdateNumberMap().get(currentLine.getMainTableName());
                if (entryMap != null && entryMap.get(currentLineOldFid) != null) {
                    newId = StringUtils.join((Object[])new Serializable[]{"-updateDeleteNewId-", entryMap.get(currentLineOldFid)});
                }
            }
            List logInfos = innerParam.getResult().getSqlValues().computeIfAbsent(tableName, k -> new ArrayList(16));
            Object[] values = new Object[]{StringUtils.join((Object[])new Serializable[]{mark, currentLineOldFid, "->", newId})};
            logInfos.add(values);
            logInfos.add(valueLst.toArray());
        }
    }

    public static void doSizeLog(DataModelInnerParam innerParam, DataModelCurrentLine currentLine, FieldInfo fieldInfo) {
        if (DataModelCommon.getInstance().isSpecSqlBatch(innerParam.getImportParam())) {
            String fieldName = currentLine.getFieldName();
            List logInfos = innerParam.getResult().getSqlValues().computeIfAbsent(currentLine.getTableName(), k -> new ArrayList(16));
            Object[] values = new Object[]{StringUtils.join((Object[])new String[]{currentLine.getTableName(), "-", fieldName, "-FieldDataType:", fieldInfo.getDataType()})};
            logInfos.add(values);
        }
    }
}

