/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.constant.DataModelConstant;

public class DataModelMetaDataFields {
    public static DataModelMetaDataFields getInstance() {
        return InnerClass.instance;
    }

    private DataModelMetaDataFields() {
    }

    public Map<String, Map<String, String>> getFieldAndTypeMap(String table) {
        HashMap<String, Map<String, String>> returns = new HashMap<String, Map<String, String>>(DataModelConstant.ARRAYDEFAULTSIZE);
        DataModelTransEnum dataM = DataModelTransEnum.getEnumByTableName(table);
        if (dataM != null) {
            String formId = dataM.getFormID();
            this.getBaseFieldByFormID(formId, returns);
        }
        return returns;
    }

    public Map<String, String> getBaseFieldByFormID(String formId, Map<String, Map<String, String>> outref_fieldAndTypeMap) {
        HashMap<String, String> returnMap = new HashMap<String, String>(DataModelConstant.ARRAYDEFAULTSIZE);
        String mainTable = DataModelTransEnum.getTableNameByFormID(formId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)formId);
        DataEntityPropertyCollection dataEntityPropertyCollection = dynamicObject.getDataEntityType().getProperties();
        for (IDataEntityProperty iDataEntityProperty : dataEntityPropertyCollection) {
            if (iDataEntityProperty instanceof MulBasedataProp) {
                this.putBaseFieldByFormID(iDataEntityProperty, mainTable, Boolean.TRUE, returnMap, outref_fieldAndTypeMap);
            }
            if (iDataEntityProperty instanceof EntryProp) {
                if (outref_fieldAndTypeMap == null) continue;
                DataEntityPropertyCollection entryCollection = ((EntryProp)iDataEntityProperty).getItemType().getProperties();
                for (IDataEntityProperty entry : entryCollection) {
                    String alias = ((EntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType().getAlias();
                    this.putSubEntity(entry, alias, returnMap, outref_fieldAndTypeMap);
                    if (entry instanceof MulBasedataProp) {
                        this.putBaseFieldByFormID(entry, alias, Boolean.TRUE, returnMap, outref_fieldAndTypeMap);
                    }
                    if (!(entry instanceof BasedataProp)) continue;
                    this.putBaseFieldByFormID(entry, alias, Boolean.FALSE, returnMap, outref_fieldAndTypeMap);
                }
            }
            if (!(iDataEntityProperty instanceof BasedataProp)) continue;
            this.putBaseFieldByFormID(iDataEntityProperty, mainTable, Boolean.FALSE, returnMap, outref_fieldAndTypeMap);
        }
        return returnMap;
    }

    private void putSubEntity(IDataEntityProperty iDataEntityProperty, String tableName, Map<String, String> outref_baseFieldMap, Map<String, Map<String, String>> outref_fieldAndTypeMap) {
        if (iDataEntityProperty instanceof SubEntryProp) {
            String entryAlias = ((SubEntryProp)iDataEntityProperty).getItemType().getAlias();
            DataEntityPropertyCollection subCols = ((SubEntryProp)iDataEntityProperty).getItemType().getProperties();
            for (IDataEntityProperty col : subCols) {
                if (col instanceof MulBasedataProp) {
                    this.putBaseFieldByFormID(iDataEntityProperty, entryAlias, Boolean.TRUE, outref_baseFieldMap, outref_fieldAndTypeMap);
                }
                if (!(col instanceof BasedataProp)) continue;
                this.putBaseFieldByFormID(col, entryAlias, Boolean.FALSE, outref_baseFieldMap, outref_fieldAndTypeMap);
            }
        }
    }

    private void putBaseFieldByFormID(IDataEntityProperty iDataEntityProperty, String tableName, Boolean isMultBaseField, Map<String, String> outref_baseFieldMap, Map<String, Map<String, String>> outref_fieldAndTypeMap) {
        Map<String, String> fieldInfoMap = this.getFieldInfoMap(iDataEntityProperty, isMultBaseField);
        if (fieldInfoMap == null || fieldInfoMap.size() == 0) {
            return;
        }
        outref_baseFieldMap.put(this.getFieldNumber(fieldInfoMap.get("fieldnumber")), fieldInfoMap.get("fielddbname"));
        if (outref_fieldAndTypeMap == null) {
            return;
        }
        this.putFieldAndTypeMap(outref_fieldAndTypeMap, tableName, fieldInfoMap.get("tablename"), fieldInfoMap.get("fielddbname"));
    }

    public Map<String, String> getFieldInfoMap(IDataEntityProperty iDataEntityProperty, Boolean isMultBaseField) {
        HashMap<String, String> returnMap = new HashMap<String, String>(16);
        String tableName = null;
        String fieldType = null;
        String fieldShowName = null;
        String fieldDBName = null;
        String fieldNumber = null;
        if (isMultBaseField.booleanValue()) {
            MulBasedataProp mulBaseProp = (MulBasedataProp)iDataEntityProperty;
            String baseType = mulBaseProp.getBaseEntityId();
            tableName = DataModelTransEnum.getTableNameByFormID(baseType);
            if (StringUtils.isBlank((CharSequence)tableName) || !DataModelTransEnum.includeTableName(tableName)) {
                return null;
            }
            fieldType = mulBaseProp.getBaseEntityId();
            fieldNumber = mulBaseProp.getRefBaseProp().getAlias();
            fieldShowName = mulBaseProp.getDisplayName().getLocaleValue();
            fieldDBName = mulBaseProp.getDynamicCollectionItemPropertyType().getAlias();
        } else {
            BasedataProp baseProp = (BasedataProp)iDataEntityProperty;
            tableName = baseProp.getDynamicComplexPropertyType().getAlias();
            if (StringUtils.isBlank((CharSequence)tableName) || !DataModelTransEnum.includeTableName(tableName)) {
                return null;
            }
            fieldType = baseProp.getBaseEntityId();
            fieldNumber = baseProp.getRefIdPropName();
            fieldShowName = baseProp.getDisplayName().getLocaleValue();
            fieldDBName = baseProp.getAlias();
        }
        if (StringUtils.isNotBlank((CharSequence)fieldDBName)) {
            returnMap.put("fieldtype", fieldType);
            returnMap.put("fieldshowname", fieldShowName);
            returnMap.put("tablename", tableName.toLowerCase());
            returnMap.put("fielddbname", fieldDBName.toUpperCase());
            returnMap.put("fieldnumber", fieldNumber.toUpperCase());
        }
        return returnMap;
    }

    private String getFieldNumber(String fieldNumber) {
        return fieldNumber.endsWith("_ID") ? fieldNumber.substring(0, fieldNumber.length() - 3) : fieldNumber;
    }

    private void putFieldAndTypeMap(Map<String, Map<String, String>> outref, String tableName, String fieldTableName, String TableFieldName) {
        Map<String, String> entryMap = outref.get(tableName);
        if (entryMap != null) {
            entryMap.put(TableFieldName.toUpperCase(), fieldTableName.toLowerCase());
        } else {
            HashMap<String, String> subMap = new HashMap<String, String>(DataModelConstant.ARRAYDEFAULTSIZE);
            subMap.put(TableFieldName.toUpperCase(), fieldTableName.toLowerCase());
            outref.put(tableName.toLowerCase(), subMap);
        }
    }

    private static class InnerClass {
        private static DataModelMetaDataFields instance = new DataModelMetaDataFields();

        private InnerClass() {
        }
    }
}

