/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataModelTrans.util;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.FieldInfo;
import kd.bos.logging.Log;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.dataModelTrans.config.DataModelTransEnum;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelCurrentLine;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelImportParam;
import kd.epm.eb.formplugin.dataModelTrans.entity.DataModelInnerParam;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelLogUtil;

public class DataModelUtil {
    public static void doLogTimeEnd(long beginTime, String info, Log log) {
        String logInfo = StringUtils.join((Object[])new Serializable[]{"epm_dataModel_import:", info, ":", Long.valueOf(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beginTime)), " || ", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())});
        log.info(logInfo);
    }

    public static void doLog(String info, Log log) {
        log.info(StringUtils.join((Object[])new String[]{"epm_dataModel_import:", info, RequestContext.get().getUserName(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())}));
    }

    public static Boolean isMainTable(String table) {
        return DataModelTransEnum.includeTableName(table) && DataModelTransEnum.getEnumByTableName(table).getIsMainTable() == 1;
    }

    public static String getUpperOrLowerFieldValue(String formId, String fieldValue) {
        if ((DataModelTransEnum.customproperty.getFormID().equalsIgnoreCase(formId) || DataModelTransEnum.custompropertyvalue.getFormID().equalsIgnoreCase(formId)) && !DataModelUtil.isCaseUpperOrLower()) {
            return fieldValue;
        }
        if (!DataModelUtil.isCaseUpperOrLower()) {
            return fieldValue.toUpperCase();
        }
        return fieldValue;
    }

    private static boolean isCaseUpperOrLower() {
        boolean flag = false;
        return flag;
    }

    public static Object getFieldByInfo(DataModelInnerParam innerParam, DataModelCurrentLine currentLine, FieldInfo fieldInfo, Object field) {
        String dataType = fieldInfo.getDataType().toLowerCase(Locale.getDefault());
        DataModelLogUtil.doSizeLog(innerParam, currentLine, fieldInfo);
        if (dataType != null) {
            if (dataType.startsWith("bigint") || dataType.startsWith("int8") || dataType.startsWith("int16")) {
                return Convert.toLong((Object)field);
            }
            if (dataType.startsWith("char") || dataType.startsWith("varchar") || dataType.startsWith("bpchar")) {
                return Convert.toStr((Object)field);
            }
            if (dataType.startsWith("int") || dataType.startsWith("tinyint")) {
                return Convert.toInt((Object)field);
            }
            if (dataType.startsWith("smallint")) {
                return Convert.toInt((Object)field);
            }
            if (dataType.startsWith("timestamp")) {
                return field;
            }
            if (dataType.startsWith("numeric") || dataType.startsWith("decimal") || dataType.startsWith("number")) {
                return Convert.toBigDecimal((Object)field);
            }
            if (dataType.startsWith("text")) {
                return Convert.toStr((Object)field);
            }
        }
        return field;
    }

    public static String getDimNumber(String text) {
        if (text.equalsIgnoreCase(SysDimensionEnum.Entity.getNumber())) {
            return SysDimensionEnum.Entity.getNumber();
        }
        if (text.equalsIgnoreCase(SysDimensionEnum.Account.getNumber())) {
            return SysDimensionEnum.Account.getNumber();
        }
        if (text.equalsIgnoreCase(SysDimensionEnum.AuditTrail.getNumber())) {
            return SysDimensionEnum.AuditTrail.getNumber();
        }
        if (text.equalsIgnoreCase(SysDimensionEnum.ChangeType.getNumber())) {
            return SysDimensionEnum.ChangeType.getNumber();
        }
        if (text.equalsIgnoreCase(SysDimensionEnum.InternalCompany.getNumber())) {
            return SysDimensionEnum.InternalCompany.getNumber();
        }
        if (text.equalsIgnoreCase(SysDimensionEnum.Scenario.getNumber())) {
            return SysDimensionEnum.Scenario.getNumber();
        }
        if (text.equalsIgnoreCase(SysDimensionEnum.Process.getNumber())) {
            return SysDimensionEnum.Process.getNumber();
        }
        if (text.equalsIgnoreCase(SysDimensionEnum.DataType.getNumber())) {
            return SysDimensionEnum.DataType.getNumber();
        }
        if (text.equalsIgnoreCase(SysDimensionEnum.Version.getNumber())) {
            return SysDimensionEnum.Version.getNumber();
        }
        if (text.equalsIgnoreCase(SysDimensionEnum.Currency.getNumber())) {
            return SysDimensionEnum.Currency.getNumber();
        }
        if (text.equalsIgnoreCase(SysDimensionEnum.Metric.getNumber())) {
            return SysDimensionEnum.Metric.getNumber();
        }
        if (text.equalsIgnoreCase(SysDimensionEnum.BudgetPeriod.getNumber())) {
            return SysDimensionEnum.BudgetPeriod.getNumber();
        }
        return null;
    }

    public static DynamicObject createErrLog(DataModelImportParam importParam, String metename, String basedata, String ExceptionString) {
        long modelid = importParam.getToModelID() == null ? 0L : importParam.getToModelID();
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"eb_tansmodelerrlogs");
        log.set("tomodel", (Object)modelid);
        log.set("toModelNumber", (Object)importParam.getToModelNumber());
        log.set("info", (Object)DataModelUtil.getInfo(importParam));
        log.set("metename", (Object)metename);
        log.set("basedata", (Object)basedata);
        log.set("errinfo", (Object)ExceptionString);
        log.set("createtime", (Object)new Date());
        log.set("creator", (Object)UserUtils.getUserId());
        return log;
    }

    private static String getInfo(DataModelImportParam importParam) {
        boolean isMainSub = importParam.getMainSubImportParam().isMainSubModel();
        boolean isSync = importParam.getMainSubImportParam().getSubSync();
        return StringUtils.join((Object[])new String[]{importParam.getImportType(), isMainSub ? "!mainSub!" : "", isSync ? "!sync!" : ""});
    }
}

