/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataUpload;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.epm.eb.business.apiservice.DataUploadService;
import kd.epm.eb.business.dataupload.ModelUploadService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.decompose.DecomposeStatus;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class EbDataTransMissionPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SCHEME_INFO_CACHE = "schemeInfoCache";
    private static final Log log = LogFactory.getLog(EbDataTransMissionPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{"period", "srcversion", "tarversion", "entity"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        Object schemeid = this.getView().getFormShowParameter().getCustomParam("schemeid");
        if (schemeid == null || schemeid.toString().length() == 0 || this.queryScheme(schemeid.toString()) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u65b9\u6848\uff0c\u8bf7\u9000\u51fa\u540e\u5237\u65b0\u5217\u8868\u9875\u9762\u3002", (String)"EbDataTransMissionPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.FALSE, new String[]{"period", "srcversion", "tarversion", "entity"});
            return;
        }
        this.getModel().setValue("uploadscheme", (Object)schemeid.toString(), 0);
        QFilter qFilter = new QFilter("model", "=", (Object)this.getInfoId("tarmodel"));
        Date today = TimeServiceHelper.today();
        QFilter qFilter1 = new QFilter("startdate", "<=", (Object)today);
        qFilter1.and("enddate", ">", (Object)today);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_receiveparameter", (String)"version.number", (QFilter[])new QFilter[]{qFilter, qFilter1});
        ArrayList<String> numbers = new ArrayList<String>(query.size());
        for (DynamicObject object : query) {
            numbers.add(object.getString("version.number"));
        }
        this.getPageCache().put("tarVersionNumCache", SerializationUtils.serializeToBase64(numbers));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("run".equals(itemKey)) {
            this.run();
            this.writeLog("upload", new MultiLangEnumBridge("\u4f53\u7cfb\u95f4\u6570\u636e\u4e0a\u4f20", "EbDataTransMissionPlugin_7", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4f53\u7cfb\u95f4\u6570\u636e\u4e0a\u4f20\u6210\u529f\u3002", "EbDataTransMissionPlugin_8", "epm-eb-formplugin"));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        Long busmodel = this.getInfoId("tarbiz");
        Long modelId = this.getInfoId("tarmodel");
        String dimNumber = null;
        QFilter filter = null;
        switch (key) {
            case "srcversion": {
                busmodel = this.getInfoId("srcbiz");
                modelId = this.getInfoId("srcmodel");
                dimNumber = SysDimensionEnum.Version.getNumber();
                break;
            }
            case "tarversion": {
                dimNumber = SysDimensionEnum.Version.getNumber();
                filter = new QFilter("number", "in", SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("tarVersionNumCache")));
                break;
            }
            case "period": {
                dimNumber = SysDimensionEnum.BudgetPeriod.getNumber();
                break;
            }
            case "entity": {
                dimNumber = SysDimensionEnum.Entity.getNumber();
            }
        }
        if (dimNumber != null) {
            MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(busmodel);
            String entityviewId = this.getPageCache().get("EntityviewId");
            if (StringUtils.isNotEmpty((String)entityviewId) && "entity".equals(key)) {
                f7Param.setViewId(Long.valueOf(entityviewId));
            }
            f7Param.setEnableView(true);
            f7Param.setOnlySelLeaf(true);
            f7Param.addCustomFilter(filter);
            NewF7Utils.openF7((BeforeF7SelectEvent)evt, (MemberF7Parameter)f7Param);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("close_page".equals(actionId)) {
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        log.info("go into confirmCallBack");
        MessageBoxResult result = evt.getResult();
        String callBackId = evt.getCallBackId();
        if ("coverRun".equals(callBackId) && MessageBoxResult.Yes == result) {
            log.info("go into coverRun");
            String pageParamStr = this.getPageCache().get("pageParam");
            if (StringUtils.isNotEmpty((String)pageParamStr)) {
                Map pageParam = (Map)SerializationUtils.deSerializeFromBase64((String)pageParamStr);
                long id = Long.parseLong((String)pageParam.get("id"));
                String schemeNumber = (String)pageParam.get("schemeNumber");
                log.info("id:" + id);
                ModelUploadService instance = ModelUploadService.getInstance();
                log.info("get commPools");
                ThreadPool commPools = EpmThreadPools.CommPools;
                log.info("execute");
                String traceId = RequestContext.getOrCreate().getTraceId();
                String loginIP = RequestContext.getOrCreate().getLoginIP();
                commPools.execute(() -> {
                    RequestContext.getOrCreate().setTraceId(traceId);
                    RequestContext.getOrCreate().setLoginIP(loginIP);
                    instance.executeUpload(Long.valueOf(id), pageParam, this.getPageCache(), schemeNumber);
                });
                log.info("executeProcess");
                this.executeProcess();
            }
        }
    }

    private Map<String, String> queryScheme(String schemeId) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"eb_modelupload", (String)"srcmodel,srcbiz,tarmodel,tarbiz", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)schemeId))});
        if (object == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("schemeid", schemeId);
        map.put("srcmodel", object.getString("srcmodel"));
        map.put("srcbiz", object.getString("srcbiz"));
        map.put("tarmodel", object.getString("tarmodel"));
        map.put("tarbiz", object.getString("tarbiz"));
        this.getPageCache().put(SCHEME_INFO_CACHE, SerializationUtils.serializeToBase64(map));
        return map;
    }

    private Long getInfoId(String key) {
        Map map = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(SCHEME_INFO_CACHE));
        return IDUtils.toLong(map.get(key));
    }

    public String getCurrentDimNumber(String controlKey) {
        switch (controlKey) {
            case "period": {
                return "BudgetPeriod";
            }
            case "entity": {
                return "Entity";
            }
        }
        return "Version";
    }

    private void run() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        DynamicObject object = (DynamicObject)entryentity.get(0);
        Long id = object.getLong("uploadscheme.id");
        String schemeNumber = object.getString("uploadscheme.number");
        ArrayList<String> number = new ArrayList<String>(10);
        ArrayList<String> name = new ArrayList<String>(10);
        HashMap<String, String> pageParam = new HashMap<String, String>(8);
        DynamicObjectCollection entitys = object.getDynamicObjectCollection("entity");
        if (entitys == null || entitys.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u7ec4\u7ec7\u3002", (String)"EbDataTransMissionPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject entity : entitys) {
            number.add(entity.getDynamicObject("fbasedataid").getString("number"));
            name.add(entity.getDynamicObject("fbasedataid").getString("name"));
        }
        pageParam.put("org", String.join((CharSequence)",", number));
        pageParam.put("orgName", String.join((CharSequence)",", name));
        pageParam.put("schemeNumber", schemeNumber);
        ArrayList<String> periodNumbers = new ArrayList<String>(10);
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue("period");
        for (DynamicObject period : periods) {
            periodNumbers.add(period.getDynamicObject("fbasedataid").getString("number"));
        }
        pageParam.put("bp", String.join((CharSequence)",", periodNumbers));
        DynamicObject srcVersion = (DynamicObject)this.getModel().getValue("srcversion");
        pageParam.put("srcVersion", srcVersion.getString("number"));
        pageParam.put("srcVersionName", srcVersion.getString("name"));
        pageParam.put("srcVersionId", srcVersion.getString("id"));
        DynamicObject tarVersion = (DynamicObject)this.getModel().getValue("tarversion");
        pageParam.put("tarVersion", tarVersion.getString("number"));
        pageParam.put("tarVersionName", tarVersion.getString("name"));
        pageParam.put("tarVersionId", tarVersion.getString("id"));
        pageParam.put("periods", SerializationUtils.serializeToBase64(periods.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet())));
        pageParam.put("entities", SerializationUtils.serializeToBase64(entitys.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet())));
        this.checkAdjust(periodNumbers, srcVersion.getString("number"));
        pageParam.put("isLock", String.valueOf(this.isLock()));
        ModelUploadService instance = ModelUploadService.getInstance();
        instance.validRepeatRun(id);
        boolean cover = instance.checkCover(id, pageParam);
        if (cover) {
            pageParam.put("id", String.valueOf(id));
            this.getPageCache().put("pageParam", SerializationUtils.serializeToBase64(pageParam));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5df2\u5b58\u5728\u6570\u636e\uff0c\u7ee7\u7eed\u6267\u884c\u5c06\u8986\u76d6\u5df2\u6709\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"EbDataTransMissionPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("coverRun"));
            return;
        }
        DataUploadService.getInstance().asyncModelDataUpload(id, pageParam, instance, this.getPageCache(), schemeNumber);
        this.executeProcess();
    }

    private void checkAdjust(List<String> periods, String version) {
        Object schemeId = this.getView().getFormShowParameter().getCustomParam("schemeid");
        DynamicObject scheme = QueryServiceHelper.queryOne((String)"eb_modelupload", (String)"srcmodel.number,srcmodel.id,srcbiz.id,srcbiz.name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)schemeId))});
        Long modelId = scheme.getLong("srcmodel.id");
        Long busmodelId = scheme.getLong("srcbiz.id");
        String busmodelName = scheme.getString("srcbiz.name");
        ArrayList memberMapList = new ArrayList(periods.size());
        for (String period : periods) {
            HashMap<String, String> memberMap = new HashMap<String, String>(16);
            memberMap.put(SysDimensionEnum.Version.getNumber(), version);
            memberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), period);
            memberMapList.add(memberMap);
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(busmodelId);
        Set adjustMemberSet = AdjustServiceHelper.getAdjustMemberSet((IModelCacheHelper)ModelCacheContext.getOrCreate((Long)modelId), (Long)busmodelId, (Long)0L, memberMapList, (Map)dimViewMap, (int[])new int[]{DecomposeStatus.WAIT.getValue(), DecomposeStatus.START.getValue()}, (Boolean)true, (Long)0L);
        if (!adjustMemberSet.isEmpty()) {
            HashSet periodNumberSet = new HashSet(16);
            for (Map adjustMemberMap : adjustMemberSet) {
                periodNumberSet.add(adjustMemberMap.get(SysDimensionEnum.BudgetPeriod.getNumber()));
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u6240\u9009\u4e1a\u52a1\u6a21\u578b\uff1a%1\u3001\u7248\u672c\uff1a%2\u3001\u671f\u95f4\uff1a%3\u6709\u5ba1\u6279\u8c03\u6574\u8bb0\u5f55\u672a\u5206\u89e3\u4e0b\u8fbe\uff0c\u4e0d\u5141\u8bb8\u6570\u636e\u4e0a\u4f20\u64cd\u4f5c\u3002", (String)"EbDataTransMissionPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{busmodelName, version, org.apache.commons.lang3.StringUtils.join((Object[])periodNumberSet.toArray(), (char)'\uff0c')}));
        }
    }

    private boolean isLock() {
        return (Boolean)this.getModel().getValue("islock");
    }

    private void executeProcess() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_copyprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u4e0a\u4f20\u4e2d", (String)"EbDataTransMissionPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        DynamicObject uploadscheme = (DynamicObject)this.getModel().getValue("uploadscheme", 0);
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"EbDataTransMissionPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("msg", (Object)sb.toString());
        showParameter.setCustomParam("id", (Object)uploadscheme.getString("id"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "close_page");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setShowTitle(Boolean.TRUE.booleanValue());
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"eb_copyprogress");
        formConfig.getPlugins().clear();
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.dataUpload.TransExecuteProgessPlugin");
        this.getView().showForm(showParameter);
    }
}

