/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataUpload;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.olapdao.BgmdOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DataUploadServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.dataUpload.dto.ModelDataUploadRequest;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.QueryRequest;
import org.apache.commons.collections4.MapUtils;

public class EbDataUploadRecordPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String CTRL_KEY_PROGRESSBAR = "progressbar";
    public static final String CACHEKEY_PROGRESS = "progress";
    public static final String CACHEKEY_STARTPROPGRESS = "startprogress";
    public static final String CACHEKEY_MSG = "msg";
    private static final Log log = LogFactory.getLog(EbDataUploadRecordPlugin.class);
    private BusinessModelServiceHelper instance = BusinessModelServiceHelper.getInstance();
    private DataUploadServiceHelper dataupinstance = DataUploadServiceHelper.getInstance();
    public static final String MODELDATAUPLOADTASKACTION = "modeldatauploadtaskaction";

    public void initialize() {
        super.initialize();
        TextEdit f7text = (TextEdit)this.getControl("orgtext");
        f7text.addClickListener((ClickListener)this);
        TextEdit f7text2 = (TextEdit)this.getControl("periodtext");
        f7text2.addClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid lillList = (EntryGrid)this.getControl("entryentity");
        lillList.addClickListener((ClickListener)this);
        ProgressBar progressBar = (ProgressBar)this.getControl(CTRL_KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        this.getPageCache().put("model", modelId.toString());
        this.getModel().setValue("model", (Object)modelId);
        HashMap scheMap = new HashMap(16);
        String schemes = (String)this.getView().getFormShowParameter().getCustomParam("uploadschemes");
        List schemeList = (List)SerializationUtils.deSerializeFromBase64((String)schemes);
        if (schemeList != null && schemeList.size() > 0) {
            for (int i = 0; i < schemeList.size(); ++i) {
                scheMap.put(((DynamicObject)schemeList.get(i)).getString("id"), schemeList.get(i));
                if (i == 0) {
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", 0);
                    entryRowEntity.set("number", (Object)((DynamicObject)schemeList.get(0)).getString("number"));
                    entryRowEntity.set("schemeid", (Object)((DynamicObject)schemeList.get(0)).getString("id"));
                    entryRowEntity.set("name", (Object)((DynamicObject)schemeList.get(0)).getString("name"));
                    entryRowEntity.set("srcbusmodel", (Object)((DynamicObject)((DynamicObject)schemeList.get(0)).get("srcbusinessmodel")).getString("name"));
                    entryRowEntity.set("trgbusmodel", (Object)((DynamicObject)((DynamicObject)schemeList.get(0)).get("trgbusinessmodel")).getString("name"));
                    this.handleEntityAndPeriod((DynamicObject)schemeList.get(0), entryRowEntity);
                    continue;
                }
                int newEntryRow = this.getModel().createNewEntryRow("entryentity");
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", newEntryRow);
                entryRowEntity.set("number", (Object)((DynamicObject)schemeList.get(newEntryRow)).getString("number"));
                entryRowEntity.set("schemeid", (Object)((DynamicObject)schemeList.get(newEntryRow)).getString("id"));
                entryRowEntity.set("name", (Object)((DynamicObject)schemeList.get(newEntryRow)).getString("name"));
                entryRowEntity.set("srcbusmodel", (Object)((DynamicObject)((DynamicObject)schemeList.get(newEntryRow)).get("srcbusinessmodel")).getString("name"));
                entryRowEntity.set("trgbusmodel", (Object)((DynamicObject)((DynamicObject)schemeList.get(newEntryRow)).get("trgbusinessmodel")).getString("name"));
                this.handleEntityAndPeriod((DynamicObject)schemeList.get(newEntryRow), entryRowEntity);
            }
            this.getPageCache().put("scheMapCache", SerializationUtils.serializeToBase64(scheMap));
        } else {
            this.getModel().deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
        }
    }

    private void handleEntityAndPeriod(DynamicObject scheme, DynamicObject entryRowEntity) {
        boolean taskstatus = scheme.getBoolean("taskstatus");
        if (taskstatus) {
            String periodJson;
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            String orgJson = scheme.getString("org");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orgJson)) {
                List orgList = (List)SerializationUtils.fromJsonString((String)orgJson, List.class);
                List names = orgList.stream().map(x -> {
                    long viewId = 0L;
                    try {
                        viewId = Long.parseLong(org.apache.commons.lang3.StringUtils.substringAfterLast((String)x, (String)","));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(viewId), x.split(",")[1]);
                    if (member != null) {
                        return member.getName();
                    }
                    return "";
                }).filter(x -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)x)).collect(Collectors.toList());
                entryRowEntity.set("orgtext", (Object)StringUtils.join(names, (char)','));
                entryRowEntity.set("org", (Object)orgJson);
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(periodJson = scheme.getString("period")))) {
                List periodList = (List)SerializationUtils.fromJsonString((String)periodJson, List.class);
                List names = periodList.stream().map(x -> {
                    Member member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, x.split(",")[1]);
                    if (member != null) {
                        return member.getName();
                    }
                    return "";
                }).filter(x -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)x)).collect(Collectors.toList());
                entryRowEntity.set("periodtext", (Object)StringUtils.join(names, (char)','));
                entryRowEntity.set("period", (Object)periodJson);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        String orgDimNumber = "Entity";
        String budperDimNumber = "BudgetPeriod";
        Long busModelId = null;
        String scheMapCache = this.getPageCache().get("scheMapCache");
        Map scheMap = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)scheMapCache)) {
            scheMap = (Map)SerializationUtils.deSerializeFromBase64((String)scheMapCache);
            String schemeId = (String)this.getModel().getValue("schemeId");
            busModelId = ((DynamicObject)((DynamicObject)scheMap.get(schemeId)).get("trgbusinessmodel")).getLong("id");
        }
        switch (fieldKey) {
            case "orgtext": {
                this.openF7("orgtext", orgDimNumber, busModelId);
                break;
            }
            case "periodtext": {
                this.openF7("periodtext", budperDimNumber, busModelId);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_ok": {
                this.getPageCache().remove("executeFlag");
                this.handelUpload("btn_ok");
                this.writeLog("upload", new MultiLangEnumBridge("\u4f53\u7cfb\u5185\u6570\u636e\u4e0a\u4f20", "EbDataUploadRecordPlugin_23", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6267\u884c\u5b8c\u6210", "EbDataUploadRecordPlugin_3", "epm-eb-formplugin"));
                break;
            }
            case "backgroundexecu": {
                String executeFlag = this.getPageCache().get("executeFlag");
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)executeFlag)) {
                    this.handelUpload("backgroundexecu");
                    break;
                }
                this.getView().close();
                break;
            }
        }
    }

    private void openF7(String actionId, String dimnumber, Long busModelId) {
        int rowIndex;
        Long modelId = this.getModelId();
        DynamicObject dimension = null;
        Set selectIds = null;
        long viewId = 0L;
        if ("orgtext".equals(actionId)) {
            dimension = NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Entity.getNumber());
            rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String org = (String)this.getModel().getValue("org", rowIndex);
            if (StringUtils.isNotEmpty((String)org)) {
                List orgList = (List)SerializationUtils.fromJsonString((String)org, List.class);
                String firstLine = (String)orgList.get(0);
                try {
                    viewId = Long.parseLong(org.apache.commons.lang3.StringUtils.substringAfterLast((String)firstLine, (String)","));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                List orgNumberList = orgList.stream().map(e -> e.split(",")[1]).collect(Collectors.toList());
                selectIds = this.getIModelCacheHelper().getMembers(SysDimensionEnum.Entity.getNumber(), Long.valueOf(viewId), orgNumberList).stream().map(x -> x.getId()).collect(Collectors.toSet());
            }
        } else if ("periodtext".equals(actionId)) {
            dimension = NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.BudgetPeriod.getNumber());
            rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String period = (String)this.getModel().getValue("period", rowIndex);
            if (StringUtils.isNotEmpty((String)period)) {
                List periodList = (List)SerializationUtils.fromJsonString((String)period, List.class);
                List periodNumberList = periodList.stream().map(e -> e.split(",")[1]).collect(Collectors.toList());
                selectIds = this.getIModelCacheHelper().getMembers(SysDimensionEnum.BudgetPeriod.getNumber(), null, periodNumberList).stream().map(x -> x.getId()).collect(Collectors.toSet());
            }
        }
        if (dimension != null) {
            MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)dimension, (String)ListSelectedRow.class.getName());
            if (selectIds != null) {
                f7Param.setSelectIds(selectIds);
            }
            f7Param.setOnlySelLeaf(true);
            f7Param.setBusModelId(busModelId);
            f7Param.setEnableView(true);
            f7Param.setViewId(Long.valueOf(viewId));
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        Object backData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (actionId.contains("orgtext") || actionId.contains("budgetperiod") || actionId.contains("periodtext")) {
            this.F7closedCallBack(e, actionId);
        } else if (MODELDATAUPLOADTASKACTION.equals(actionId) && (backData = e.getReturnData()) != null) {
            Map backDataMap = (Map)backData;
            Map taskInfo = (Map)SerializationUtils.fromJsonString((String)((String)backDataMap.get("taskinfo")), HashMap.class);
            Map data = (Map)SerializationUtils.fromJsonString((String)((String)taskInfo.get("data")), HashMap.class);
            Object status = data.get("status");
            if (status == null) {
                return;
            }
            if ("success".equals(status)) {
                String msg = ResManager.loadKDString((String)"\u4f53\u7cfb\u5185\u6570\u636e\u4e0a\u4f20\u5b8c\u6210", (String)"EbDataUploadRecordPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(msg);
                this.getView().close();
            } else {
                this.getView().showTipNotification(data.get("exportResult").toString());
            }
        }
    }

    private void F7closedCallBack(ClosedCallBackEvent e, String actionId) {
        super.closedCallBack(e);
        if (Objects.nonNull(e.getReturnData())) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
            if (returnData == null || returnData.size() <= 0) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            String numberSb = "";
            ArrayList<String> orgList = new ArrayList<String>(returnData.size());
            ArrayList<String> periodList = new ArrayList<String>(returnData.size());
            for (int i = 0; i < returnData.size(); ++i) {
                String id;
                String name = returnData.get(i).getName();
                String numbder = returnData.get(i).getNumber();
                if ("orgtext".equals(actionId)) {
                    StringBuilder orgsb = new StringBuilder();
                    id = returnData.get(i).getPrimaryKeyValue().toString();
                    orgsb.append(id).append(",");
                    orgsb.append(numbder).append(",");
                    orgsb.append(MapUtils.getString((Map)returnData.get(i).getDataMap(), (Object)"viewid", (String)"0"));
                    orgList.add(orgsb.toString());
                } else if ("periodtext".equals(actionId)) {
                    StringBuilder periodsb = new StringBuilder();
                    id = returnData.get(i).getPrimaryKeyValue().toString();
                    String idStr = id + ",";
                    periodsb.append(idStr);
                    periodsb.append(numbder);
                    periodList.add(periodsb.toString());
                }
                if (i == returnData.size() - 1) {
                    sb.append(name);
                    numberSb = numbder;
                    continue;
                }
                String nameNew = name + ",";
                sb.append(nameNew);
            }
            this.getModel().setValue(actionId, (Object)sb);
            if ("orgtext".equals(actionId)) {
                this.getModel().setValue("org", (Object)SerializationUtils.toJsonString(orgList));
            }
            if ("periodtext".equals(actionId)) {
                this.getModel().setValue("period", (Object)SerializationUtils.toJsonString(periodList));
            }
        }
    }

    private void handelUpload(String clickFlag) {
        this.getPageCache().put("clickFlag", clickFlag);
        DynamicObjectCollection sckemeObjects = this.getModel().getEntryEntity("entryentity");
        if (sckemeObjects == null || sckemeObjects.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4e0a\u4f20\u7684\u65b9\u6848\u3002", (String)"EbDataUploadRecordPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.checkIsSeleEntity(sckemeObjects)) {
            return;
        }
        if (this.chechDimIsAddOrDelete().booleanValue()) {
            return;
        }
        boolean containFlag = this.checkReportDataOfTrgDim(sckemeObjects);
        if (containFlag) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5df2\u5b58\u5728\u6570\u636e\uff0c\u7ee7\u7eed\u6267\u884c\u5c06\u8986\u76d6\u5df2\u6709\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"EbDataUploadRecordPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmUpLoad"));
            return;
        }
        this.getPageCache().put("executeFlag", "1");
        this.startDataUpLoad();
    }

    private void startDataUpLoad() {
        ModelDataUploadRequest modelDataUploadRequest = new ModelDataUploadRequest();
        modelDataUploadRequest.setModelId(this.getModelId());
        modelDataUploadRequest.setLock((Boolean)this.getModel().getValue("islock"));
        DynamicObjectCollection sckemeObjects = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)sckemeObjects)) {
            return;
        }
        List<String> numbers = sckemeObjects.stream().map(x -> x.getString("number")).collect(Collectors.toList());
        modelDataUploadRequest.setSchemeNumbers(numbers);
        Map<String, String> periodMap = sckemeObjects.stream().collect(Collectors.toMap(x -> x.getString("number"), x -> x.getString("period")));
        modelDataUploadRequest.setPeriodMap(periodMap);
        Map<String, String> orgMap = sckemeObjects.stream().collect(Collectors.toMap(x -> x.getString("number"), x -> x.getString("org")));
        modelDataUploadRequest.setOrgMap(orgMap);
        JobInfo jobInfo = this.createJobInfo(modelDataUploadRequest, this.getView());
        JobFormInfo jobFormInfo = this.createJobFormInfo(jobInfo, this.getView(), this);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private JobFormInfo createJobFormInfo(JobInfo jobInfo, IFormView formView, AbstractFormPlugin abstractFormPlugin) {
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setJobInfo(jobInfo);
        String caption = ResManager.loadKDString((String)"\u4f53\u7cfb\u5185\u6570\u636e\u4e0a\u4f20", (String)"EbDataUploadRecordPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        jobFormInfo.setCaption(caption);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setTimeout(3600);
        jobFormInfo.setClickClassName("kd.epm.eb.formplugin.dataUpload.job.ModelDataUploadTaskClick");
        jobFormInfo.setCloseCallBack(new CloseCallBack((IFormPlugin)abstractFormPlugin, MODELDATAUPLOADTASKACTION));
        jobFormInfo.setParentPageId(formView.getFormShowParameter().getPageId());
        jobFormInfo.setRootPageId(formView.getFormShowParameter().getRootPageId());
        return jobFormInfo;
    }

    private JobInfo createJobInfo(ModelDataUploadRequest modelDataUploadRequest, IFormView formView) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setTaskClassname("kd.epm.eb.formplugin.dataUpload.job.ModelDataUploadTask");
        String jobName = ResManager.loadKDString((String)"\u4f53\u7cfb\u5185\u6570\u636e\u4f20\u8f93", (String)"EbDataUploadRecordPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        jobInfo.setName(jobName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setCanStop(Boolean.valueOf(true));
        jobInfo.setFailNotify(true);
        jobInfo.setTimeout(3600);
        jobInfo.setOverTime(true);
        jobInfo.setExecuteTime(3600);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(UserUtils.getUserId().longValue());
        jobInfo.setAppId(formView.getFormShowParameter().getServiceAppId());
        jobInfo.setFailNotify(true);
        jobInfo.setSuccessNotify(true);
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("pageId", formView.getPageId());
        customParams.put("appId", formView.getFormShowParameter().getServiceAppId());
        FormConfig formConfig = formView.getFormShowParameter().getFormConfig();
        customParams.put("formConfig", formConfig.getEntityTypeId());
        customParams.put("parentPageId", formView.getFormShowParameter().getPageId());
        customParams.put("rootPageId", formView.getFormShowParameter().getRootPageId());
        customParams.put("modelId", modelDataUploadRequest.getModelId());
        customParams.put("lock", modelDataUploadRequest.getLock());
        customParams.put("schemeNumbers", SerializationUtils.toJsonString(modelDataUploadRequest.getSchemeNumbers()));
        customParams.put("transportLogId", modelDataUploadRequest.getTransportLogId());
        customParams.put("orgMap", SerializationUtils.toJsonString(modelDataUploadRequest.getOrgMap()));
        customParams.put("periodMap", SerializationUtils.toJsonString(modelDataUploadRequest.getPeriodMap()));
        customParams.put("loginIp", RequestContext.get().getLoginIP());
        jobInfo.setParams(customParams);
        return jobInfo;
    }

    private boolean checkReportDataOfTrgDim(DynamicObjectCollection sckemeObjects) {
        if (sckemeObjects.size() < 1) {
            return Boolean.FALSE;
        }
        boolean containFlag = Boolean.FALSE;
        for (DynamicObject schemeDoc : sckemeObjects) {
            if (containFlag) break;
            long id = schemeDoc.getLong("schemeid");
            String org = schemeDoc.getString("org");
            List orgList = (List)SerializationUtils.fromJsonString((String)org, List.class);
            List<String> orgNumberList = orgList.stream().map(e -> e.split(",")[1]).collect(Collectors.toList());
            String period = schemeDoc.getString("period");
            List periodList = (List)SerializationUtils.fromJsonString((String)period, List.class);
            List<String> periodNumberList = periodList.stream().map(e -> e.split(",")[1]).collect(Collectors.toList());
            containFlag = this.queryDataByTrgDimMem(id, orgNumberList, periodNumberList);
        }
        return containFlag;
    }

    private boolean queryDataByTrgDimMem(long schemeId, List<String> orgList, List<String> periodNumberList) {
        DynamicObject dym = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"eb_datauploadscheme");
        DynamicObjectCollection dimCol = dym.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection accountCol = dym.getDynamicObjectCollection("accountentryentity");
        Set accountSet = accountCol.stream().filter(e -> "0".equals(e.getString("entrystatus"))).collect(Collectors.toSet());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)Long.parseLong(this.getPageCache().get("model")));
        HashMap<Long, Set> map = new HashMap<Long, Set>(16);
        for (DynamicObject dymAccount : accountSet) {
            Member member = modelCache.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), Long.valueOf(dymAccount.getLong("trgaccount.id")));
            Set numberSet = map.computeIfAbsent(member.getDatasetId(), f -> new HashSet(16));
            numberSet.add(dymAccount.getString("trgaccount.number"));
        }
        Map<String, DynamicObject> trgDimNumberMap = dimCol.stream().collect(Collectors.toMap(e -> e.getString("trgdimnumber"), e -> e, (v1, v2) -> v1));
        HashMap<String, Set<Object>> trgDimAndMemMap = new HashMap<String, Set<Object>>(16);
        for (Map.Entry entry : map.entrySet()) {
            List trgDimensionList = modelCache.getDimensionList((Long)entry.getKey());
            for (Dimension dim : trgDimensionList) {
                DynamicObject dymDimMap;
                if (SysDimensionEnum.Entity.getNumber().equals(dim.getNumber()) || SysDimensionEnum.Account.getNumber().equals(dim.getNumber()) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dim.getNumber()) || SysDimensionEnum.Metric.getNumber().equals(dim.getNumber()) || (dymDimMap = trgDimNumberMap.get(dim.getNumber())) == null) continue;
                String trgdimnumber = dymDimMap.getString("trgdimnumber");
                String trgdimmemnumber = dymDimMap.getString("trgdimmemnumber");
                HashSet<String> memList = new HashSet<String>(1);
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)trgdimmemnumber)) {
                    Map groupViewMap = modelCache.getViewGroupViewsByBusModel(Long.valueOf(dym.getLong("trgbusinessmodel.id")));
                    List viewList = (List)groupViewMap.get(dim.getNumber());
                    List members = Lists.newArrayListWithCapacity((int)10);
                    if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)viewList)) {
                        members = modelCache.getMembers(null, dim.getNumber());
                    } else {
                        for (Long vid : viewList) {
                            List vMembers = modelCache.getMembers(vid, dim.getNumber());
                            List rawMembers = vMembers.stream().filter(e -> !ViewMemberSourceEnum.INNER_REF.getIndex().equals(e.getSource())).collect(Collectors.toList());
                            if (rawMembers.isEmpty()) continue;
                            members.addAll(rawMembers);
                        }
                    }
                    Set memberNumbers = members.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    Dataset dataset = Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)((Long)entry.getKey())));
                    memberNumbers = ShrekOlapServiceHelper.getExistDataMember((Model)modelCache.getModelobj(), Collections.singletonList(dataset), (String)dim.getNumber(), memberNumbers);
                    if (memberNumbers == null || memberNumbers.size() < 1) {
                        return Boolean.FALSE;
                    }
                    trgDimAndMemMap.put(trgdimnumber, memberNumbers);
                    continue;
                }
                memList.add(trgdimmemnumber);
                trgDimAndMemMap.put(trgdimnumber, memList);
            }
            trgDimAndMemMap.put(SysDimensionEnum.Entity.getNumber(), new HashSet<String>(orgList));
            trgDimAndMemMap.put(SysDimensionEnum.Account.getNumber(), (Set<Object>)entry.getValue());
            trgDimAndMemMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), new HashSet<String>(periodNumberList));
            HashSet c = new HashSet(1);
            List<Member> members = modelCache.getMembers(null, SysDimensionEnum.Metric.getNumber()).stream().filter(e -> e.getChildren().size() == 0).collect(Collectors.toList());
            members.forEach(e -> c.add(e.getNumber()));
            trgDimAndMemMap.put(SysDimensionEnum.Metric.getNumber(), c);
            BgmdOlapReader reader = OlapManager.getInstance().queryReader(new QueryRequest(this.getModelId(), (Long)entry.getKey(), trgDimAndMemMap));
            Throwable throwable = null;
            try {
                if (!reader.hasNext()) continue;
                boolean bl = Boolean.TRUE;
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        return Boolean.FALSE;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        switch (propName) {
            case "budgetperiod": {
                if (!StringUtils.isEmpty((String)newValue.toString())) break;
                this.getPageCache().remove("budgetperiod");
                break;
            }
            case "orgtext": {
                if (!StringUtils.isEmpty((String)newValue.toString())) break;
                this.getModel().setValue("org", (Object)"", rowIndex);
                break;
            }
            case "periodtext": {
                if (!StringUtils.isEmpty((String)newValue.toString())) break;
                this.getModel().setValue("period", (Object)"", rowIndex);
                break;
            }
        }
    }

    private boolean checkIsSeleEntity(DynamicObjectCollection entryList) {
        boolean sele = true;
        for (DynamicObject dynamicObject : entryList) {
            String budgetperiod = dynamicObject.getString("periodtext");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)budgetperiod)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u671f\u95f4\u3002", (String)"EbDataUploadRecordPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                sele = false;
                break;
            }
            String orgtext = dynamicObject.getString("orgtext");
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)orgtext)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7", (String)"EbDataUploadRecordPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            sele = false;
            break;
        }
        return sele;
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if ("confirmUpLoad".equals(callBackId) && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            this.startDataUpLoad();
        }
    }

    public void onProgress(ProgressEvent e) {
        String startProgress = this.getPageCache().get(CACHEKEY_STARTPROPGRESS);
        if (StringUtils.isEmpty((String)startProgress)) {
            return;
        }
        int progress = 1;
        String cacheProgress = this.getPageCache().get(CACHEKEY_PROGRESS);
        String text = ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"EbDataUploadRecordPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((String)cacheProgress)) {
            progress = Integer.parseInt(cacheProgress);
        }
        ProgressBar progressBar = (ProgressBar)this.getControl(CTRL_KEY_PROGRESSBAR);
        e.setProgress(progress);
        if (progress >= 100) {
            text = ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"EbDataUploadRecordPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if (this.getPageCache().get(CACHEKEY_MSG) != null) {
                this.getView().showTipNotification(this.getPageCache().get(CACHEKEY_MSG));
            }
            progressBar.stop();
            e.setText(text);
            progressBar.stop();
            this.getPageCache().put(CACHEKEY_STARTPROPGRESS, "false");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"EbDataUploadRecordPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Boolean chechDimIsAddOrDelete() {
        DynamicObjectCollection sckemeObjects = this.getModel().getEntryEntity("entryentity");
        List<Long> schemeIds = sckemeObjects.stream().map(e -> e.getLong("schemeid")).collect(Collectors.toList());
        DynamicObject[] schemeArry = (DynamicObject[])BusinessDataServiceHelper.load((Object[])schemeIds.toArray(new Long[schemeIds.size()]), (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"eb_datauploadscheme").getDataEntityType());
        Map<Long, DynamicObject> schemeMap = Stream.of(schemeArry).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        Boolean isDimChange = Boolean.FALSE;
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)Long.parseLong(this.getPageCache().get("model")));
        for (Long schemeid : schemeIds) {
            DynamicObject schemeDoc = schemeMap.get(schemeid);
            Long srcBusinessModelId = schemeDoc.getLong("srcbusinessmodel.id");
            List srcDataSets = this.instance.queryDataSetIds(srcBusinessModelId);
            Set srcDims = this.instance.queryDimId(srcDataSets);
            Long trgBusinessModelId = schemeDoc.getLong("trgbusinessmodel.id");
            List trgDataSets = this.instance.queryDataSetIds(trgBusinessModelId);
            Set trgDims = this.instance.queryDimId(trgDataSets);
            DynamicObjectCollection dimsMapping = schemeDoc.getDynamicObjectCollection("entryentity");
            for (DynamicObject b : dimsMapping) {
                String srcDimNumber = b.getString("srcdimnumber");
                String trgDimNumber = b.getString("trgdimnumber");
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)srcDimNumber) && !srcDims.contains(modelCache.getDimension(srcDimNumber).getId())) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u65b9\u6848\u7f16\u7801\u4e3a%1\u7684\u6e90\u7ef4\u5ea6\u5df2\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u65b9\u6848\u3002", (String)"EbDataUploadRecordPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeDoc.getString("number")}));
                    isDimChange = Boolean.TRUE;
                    break;
                }
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)trgDimNumber) || trgDims.contains(modelCache.getDimension(trgDimNumber).getId())) continue;
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u65b9\u6848\u7f16\u7801\u4e3a%1\u7684\u76ee\u6807\u7ef4\u5ea6\u5df2\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u65b9\u6848\u3002", (String)"EbDataUploadRecordPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeDoc.getString("number")}));
                isDimChange = Boolean.TRUE;
                break;
            }
            if (!isDimChange.equals(Boolean.FALSE)) continue;
            List srcdimnumber = dimsMapping.stream().filter(e -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)e.getString("srcdimnumber"))).collect(Collectors.toList());
            if (srcDims.size() - 3 > srcdimnumber.size()) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u65b9\u6848\u7f16\u7801\u4e3a%1\u7684\u6e90\u7ef4\u5ea6\u5df2\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u65b9\u6848\u3002", (String)"EbDataUploadRecordPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeDoc.getString("number")}));
                isDimChange = Boolean.TRUE;
                break;
            }
            List trgdimnumber = dimsMapping.stream().filter(e -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)e.getString("trgdimnumber"))).collect(Collectors.toList());
            if (trgDims.size() - 3 <= trgdimnumber.size()) continue;
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u65b9\u6848\u7f16\u7801\u4e3a%1\u7684\u76ee\u6807\u7ef4\u5ea6\u5df2\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u65b9\u6848\u3002", (String)"EbDataUploadRecordPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeDoc.getString("number")}));
            isDimChange = Boolean.TRUE;
            break;
        }
        return isDimChange;
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        return model.getLong("id");
    }
}

