/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataUpload;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.model.utils.ModelUtil;

public class EbDataUploadSchemeCMPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final String SRC_MODEL = "srcmodel";
    private static final String TAR_MODEL = "tarmodel";
    private static final String SRC_BIZ = "srcbiz";
    private static final String TAR_BIZ = "tarbiz";
    private static final String DIM_MAPENTRY = "dimmapentity";
    private static final List<String> commonDimNums = Arrays.asList("Entity", "Account", "Metric", "DataType", "ChangeType", "AuditTrail", "Currency");

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{"srcdim", "tardim", "membermap", "srcmember", "tarmember", SRC_MODEL, TAR_MODEL, SRC_BIZ, TAR_BIZ});
        this.addClickListeners(new String[]{"srcmembername", "tarmembername"});
    }

    public void afterCreateNewData(EventObject e) {
        List modelFilter = ModelUtil.getModelFilter((IFormView)this.getView());
        BasedataEdit control = (BasedataEdit)this.getControl(SRC_MODEL);
        control.setQFilters(new ArrayList(modelFilter));
        control = (BasedataEdit)this.getControl(TAR_MODEL);
        control.setQFilters(modelFilter);
        Object paramModel = this.getView().getFormShowParameter().getCustomParam(SRC_MODEL);
        if (paramModel != null) {
            this.getModel().setValue(SRC_MODEL, (Object)paramModel.toString());
            this.getView().setEnable(Boolean.FALSE, new String[]{SRC_MODEL});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"number", "name"});
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    public void afterLoadData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{SRC_MODEL, SRC_BIZ, TAR_MODEL, TAR_BIZ});
        this.setPresetDimNotEnable(this.getView());
        this.lockForm();
        this.loadDimCacheWhenEdit();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        switch (key) {
            case "srcmodel": 
            case "tarmodel": {
                this.getModel().setValue(key.substring(0, 3) + "biz", null);
                break;
            }
            case "srcbiz": 
            case "tarbiz": {
                String prefix = key.substring(0, 3);
                this.clearEntryData(prefix);
                this.loadDimensionMapping(prefix);
                break;
            }
            case "srcdim": 
            case "tardim": {
                this.setIcEntityType(e, key.substring(0, 3));
                break;
            }
            case "istransfermember": {
                this.changeMutexValue(rowIndex, newValue, "maponly");
                break;
            }
            case "maponly": {
                this.changeMutexValue(rowIndex, newValue, "istransfermember");
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        if ("srcdim".equals(key) || "tardim".equals(key)) {
            String cache = this.getPageCache().get(key.substring(0, 3) + "DefineDimsCache");
            if (cache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5bf9\u5e94\u7684\u4f53\u7cfb\u548c\u4e1a\u52a1\u6a21\u578b\u3002", (String)"EbDataUploadSchemeCMPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)cache);
            map.values().removeAll(this.getExistDimIds(key));
            qFilters.add(new QFilter("id", "in", (Object)map.values().toArray()));
        } else if ("membermap".equals(key)) {
            qFilters.addAll(this.setDimMapingQfilter());
        } else if ("srcmember".equals(key) || "tarmember".equals(key)) {
            this.openMember(evt, key.substring(0, 3));
        } else if (SRC_MODEL.equals(key) || TAR_MODEL.equals(key)) {
            String otherModelKey = key.startsWith("src") ? TAR_MODEL : SRC_MODEL;
            Object model = this.getModel().getValue(otherModelKey);
            if (model != null) {
                qFilters.add(new QFilter("id", "!=", ((DynamicObject)model).get("id")));
            }
        } else if (SRC_BIZ.equals(key) || TAR_BIZ.equals(key)) {
            String modelKey = key.startsWith("src") ? SRC_MODEL : TAR_MODEL;
            Object model = this.getModel().getValue(modelKey);
            if (model == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5bf9\u5e94\u7684\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeCMPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("model", "=", ((DynamicObject)model).get("id")));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        DynamicObject srcModel = (DynamicObject)this.getModel().getValue(SRC_MODEL);
        DynamicObject tarModel = (DynamicObject)this.getModel().getValue(TAR_MODEL);
        if (srcModel != null && AdminModelUtil.checkAdminModeNeedResult(srcModel.getLong("id"), this.getView())) {
            args.setCancel(true);
            return;
        }
        if (tarModel != null && AdminModelUtil.checkAdminModeNeedResult(tarModel.getLong("id"), this.getView())) {
            args.setCancel(true);
            return;
        }
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey)) {
            boolean validator = this.saveValidator();
            args.setCancel(validator);
            if (!validator) {
                this.setOtherProperties();
            }
        } else if ("deleteentry".equals(operateKey)) {
            EntryGrid control = (EntryGrid)this.getControl(DIM_MAPENTRY);
            int focusRow = control.getEntryState().getFocusRow();
            Object srcBiz = this.getModel().getValue(SRC_BIZ);
            Object tarBiz = this.getModel().getValue(TAR_BIZ);
            if (focusRow < commonDimNums.size() && (srcBiz != null || tarBiz != null)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6210\u5458\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"EbDataUploadSchemeCMPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean isSuccess;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && (isSuccess = args.getOperationResult().getValidateResult().isSuccess())) {
            IFormView formView = this.getView();
            this.setPresetDimNotEnable(formView);
            this.getView().updateView(DIM_MAPENTRY);
            this.getView().setEnable(Boolean.FALSE, new String[]{SRC_MODEL, SRC_BIZ, TAR_MODEL, TAR_BIZ});
            this.getView().setVisible(Boolean.TRUE, new String[]{"number", "name"});
            this.lockForm();
            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
            this.getView().setStatus(OperationStatus.EDIT);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (actionId.startsWith("srcmembername") || actionId.startsWith("tarmembername")) {
            String row = actionId.substring("srcmembername".length());
            if (!this.isInteger(row)) {
                return;
            }
            Object returnData = evt.getReturnData();
            if (returnData == null || ((ListSelectedRowCollection)returnData).size() == 0) {
                return;
            }
            ListSelectedRow list = ((ListSelectedRowCollection)returnData).get(0);
            String sign = actionId.substring(0, 3);
            int i = Integer.parseInt(row);
            this.getModel().setValue(sign + "membername", (Object)list.getName(), i);
            this.getModel().setValue(sign + "membernumber", (Object)list.getNumber(), i);
            this.getView().updateView(sign + "membername", i);
        }
    }

    private void loadDimensionMapping(String sign) {
        if (!"src".equals(sign) && !"tar".equals(sign)) {
            return;
        }
        IDataModel dataModel = this.getModel();
        Object value = dataModel.getValue(sign + "model");
        Object value1 = dataModel.getValue(sign + "biz");
        if (value == null || value1 == null) {
            this.getPageCache().put(sign + "CommonDimsCache", null);
            this.getPageCache().put(sign + "DefineDimsCache", null);
            return;
        }
        long modelId = ((DynamicObject)value).getLong("id");
        long busModelId = ((DynamicObject)value1).getLong("id");
        Map<String, Long> allDims = this.queryAllDims(modelId, busModelId, sign);
        String currentDimKey = sign + "dim";
        String currentDimType = sign + "membertype";
        String other = "src".equals(sign) ? "tar" : "src";
        String otherDimKey = other + "dim";
        int rowCount = dataModel.getEntryRowCount(DIM_MAPENTRY);
        dataModel.beginInit();
        if (rowCount == 0) {
            if (!allDims.isEmpty()) {
                dataModel.batchCreateNewEntryRow(DIM_MAPENTRY, allDims.size());
            }
            for (Map.Entry<String, Long> entry : allDims.entrySet()) {
                dataModel.setValue(currentDimKey, (Object)entry.getValue(), rowCount);
                this.setIcEntityTypeWhenLoad(dataModel, currentDimType, entry.getKey(), rowCount);
                ++rowCount;
            }
        } else {
            int i;
            for (i = 0; i < rowCount; ++i) {
                String otherDimNum;
                Long dimId;
                Object otherDim = dataModel.getValue(otherDimKey, i);
                if (otherDim == null || (dimId = allDims.remove(otherDimNum = ((DynamicObject)otherDim).getString("number"))) == null) continue;
                dataModel.setValue(currentDimKey, (Object)dimId, i);
                this.setIcEntityTypeWhenLoad(dataModel, currentDimType, otherDimNum, i);
            }
            if (allDims.size() > 0) {
                dataModel.batchCreateNewEntryRow(DIM_MAPENTRY, allDims.size());
                i = rowCount;
                for (Map.Entry<String, Long> entry : allDims.entrySet()) {
                    dataModel.setValue(currentDimKey, (Object)entry.getValue(), i);
                    this.setIcEntityTypeWhenLoad(dataModel, currentDimType, entry.getKey(), i);
                    ++i;
                }
            }
        }
        dataModel.endInit();
        dataModel.updateCache();
        IFormView formView = this.getView();
        this.setPresetDimNotEnable(formView);
        formView.updateView(DIM_MAPENTRY);
    }

    private void clearEntryData(String sign) {
        String other = "src".equals(sign) ? "tar" : "src";
        IDataModel dataModel = this.getModel();
        Object otherValue = dataModel.getValue(other + "biz");
        if (otherValue == null) {
            dataModel.deleteEntryData(DIM_MAPENTRY);
        } else {
            String currentDimKey = sign + "dim";
            String memberKey = sign + "member";
            int rowCount = dataModel.getEntryRowCount(DIM_MAPENTRY);
            dataModel.beginInit();
            for (int i = 0; i < rowCount; ++i) {
                dataModel.setValue(currentDimKey, null, i);
                dataModel.setValue(memberKey, null, i);
                dataModel.setValue("maponly", (Object)"0", i);
                dataModel.setValue("membermap", null, i);
                dataModel.setValue("istransfermember", (Object)"0", i);
            }
            dataModel.endInit();
        }
        dataModel.updateCache();
        this.getView().updateView(DIM_MAPENTRY);
    }

    private Map<String, Long> queryAllDims(long modelId, long busModelId, String sign) {
        Map<String, Long> commonDims = this.queryCommonDims(modelId, busModelId);
        Map<String, Long> defineDims = this.queryDataSetDims(modelId, busModelId);
        this.getPageCache().put(sign + "CommonDimsCache", SerializationUtils.serializeToBase64(commonDims));
        this.getPageCache().put(sign + "DefineDimsCache", SerializationUtils.serializeToBase64(defineDims));
        commonDims.putAll(defineDims);
        return commonDims;
    }

    private Map<String, Long> queryCommonDims(long modelId, long busModelId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List busModelDims = modelCache.getDimensionListByBusModel(Long.valueOf(busModelId));
        LinkedHashMap<String, Long> commonDims = new LinkedHashMap<String, Long>(12);
        for (Dimension busModelDim : busModelDims) {
            String dimNumber = busModelDim.getNumber();
            if (commonDimNums.contains(dimNumber)) {
                commonDims.put(dimNumber, busModelDim.getId());
            }
            if (commonDims.size() != commonDimNums.size()) continue;
            break;
        }
        return commonDims;
    }

    private Map<String, Long> queryDataSetDims(long modelId, long busModelId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("businessmodel", "=", (Object)busModelId));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_dataset", (String)"entryentity.datasetdim", (QFilter[])qFilters.toArray(new QFilter[0]));
        LinkedHashMap<String, Long> deefineDims = new LinkedHashMap<String, Long>(16);
        if (load != null && load.length > 0) {
            for (DynamicObject ob : load) {
                List objects = ob.getDynamicObjectCollection("entryentity").stream().filter(o -> !o.getBoolean("datasetdim.issysdimension") || "InternalCompany".equals(o.getString("datasetdim.number"))).collect(Collectors.toList());
                for (DynamicObject object : objects) {
                    String number = object.getString("datasetdim.number");
                    if (deefineDims.containsKey(number)) continue;
                    deefineDims.put(number, object.getLong("datasetdim.id"));
                }
            }
        }
        return deefineDims;
    }

    private void openMember(BeforeF7SelectEvent evt, String sign) {
        DynamicObject dim;
        EntryGrid control = (EntryGrid)this.getControl(DIM_MAPENTRY);
        int focusRow = control.getEntryState().getFocusRow();
        if (focusRow < 0) {
            evt.setCancel(Boolean.TRUE.booleanValue());
        }
        if ((dim = (DynamicObject)this.getModel().getValue(sign + "dim")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6", (String)"EbDataUploadSchemeCMPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        long busModelId = ((DynamicObject)this.getModel().getValue(sign + "biz")).getLong("id");
        DynamicObject model = null;
        model = "tar".equals(sign) ? (DynamicObject)this.getModel().getValue(TAR_MODEL) : (DynamicObject)this.getModel().getValue(SRC_MODEL);
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeCMPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            evt.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)model.getLong("id"), (DynamicObject)NewF7Utils.getDimension((Long)dim.getLong("id")), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(busModelId));
        f7Param.setEnableView(true);
        if ("tar".equals(sign)) {
            f7Param.setOnlySelLeaf(true);
        }
        NewF7Utils.openF7((BeforeF7SelectEvent)evt, (MemberF7Parameter)f7Param);
    }

    private boolean saveValidator() {
        this.deleteNullRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DIM_MAPENTRY);
        return this.wholeDimsValidator(entryEntity) || this.mustInputValidator(entryEntity);
    }

    private boolean wholeDimsValidator(DynamicObjectCollection entryEntity) {
        Map srcAllDims = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("srcCommonDimsCache"));
        srcAllDims.putAll((Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("srcDefineDimsCache")));
        Map tarAllDims = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("tarCommonDimsCache"));
        tarAllDims.putAll((Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("tarDefineDimsCache")));
        for (DynamicObject object : entryEntity) {
            DynamicObject srcDim = object.getDynamicObject("srcdim");
            DynamicObject tarDim = object.getDynamicObject("tardim");
            if (srcDim != null) {
                srcAllDims.remove(srcDim.getString("number"));
            }
            if (tarDim == null) continue;
            tarAllDims.remove(tarDim.getString("number"));
        }
        if (srcAllDims.size() > 0 || tarAllDims.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u6301\u6e90\u7ef4\u5ea6\u6216\u76ee\u6807\u7ef4\u5ea6\u7684\u5b8c\u6574\u6027\u3002", (String)"EbDataUploadSchemeCMPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean mustInputValidator(DynamicObjectCollection entryEntity) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(DIM_MAPENTRY);
        entryGrid.setColumnProperty("srcmember", "bc", (Object)"");
        entryGrid.setColumnProperty("tarmember", "bc", (Object)"");
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(10);
        for (DynamicObject object : entryEntity) {
            boolean maponly = object.getBoolean("maponly");
            if (maponly && object.getDynamicObject("membermap") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u9009\u4e2d\u2018\u4ec5\u4f7f\u7528\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u2019\u5b57\u6bb5\u7684\u5206\u5f55\u884c\uff0c\u5fc5\u987b\u5f55\u5165\u2018\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u2019\u5b57\u6bb5\u3002", (String)"EbDataUploadSchemeCMPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return Boolean.TRUE;
            }
            DynamicObject srcDim = object.getDynamicObject("srcdim");
            DynamicObject tarDim = object.getDynamicObject("tardim");
            if (srcDim != null && tarDim != null) continue;
            int row = object.getInt("seq") - 1;
            DynamicObject srcmember = object.getDynamicObject("srcmember");
            if (srcDim != null && srcmember == null) {
                styles.add(this.getCellStyle(row, "srcmember"));
            }
            DynamicObject tarmember = object.getDynamicObject("tarmember");
            if (tarDim == null || tarmember != null) continue;
            styles.add(this.getCellStyle(row, "tarmember"));
        }
        if (styles.size() > 0) {
            entryGrid.setCellStyle(styles);
            IFormView formView = this.getView();
            this.setPresetDimNotEnable(formView);
            formView.updateView(DIM_MAPENTRY);
            formView.showTipNotification(ResManager.loadKDString((String)"\u53d8\u8272\u5355\u5143\u683c\u4e3a\u5fc5\u586b\u9879", (String)"EbDataUploadSchemeCMPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public void deleteNullRows() {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity(DIM_MAPENTRY);
        ArrayList<Integer> delRows = new ArrayList<Integer>(10);
        for (DynamicObject object : entryEntity) {
            Object srcdim = object.get("srcdim");
            Object tardim = object.get("tardim");
            int row = object.getInt("seq") - 1;
            if (srcdim == null && tardim == null) {
                delRows.add(row);
                continue;
            }
            if (srcdim == null || tardim == null) {
                dataModel.setValue("maponly", (Object)"0", row);
                dataModel.setValue("membermap", null, row);
                dataModel.setValue("istransfermember", (Object)"0", row);
                continue;
            }
            if (object.get("tarmember") == null && object.get("srcmember") == null) continue;
            dataModel.setValue("istransfermember", (Object)"0", row);
        }
        dataModel.deleteEntryRows(DIM_MAPENTRY, delRows.stream().mapToInt(r -> r).toArray());
        dataModel.updateCache();
    }

    private CellStyle getCellStyle(int row, String filedKey) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(row);
        cellStyle.setFieldKey(filedKey);
        cellStyle.setBackColor("#ffaaaa");
        return cellStyle;
    }

    private void setPresetDimNotEnable(IFormView view) {
        for (int i = 0; i < commonDimNums.size(); ++i) {
            view.setEnable(Boolean.FALSE, i, new String[]{"srcdim", "srcmember", "tardim", "tarmember", "istransfermember"});
        }
        this.setIcEntityNotTransfer(view);
    }

    private List<Long> getExistDimIds(String key) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DIM_MAPENTRY);
        ArrayList<Long> ids = new ArrayList<Long>(entryEntity.size());
        for (DynamicObject object : entryEntity) {
            DynamicObject dynamicObject = object.getDynamicObject(key);
            if (dynamicObject == null) continue;
            ids.add(dynamicObject.getLong("id"));
        }
        return ids;
    }

    private List<QFilter> setDimMapingQfilter() {
        QFilter qfNull = new QFilter("id", "=", (Object)0);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("status", "=", (Object)"1"));
        EntryGrid control = (EntryGrid)this.getControl(DIM_MAPENTRY);
        int focusRow = control.getEntryState().getFocusRow();
        if (focusRow < 0) {
            qFilters.add(qfNull);
            return qFilters;
        }
        Object srcModel = this.getModel().getValue(SRC_MODEL);
        Object tarModel = this.getModel().getValue(TAR_MODEL);
        Object srcBiz = this.getModel().getValue(SRC_BIZ);
        Object tarBiz = this.getModel().getValue(TAR_BIZ);
        if (srcModel == null || tarModel == null || srcBiz == null || tarBiz == null) {
            qFilters.add(qfNull);
            return qFilters;
        }
        qFilters.add(new QFilter(SRC_MODEL, "=", (Object)((DynamicObject)srcModel).getLong("id")));
        qFilters.add(new QFilter(TAR_MODEL, "=", (Object)((DynamicObject)tarModel).getLong("id")));
        DynamicObject rowObject = this.getModel().getEntryRowEntity(DIM_MAPENTRY, focusRow);
        if (rowObject == null) {
            qFilters.add(qfNull);
            return qFilters;
        }
        this.setDimMapViewQfilter(rowObject, "src", qFilters);
        this.setDimMapViewQfilter(rowObject, "tar", qFilters);
        return qFilters;
    }

    private void setDimMapViewQfilter(DynamicObject rowObject, String sign, List<QFilter> qFilters) {
        DynamicObject dim = rowObject.getDynamicObject(sign + "dim");
        if (dim == null) {
            return;
        }
        Long dimId = dim.getLong("id");
        qFilters.add(new QFilter(sign + "dim", "=", (Object)dimId));
        Object modelObj = this.getModel().getValue(sign + "model");
        Object busObj = this.getModel().getValue(sign + "biz");
        long modelId = ((DynamicObject)modelObj).getLong("id");
        long busModelId = ((DynamicObject)busObj).getLong("id");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Map viewMap = modelCache.getViewGroupViewsByBusModel(Long.valueOf(busModelId));
        String dimNumber = dim.getString("number");
        List viewIds = (List)viewMap.get(dimNumber);
        if (CollectionUtils.isNotEmpty((Collection)viewIds)) {
            qFilters.add(new QFilter(sign + "dimview", "in", (Object)viewIds));
        }
    }

    private void setNumberAndName() {
        DynamicObject srcBiz = (DynamicObject)this.getModel().getValue(SRC_BIZ);
        DynamicObject tarBiz = (DynamicObject)this.getModel().getValue(TAR_BIZ);
        DynamicObject tarModel = (DynamicObject)this.getModel().getValue(TAR_MODEL);
        this.getModel().setValue("name", (Object)(srcBiz.getString("name") + "-" + tarBiz.getString("name") + '(' + tarModel.getString("name") + ')'));
        DynamicObject srcModel = (DynamicObject)this.getModel().getValue(SRC_MODEL);
        this.getModel().setValue("number", (Object)this.getOnlyNumber(srcModel, tarModel, tarBiz, srcBiz));
    }

    private String getOnlyNumber(DynamicObject srcModel, DynamicObject tarModel, DynamicObject tarBiz, DynamicObject srcBiz) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(SRC_MODEL, "=", (Object)srcModel.getLong("id")));
        qFilters.add(new QFilter(SRC_BIZ, "=", (Object)srcBiz.getLong("id")));
        qFilters.add(new QFilter(TAR_MODEL, "=", (Object)tarModel.getLong("id")));
        qFilters.add(new QFilter(TAR_BIZ, "=", (Object)tarBiz.getLong("id")));
        qFilters.add(new QFilter("number", "not like", (Object)"%.copy%"));
        StringBuilder startNumber = new StringBuilder(srcBiz.getString("number"));
        startNumber.append("-").append(tarBiz.getString("number"));
        StringBuilder endNumber = new StringBuilder();
        endNumber.append('(').append(tarModel.getString("shownumber")).append(')');
        String numberIndex = "001";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_modelupload", (String)"number", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"createdate desc", (int)1);
        if (query.size() > 0) {
            String preNumber = ((DynamicObject)query.get(0)).getString("number");
            int startIndex = startNumber.toString().length() + 1;
            int endIndex = preNumber.length() - endNumber.length();
            numberIndex = String.valueOf(Integer.parseInt(preNumber.substring(startIndex, endIndex)) + 1);
        }
        StringBuilder midNumber = new StringBuilder();
        for (int i = 0; i < 3 - numberIndex.length(); ++i) {
            midNumber.append(0);
        }
        midNumber.append(numberIndex);
        startNumber.append((CharSequence)midNumber).append((CharSequence)endNumber);
        return startNumber.toString();
    }

    private boolean isEditStatus() {
        long id = (Long)this.getModel().getValue("id");
        if (id != 0L) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void setOtherProperties() {
        Date now = TimeServiceHelper.now();
        Long userId = UserUtils.getUserId();
        this.getModel().setValue("modifier", (Object)userId);
        this.getModel().setValue("modifydate", (Object)now);
        if (this.isEditStatus()) {
            return;
        }
        this.getModel().setValue("creater", (Object)userId);
        this.getModel().setValue("createdate", (Object)now);
        this.setNumberAndName();
    }

    private void setIcEntityTypeWhenLoad(IDataModel dataModel, String key, String dimNumber, int rowCount) {
        if ("InternalCompany".equals(dimNumber)) {
            dataModel.setValue(key, (Object)"epm_icmembertree", rowCount);
        }
    }

    private void setIcEntityType(PropertyChangedArgs e, String sign) {
        EntryGrid control = (EntryGrid)this.getControl(DIM_MAPENTRY);
        int focusRow = control.getEntryState().getFocusRow();
        if (focusRow < 0) {
            return;
        }
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (newValue == null || !"InternalCompany".equals(newValue.getString("number"))) {
            this.getModel().setValue(sign + "membertype", (Object)"epm_userdefinedmembertree", focusRow);
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"istransfermember"});
        } else {
            this.getModel().setValue(sign + "membertype", (Object)"epm_icmembertree", focusRow);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"istransfermember"});
        }
        if (newValue == null) {
            this.getModel().setValue(sign + "member", null, focusRow);
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        EntryGrid control = (EntryGrid)this.getControl(DIM_MAPENTRY);
        int focusRow = control.getEntryState().getFocusRow();
        if (focusRow < 0) {
            return null;
        }
        return ((DynamicObject)this.getModel().getValue(controlKey.substring(0, 3) + "dim")).getString("number");
    }

    private void loadDimCacheWhenEdit() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DIM_MAPENTRY);
        HashMap<String, Long> srcUserDim = new HashMap<String, Long>(16);
        HashMap<String, Long> tarUserDim = new HashMap<String, Long>(16);
        for (DynamicObject object : entryEntity) {
            DynamicObject srcDim = object.getDynamicObject("srcdim");
            DynamicObject tarDim = object.getDynamicObject("tardim");
            if (srcDim != null) {
                srcUserDim.put(srcDim.getString("number"), srcDim.getLong("id"));
            }
            if (tarDim == null) continue;
            tarUserDim.put(tarDim.getString("number"), tarDim.getLong("id"));
        }
        HashMap<String, Long> srcCommonDim = new HashMap<String, Long>(12);
        HashMap<String, Long> tarCommonDim = new HashMap<String, Long>(12);
        for (String commonDimNum : commonDimNums) {
            Long tarid;
            Long srcid = (Long)srcUserDim.remove(commonDimNum);
            if (srcid != null) {
                srcCommonDim.put(commonDimNum, srcid);
            }
            if ((tarid = (Long)tarUserDim.remove(commonDimNum)) == null) continue;
            tarCommonDim.put(commonDimNum, tarid);
        }
        this.getPageCache().put("srcCommonDimsCache", SerializationUtils.serializeToBase64(srcCommonDim));
        this.getPageCache().put("tarCommonDimsCache", SerializationUtils.serializeToBase64(tarCommonDim));
        this.getPageCache().put("srcDefineDimsCache", SerializationUtils.serializeToBase64(srcUserDim));
        this.getPageCache().put("tarDefineDimsCache", SerializationUtils.serializeToBase64(tarUserDim));
    }

    private void lockForm() {
        long id = (Long)this.getModel().getValue("id");
        boolean exists = QueryServiceHelper.exists((String)"eb_modelupload_log", (QFilter[])new QFilter[]{new QFilter("modelupload", "=", (Object)id)});
        if (exists) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DIM_MAPENTRY);
            int[] rows = entryEntity.stream().mapToInt(e -> e.getInt("seq") - 1).toArray();
            EntryGrid control = (EntryGrid)this.getControl(DIM_MAPENTRY);
            control.setRowLock(Boolean.TRUE.booleanValue(), rows);
            this.getView().setEnable(Boolean.FALSE, new String[]{"addrow", "deleterow"});
        }
    }

    private void setIcEntityNotTransfer(IFormView view) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(DIM_MAPENTRY);
        for (int j = commonDimNums.size(); j < collection.size(); ++j) {
            DynamicObject object = (DynamicObject)collection.get(j);
            if (!"InternalCompany".equals(object.getString("srcdim.number")) && !"InternalCompany".equals(object.getString("tardim.number"))) continue;
            view.setEnable(Boolean.FALSE, j, new String[]{"istransfermember"});
        }
    }

    private void changeMutexValue(int rowIndex, Object newValue, String tar) {
        if (newValue instanceof Boolean && ((Boolean)newValue).booleanValue()) {
            this.getModel().setValue(tar, (Object)Boolean.FALSE, rowIndex);
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_close"}));
    }
}

