/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataUpload;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class EbDataUploadSchemeCMlListPlugin
extends AbstractListPlugin {
    private static final String MODEL_SELECT_CACHE = "userSelectModel";
    private static final String MODEL = "srcmodel";

    public void afterCreateNewData(EventObject e) {
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"", (boolean)Boolean.FALSE);
        if (modelId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put(MODEL_SELECT_CACHE, modelId.toString());
        if (IDUtils.isNull((Long)modelId)) {
            this.getPageCache().put(MODEL_SELECT_CACHE, null);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String modelid = this.getPageCache().get(MODEL_SELECT_CACHE);
        if (modelid == null) {
            return;
        }
        this.getPageCache().put(MODEL_SELECT_CACHE, null);
        List commonFilterColumns = args.getCommonFilterColumns();
        CommonFilterColumn filterColumn = (CommonFilterColumn)commonFilterColumns.stream().filter(c -> c.getFieldName().equals("srcmodel.name")).findFirst().get();
        ArrayList modelQFilters = new ArrayList(16);
        modelQFilters.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[0]), null);
        filterColumn.getComboItems().clear();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (DynamicObject dynamicObject : load) {
            Object id = dynamicObject.get("id");
            if (id == null) continue;
            String name = dynamicObject.getLocaleString("name").getLocaleValue();
            if (name == null) {
                name = "id:" + id;
            }
            ComboItem comboItem = new ComboItem(new LocaleString(name), String.valueOf(id));
            comboItems.add(comboItem);
        }
        filterColumn.setComboItems(comboItems);
        if (this.isExistModel(modelid)) {
            long count = comboItems.stream().filter(model -> model != null && modelid.equals(model.getValue())).count();
            if (count == 0L) {
                this.noModel(filterColumn, comboItems);
            } else {
                filterColumn.setDefaultValue(modelid);
                this.getPageCache().put(MODEL, modelid);
            }
        } else {
            this.noModel(filterColumn, comboItems);
        }
    }

    private void noModel(CommonFilterColumn filterColumn, List<ComboItem> comboItems) {
        String value = comboItems != null && comboItems.size() > 0 ? comboItems.get(0).getValue() : "0";
        filterColumn.setDefaultValue(value);
        if ("0".equals(value)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("srcmodel.id".equals(args.getFieldName())) {
            args.setCustomQFilters(ModelUtil.getModelFilter((IFormView)this.getView()));
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        QFilter qFilter = args.getQFilter("srcmodel.id");
        Long modelId = 0L;
        if (qFilter != null) {
            modelId = IDUtils.toLong((Object)qFilter.getValue());
        }
        if (IDUtils.isNull((Long)modelId) && args.getSearchClickEvent().getSelectMainOrgIds().size() == 1) {
            modelId = (Long)args.getSearchClickEvent().getSelectMainOrgIds().get(0);
        }
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalyzeListSet_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
            this.getPageCache().put(MODEL, modelId.toString());
        }
    }

    public void setFilter(SetFilterEvent e) {
        boolean hasModel = false;
        List filters = e.getMergeQFilters();
        for (QFilter filter : filters) {
            if (filter == null || !filter.getProperty().equals(MODEL)) continue;
            hasModel = true;
            break;
        }
        if (!hasModel) {
            e.getQFilters().add(new QFilter(MODEL, "=", (Object)0L));
        }
        e.setOrderBy("modifydate desc");
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_add": {
                this.addNew();
                break;
            }
            case "btn_delete": {
                this.befroeDelete(key);
                break;
            }
            case "btn_copy": {
                this.batchCopy();
                break;
            }
            case "btn_dataupload": {
                this.dataTransMission(key);
                break;
            }
            case "btn_uploadlogs": {
                this.opLogList();
                break;
            }
            case "btn_refresh": {
                this.refresh();
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "addNewCloseCallBack": {
                this.refresh();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        MessageBoxResult result = evt.getResult();
        String callBackId = evt.getCallBackId();
        if ("btn_delete".equals(callBackId) && MessageBoxResult.Yes == result) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
            ArrayList<Object> ids = new ArrayList<Object>(selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                ids.add(selectedRow.getPrimaryKeyValue());
            }
            DeleteServiceHelper.delete((String)"eb_modelupload", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664\u4f53\u7cfb\u95f4\u4e0a\u4f20\u65b9\u6848", "EbDataUploadSchemeCMlListPlugin_0", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664%1$s\u6761\u6570\u636e", "EbDataUploadSchemeCMlListPlugin_1", "epm-eb-formplugin"), new String[]{ids.size() + ""});
            this.refresh();
            this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "AbstractMultiReportPlugin_60", "epm-eb-budget"), new MultiLangEnumBridge("\u4f53\u7cfb\u95f4\u6570\u636e\u4e0a\u4f20\u65b9\u6848\u5220\u9664\u6210\u529f", "AbstractMultiReportPlugin_142", "epm-eb-budget"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"EbDataUploadSchemeCMlListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void addNew() {
        long modelId = this.getModelId();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("eb_modelupload");
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u4f53\u7cfb\u95f4\u6570\u636e\u4e0a\u4f20\u65b9\u6848", (String)"EbDataUploadSchemeCMlListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addNewCloseCallBack"));
        baseShowParameter.setCustomParam(MODEL, (Object)String.valueOf(modelId));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void befroeDelete(String key) {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"EbDataUploadSchemeCMlListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> ids = new ArrayList<Object>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            ids.add(selectedRow.getPrimaryKeyValue());
        }
        QFilter qFilter = new QFilter("modelupload", "in", ids);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_modelupload_log", (String)"modelupload", (QFilter[])new QFilter[]{qFilter});
        if (load == null || load.length == 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u6240\u9009\u62e9\u7684\u65b9\u6848\uff1f", (String)"EbDataUploadSchemeCMlListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(key));
            return;
        }
        for (DynamicObject object : load) {
            ids.remove(object.get("modelupload.id"));
        }
        billlist.clearSelection();
        if (ids.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u65b9\u6848\u5df2\u7ecf\u5b58\u5728\u4e0a\u4f20\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"EbDataUploadSchemeCMlListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] intRows = selectedRows.stream().filter(s -> ids.contains(s.getPrimaryKeyValue())).mapToInt(s -> s.getRowKey()).toArray();
        billlist.selectRows(intRows);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5220\u9664\u65e0\u4e0a\u4f20\u6570\u636e\u7684\u65b9\u6848\uff0c\u786e\u8ba4\u5220\u9664\uff1f", (String)"EbDataUploadSchemeCMlListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(key));
    }

    private void batchCopy() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (selectedRows == null || selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u6761\u8981\u590d\u5236\u7684\u6570\u636e\u3002", (String)"EbDataUploadSchemeCMlListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> ids = new ArrayList<Object>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            ids.add(selectedRow.getPrimaryKeyValue());
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_modelupload").getDynamicObjectType());
        if (load == null || load.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"EbDataUploadSchemeCMlListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.refresh();
            return;
        }
        ArrayList<DynamicObject> copyDynamicObjects = new ArrayList<DynamicObject>(load.length);
        Date now = TimeServiceHelper.now();
        Long userId = UserUtils.getUserId();
        for (DynamicObject object : load) {
            copyDynamicObjects.add(this.clonObject(object, now, userId));
        }
        SaveServiceHelper.save((DynamicObject[])copyDynamicObjects.toArray(new DynamicObject[0]));
        this.refresh();
        this.writeLog("copy", new MultiLangEnumBridge("\u590d\u5236\u65b9\u6848", "EbDataUploadSchemeCMlListPlugin_11", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5df2\u590d\u5236%1$s\u6761\u6570\u636e\u3002", "EbDataUploadSchemeCMlListPlugin_12", "epm-eb-formplugin"), new String[]{copyDynamicObjects.size() + ""});
    }

    @Override
    public String getBizEntityNumber() {
        return "eb_modelupload";
    }

    private void dataTransMission(String key) {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (selectedRows == null || selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"EbDataUploadSchemeCMlListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String schemeId = selectedRows.get(0).getPrimaryKeyValue().toString();
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_modelupload", (String)"status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)IDUtils.toLong((Object)schemeId))});
        if (!query.getBoolean("status")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u4e0a\u4f20\u3002", (String)"EbDataUploadSchemeCMlListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_datatransmission");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setCustomParam("schemeid", (Object)schemeId);
        this.getView().showForm(formShowParameter);
    }

    private void opLogList() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.getListFilterParameter().getQFilters().add(new QFilter("modelupload.srcmodel", "=", (Object)this.getModelId()));
        lsp.setBillFormId("eb_modelupload_log");
        lsp.setPageId(lsp.getBillFormId() + this.getModelId() + "_" + this.getView().getPageId());
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "log_close"));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void refresh() {
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.clearSelection();
        billlist.setOrderBy("modifydate desc");
        billlist.refresh();
    }

    private boolean isExistModel(String modelId) {
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)Long.parseLong(modelId));
        if (orCreate == null) {
            return Boolean.FALSE;
        }
        Model model = orCreate.getModelobj();
        if (model == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private DynamicObject clonObject(DynamicObject formObject, Date now, Long userId) {
        DynamicObject toObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_modelupload");
        DynamicObjectUtils.copy((DynamicObject)formObject, (DynamicObject)toObject);
        toObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
        toObject.set("modifier", (Object)userId);
        toObject.set("modifydate", (Object)now);
        toObject.set("creater", (Object)userId);
        toObject.set("createdate", (Object)now);
        toObject.set("number", (Object)this.getOnlyNumber(formObject));
        return toObject;
    }

    private String getOnlyNumber(DynamicObject formObject) {
        String number = formObject.getString("number") + ".copy";
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(MODEL, "=", (Object)formObject.getLong("srcmodel.id")));
        qFilters.add(new QFilter("srcbiz", "=", (Object)formObject.getLong("srcbiz.id")));
        qFilters.add(new QFilter("tarmodel", "=", (Object)formObject.getLong("tarmodel.id")));
        qFilters.add(new QFilter("tarbiz", "=", (Object)formObject.getLong("tarbiz.id")));
        QFilter qFilter = new QFilter("number", "like", (Object)(number + "%"));
        qFilter.and("number", "not like", (Object)(number + "%.copy%"));
        qFilters.add(qFilter);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"eb_modelupload", (String)"number", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"createdate desc", (int)1);
        if (objects.size() == 0) {
            return number;
        }
        String oldNumber = ((DynamicObject)objects.get(0)).getString("number");
        if (number.equals(oldNumber)) {
            return number + 1;
        }
        int num = Integer.parseInt(oldNumber.substring(number.length())) + 1;
        return number + num;
    }

    @Override
    public Long getModelId() {
        String cache = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((String)cache)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeCMlListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return Long.valueOf(cache);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_close"}));
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            return;
        }
        super.hyperLinkClick(hyperLinkClickEvent);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            evt.setCancel(true);
            return;
        }
        super.billListHyperLinkClick(evt);
    }
}

