/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataUpload;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.DataUploadServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.dataUpload.EbDataUploadEntity;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class EbDataUploadSchemeEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private final String SRCBUSINESSMODEL = "srcbusinessmodel";
    private final String TRGBUSINESSMODEL = "trgbusinessmodel";
    private final String BTN_ADDENTRY = "btn_addentry";
    private final String BTN_DELETEENTRY = "btn_deleteentry";
    private final String BTN_IMPORTENTRY = "btn_importentry";
    private final String BTN_EXPORTENTRY = "btn_exportentry";
    private final String ACCOUNT_ENTITY = "accountentryentity";
    private final String NUMBER_ID_CACHE = "numberIdCache";
    private BusinessModelServiceHelper instance = BusinessModelServiceHelper.getInstance();
    private DataUploadServiceHelper uploadInstance = DataUploadServiceHelper.getInstance();
    private static final Log log = LogFactory.getLog(EbDataUploadSchemeEditPlugin.class);

    public void initialize() {
        super.initialize();
        this.addBeforeF7SelectListeners("srcbusinessmodel", "trgbusinessmodel", "srcaccount", "trgaccount", "enddate", "startdate", "srcdimmemshow", "trgdimmemshow");
        TextEdit f7text = (TextEdit)this.getControl("orgtext");
        f7text.addClickListener((ClickListener)this);
        TextEdit f7text2 = (TextEdit)this.getControl("periodtext");
        f7text2.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"first", "previous", "next", "last"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"advcontoolbarap1", "btn_addentry"});
        final Tab tab = (Tab)this.getControl("tabap1");
        tab.addTabSelectListener(new TabSelectListener(){

            public void tabSelected(TabSelectEvent tabSelectEvent) {
                String key = tabSelectEvent.getTabKey();
                if ("tabpage_ebdimmapping".equalsIgnoreCase(key)) {
                    tab.activeTab("tabpage_ebdimmapping");
                } else {
                    tab.activeTab("tabpage_ebaccountmapping");
                }
            }
        });
        this.getView().setVisible(Boolean.TRUE, new String[]{"advconchildpanelap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        String orgDimNumber = "Entity";
        String budperDimNumber = "BudgetPeriod";
        DynamicObject trgdc = (DynamicObject)this.getModel().getValue("trgbusinessmodel");
        if (trgdc == null) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u3002", (String)"EbDataUploadSchemeEditPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        long busModelId = trgdc.getLong("id");
        switch (fieldKey) {
            case "orgtext": {
                this.openF7("orgtext", orgDimNumber, busModelId);
                break;
            }
            case "periodtext": {
                this.openF7("periodtext", budperDimNumber, busModelId);
            }
        }
    }

    private void openF7(String actionId, String dimnumber, Long busModelId) {
        int rowIndex;
        Long modelId = this.getModelId();
        DynamicObject dimension = null;
        Set selectIds = null;
        long viewId = 0L;
        if ("orgtext".equals(actionId)) {
            dimension = NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Entity.getNumber());
            rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String org = (String)this.getModel().getValue("org", rowIndex);
            if (StringUtils.isNotEmpty((CharSequence)org)) {
                List orgList = (List)SerializationUtils.fromJsonString((String)org, List.class);
                selectIds = orgList.stream().map(e -> Long.parseLong(e.split(",")[0])).collect(Collectors.toSet());
                String firstLine = (String)orgList.get(0);
                try {
                    viewId = Long.parseLong(StringUtils.substringAfterLast((String)firstLine, (String)","));
                }
                catch (Exception exception) {}
            }
        } else if ("periodtext".equals(actionId)) {
            dimension = NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.BudgetPeriod.getNumber());
            rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String org = (String)this.getModel().getValue("period", rowIndex);
            if (StringUtils.isNotEmpty((CharSequence)org)) {
                List periodList = (List)SerializationUtils.fromJsonString((String)org, List.class);
                selectIds = periodList.stream().map(e -> Long.parseLong(e.split(",")[0])).collect(Collectors.toSet());
            }
        }
        if (dimension != null) {
            MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)dimension, (String)ListSelectedRow.class.getName());
            if (selectIds != null) {
                f7Param.setSelectIds(selectIds);
            }
            f7Param.setOnlySelLeaf(true);
            f7Param.setBusModelId(busModelId);
            f7Param.setEnableView(true);
            f7Param.setViewId(Long.valueOf(viewId));
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("importcloseback".equals(actionId)) {
            if (event.getReturnData() instanceof List) {
                List accountList = (List)event.getReturnData();
                try {
                    this.accountShow(accountList);
                }
                catch (ParseException e) {
                    log.error(e.getMessage());
                }
            } else if (event.getReturnData() instanceof String) {
                this.getView().showTipNotification(String.valueOf(event.getReturnData()));
            }
        } else if (actionId.contains("orgtext") || actionId.contains("periodtext")) {
            this.f7closedCallBack(event, actionId);
        }
    }

    private void f7closedCallBack(ClosedCallBackEvent e, String actionId) {
        super.closedCallBack(e);
        if (Objects.nonNull(e.getReturnData())) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
            if (returnData == null || returnData.size() <= 0) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            ArrayList<String> orgList = new ArrayList<String>(returnData.size());
            ArrayList<String> periodList = new ArrayList<String>(returnData.size());
            for (int i = 0; i < returnData.size(); ++i) {
                String id;
                String name = returnData.get(i).getName();
                String numbder = returnData.get(i).getNumber();
                if ("orgtext".equals(actionId)) {
                    StringBuilder orgsb = new StringBuilder();
                    id = returnData.get(i).getPrimaryKeyValue().toString();
                    orgsb.append(id).append(",");
                    orgsb.append(numbder).append(",");
                    orgsb.append(MapUtils.getString((Map)returnData.get(i).getDataMap(), (Object)"viewid", (String)"0"));
                    orgList.add(orgsb.toString());
                } else if ("periodtext".equals(actionId)) {
                    StringBuilder periodsb = new StringBuilder();
                    id = returnData.get(i).getPrimaryKeyValue().toString();
                    String idStr = id + ",";
                    periodsb.append(idStr);
                    periodsb.append(numbder);
                    periodList.add(periodsb.toString());
                }
                if (i == returnData.size() - 1) {
                    sb.append(name);
                    continue;
                }
                String nameNew = name + ",";
                sb.append(nameNew);
            }
            this.getModel().setValue(actionId, (Object)sb);
            if ("orgtext".equals(actionId)) {
                this.getModel().setValue("org", (Object)SerializationUtils.toJsonString(orgList));
            }
            if ("periodtext".equals(actionId)) {
                this.getModel().setValue("period", (Object)SerializationUtils.toJsonString(periodList));
            }
        }
    }

    public void afterBindData(EventObject e) {
        Long model = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        if ("copy".equals(this.getPageCache().get("operationStatus"))) {
            this.afterBindDataByCopy(model);
            this.buildTaskInfos();
        } else {
            this.buildTaskInfos();
            String status = null;
            String id = String.valueOf(this.getModel().getValue("id"));
            if (StringUtils.isNotEmpty((CharSequence)id) && !"0".equals(id)) {
                status = "edit";
            }
            List dynamicObjects = DimensionServiceHelper.queryAllDim((Long)model, (String)"id, name, number");
            HashMap<String, DynamicObject> dimsAll = new HashMap<String, DynamicObject>(16);
            for (DynamicObject dy : dynamicObjects) {
                dimsAll.put(dy.getString("number"), dy);
            }
            this.getPageCache().put("dimsAll", SerializationUtils.serializeToBase64(dimsAll));
            this.queryBperiodOrderByNumber();
            this.setEnable();
            ArrayList<Long> srcDimsCache = new ArrayList<Long>(16);
            ArrayList<Long> trgDimsCache = new ArrayList<Long>(16);
            DynamicObjectCollection dimEntryEntity1 = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject dy : dimEntryEntity1) {
                String srcdimnumber = dy.getString("srcdimnumber");
                String trgdimnumber = dy.getString("trgdimnumber");
                if (StringUtils.isNotEmpty((CharSequence)srcdimnumber)) {
                    srcDimsCache.add(((DynamicObject)dimsAll.get(srcdimnumber)).getLong("id"));
                }
                if (!StringUtils.isNotEmpty((CharSequence)trgdimnumber)) continue;
                trgDimsCache.add(((DynamicObject)dimsAll.get(trgdimnumber)).getLong("id"));
            }
            this.getPageCache().put("srcDimsCache", SerializationUtils.serializeToBase64(srcDimsCache));
            this.getPageCache().put("trgDimsCache", SerializationUtils.serializeToBase64(trgDimsCache));
            this.queryAccountByBizModel();
            if ("edit".equals(status)) {
                this.afterBindDataByEdit(status, model);
            }
        }
        this.getPageCache().put("dataChange", "false");
    }

    private void buildTaskInfos() {
        Boolean taskstatus = (Boolean)this.getModel().getValue("taskstatus");
        if (taskstatus.booleanValue()) {
            String period;
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"fs_taskinfo"});
            String org = (String)this.getModel().getValue("org");
            if (StringUtils.isNotEmpty((CharSequence)org)) {
                List orgList = (List)SerializationUtils.fromJsonString((String)org, List.class);
                List names = orgList.stream().map(x -> {
                    Member member;
                    String[] split = x.split(",");
                    long viewId = 0L;
                    if (split.length > 2) {
                        viewId = Long.parseLong(split[2]);
                    }
                    if ((member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(viewId), split[1])) == null) {
                        return "";
                    }
                    return member.getName();
                }).filter(x -> StringUtils.isNotEmpty((CharSequence)x)).collect(Collectors.toList());
                this.getModel().setValue("orgtext", (Object)String.join((CharSequence)",", names));
            }
            if (StringUtils.isNotEmpty((CharSequence)(period = (String)this.getModel().getValue("period")))) {
                List periodList = (List)SerializationUtils.fromJsonString((String)period, List.class);
                List names = periodList.stream().map(x -> {
                    Member member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, x.split(",")[1]);
                    if (member == null) {
                        return "";
                    }
                    return member.getName();
                }).filter(x -> StringUtils.isNotEmpty((CharSequence)x)).collect(Collectors.toList());
                this.getModel().setValue("periodtext", (Object)String.join((CharSequence)",", names));
            }
            TextEdit orgtext = (TextEdit)this.getControl("orgtext");
            orgtext.setMustInput(true);
            TextEdit periodtext = (TextEdit)this.getControl("periodtext");
            periodtext.setMustInput(true);
            this.getView().updateView("fs_taskinfo");
        } else {
            TextEdit orgtext = (TextEdit)this.getControl("orgtext");
            orgtext.setMustInput(false);
            TextEdit periodtext = (TextEdit)this.getControl("periodtext");
            periodtext.setMustInput(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fs_taskinfo"});
        }
    }

    private void afterBindDataByEdit(String status, Long model) {
        String srcbusmodelid = ((DynamicObject)this.getModel().getValue("srcbusinessmodel")).getString("id");
        String trgbusmodelid = ((DynamicObject)this.getModel().getValue("trgbusinessmodel")).getString("id");
        this.getPageCache().put("srcbusmodelid", srcbusmodelid);
        this.getPageCache().put("trgbusmodelid", trgbusmodelid);
        this.getPageCache().put("status", status);
        this.getPageCache().put("model", String.valueOf(model));
        DynamicObjectCollection logs = this.uploadInstance.querySchemeLogByNumber((String)this.getModel().getValue("number"), model);
        if (logs != null && logs.size() > 0) {
            DynamicObjectCollection accEntryEntity;
            DynamicObjectCollection dimEntryEntity = this.getModel().getEntryEntity("entryentity");
            if (dimEntryEntity != null && dimEntryEntity.size() > 0) {
                for (int i = 0; i < dimEntryEntity.size(); ++i) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"srcdimtext", "srcdimmemshow", "trgdimtext", "trgdimmemshow"});
                }
            }
            if ((accEntryEntity = this.getModel().getEntryEntity("accountentryentity")) != null && accEntryEntity.size() > 0) {
                for (int j = 0; j < accEntryEntity.size(); ++j) {
                    this.getView().setEnable(Boolean.FALSE, j, new String[]{"srcaccount", "trgaccount", "startdate"});
                }
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addentry", "btn_deleteentry", "btn_importentry"});
        }
    }

    private void afterBindDataByCopy(Long model) {
        Long schemeId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("schemeId"));
        DynamicObject dataSchemeById = this.uploadInstance.querySchemeById(IDUtils.toLong((Object)schemeId), model);
        if (dataSchemeById == null) {
            return;
        }
        this.getModel().setValue("srcbusinessmodel", dataSchemeById.get("srcbusinessmodel"));
        this.getModel().setValue("trgbusinessmodel", dataSchemeById.get("trgbusinessmodel"));
        this.getModel().setValue("description", dataSchemeById.get("description"));
        this.getModel().setValue("name", dataSchemeById.get("name"));
        this.getModel().setValue("model", (Object)model);
        this.getModel().setValue("org", dataSchemeById.get("org"));
        this.getModel().setValue("period", dataSchemeById.get("period"));
        DynamicObjectCollection entryentity = this.uploadInstance.querySchemeDimMapById(schemeId, model);
        HashMap<String, DynamicObject> entryMap = new HashMap<String, DynamicObject>(16);
        int j = 0;
        for (DynamicObject dy : entryentity) {
            String srcdimnumber = ((DynamicObject)entryentity.get(j)).getString("entryentity.srcdimnumber");
            String trgdimnumber = ((DynamicObject)entryentity.get(j)).getString("entryentity.trgdimnumber");
            if (StringUtils.isNotEmpty((CharSequence)srcdimnumber)) {
                entryMap.put(dy.getString("entryentity.srcdimnumber"), dy);
            } else if (StringUtils.isNotEmpty((CharSequence)trgdimnumber)) {
                entryMap.put(dy.getString("entryentity.trgdimnumber"), dy);
            }
            ++j;
        }
        DynamicObjectCollection entryEntity2 = this.getModel().getEntryEntity("entryentity");
        for (int t = 0; t < entryEntity2.size(); ++t) {
            Map mems;
            HashSet<Long> s;
            String srcdimnumber2 = ((DynamicObject)entryEntity2.get(t)).getString("srcdimnumber");
            String trgdimnumber2 = ((DynamicObject)entryEntity2.get(t)).getString("trgdimnumber");
            if (StringUtils.isNotEmpty((CharSequence)srcdimnumber2)) {
                s = new HashSet<Long>(16);
                if (entryMap.get(srcdimnumber2) != null) {
                    s.add(((DynamicObject)entryMap.get(srcdimnumber2)).getLong("entryentity.srcdimmemshow"));
                    mems = MemberServiceHelper.queryByIds((String)srcdimnumber2, s);
                    DynamicObject srcdimmemshow = (DynamicObject)mems.get(((DynamicObject)entryMap.get(srcdimnumber2)).getLong("entryentity.srcdimmemshow"));
                    ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(t)).set("srcdimmemshow", (Object)srcdimmemshow);
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)trgdimnumber2)) continue;
            s = new HashSet(16);
            if (entryMap.get(trgdimnumber2) == null) continue;
            s.add(((DynamicObject)entryMap.get(trgdimnumber2)).getLong("entryentity.trgdimmemshow"));
            mems = MemberServiceHelper.queryByIds((String)trgdimnumber2, s);
            DynamicObject trgdimmemshow = (DynamicObject)mems.get(((DynamicObject)entryMap.get(trgdimnumber2)).getLong("entryentity.trgdimmemshow"));
            ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(t)).set("trgdimmemshow", (Object)trgdimmemshow);
        }
        this.getView().updateView("entryentity");
        DynamicObjectCollection accountentryentity = this.uploadInstance.querySchemeAccMapById(schemeId, model);
        int i = 0;
        int[] rows = this.getModel().batchCreateNewEntryRow("accountentryentity", accountentryentity.size());
        for (DynamicObject dy : accountentryentity) {
            this.getModel().setValue("srcaccount", (Object)dy.getString("accountentryentity.srcaccount"), rows[i]);
            this.getModel().setValue("trgaccount", (Object)dy.getString("accountentryentity.trgaccount"), rows[i]);
            this.getModel().setValue("entrystatus", (Object)dy.getString("accountentryentity.entrystatus"), rows[i]);
            this.getModel().setValue("enddate", (Object)dy.getString("accountentryentity.enddate"), rows[i]);
            this.getModel().setValue("startdate", (Object)dy.getString("accountentryentity.startdate"), rows[i]);
            ++i;
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"srcbusinessmodel", "trgbusinessmodel"});
        this.getView().updateView("accountentryentity");
        this.getPageCache().put("operationStatus", null);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.setDataChange();
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        this.setDataChange();
    }

    private void setDataChange() {
        String dataChange = this.getPageCache().get("dataChange");
        if ("false".equals(dataChange)) {
            this.getModel().setDataChanged(false);
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"bar_close"}));
        String model = this.getPageCache().get("model");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("accountentryentity");
        if ("bar_save".equals(evt.getItemKey())) {
            String msg;
            String copyStatus = this.getPageCache().get("copyStatus");
            if (StringUtils.isEmpty((CharSequence)copyStatus)) {
                DynamicObject[] dyArray;
                Boolean state = (Boolean)this.getModel().getValue("state");
                if (state.booleanValue() && (dyArray = this.uploadInstance.getSchemeByName(this.getModel().getValue("name").toString(), Long.valueOf(model), "1")) != null && dyArray.length > 0 && !this.getModel().getValue("number").equals(dyArray[0].getString("number"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76f8\u540c\u540d\u79f0\u7684\u6570\u636e\u4e0a\u4f20\u65b9\u6848\u53ea\u5141\u8bb8\u4e00\u4e2a\u65b9\u6848\u4e3a\u542f\u7528\u72b6\u6001\u3002", (String)"EbDataUploadSchemeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (state.booleanValue()) {
                    this.getModel().setValue("enable", (Object)1);
                } else {
                    this.getModel().setValue("enable", (Object)0);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(msg = this.checkDim()))) {
                this.getView().showErrorNotification(msg);
                evt.setCancel(true);
                return;
            }
            if (entryEntity == null || entryEntity.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u79d1\u76ee\u6620\u5c04\u5173\u7cfb\u3002", (String)"EbDataUploadSchemeEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (!this.checkAccount()) {
                evt.setCancel(true);
                return;
            }
            this.checkTaskStatus();
            this.checkBusModelIsExist();
            this.checkDimIsExist();
            if (StringUtils.isNotEmpty((CharSequence)copyStatus) && "1".equals(copyStatus)) {
                this.updateCopyScheme();
            }
        }
    }

    private void checkTaskStatus() {
        Boolean taskstatus = (Boolean)this.getModel().getValue("taskstatus");
        if (taskstatus.booleanValue()) {
            String org = (String)this.getModel().getValue("org");
            if (StringUtils.isEmpty((CharSequence)org)) {
                String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            String budgetPeriod = (String)this.getModel().getValue("period");
            if (StringUtils.isEmpty((CharSequence)budgetPeriod)) {
                String msg = ResManager.loadKDString((String)"\u9884\u7b97\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
        }
    }

    private void updateCopyScheme() {
        Long schemeId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("schemeId"));
        ArrayList<Long> ids = new ArrayList<Long>(10);
        ids.add(schemeId);
        DynamicObject[] schemeList = this.uploadInstance.getSchemeListByIds(ids, this.getModelId());
        if (schemeList != null && schemeList.length > 0) {
            for (DynamicObject scheme : schemeList) {
                scheme.set("state", (Object)"0");
                scheme.set("enable", (Object)"0");
            }
        }
        SaveServiceHelper.save((DynamicObject[])schemeList);
        this.getModel().setValue("state", (Object)"1");
        this.getModel().setValue("enable", (Object)"1");
        this.getPageCache().put("copyStatus", null);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_addentry": {
                if (!this.isAlreadySeleBizModel()) {
                    return;
                }
                this.newAddAccountRow();
                break;
            }
            case "btn_deleteentry": {
                this.deleteEntryRow();
                this.getView().updateView("accountentryentity");
                break;
            }
            case "btn_importentry": {
                this.importAccMappingCase();
                break;
            }
            case "btn_exportentry": {
                this.exportAccMappingCase();
                break;
            }
            case "upload": {
                this.toDataUpload();
                break;
            }
        }
    }

    private void toDataUpload() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = (Long)this.getModel().getDataEntity().getPkValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_datauploadscheme");
        String enable = (String)dynamicObject.get("enable");
        if (!"1".equals(enable)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u65b9\u6848\u3002", (String)"EbDataUploadSchemeEditPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String uploadSchemes = SerializationUtils.serializeToBase64((Object)Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("eb_datamoreupload");
        param.setCustomParam("model", (Object)this.getModelId());
        param.setCustomParam("uploadschemes", (Object)uploadSchemes);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "upload"));
        this.getView().showForm(param);
    }

    private void importAccMappingCase() {
        if (!this.isAlreadySeleBizModel()) {
            return;
        }
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "epm_import");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        DynamicObject srcBussModel = (DynamicObject)this.getModel().getValue("srcbusinessmodel");
        showParameter.setCustomParam("srcBussModel", (Object)srcBussModel.getLong("id"));
        DynamicObject tarBussModel = (DynamicObject)this.getModel().getValue("trgbusinessmodel");
        showParameter.setCustomParam("tarBussModel", (Object)tarBussModel.getLong("id"));
        showParameter.setCustomParam("sourceAccount", (Object)this.getPageCache().get("sourceAccountList"));
        showParameter.setCustomParam("targetAccount", (Object)this.getPageCache().get("targetAccountList"));
        showParameter.setCustomParam("BudgetPeriodCache", (Object)this.getPageCache().get("BudgetPeriodCache"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u79d1\u76ee\u6620\u5c04\u5173\u7cfb\u5bfc\u5165", (String)"EbDataUploadSchemeEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.dataUpload.importandexport.DataUploadAccountImportPlugin");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importcloseback"));
        this.getView().showForm(showParameter);
    }

    private void accountShow(List<EbDataUploadEntity> accountList) throws ParseException {
        String accountCache = this.getPageCache().get("numberIdCache");
        String bPMapCache = this.getPageCache().get("bPMapCache");
        Map bp = (Map)SerializationUtils.deSerializeFromBase64((String)bPMapCache);
        Map map = (Map)SerializationUtils.fromJsonString((String)accountCache, Map.class);
        if (accountList == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty(accountList)) {
            int[] rows = this.getModel().batchCreateNewEntryRow("accountentryentity", accountList.size());
            int i = 0;
            for (EbDataUploadEntity accountEntity : accountList) {
                String startdate = accountEntity.getStartDate();
                String enddate = accountEntity.getEndDate();
                this.getModel().setValue("srcaccount", map.get(accountEntity.getSrcdimNumber()), rows[i]);
                this.getModel().setValue("trgaccount", map.get(accountEntity.getTrgdimNumber()), rows[i]);
                if (accountEntity.getAccountStatus() == null || ResManager.loadKDString((String)"\u542f\u7528", (String)"EbDataUploadSchemeEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(accountEntity.getAccountStatus())) {
                    this.getModel().setValue("entrystatus", (Object)"0", rows[i]);
                } else if (ResManager.loadKDString((String)"\u5220\u9664", (String)"EbDataUploadSchemeEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(accountEntity.getAccountStatus())) {
                    this.getModel().setValue("entrystatus", (Object)"1", rows[i]);
                } else {
                    this.getModel().setValue("entrystatus", (Object)"0", rows[i]);
                }
                if (StringUtils.isNotEmpty((CharSequence)enddate)) {
                    this.getModel().setValue("enddate", (Object)((DynamicObject)bp.get(enddate)).getString("id"), rows[i]);
                }
                this.getModel().setValue("startdate", (Object)((DynamicObject)bp.get(startdate)).getString("id"), rows[i]);
                ++i;
            }
        }
    }

    private void exportAccMappingCase() {
        String tempPath = "dataupload/dataupload_accountmapping.xlsx";
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath(tempPath);
        HashMap finalDataMap = Maps.newHashMapWithExpectedSize((int)10);
        finalDataMap.put("title", ResManager.loadKDString((String)"\u6570\u636e\u4e0a\u4f20\u79d1\u76ee\u6620\u5c04\u65b9\u6848\u5bfc\u51fa\u6a21\u677f", (String)"DataUploadAccountImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("tip", ResManager.loadKDString((String)"\u7ea2\u8272*\u5fc5\u586b", (String)"DataUploadAccountImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("srcAccNumber", ResManager.loadKDString((String)"*\u6e90\u79d1\u76ee\u7f16\u7801", (String)"DataUploadAccountImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("srcAccName", ResManager.loadKDString((String)"\u6e90\u79d1\u76ee\u540d\u79f0", (String)"DataUploadAccountImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("tarAccNumber", ResManager.loadKDString((String)"*\u76ee\u6807\u79d1\u76ee\u7f16\u7801", (String)"DataUploadAccountImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("tarAccName", ResManager.loadKDString((String)"\u76ee\u6807\u79d1\u76ee\u540d\u79f0", (String)"DataUploadAccountImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("status", ResManager.loadKDString((String)"*\u4f7f\u7528\u72b6\u6001\uff08\u4e0d\u586b\u9ed8\u8ba4\u4e3a\u542f\u7528\u72b6\u6001\uff09", (String)"DataUploadAccountImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        String[] statusOpt = new String[]{ResManager.loadKDString((String)"\u542f\u7528", (String)"DataUploadAccountImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5220\u9664", (String)"DataUploadAccountImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0])};
        excelWriter.setDropDownBox(statusOpt, Integer.valueOf(3), Integer.valueOf(100), Integer.valueOf(4), Integer.valueOf(4));
        finalDataMap.put("startBpNumber", ResManager.loadKDString((String)"*\u751f\u6548\u8d77\u59cb\u671f\u95f4\u7f16\u7801(\u683c\u5f0f:\u4f8b\uff1aFY2020.M01\uff09", (String)"DataUploadAccountImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("starBpName", ResManager.loadKDString((String)"\u751f\u6548\u8d77\u59cb\u671f\u95f4\u540d\u79f0(\u683c\u5f0f:\u4f8b\uff1a2020\u5e741\u6708\uff09", (String)"DataUploadAccountImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("endBpNumber", ResManager.loadKDString((String)"\u751f\u6548\u7ed3\u675f\u671f\u95f4\u7f16\u7801(\u683c\u5f0f:\u4f8b\uff1aFY2020.M01\uff09", (String)"DataUploadAccountImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("endBpName", ResManager.loadKDString((String)"\u751f\u6548\u7ed3\u675f\u671f\u95f4\u540d\u79f0(\u683c\u5f0f:\u4f8b\uff1a2020\u5e741\u6708\uff09", (String)"DataUploadAccountImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        excelWriter.replaceFinalData((Map)finalDataMap);
        excelWriter.setStarPosition(3, 0);
        DynamicObjectCollection accountentryentity = new DynamicObjectCollection();
        EntryGrid control = (EntryGrid)this.getControl("accountentryentity");
        int[] selectRows = control.getSelectRows();
        if (selectRows.length > 0) {
            for (int selectRow : selectRows) {
                accountentryentity.add((Object)this.getModel().getEntryRowEntity("accountentryentity", selectRow));
            }
        } else {
            accountentryentity = this.getModel().getEntryEntity("accountentryentity");
        }
        if (accountentryentity != null && accountentryentity.size() != 0) {
            Object object = accountentryentity.iterator();
            while (object.hasNext()) {
                DynamicObject enddate;
                DynamicObject startdate;
                DynamicObject trgaccount;
                DynamicObject dy = (DynamicObject)object.next();
                String entrystatus = "0";
                String srcaccountNumber = null;
                String srcaccountName = null;
                String trgaccountNumber = null;
                String trgaccountName = null;
                String startdateNumber = null;
                String startdateName = null;
                String enddateNumber = null;
                String enddateName = null;
                if ("0".equals(dy.getString("entrystatus"))) {
                    entrystatus = ResManager.loadKDString((String)"\u542f\u7528", (String)"EbDataUploadSchemeEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                } else if ("1".equals(dy.getString("entrystatus"))) {
                    entrystatus = ResManager.loadKDString((String)"\u5220\u9664", (String)"EbDataUploadSchemeEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                DynamicObject srcaccount = (DynamicObject)dy.get("srcaccount");
                if (srcaccount != null) {
                    srcaccountNumber = srcaccount.getString("number");
                    srcaccountName = srcaccount.getString("name");
                }
                if ((trgaccount = (DynamicObject)dy.get("trgaccount")) != null) {
                    trgaccountNumber = trgaccount.getString("number");
                    trgaccountName = trgaccount.getString("name");
                }
                if ((startdate = (DynamicObject)dy.get("startdate")) != null) {
                    startdateNumber = startdate.getString("number");
                    startdateName = startdate.getString("name");
                }
                if ((enddate = (DynamicObject)dy.get("enddate")) != null) {
                    enddateNumber = enddate.getString("number");
                    enddateName = enddate.getString("name");
                }
                excelWriter.createRow(new Object[]{srcaccountNumber, srcaccountName, trgaccountNumber, trgaccountName, entrystatus, startdateNumber, startdateName, enddateNumber, enddateName});
            }
        }
        String fileName = ResManager.loadKDString((String)"\u6570\u636e\u4e0a\u4f20\u79d1\u76ee\u6620\u5c04\u65b9\u6848\u5bfc\u51fa\u6210\u529f", (String)"EbDataUploadSchemeEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        fileName = fileName + ".xlsx";
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private String checkDim() {
        Long modelId = Long.valueOf(this.getPageCache().get("model"));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String msg = "";
        for (DynamicObject dimEntity : entryEntity) {
            DynamicObject srcdimmemshow = (DynamicObject)dimEntity.get("srcdimmemshow");
            DynamicObject trgdimmemshow = (DynamicObject)dimEntity.get("trgdimmemshow");
            String srcdimnumber = dimEntity.getString("srcdimnumber");
            String trgdimnumber = dimEntity.getString("trgdimnumber");
            this.setMemAndViewId(dimEntity, srcdimmemshow, srcdimnumber, modelId, "srcdimmemnumber", "srcdimview");
            this.setMemAndViewId(dimEntity, trgdimmemshow, trgdimnumber, modelId, "trgdimmemnumber", "trgdimview");
            if (StringUtils.isEmpty((CharSequence)srcdimnumber)) {
                if (!StringUtils.isNotEmpty((CharSequence)trgdimnumber) || trgdimmemshow != null) continue;
                msg = ResManager.loadKDString((String)"\u5f53\u6e90\u7ef4\u5ea6\u4e0e\u76ee\u6807\u7ef4\u5ea6\u4e0d\u4e00\u81f4\u65f6\uff0c\u8bf7\u786e\u4fdd\u7ef4\u5ea6\u6210\u5458\u4e0d\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            if (StringUtils.isEmpty((CharSequence)trgdimnumber)) {
                if (srcdimmemshow != null) continue;
                msg = ResManager.loadKDString((String)"\u5f53\u6e90\u7ef4\u5ea6\u4e0e\u76ee\u6807\u7ef4\u5ea6\u4e0d\u4e00\u81f4\u65f6\uff0c\u8bf7\u786e\u4fdd\u7ef4\u5ea6\u6210\u5458\u4e0d\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            if (srcdimmemshow == null) {
                if (trgdimmemshow == null) continue;
                msg = ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u4e3a\u7a7a\uff0c\u76ee\u6807\u7ef4\u5ea6\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                break;
            }
            if (trgdimmemshow != null) continue;
            msg = ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u76ee\u6807\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            break;
        }
        return msg;
    }

    private void setMemAndViewId(DynamicObject dimEntity, DynamicObject dimmemshow, String dimnumber, Long modelId, String dimmemnumberstr, String dimviewstr) {
        DimensionViewServiceHelper viewInstance = DimensionViewServiceHelper.getInstance();
        if (dimmemshow != null) {
            dimEntity.set(dimmemnumberstr, (Object)dimmemshow.getString("number"));
            if (SysDimensionEnum.ChangeType.getNumber().equals(dimnumber)) {
                Long id = viewInstance.getChangeTypeViewId(Long.valueOf(dimmemshow.getLong("id")));
                dimEntity.set(dimviewstr, (Object)id);
            }
        } else {
            dimEntity.set(dimmemnumberstr, null);
            if (SysDimensionEnum.ChangeType.getNumber().equals(dimnumber)) {
                Long id = viewInstance.queryBaseViewIdByNumber(modelId, dimnumber);
                dimEntity.set(dimviewstr, (Object)id);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }

    private void checkBusModelIsExist() {
        Long srcbusmodelid = IDUtils.toLong((Object)this.getPageCache().get("srcbusmodelid"));
        Long trgbusmodelid = IDUtils.toLong((Object)this.getPageCache().get("trgbusmodelid"));
        DynamicObject srcObject = this.uploadInstance.busModelIsExit(srcbusmodelid);
        DynamicObject trgObject = this.uploadInstance.busModelIsExit(trgbusmodelid);
        if (srcObject == null && trgObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u4e1a\u52a1\u6a21\u578b\u548c\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u5df2\u5220\u9664\u3002", (String)"EbDataUploadSchemeEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (srcObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u4e1a\u52a1\u6a21\u578b\u5df2\u5220\u9664\u3002", (String)"EbDataUploadSchemeEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (trgObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u5df2\u5220\u9664\u3002", (String)"EbDataUploadSchemeEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkDimIsExist() {
        String numberNew;
        int i;
        DynamicObject newValue;
        String srcDims = this.getPageCache().get("srcDimsCache");
        String trgDims = this.getPageCache().get("trgDimsCache");
        String srcbusmodelid = this.getPageCache().get("srcbusmodelid");
        String trgbusmodelid = this.getPageCache().get("trgbusmodelid");
        DynamicObjectCollection srcDimAllDel = this.getDimsDel(srcDims, srcbusmodelid);
        DynamicObjectCollection trgDimAllDel = this.getDimsDel(trgDims, trgbusmodelid);
        StringBuilder sbSrc = new StringBuilder();
        StringBuilder sbTrg = new StringBuilder();
        if (srcDimAllDel != null && srcDimAllDel.size() > 0) {
            newValue = (DynamicObject)this.getModel().getValue("srcbusinessmodel");
            this.srcBusModelProChange(newValue);
            sbSrc.append(ResManager.loadKDString((String)"\u6e90\u4e1a\u52a1\u6a21\u578b\u4e2d\u7684\u7f16\u7801\u4e3a\uff1a", (String)"EbDataUploadSchemeEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            for (i = 0; i < srcDimAllDel.size(); ++i) {
                if (i == srcDimAllDel.size() - 1) {
                    sbSrc.append(((DynamicObject)srcDimAllDel.get(i)).getString("number"));
                    continue;
                }
                numberNew = ((DynamicObject)srcDimAllDel.get(i)).getString("number") + ",";
                sbSrc.append(numberNew);
            }
            sbSrc.append(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"EbDataUploadSchemeEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (trgDimAllDel != null && trgDimAllDel.size() > 0) {
            newValue = (DynamicObject)this.getModel().getValue("trgbusinessmodel");
            this.trgBusModelProChange(newValue);
            sbTrg.append(ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4e2d\u7684\u7f16\u7801\u4e3a\uff1a", (String)"EbDataUploadSchemeEditPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            for (i = 0; i < trgDimAllDel.size(); ++i) {
                if (i == trgDimAllDel.size() - 1) {
                    sbTrg.append(((DynamicObject)trgDimAllDel.get(i)).getString("number"));
                    continue;
                }
                numberNew = ((DynamicObject)trgDimAllDel.get(i)).getString("number") + ",";
                sbTrg.append(numberNew);
            }
            sbTrg.append(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"EbDataUploadSchemeEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String str = "";
        if (sbSrc != null && sbSrc.length() > 0) {
            str = sbSrc.toString();
        }
        if (sbTrg != null && sbTrg.length() > 0) {
            String s = sbTrg.toString();
            str = str + s;
        }
        if (sbSrc != null && sbSrc.length() > 0 || sbTrg != null && sbTrg.length() > 0) {
            this.queryAccountByBizModel();
            this.setEnable();
            this.getView().showErrorNotification(ResManager.loadKDString((String)str, (String)"EbDataUploadSchemeEditPlugin_13", (String)"EbDataUploadSchemeEditPlugin_16", (Object[])new Object[0]));
            return;
        }
    }

    public DynamicObjectCollection getDimsDel(String dims, String busmodelid) {
        if (StringUtils.isNotEmpty((CharSequence)dims)) {
            List dimSet = (List)SerializationUtils.deSerializeFromBase64((String)dims);
            Set dimSetExit = this.instance.queryDimIdByBizModelId(Long.valueOf(busmodelid));
            ArrayList<Long> dimDel = new ArrayList<Long>(16);
            for (Long dim : dimSet) {
                boolean contains = dimSetExit.contains(dim);
                if (contains) continue;
                dimDel.add(dim);
            }
            QFilter qf1 = new QFilter("id", "in", dimDel);
            return QueryServiceHelper.query((String)"epm_dimension", (String)"id, number, name", (QFilter[])new QFilter[]{qf1});
        }
        return null;
    }

    private void setEntity(List<Long> dims, Set<Long> dimSet, Long busmodelid, String dimKind) {
        this.getModel().deleteEntryData("entryentity");
        Map<Long, DynamicObject> dimMap = this.getDimMap(dimSet);
        Map viewIds = this.instance.getViewIds(busmodelid, dimSet);
        String model = this.getPageCache().get("model");
        DynamicObjectCollection dynamicObjects = DimensionServiceHelper.queryDimensionByIds((Long)Long.valueOf(model), dims, (String)"id, name, number, issysdimension, dseq");
        this.getModel().beginInit();
        int i = 0;
        for (DynamicObject dy : dynamicObjects) {
            DynamicObject query = dimMap.get(dy.getLong("id"));
            if (query != null) {
                Long viewId;
                int newEntryRow = this.getModel().createNewEntryRow("entryentity");
                String dimtitle = query.getString("name");
                String dimnumber = query.getString("number");
                if ("srcdimmemnumber".equals(dimKind)) {
                    this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("srcdimtext", (Object)dimtitle);
                    this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("srcdimnumber", (Object)dimnumber);
                    this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("srcdimmembertype", (Object)query.getString("membermodel"));
                    if (viewIds != null) {
                        viewId = (Long)viewIds.get(dy.getLong("id"));
                        this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("srcdimview", (Object)viewId);
                    }
                } else {
                    this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("trgdimtext", (Object)dimtitle);
                    this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("trgdimnumber", (Object)dimnumber);
                    this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("trgdimmembertype", (Object)query.getString("membermodel"));
                    if (viewIds != null) {
                        viewId = (Long)viewIds.get(dy.getLong("id"));
                        this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("trgdimview", (Object)viewId);
                    }
                }
            }
            ++i;
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"fs_taskinfo"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"number"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IDataModel model = this.getModel();
        Long modelId = IDUtils.toLong(customParams.get("model"));
        this.getPageCache().put("model", String.valueOf(modelId));
        model.setValue("model", (Object)modelId);
        List dynamicObjects = DimensionServiceHelper.queryAllDim((Long)modelId, (String)"id, name, number, membermodel");
        HashMap<String, DynamicObject> dimsAll = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dy : dynamicObjects) {
            dimsAll.put(dy.getString("number"), dy);
        }
        this.queryBperiodOrderByNumber();
        this.getPageCache().put("dimsAll", SerializationUtils.serializeToBase64(dimsAll));
        Object operationStatus = customParams.get("operationStatus");
        if (operationStatus != null) {
            String operationToString = operationStatus.toString();
            this.getPageCache().put("operationStatus", operationToString);
            if ("copy".equals(operationToString)) {
                Long schemeId = IDUtils.toLong(customParams.get("schemeId"));
                DynamicObject dataSchemeById = this.uploadInstance.querySchemeById(schemeId, modelId);
                if (dataSchemeById == null) {
                    return;
                }
                String state = dataSchemeById.getString("state");
                if ("true".equals(state)) {
                    this.getPageCache().put("copyStatus", "1");
                }
                this.getModel().setValue("taskstatus", dataSchemeById.get("taskstatus"));
                this.getModel().setValue("state", (Object)dataSchemeById.getString("state"));
                this.getModel().setValue("enable", dataSchemeById.get("enable"));
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent f7) {
        String key;
        switch (key = ((BasedataEdit)f7.getSource()).getKey()) {
            case "srcbusinessmodel": {
                this.setF7Filter(f7, "srcbusinessmodel");
                break;
            }
            case "trgbusinessmodel": {
                this.setF7Filter(f7, "trgbusinessmodel");
                break;
            }
            case "srcaccount": {
                this.setF7FilterOfAccount(f7, "srcbusinessmodel");
                break;
            }
            case "trgaccount": {
                this.setF7FilterOfAccount(f7, "trgbusinessmodel");
                break;
            }
            case "startdate": {
                this.setF7Filter(f7, "startdate");
                break;
            }
            case "enddate": {
                this.setF7Filter(f7, "enddate");
                break;
            }
            case "srcdimmemshow": {
                this.setF7Filter(f7, "srcdimmemshow");
                break;
            }
            case "trgdimmemshow": {
                this.setF7Filter(f7, "trgdimmemshow");
                break;
            }
        }
    }

    private void addBeforeF7SelectListeners(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void setF7Filter(BeforeF7SelectEvent f7, String actionId) {
        MemberF7Parameter f7Param;
        String key = ((BasedataEdit)f7.getSource()).getKey();
        ListShowParameter showParameter = (ListShowParameter)f7.getFormShowParameter();
        List qFilterList = showParameter.getListFilterParameter().getQFilters();
        String model = this.getPageCache().get("model");
        qFilterList.add(new QFilter("model", "=", (Object)IDUtils.toLong((Object)model)));
        if ("srcbusinessmodel".equals(key) || "trgbusinessmodel".equals(key)) {
            return;
        }
        Long modelId = IDUtils.toLong((Object)model);
        String dimNumber = "";
        Tab tab = (Tab)this.getControl("tabap1");
        String currentTab = tab.getCurrentTab();
        if ("tabpage_ebaccountmapping".equals(currentTab)) {
            dimNumber = SysDimensionEnum.BudgetPeriod.getNumber();
            f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        } else {
            IModelCacheHelper modelCacheHelper;
            Member ebChangesMember;
            EntryGrid control = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = control.getSelectRows();
            if (selectRows.length <= 0 || selectRows[0] < 0) {
                return;
            }
            int index = selectRows[0];
            String srcDimNumber = this.getModel().getEntryRowEntity("entryentity", index).getString("srcdimnumber");
            String trgDimNumber = this.getModel().getEntryRowEntity("entryentity", index).getString("trgdimnumber");
            dimNumber = srcDimNumber;
            if ("trgdimmemshow".equals(actionId)) {
                dimNumber = trgDimNumber;
            }
            f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            String changeTypeNumber = SysDimensionEnum.ChangeType.getNumber();
            if ((changeTypeNumber.equals(srcDimNumber) && "srcdimmemshow".equals(key) || changeTypeNumber.equals(trgDimNumber) && "trgdimmemshow".equals(key)) && (ebChangesMember = (modelCacheHelper = ModelCacheContext.getOrCreate((Long)IDUtils.toLong((Object)model))).getMember(changeTypeNumber, null, "EBChanges")) != null) {
                List allMemberNumber = ebChangesMember.getAllMembers().stream().map(BaseCache::getNumber).collect(Collectors.toList());
                QFilter filter3 = new QFilter("number", "not in", allMemberNumber);
                f7Param.addCustomFilter(filter3);
            }
            if ("srcdimmemshow".equals(key)) {
                String srcdimview = this.getModel().getEntryRowEntity("entryentity", index).getString("srcdimview");
                if (StringUtils.isEmpty((CharSequence)srcdimview)) {
                    srcdimview = "0";
                }
                boolean isLeaf = "Entity".equals(this.getCurrentDimNumber(key));
                f7Param.setOnlySelLeaf(isLeaf);
                DynamicObject srcdc = (DynamicObject)this.getModel().getValue("srcbusinessmodel");
                if (srcdc != null) {
                    f7Param.setBusModelId(Long.valueOf(srcdc.getLong("id")));
                }
                f7Param.setViewId(Long.valueOf(Long.parseLong(srcdimview)));
            } else if ("trgdimmemshow".equals(key)) {
                DynamicObject trgdc;
                String trgdimview = this.getModel().getEntryRowEntity("entryentity", index).getString("trgdimview");
                if (StringUtils.isEmpty((CharSequence)trgdimview)) {
                    trgdimview = "0";
                }
                if ((trgdc = (DynamicObject)this.getModel().getValue("trgbusinessmodel")) != null) {
                    f7Param.setBusModelId(Long.valueOf(trgdc.getLong("id")));
                }
                f7Param.setOnlySelLeaf(true);
                f7Param.setViewId(Long.valueOf(Long.parseLong(trgdimview)));
            }
        }
        if ("startdate".equals(key) || "enddate".equals(key)) {
            f7Param.setOnlySelLeaf(true);
        }
        f7Param.setEnableView(true);
        NewF7Utils.openF7((BeforeF7SelectEvent)f7, (MemberF7Parameter)f7Param);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        this.getPageCache().put("dataChange", "true");
        switch (fieldKey) {
            case "srcbusinessmodel": {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.srcBusModelProChange(newValue);
                this.setEnable();
                if (this.getModel().getValue("trgbusinessmodel") == null) break;
                this.queryAccountByBizModel();
                break;
            }
            case "trgbusinessmodel": {
                DynamicObject newValue2 = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.trgBusModelProChange(newValue2);
                this.setEnable();
                if (this.getModel().getValue("srcbusinessmodel") != null) {
                    this.queryAccountByBizModel();
                }
                this.getModel().setValue("orgtext", (Object)"");
                this.getModel().setValue("periodtext", (Object)"");
                this.getModel().setValue("org", (Object)"");
                this.getModel().setValue("period", (Object)"");
                break;
            }
            case "taskstatus": {
                Boolean newValue3 = (Boolean)e.getChangeSet()[0].getNewValue();
                if (newValue3.booleanValue()) {
                    TextEdit orgtext = (TextEdit)this.getControl("orgtext");
                    orgtext.setMustInput(true);
                    TextEdit periodtext = (TextEdit)this.getControl("periodtext");
                    periodtext.setMustInput(true);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"fs_taskinfo"});
                    break;
                }
                TextEdit orgtext = (TextEdit)this.getControl("orgtext");
                orgtext.setMustInput(false);
                TextEdit periodtext = (TextEdit)this.getControl("periodtext");
                periodtext.setMustInput(false);
                this.getModel().setValue("orgtext", (Object)"");
                this.getModel().setValue("periodtext", (Object)"");
                this.getModel().setValue("org", (Object)"");
                this.getModel().setValue("period", (Object)"");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"fs_taskinfo"});
                break;
            }
            case "orgtext": {
                String newValue4 = (String)e.getChangeSet()[0].getNewValue();
                if (!StringUtils.isEmpty((CharSequence)newValue4)) break;
                this.getModel().setValue("org", (Object)"");
                break;
            }
            case "periodtext": {
                String newValue5 = (String)e.getChangeSet()[0].getNewValue();
                if (!StringUtils.isEmpty((CharSequence)newValue5)) break;
                this.getModel().setValue("period", (Object)"");
                break;
            }
        }
    }

    private void setEnable() {
        DynamicObjectCollection dy1 = this.getModel().getEntryEntity("entryentity");
        int i = 0;
        ArrayList<Integer> st = new ArrayList<Integer>(16);
        int k = 0;
        for (DynamicObject dd : dy1) {
            if (StringUtils.isEmpty((CharSequence)dd.getString("trgdimnumber")) && StringUtils.isEmpty((CharSequence)dd.getString("srcdimnumber"))) {
                st.add(i);
                ++k;
            }
            ++i;
        }
        int[] y = new int[st.size()];
        for (int c = 0; c < st.size(); ++c) {
            y[c] = (Integer)st.get(c);
        }
        this.getModel().deleteEntryRows("entryentity", y);
        this.getView().updateView("entryentity");
        DynamicObjectCollection dy2 = this.getModel().getEntryEntity("entryentity");
        for (int j = 0; j < dy2.size(); ++j) {
            if (StringUtils.isEmpty((CharSequence)((DynamicObject)dy2.get(j)).getString("srcdimnumber"))) {
                this.getView().setEnable(Boolean.FALSE, j, new String[]{"srcdimmemshow"});
            } else {
                this.getView().setEnable(Boolean.TRUE, j, new String[]{"srcdimmemshow"});
            }
            if (StringUtils.isEmpty((CharSequence)((DynamicObject)dy2.get(j)).getString("trgdimnumber"))) {
                this.getView().setEnable(Boolean.FALSE, j, new String[]{"trgdimmemshow"});
                continue;
            }
            this.getView().setEnable(Boolean.TRUE, j, new String[]{"trgdimmemshow"});
        }
    }

    private void haveDataSet(Long busmodelid) {
        List dataSetIds = this.instance.queryDataSetIds(busmodelid);
        if (dataSetIds == null || dataSetIds.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u4e1a\u52a1\u6a21\u578b\u4e0b\u65e0\u5173\u8054\u7684\u6570\u636e\u96c6\uff0c\u53ef\u5728\u6b64\u4e1a\u52a1\u6a21\u578b\u4e0b\u6dfb\u52a0\u6570\u636e\u96c6\u3002", (String)"EbDataUploadSchemeEditPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void srcBusModelProChange(DynamicObject newValue) {
        if (newValue != null) {
            DynamicObjectCollection accountEntrys = this.getModel().getEntryEntity("accountentryentity");
            if (accountEntrys != null && accountEntrys.size() > 0) {
                for (DynamicObject dy : accountEntrys) {
                    dy.set("srcaccount", null);
                }
            }
            String srcbusmodelname = newValue.getString("name");
            Long srcbusmodelId = newValue.getLong("id");
            DynamicObject trg = (DynamicObject)this.getModel().getValue("trgbusinessmodel");
            this.haveDataSet(srcbusmodelId);
            DynamicObjectCollection dyList = this.getModel().getEntryEntity("entryentity");
            if (trg != null) {
                String trgbusmodelname = trg.getString("name");
                if (trgbusmodelname.equals(srcbusmodelname)) {
                    for (DynamicObject dy : dyList) {
                        dy.set("srcdimview", null);
                        dy.set("srcdimnumber", null);
                        dy.set("srcdimtext", null);
                        dy.set("srcdimmemshow", null);
                        dy.set("srcdimmembertype", null);
                    }
                    this.getModel().setValue("srcbusinessmodel", null);
                    this.getView().updateView("entryentity");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4e0d\u5141\u8bb8\u4e0e\u6e90\u4e1a\u52a1\u6a21\u578b\u76f8\u540c\u3002", (String)"EbDataUploadSchemeEditPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().getModel().setValue("name", (Object)(srcbusmodelname + "-" + trgbusmodelname));
            }
            Set srcDims = this.instance.queryDimIdByBizModelId(srcbusmodelId);
            Map<Long, DynamicObject> dimMap = this.getDimMap(srcDims);
            Map viewIds = this.instance.getViewIds(srcbusmodelId, srcDims);
            this.getPageCache().put("srcbusmodelid", srcbusmodelId.toString());
            ArrayList<Long> srcDimsCache = new ArrayList<Long>(16);
            for (Long srcDim : srcDims) {
                DynamicObject query = dimMap.get(srcDim);
                if (query == null) continue;
                String number = query.getString("number");
                if (SysDimensionEnum.Entity.getNumber().equals(number) || SysDimensionEnum.BudgetPeriod.getNumber().equals(number) || SysDimensionEnum.Metric.getNumber().equals(number) || SysDimensionEnum.Account.getNumber().equals(number)) continue;
                srcDimsCache.add(srcDim);
            }
            this.getPageCache().put("srcDimsCache", SerializationUtils.serializeToBase64(srcDimsCache));
            if (this.getModel().getEntryEntity("entryentity").size() == 0 || trg == null) {
                this.setEntity(srcDimsCache, srcDims, srcbusmodelId, "srcdimmemnumber");
            } else {
                ArrayList<String> numList = new ArrayList<String>(16);
                for (DynamicObject dy : dyList) {
                    dy.set("srcdimview", null);
                    dy.set("srcdimnumber", null);
                    dy.set("srcdimtext", null);
                    dy.set("srcdimmemshow", null);
                    dy.set("srcdimmembertype", null);
                    numList.add(dy.getString("trgdimnumber"));
                }
                this.getModel().beginInit();
                block4: for (Long srcDim : srcDimsCache) {
                    DynamicObject query = dimMap.get(srcDim);
                    if (query == null) continue;
                    String srcdimtitle = query.getString("name");
                    for (int i = 0; i < dyList.size(); ++i) {
                        String trgdimnumber = ((DynamicObject)dyList.get(i)).getString("trgdimnumber");
                        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", i);
                        String srcdimnumber = query.getString("number");
                        if (numList.contains(srcdimnumber)) {
                            if (!trgdimnumber.equals(srcdimnumber)) continue;
                            String trgdimnumber1 = entryRowEntity.getString("trgdimnumber");
                            String trgdimtext = entryRowEntity.getString("trgdimtext");
                            String trgdimview = entryRowEntity.getString("trgdimview");
                            String trgdimmembertype = entryRowEntity.getString("trgdimmembertype");
                            DynamicObject trgdimmemshow = (DynamicObject)entryRowEntity.get("trgdimmemshow");
                            entryRowEntity.set("trgdimnumber", (Object)trgdimnumber);
                            entryRowEntity.set("trgdimtext", (Object)trgdimtext);
                            entryRowEntity.set("trgdimmemshow", (Object)trgdimmemshow);
                            entryRowEntity.set("trgdimview", (Object)trgdimview);
                            entryRowEntity.set("trgdimmembertype", (Object)trgdimmembertype);
                            entryRowEntity.set("srcdimnumber", (Object)trgdimnumber1);
                            entryRowEntity.set("srcdimmembertype", (Object)query.getString("membermodel"));
                            entryRowEntity.set("srcdimtext", (Object)srcdimtitle);
                            if (viewIds == null) continue block4;
                            Long viewId = (Long)viewIds.get(srcDim);
                            this.getModel().getEntryRowEntity("entryentity", i).set("srcdimview", (Object)viewId);
                            continue block4;
                        }
                        int newEntryRow = this.getModel().createNewEntryRow("entryentity");
                        this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("srcdimtext", (Object)srcdimtitle);
                        this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("srcdimnumber", (Object)srcdimnumber);
                        this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("srcdimmembertype", (Object)query.getString("membermodel"));
                        if (viewIds == null) continue block4;
                        Long viewId = (Long)viewIds.get(srcDim);
                        this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("srcdimview", (Object)viewId);
                        continue block4;
                    }
                }
                this.getView().updateView("entryentity");
                this.getView().updateView("accountentryentity");
            }
        }
    }

    private Map<Long, DynamicObject> getDimMap(Set<Long> dims) {
        Long[] dimensionIds = new Long[dims.size()];
        int dimIndex = 0;
        Iterator<Long> iterator = dims.iterator();
        while (iterator.hasNext()) {
            Long Dim;
            dimensionIds[dimIndex] = Dim = iterator.next();
            ++dimIndex;
        }
        String selectFields = "id, name, number, membermodel";
        DynamicObjectCollection dimensionList = DimensionServiceHelper.queryDimensionByIds((Long)Long.valueOf(this.getPageCache().get("model")), (Long[])dimensionIds, (String)selectFields);
        HashMap<Long, DynamicObject> dimensionMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dy : dimensionList) {
            dimensionMap.put(dy.getLong("id"), dy);
        }
        return dimensionMap;
    }

    private void trgBusModelProChange(DynamicObject newValue) {
        if (newValue != null) {
            String srcbusmodelname;
            DynamicObjectCollection accountEntrys = this.getModel().getEntryEntity("accountentryentity");
            if (accountEntrys != null && accountEntrys.size() > 0) {
                for (DynamicObject dy : accountEntrys) {
                    dy.set("trgaccount", null);
                }
            }
            String trgbusmodelname = newValue.getString("name");
            Long trgbusmodelid = newValue.getLong("id");
            DynamicObject src = (DynamicObject)this.getModel().getValue("srcbusinessmodel");
            this.haveDataSet(trgbusmodelid);
            DynamicObjectCollection dyList = this.getModel().getEntryEntity("entryentity");
            if (src != null && (srcbusmodelname = src.getString("name")).equals(trgbusmodelname)) {
                for (DynamicObject entryRowEntity : dyList) {
                    entryRowEntity.set("trgdimview", null);
                    entryRowEntity.set("trgdimnumber", null);
                    entryRowEntity.set("trgdimtext", null);
                    entryRowEntity.set("trgdimmemshow", null);
                    entryRowEntity.set("trgdimmembertype", null);
                }
                this.getModel().setValue("trgbusinessmodel", null);
                this.getView().updateView("entryentity");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u4e0d\u5141\u8bb8\u4e0e\u6e90\u4e1a\u52a1\u6a21\u578b\u76f8\u540c\u3002", (String)"EbDataUploadSchemeEditPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Set trgDims = this.instance.queryDimIdByBizModelId(trgbusmodelid);
            Map<Long, DynamicObject> dimMap = this.getDimMap(trgDims);
            Map viewIds = this.instance.getViewIds(trgbusmodelid, trgDims);
            this.getPageCache().put("trgbusmodelid", String.valueOf(trgbusmodelid));
            this.getPageCache().put("trgDims", SerializationUtils.serializeToBase64((Object)trgDims));
            ArrayList<Long> trgDimsCache = new ArrayList<Long>(16);
            for (Long trgDim : trgDims) {
                DynamicObject query = dimMap.get(trgDim);
                if (query == null) continue;
                String number = query.getString("number");
                if (SysDimensionEnum.Entity.getNumber().equals(number) || SysDimensionEnum.BudgetPeriod.getNumber().equals(number) || SysDimensionEnum.Metric.getNumber().equals(number) || SysDimensionEnum.Account.getNumber().equals(number)) continue;
                trgDimsCache.add(trgDim);
            }
            this.getPageCache().put("trgDimsCache", SerializationUtils.serializeToBase64(trgDimsCache));
            if (this.getModel().getEntryEntity("entryentity").size() == 0 || src == null) {
                this.setEntity(trgDimsCache, trgDims, trgbusmodelid, "trgdimmemnumber");
            } else {
                ArrayList<String> numList = new ArrayList<String>(16);
                for (DynamicObject entryRowEntity : dyList) {
                    entryRowEntity.set("trgdimview", null);
                    entryRowEntity.set("trgdimnumber", null);
                    entryRowEntity.set("trgdimtext", null);
                    entryRowEntity.set("trgdimmemshow", null);
                    entryRowEntity.set("trgdimmembertype", null);
                    numList.add(entryRowEntity.getString("srcdimnumber"));
                }
                this.getModel().beginInit();
                block4: for (Long trgDim : trgDimsCache) {
                    DynamicObject query = dimMap.get(trgDim);
                    if (query == null) continue;
                    String trgdimtitle = query.getString("name");
                    for (int i = 0; i < dyList.size(); ++i) {
                        String srcdimnumber = ((DynamicObject)dyList.get(i)).getString("srcdimnumber");
                        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", i);
                        String trgdimnumber = query.getString("number");
                        if (numList.contains(trgdimnumber)) {
                            if (!srcdimnumber.equals(trgdimnumber)) continue;
                            String srcdimnumber1 = entryRowEntity.getString("srcdimnumber");
                            String srcdimtext = entryRowEntity.getString("srcdimtext");
                            String srcdimview = entryRowEntity.getString("srcdimview");
                            DynamicObject srcdimmemshow = (DynamicObject)entryRowEntity.get("srcdimmemshow");
                            String srcdimmembertype = entryRowEntity.getString("srcdimmembertype");
                            entryRowEntity.set("srcdimnumber", (Object)srcdimnumber1);
                            entryRowEntity.set("srcdimtext", (Object)srcdimtext);
                            entryRowEntity.set("srcdimview", (Object)srcdimview);
                            entryRowEntity.set("srcdimmemshow", (Object)srcdimmemshow);
                            entryRowEntity.set("srcdimmembertype", (Object)srcdimmembertype);
                            entryRowEntity.set("trgdimtext", (Object)trgdimtitle);
                            entryRowEntity.set("trgdimnumber", (Object)trgdimnumber);
                            entryRowEntity.set("trgdimmembertype", (Object)query.getString("membermodel"));
                            if (viewIds == null) continue block4;
                            Long viewId = (Long)viewIds.get(trgDim);
                            this.getModel().getEntryRowEntity("entryentity", i).set("trgdimview", (Object)viewId);
                            continue block4;
                        }
                        int newEntryRow = this.getModel().createNewEntryRow("entryentity");
                        this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("trgdimtext", (Object)trgdimtitle);
                        this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("trgdimnumber", (Object)trgdimnumber);
                        this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("trgdimmembertype", (Object)query.getString("membermodel"));
                        if (viewIds == null) continue block4;
                        Long viewId = (Long)viewIds.get(trgDim);
                        this.getModel().getEntryRowEntity("entryentity", newEntryRow).set("trgdimview", (Object)viewId);
                        continue block4;
                    }
                }
                this.getView().updateView("entryentity");
                this.getView().updateView("accountentryentity");
            }
        }
    }

    public List<Long> queryDataSetIds(Long bizModelId) {
        LinkedList<Long> datasetIds = new LinkedList<Long>();
        if (bizModelId == null || bizModelId == 0L) {
            return datasetIds;
        }
        QFilter filter = new QFilter("businessmodel", "=", (Object)bizModelId);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"eb_dataset", (String)"id", (QFilter[])new QFilter[]{filter});
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject dc : dcs) {
                datasetIds.add(dc.getLong("id"));
            }
        }
        return datasetIds;
    }

    private DynamicObjectCollection queryDataSetAccount(Long bizModelId) {
        List<Long> accounts = this.queryDataSetIds(bizModelId);
        if (accounts == null || accounts.size() == 0) {
            return null;
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        QFilter filter = new QFilter("dataset", "in", accounts);
        qFilterList.add(filter);
        return QueryServiceHelper.query((String)"epm_accountmembertree", (String)"id,name,number,parent", (QFilter[])qFilterList.toArray(new QFilter[0]));
    }

    private boolean isAlreadySeleBizModel() {
        boolean isSelect = true;
        Object bizModel1 = this.getModel().getValue("srcbusinessmodel");
        Object bizModel2 = this.getModel().getValue("trgbusinessmodel");
        if (bizModel1 == null && bizModel2 == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u4e1a\u52a1\u6a21\u578b\u548c\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u3002", (String)"EbDataUploadSchemeEditPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            isSelect = false;
        } else if (bizModel1 == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u4e1a\u52a1\u6a21\u578b\u3002", (String)"EbDataUploadSchemeEditPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            isSelect = false;
        } else if (bizModel2 == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u4e1a\u52a1\u6a21\u578b\u3002", (String)"EbDataUploadSchemeEditPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            isSelect = false;
        } else {
            return isSelect;
        }
        return isSelect;
    }

    private void setF7FilterOfAccount(BeforeF7SelectEvent f7, String bizModelFlag) {
        DynamicObject dc = (DynamicObject)this.getModel().getValue(bizModelFlag);
        if (dc == null) {
            return;
        }
        List<Long> accounts = this.queryDataSetIds(dc.getLong("id"));
        if (accounts == null || accounts.size() == 0) {
            return;
        }
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Account.getNumber()), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(dc.getLong("id")));
        f7Param.setDatasetIds(accounts);
        String key = f7.getProperty().getName();
        if (!"srcaccount".equals(key) && "trgaccount".equals(key)) {
            f7Param.setOnlySelLeaf(true);
        }
        NewF7Utils.openF7((BeforeF7SelectEvent)f7, (MemberF7Parameter)f7Param);
    }

    @Override
    public Long getModelId() {
        return ((DynamicObject)this.getModel().getValue("model")).getLong("id");
    }

    public String getCurrentDimNumber(String controlKey) {
        EntryGrid control = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = control.getSelectRows();
        switch (controlKey) {
            case "srcaccount": 
            case "trgaccount": {
                return "Account";
            }
            case "startdate": 
            case "enddate": {
                return "BudgetPeriod";
            }
            case "srcdimmemshow": {
                int index = selectRows[0];
                return this.getModel().getEntryRowEntity("entryentity", index).getString("srcdimnumber");
            }
            case "trgdimmemshow": {
                int index = selectRows[0];
                return this.getModel().getEntryRowEntity("entryentity", index).getString("trgdimnumber");
            }
        }
        return null;
    }

    private void newAddAccountRow() {
        this.getModel().beginInit();
        int newEntryRow = this.getModel().createNewEntryRow("accountentryentity");
        this.getModel().getEntryRowEntity("accountentryentity", newEntryRow).set("entrystatus", (Object)"0");
        String bpDyCache = this.getPageCache().get("bpDyCache");
        if (bpDyCache != null) {
            List bp = (List)SerializationUtils.deSerializeFromBase64((String)bpDyCache);
            this.getModel().setValue("startdate", (Object)((DynamicObject)bp.get(0)).getString("id"), newEntryRow);
        }
        this.getModel().endInit();
        this.getView().updateView("accountentryentity");
    }

    private boolean checkAccount() {
        boolean isRignt = true;
        Map accountNumberMap = this.queryAccountDataByBizModel();
        int count = this.getModel().getEntryRowCount("accountentryentity");
        String bPeriodMapCache = this.getPageCache().get("bPeriodMapCache");
        Map bpMap = (Map)SerializationUtils.deSerializeFromBase64((String)bPeriodMapCache);
        String msg = "";
        if (count == 1) {
            DynamicObject IsrcAccount = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", 0).get("srcaccount");
            DynamicObject ItrgAccount = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", 0).get("trgaccount");
            String IsrcStartData = null;
            DynamicObject IsrcStartDataDy = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", 0).get("startdate");
            DynamicObject obEndDate = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", 0).get("enddate");
            String ItrgEndDate = null;
            if (ItrgAccount == null) {
                msg = ResManager.loadKDString((String)"\u76ee\u6807\u79d1\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                isRignt = false;
            }
            if (IsrcAccount == null) {
                msg = ResManager.loadKDString((String)"\u6e90\u79d1\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                isRignt = false;
            }
            if (IsrcStartDataDy == null) {
                msg = ResManager.loadKDString((String)"\u751f\u6548\u8d77\u59cb\u671f\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                isRignt = false;
            }
            if (IsrcStartDataDy != null) {
                IsrcStartData = IsrcStartDataDy.getString("number");
            }
            if (obEndDate != null) {
                ItrgEndDate = obEndDate.getString("number");
            }
            Integer srcStartDate = (Integer)bpMap.get(IsrcStartData);
            Integer srcEndDate = null;
            if (ItrgEndDate != null) {
                srcEndDate = (Integer)bpMap.get(ItrgEndDate);
            }
            if (srcStartDate != null && srcEndDate != null && srcStartDate > srcEndDate) {
                msg = ResManager.loadKDString((String)"\u751f\u6548\u7ed3\u675f\u671f\u95f4\u9700\u5927\u4e8e\u7b49\u4e8e\u751f\u6548\u8d77\u59cb\u671f\u95f4\u3002", (String)"EbDataUploadSchemeEditPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                isRignt = false;
            }
        } else {
            block0: for (int i = 0; i < count - 1; ++i) {
                DynamicObject IsrcAccount = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", i).get("srcaccount");
                DynamicObject ItrgAccount = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", i).get("trgaccount");
                String IsrcStatus = this.getModel().getEntryRowEntity("accountentryentity", i).getString("entrystatus");
                DynamicObject srcStartdate = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", i).get("startdate");
                if (IsrcAccount == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u79d1\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    isRignt = false;
                    break;
                }
                if (ItrgAccount == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u79d1\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    isRignt = false;
                    break;
                }
                if (srcStartdate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u8d77\u59cb\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    isRignt = false;
                    break;
                }
                if (IsrcStatus == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (String)"EbDataUploadSchemeEditPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    isRignt = false;
                    break;
                }
                String IsrcAccountValue = IsrcAccount.getString("number");
                String ItrgAccountValue = ItrgAccount.getString("number");
                String IsrcStartData = null;
                DynamicObject IsrcStartDataDy = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", i).get("startdate");
                DynamicObject obEndDate = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", i).get("enddate");
                String ItrgEndDate = null;
                if (IsrcStartDataDy != null) {
                    IsrcStartData = IsrcStartDataDy.getString("number");
                }
                if (obEndDate != null) {
                    ItrgEndDate = obEndDate.getString("number");
                }
                Integer srcStartDate = (Integer)bpMap.get(IsrcStartData);
                Integer srcEndDate = null;
                if (ItrgEndDate != null) {
                    srcEndDate = (Integer)bpMap.get(ItrgEndDate);
                }
                if (srcStartDate != null && srcEndDate != null && srcStartDate > srcEndDate) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u7ed3\u675f\u671f\u95f4\u9700\u5927\u4e8e\u7b49\u4e8e\u751f\u6548\u8d77\u59cb\u671f\u95f4\u3002", (String)"EbDataUploadSchemeEditPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    isRignt = false;
                }
                boolean boolea1 = StringUtils.isEmpty((CharSequence)IsrcAccountValue);
                boolean loolea2 = StringUtils.isEmpty((CharSequence)ItrgAccountValue);
                if (!StringUtils.isEmpty((CharSequence)msg)) break;
                if (boolea1 && !loolea2) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u79d1\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    isRignt = false;
                    break;
                }
                if (!boolea1 && loolea2) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u79d1\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    isRignt = false;
                    break;
                }
                if (!isRignt) break;
                for (int j = i + 1; j < count; ++j) {
                    boolean boo6;
                    String JtrgAccountValue;
                    DynamicObject JsrcAccount = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", j).get("srcaccount");
                    DynamicObject JtrgAccount = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", j).get("trgaccount");
                    String JsrcStatus = this.getModel().getEntryRowEntity("accountentryentity", j).getString("entrystatus");
                    DynamicObject trgDateObject = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", j).get("startdate");
                    String JsrcAccountValue = JsrcAccount == null ? null : JsrcAccount.getString("number");
                    String string = JtrgAccountValue = JtrgAccount == null ? null : JtrgAccount.getString("number");
                    if (JsrcAccountValue == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u79d1\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        isRignt = false;
                        continue block0;
                    }
                    if (JtrgAccountValue == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u79d1\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        isRignt = false;
                        continue block0;
                    }
                    if (trgDateObject == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u8d77\u59cb\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        isRignt = false;
                        continue block0;
                    }
                    String JsrcStartData = null;
                    DynamicObject JsrcStartDataDy = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", j).get("startdate");
                    String JtrgEndDate = null;
                    String string2 = JsrcStartData = JsrcStartDataDy == null ? null : JsrcStartDataDy.getString("number");
                    if (trgDateObject == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u8d77\u59cb\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        isRignt = false;
                        continue block0;
                    }
                    if (JsrcStartData == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u8d77\u59cb\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"EbDataUploadSchemeEditPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        isRignt = false;
                        continue block0;
                    }
                    DynamicObject tdb = (DynamicObject)this.getModel().getEntryRowEntity("accountentryentity", j).get("enddate");
                    if (tdb != null) {
                        JtrgEndDate = tdb.getString("number");
                    }
                    Integer JstartDate = (Integer)bpMap.get(JsrcStartData);
                    Integer JEndDate = null;
                    if (JtrgEndDate != null) {
                        JEndDate = (Integer)bpMap.get(JtrgEndDate);
                    }
                    if (JstartDate != null && JEndDate != null && JstartDate > JEndDate) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u7ed3\u675f\u671f\u95f4\u9700\u5927\u4e8e\u7b49\u4e8e\u751f\u6548\u8d77\u59cb\u671f\u95f4\u3002", (String)"EbDataUploadSchemeEditPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        isRignt = false;
                    }
                    boolean boo2 = IsrcStatus.equals(JsrcStatus);
                    boolean boo4 = IsrcAccountValue.equals(JsrcAccountValue);
                    boolean boo5 = ItrgAccountValue.equals(JtrgAccountValue);
                    boolean bl = boo6 = accountNumberMap.get(IsrcAccountValue).equals(JsrcAccount.getString("id")) || IsrcAccount.getString("id").equals(accountNumberMap.get(JsrcAccountValue));
                    if (IsrcStartData == null) {
                        msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u751f\u6548\u8d77\u59cb\u65f6\u95f4\u3002", (String)"EbDataUploadSchemeEditPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                        isRignt = false;
                        continue block0;
                    }
                    if (boo2 && (boo4 || boo6)) {
                        String msginfo = ResManager.loadKDString((String)"\u540c\u4e00\u4f7f\u7528\u72b6\u6001\u4e0b\uff0c\u540c\u4e00\u6811\u7ea7\u6e90\u79d1\u76ee\u751f\u6548\u671f\u95f4\u4e0d\u80fd\u5b58\u5728\u4ea4\u53c9\u3002", (String)"EbDataUploadSchemeEditPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                        if (srcEndDate == null && JEndDate == null) {
                            msg = msginfo;
                            isRignt = false;
                            continue block0;
                        }
                        if (srcEndDate != null && JEndDate == null && srcEndDate >= JstartDate) {
                            msg = msginfo;
                            isRignt = false;
                            continue block0;
                        }
                        if (JEndDate != null && srcEndDate == null && JEndDate >= srcStartDate) {
                            msg = msginfo;
                            isRignt = false;
                            continue block0;
                        }
                        if (JEndDate != null && srcEndDate != null && JEndDate <= srcEndDate && JEndDate >= srcStartDate) {
                            msg = msginfo;
                            isRignt = false;
                            continue block0;
                        }
                        if (JEndDate == null || srcEndDate == null || srcEndDate > JEndDate || srcEndDate < JstartDate) continue;
                        msg = msginfo;
                        isRignt = false;
                        continue block0;
                    }
                    if (!boo2 || !boo5) continue;
                    String s = ResManager.loadKDString((String)"\u540c\u4e00\u4f7f\u7528\u72b6\u6001\u4e0b\uff0c\u76f8\u540c\u76ee\u6807\u79d1\u76ee\u7684\u751f\u6548\u671f\u95f4\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"EbDataUploadSchemeEditPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    if (srcEndDate == null && JEndDate == null) {
                        msg = s;
                        isRignt = false;
                        continue block0;
                    }
                    if (srcEndDate != null && JEndDate == null && srcEndDate >= JstartDate) {
                        msg = s;
                        isRignt = false;
                        continue block0;
                    }
                    if (JEndDate != null && srcEndDate == null && JEndDate >= srcStartDate) {
                        msg = s;
                        isRignt = false;
                        continue block0;
                    }
                    if (JEndDate != null && srcEndDate != null && JEndDate <= srcEndDate && JEndDate >= srcStartDate) {
                        msg = s;
                        isRignt = false;
                        continue block0;
                    }
                    if (JEndDate == null || srcEndDate == null || srcEndDate > JEndDate || srcEndDate < JstartDate) continue;
                    msg = s;
                    isRignt = false;
                    continue block0;
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.getView().showTipNotification(msg);
        }
        return isRignt;
    }

    private void queryBperiodOrderByNumber() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        HashMap<String, Object> bpMap = new HashMap<String, Object>(16);
        QFilter q1 = new QFilter("number", "=", (Object)"BudgetPeriod");
        QFilter q2 = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_dimension", (String)"id, number, name, model", (QFilter[])new QFilter[]{q1.and(q2)});
        if (query != null && query.size() > 0) {
            Long id = ((DynamicObject)query.get(0)).getLong("id");
            QFilter qf1 = new QFilter("dimension", "=", (Object)id);
            QFilter qf2 = new QFilter("isleaf", "=", (Object)"1");
            DynamicObjectCollection epm_bperiodmembertree = QueryServiceHelper.query((String)"epm_bperiodmembertree", (String)"number, id, name", (QFilter[])new QFilter[]{qf1.and(qf2)}, (String)"number asc");
            ArrayList<String> bpCache = new ArrayList<String>(16);
            ArrayList<Object> bpDyCache = new ArrayList<Object>(16);
            if (epm_bperiodmembertree != null && epm_bperiodmembertree.size() > 0) {
                for (int i = 0; i < epm_bperiodmembertree.size(); ++i) {
                    String number = ((DynamicObject)epm_bperiodmembertree.get(i)).getString("number");
                    if (number.endsWith("._inv")) continue;
                    map.put(number, i);
                    bpCache.add(number);
                    bpDyCache.add(epm_bperiodmembertree.get(i));
                    bpMap.put(number, epm_bperiodmembertree.get(i));
                }
            }
            this.getPageCache().put("bpDyCache", SerializationUtils.serializeToBase64(bpDyCache));
            this.getPageCache().put("BudgetPeriodCache", SerializationUtils.serializeToBase64(bpCache));
            this.getPageCache().put("bPeriodMapCache", SerializationUtils.serializeToBase64(map));
            this.getPageCache().put("bPMapCache", SerializationUtils.serializeToBase64(bpMap));
        }
    }

    private Map queryAccountDataByBizModel() {
        HashMap<String, String> accountNumberMap = new HashMap<String, String>(16);
        DynamicObject srcdc = (DynamicObject)this.getModel().getValue("srcbusinessmodel");
        Long srcBusinessModelId = Long.parseLong(srcdc.getString("id"));
        DynamicObject trgdc = (DynamicObject)this.getModel().getValue("trgbusinessmodel");
        Long trgBusinessModelId = Long.parseLong(trgdc.getString("id"));
        ArrayList<String> sourceAccountList = new ArrayList<String>(10);
        ArrayList<String> targetAccountList = new ArrayList<String>(10);
        DynamicObjectCollection srcBusiMods = this.queryDataSetAccount(srcBusinessModelId);
        DynamicObjectCollection trgBusiMods = this.queryDataSetAccount(trgBusinessModelId);
        for (DynamicObject dynamicObject : srcBusiMods) {
            accountNumberMap.put(dynamicObject.getString("number"), dynamicObject.getString("parent"));
            sourceAccountList.add(dynamicObject.getString("number"));
        }
        for (DynamicObject trgObject : trgBusiMods) {
            accountNumberMap.put(trgObject.getString("number"), trgObject.getString("parent"));
            targetAccountList.add(trgObject.getString("number"));
        }
        this.getPageCache().put("sourceAccountList", SerializationUtils.toJsonString(sourceAccountList));
        this.getPageCache().put("targetAccountList", SerializationUtils.toJsonString(targetAccountList));
        return accountNumberMap;
    }

    private void queryAccountByBizModel() {
        DynamicObject trgdc;
        ArrayList<String> sourceAccountList = new ArrayList<String>(10);
        ArrayList<String> targetAccountList = new ArrayList<String>(10);
        HashMap<String, String> map = new HashMap<String, String>(16);
        DynamicObject srcdc = (DynamicObject)this.getModel().getValue("srcbusinessmodel");
        if (srcdc != null) {
            Long srcBusinessModelId = Long.parseLong(srcdc.getString("id"));
            DynamicObjectCollection srcBusiMods = this.queryDataSetAccount(srcBusinessModelId);
            for (DynamicObject dynamicObject : srcBusiMods) {
                sourceAccountList.add(dynamicObject.getString("number"));
                map.put(dynamicObject.getString("number"), dynamicObject.getString("id"));
            }
        }
        if ((trgdc = (DynamicObject)this.getModel().getValue("trgbusinessmodel")) != null) {
            Long trgBusinessModelId = Long.parseLong(trgdc.getString("id"));
            DynamicObjectCollection trgBusiMods = this.queryDataSetAccount(trgBusinessModelId);
            for (DynamicObject trgObject : trgBusiMods) {
                targetAccountList.add(trgObject.getString("number"));
                map.put(trgObject.getString("number"), trgObject.getString("id"));
            }
        }
        this.getPageCache().put("sourceAccountList", SerializationUtils.toJsonString(sourceAccountList));
        this.getPageCache().put("targetAccountList", SerializationUtils.toJsonString(targetAccountList));
        this.getPageCache().put("numberIdCache", SerializationUtils.toJsonString(map));
    }

    private void deleteEntryRow() {
        EntryGrid eg = (EntryGrid)this.getControl("accountentryentity");
        int[] rows = eg.getSelectRows();
        ArrayList<Integer> allowDel = new ArrayList<Integer>(16);
        if (rows.length > 0) {
            for (int row : rows) {
                allowDel.add(row);
            }
            int[] dels = new int[allowDel.size()];
            int i = 0;
            for (Integer integer : allowDel) {
                dels[i] = integer;
                ++i;
            }
            this.getModel().deleteEntryRows("accountentryentity", dels);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"EbDataUploadSchemeEditPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c\u3002", (String)"EbDataUploadSchemeEditPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }
}

