/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataUpload;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.utils.DataUploadServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.model.utils.ModelUtil;

public class EbDataUploadSchemeListPlugin
extends AbstractListPlugin {
    private static final String BTN_REMOVE = "btn_remove";
    private static final String BTN_NEW = "btn_new";
    private static final String BTN_REFUSH = "btn_refush";
    private static final String BTN_DATAUPLOAD = "btn_dataupload";
    private static final String BTN_UPLOADLOGS = "btn_uploadlogs";
    private static final String BTN_COPYSCHEME = "btn_copyscheme";
    public static final String MODEL_COMBOITEMS = "MODEL_COMBOITEMS";
    private DataUploadServiceHelper instance = DataUploadServiceHelper.getInstance();

    public void initialize() {
        super.initialize();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        if (modelid == null) {
            return;
        }
        this.getPageCache().put("KEY_MODEL_ID", null);
        List commonFilterColumns = args.getCommonFilterColumns();
        CommonFilterColumn filterColumn = (CommonFilterColumn)commonFilterColumns.stream().filter(c -> c.getFieldName().equals("model.name")).findFirst().get();
        ArrayList modelQFilters = new ArrayList(16);
        modelQFilters.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"model", (String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[0]), null);
        filterColumn.getComboItems().clear();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        col.forEach(e -> comboItems.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id"))));
        filterColumn.setComboItems(comboItems);
        if (this.isExistModel(modelid)) {
            long count = comboItems.stream().filter(model -> model != null && modelid.equals(model.getValue())).count();
            if (count == 0L) {
                this.noModel(filterColumn, comboItems);
            } else {
                filterColumn.setDefaultValue(modelid);
                this.getPageCache().put("KEY_MODEL_ID", modelid);
            }
        } else {
            this.noModel(filterColumn, comboItems);
        }
    }

    private void noModel(CommonFilterColumn filterColumn, List<ComboItem> comboItems) {
        String value = comboItems != null && comboItems.size() > 0 ? comboItems.get(0).getValue() : "0";
        filterColumn.setDefaultValue(value);
        if ("0".equals(value)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isExistModel(String modelId) {
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)Long.parseLong(modelId));
        if (orCreate == null) {
            return Boolean.FALSE;
        }
        Model model = orCreate.getModelobj();
        if (model == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("model.id".equals(args.getFieldName())) {
            args.setCustomQFilters(ModelUtil.getModelFilter((IFormView)this.getView()));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        QFilter qFilter = args.getQFilter("srcmodel.id");
        Long modelId = 0L;
        if (qFilter != null) {
            modelId = IDUtils.toLong((Object)qFilter.getValue());
        }
        if (IDUtils.isNull((Long)modelId) && args.getSearchClickEvent().getSelectMainOrgIds().size() == 1) {
            modelId = (Long)args.getSearchClickEvent().getSelectMainOrgIds().get(0);
        }
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalyzeListSet_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            UserSelectUtils.saveUserSelectModelId((IFormView)this.getView(), (long)modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = 0L;
        try {
            modelId = UserSelectUtils.getUserSelectModelId((IFormView)this.getView());
        }
        catch (Exception ex) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        }
    }

    private void reFreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_new": {
                this.toNew();
                break;
            }
            case "btn_remove": {
                this.toRemove();
                break;
            }
            case "btn_dataupload": {
                this.toDataUpload();
                break;
            }
            case "btn_uploadlogs": {
                this.toUploadLogs();
                break;
            }
            case "btn_copyscheme": {
                this.toCopyScheme();
                break;
            }
            case "btn_refush": {
                this.reFreshBillList();
                break;
            }
        }
    }

    @Override
    public String getBizEntityNumber() {
        return "eb_datauploadscheme";
    }

    private void toNew() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            BillShowParameter param = new BillShowParameter();
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setStatus(OperationStatus.ADDNEW);
            param.setFormId("eb_datauploadscheme");
            param.setCustomParam("model", (Object)modelId);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bar_new"));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void toCopyScheme() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            BillList list = (BillList)this.getControl("billlistap");
            if (list.getSelectedRows().size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u65b9\u6848\u3002", (String)"EbDataUploadSchemeListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (list.getSelectedRows().size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u8fdb\u884c\u590d\u5236\u3002", (String)"EbDataUploadSchemeListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long schemeId = (Long)list.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"eb_datauploadscheme");
            BillShowParameter param = new BillShowParameter();
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setStatus(OperationStatus.ADDNEW);
            param.setFormId("eb_datauploadscheme");
            param.setCustomParam("model", (Object)String.valueOf(dyo.getLong("model.id")));
            param.setCustomParam("schemeId", (Object)String.valueOf(schemeId));
            param.setCustomParam("operationStatus", (Object)"copy");
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_COPYSCHEME));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void toRemove() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u8bb0\u5f55\u3002", (String)"EbDataUploadSchemeListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u9009\u62e9\u7684\u8bb0\u5f55\uff1f", (String)"EbDataUploadSchemeListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_REMOVE, (IFormPlugin)this));
            }
        }
    }

    private void toUploadLogs() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            ListShowParameter param = new ListShowParameter();
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId("eb_datauploadloglist");
            param.setPageId(param.getBillFormId() + this.getModelId() + "_" + this.getView().getPageId());
            param.setCustomParam("model", (Object)modelId);
            IFormView parentView = this.getView().getParentView();
            param.setParentPageId(parentView == null ? "" : parentView.getPageId());
            param.getOpenStyle().setTargetKey("_submaintab_");
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_UPLOADLOGS));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void toDataUpload() {
        long modelId = this.getModelId();
        BillList list = (BillList)this.getControl("billlistap");
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"EbDataUploadSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u542f\u7528\u72b6\u6001\u7684\u65b9\u6848\u3002", (String)"EbDataUploadSchemeListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> schemeIds = new ArrayList<Long>(10);
            for (ListSelectedRow row : rows) {
                schemeIds.add(IDUtils.toLong((Object)row.getPrimaryKeyValue()));
            }
            DynamicObject[] schemeArry = (DynamicObject[])BusinessDataServiceHelper.load((Object[])schemeIds.toArray(new Long[schemeIds.size()]), (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"eb_datauploadscheme").getDataEntityType());
            Map<Long, DynamicObject> schemeMap = Stream.of(schemeArry).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            List<Object> schemes = new ArrayList(10);
            for (Long s : schemeIds) {
                String enable = schemeMap.get(s).getString("enable");
                if (!"1".equals(enable)) continue;
                schemes.add(schemeMap.get(s));
            }
            if (schemes.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u542f\u7528\u72b6\u6001\u7684\u65b9\u6848\u3002", (String)"EbDataUploadSchemeListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            schemes = schemes.stream().sorted(Comparator.comparing(x -> x.getDate("createtime"), Comparator.reverseOrder())).collect(Collectors.toList());
            String uploadSchemes = SerializationUtils.serializeToBase64(schemes);
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("eb_datamoreupload");
            param.setCustomParam("model", (Object)this.getModelId());
            param.setCustomParam("uploadschemes", (Object)uploadSchemes);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_DATAUPLOAD));
            this.getView().showForm(param);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        Long model = this.getModelId();
        if (MessageBoxResult.Yes.getValue() == event.getResult().getValue() && BTN_REMOVE.equals(callBackId)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            ArrayList<String> selectNumbers = new ArrayList<String>(rows.size());
            StringBuilder sb = new StringBuilder();
            ArrayList<String> deleteid = new ArrayList<String>(rows.size());
            for (ListSelectedRow row : rows) {
                selectNumbers.add(row.getNumber());
                deleteid.add(row.getPrimaryKeyValue().toString());
            }
            Set numbers = this.instance.querySchemeLogByNumbers(selectNumbers, model);
            DynamicObjectCollection schemeListByModel = this.instance.getSchemeListByModel(model);
            HashMap map = new HashMap(16);
            schemeListByModel.forEach(e -> map.put(e.getString("number"), e));
            if (numbers != null && numbers.size() > 0) {
                sb.append(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u65b9\u6848\u7f16\u7801\uff1a", (String)"EbDataUploadSchemeListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                int i = 0;
                for (String number : numbers) {
                    String id = ((DynamicObject)map.get(number)).getString("id");
                    deleteid.remove(id);
                    if (i == numbers.size() - 1) {
                        sb.append(number);
                        continue;
                    }
                    sb.append(number).append(",");
                }
                sb.append(ResManager.loadKDString((String)"\u4e3a\u5df2\u6267\u884c\u6570\u636e\u4e0a\u4f20\u7684\u65b9\u6848\u3002", (String)"EbDataUploadSchemeListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DeleteServiceHelper.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"eb_datauploadscheme").getDataEntityType(), (Object[])deleteid.toArray());
            if (sb != null && sb.length() > 0) {
                this.getView().showTipNotification(sb.toString());
            } else {
                this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "AbstractMultiReportPlugin_60", "epm-eb-budget"), new MultiLangEnumBridge("\u4f53\u7cfb\u5185\u6570\u636e\u4e0a\u4f20\u65b9\u6848\u5220\u9664\u6210\u529f", "AbstractMultiReportPlugin_154", "epm-eb-budget"));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"EbDataUploadSchemeListPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.reFreshBillList();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.reFreshBillList();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        boolean hasModel = false;
        List filters = e.getMergeQFilters();
        for (QFilter filter : filters) {
            if (filter == null || !filter.getProperty().equals("model")) continue;
            hasModel = true;
            break;
        }
        if (!hasModel) {
            e.getQFilters().add(new QFilter("model", "=", (Object)0L));
        }
        e.setOrderBy("id desc");
    }

    @Override
    public Long getModelId() {
        String strModelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isNotEmpty((String)strModelId)) {
            return Long.valueOf(strModelId);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"EbDataUploadSchemeListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"close"}));
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            args.setCancel(true);
            return;
        }
        super.billListHyperLinkClick(args);
    }
}

