/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataUpload;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.jetbrains.annotations.NotNull;

public class EbDatauploadloglistPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
CreateListDataProviderListener {
    private static final String MODELKEY = "modelbd";
    private static final String BILLLISTAP = "billlistap";
    private static final String TOOLBAR = "toolbarappplate";
    private static final String EB_DATAUPLOADLOG = "eb_datauploadlog";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBAR});
        BasedataEdit modelEdit = (BasedataEdit)this.getView().getControl(MODELKEY);
        modelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{MODELKEY});
        String model = this.getView().getFormShowParameter().getCustomParam("model").toString();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.setBillFormId(EB_DATAUPLOADLOG);
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        if (StringUtils.isNotEmpty((String)model)) {
            this.getModel().setValue(MODELKEY, (Object)model);
            this.getPageCache().put(MODELKEY, model);
            this.getModel().setValue(MODELKEY, (Object)model);
        } else if (IDUtils.isNotNull((Long)modelId)) {
            this.getModel().setValue(MODELKEY, (Object)modelId);
            this.getPageCache().put(MODELKEY, modelId.toString());
        } else {
            ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>(16);
            QFilter superid = new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser());
            QFilter haspermid = new QFilter("id", "in", (Object)FunPermissionHelper.getEffectiveByPermModel((String)"eb_datauploadloglist", (ApplicationTypeEnum)ModelUtil.queryApp((IFormView)this.getView())));
            QFilter perRoleids = new QFilter("id", "in", (Object)FunPermissionHelper.getRoleModel((Long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)ModelUtil.queryApp((IFormView)this.getView()), (String)"eb_datauploadloglist", (String)"47150e89000000ac"));
            modelQFilters.add(superid.or(haspermid).or(perRoleids));
            modelQFilters.add(new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.BGMD.getIndex()));
            DynamicObjectCollection docs = QueryServiceHelper.query((String)"model", (String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[modelQFilters.size()]), null);
            if (docs != null && docs.size() > 0) {
                DynamicObject dc = (DynamicObject)docs.get(0);
                this.getModel().setValue(MODELKEY, (Object)dc.getString("id"));
                this.getPageCache().put(MODELKEY, dc.getString("id"));
            }
        }
        this.refreshBillList();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MODELKEY.equals(key)) {
            this.modelChange();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshBillList();
            }
        }
    }

    public void click(EventObject evt) {
    }

    private Long getCurrentModelId() {
        return IDUtils.toLong((Object)this.getPageCache().get(MODELKEY));
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.setBillFormId(EB_DATAUPLOADLOG);
        QFilter qFilter = this.getQFilter();
        billList.getDataPermQFilters().add(qFilter);
        billList.setFilter(qFilter);
        billList.setClearSelection(true);
        billList.setOrderBy("uploaddate desc");
        billList.refresh();
    }

    public void setFilter(@NotNull SetFilterEvent e) {
        BillList billList;
        if (e.getSource() instanceof BillList && BILLLISTAP.equals((billList = (BillList)e.getSource()).getKey())) {
            QFilter qFilter = this.getQFilter();
            e.getQFilters().add(qFilter);
            billList.setClearSelection(true);
            e.setOrderBy("uploaddate desc");
        }
    }

    private QFilter getQFilter() {
        return new QFilter("model", "=", (Object)this.getCurrentModelId());
    }

    private void modelChange() {
        DynamicObject selModel = this.getSelModel();
        if (selModel != null) {
            this.getPageCache().put(MODELKEY, selModel.getString("id"));
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)selModel.getLong("id"));
        }
        this.refreshBillList();
    }

    public DynamicObject getSelModel() {
        Object obj = this.getModel().getValue(MODELKEY);
        if (obj instanceof DynamicObject) {
            return (DynamicObject)obj;
        }
        return null;
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs arg0) {
        arg0.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection datas = super.getData(arg0, arg1);
                if (datas != null && datas.size() > 0) {
                    Map<String, DynamicObject> bpMap = this.queryBperiodOrderByNumber(((DynamicObject)datas.get(0)).getLong("model_id"));
                    for (DynamicObject data : datas) {
                        String budgetperiod = data.getString("budgetperiod");
                        List budgetperiodList = (List)SerializationUtils.fromJsonString((String)budgetperiod, List.class);
                        StringBuilder budgetperiodStr = new StringBuilder();
                        for (int i = 0; i < budgetperiodList.size(); ++i) {
                            DynamicObject dynamicObject = bpMap.get(budgetperiodList.get(i));
                            if (i == budgetperiodList.size() - 1) {
                                if (dynamicObject == null) continue;
                                budgetperiodStr.append(dynamicObject.getString("name"));
                                continue;
                            }
                            if (dynamicObject == null) {
                                budgetperiodStr.append(",");
                                continue;
                            }
                            budgetperiodStr.append(dynamicObject.getString("name")).append(",");
                        }
                        data.set("budgetperiod", (Object)budgetperiodStr.toString());
                    }
                }
                return datas;
            }

            private Map<String, DynamicObject> queryBperiodOrderByNumber(Long model) {
                Long id;
                QFilter qf1;
                DynamicObjectCollection epm_bperiodmembertree;
                HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
                QFilter q1 = new QFilter("number", "=", (Object)"BudgetPeriod");
                QFilter q2 = new QFilter("model", "=", (Object)model);
                DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_dimension", (String)"id, number, name, model", (QFilter[])new QFilter[]{q1.and(q2)});
                if (query != null && query.size() > 0 && (epm_bperiodmembertree = QueryServiceHelper.query((String)"epm_bperiodmembertree", (String)"number, id, name", (QFilter[])new QFilter[]{qf1 = new QFilter("dimension", "=", (Object)(id = Long.valueOf(((DynamicObject)query.get(0)).getLong("id"))))}, (String)"number asc")) != null && epm_bperiodmembertree.size() > 0) {
                    for (int i = 0; i < epm_bperiodmembertree.size(); ++i) {
                        map.put(((DynamicObject)epm_bperiodmembertree.get(i)).getString("number"), (DynamicObject)epm_bperiodmembertree.get(i));
                    }
                }
                return map;
            }
        });
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }
}

