/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataUpload;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class ReceiveParameterPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final String MODEL = "model";
    private static final String DISPLAY_REC_DIMS = "displayrecdims";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{"version"});
    }

    public void afterCreateNewData(EventObject e) {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam(MODEL);
        this.getModel().setValue(MODEL, (Object)modelId);
        this.loadRecDims();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.loadRecDims();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("version".equals(key)) {
            LeftTreeF7Parameter parameter = new LeftTreeF7Parameter();
            parameter.setKeepTree(Boolean.TRUE.booleanValue());
            parameter.setOnlyLeaf(Boolean.TRUE.booleanValue());
            this.switchLeftTreeF7(evt, 0L, parameter);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey)) {
            args.setCancel(this.saveValidator());
        }
    }

    private boolean saveValidator() {
        boolean exists;
        QFilter qFmodel = new QFilter(MODEL, "=", (Object)this.getModelId());
        Timestamp startdate = new Timestamp(((Date)this.getModel().getValue("startdate")).getTime());
        Date enddate = this.getEndDate((Date)this.getModel().getValue("enddate"));
        this.getModel().setValue("enddate", (Object)enddate);
        if (!this.isValidatorDataRange(startdate, enddate)) {
            return Boolean.FALSE;
        }
        QFilter qfData = new QFilter("startdate", ">=", (Object)startdate);
        qfData.and("startdate", "<", (Object)enddate);
        QFilter qfData1 = new QFilter("enddate", ">", (Object)startdate);
        qfData1.and("enddate", "<=", (Object)enddate);
        QFilter qfData2 = new QFilter("startdate", "<=", (Object)startdate);
        qfData2.and("enddate", ">=", (Object)enddate);
        qfData.or(qfData1).or(qfData2);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
        qFilterList.add(qFmodel);
        qFilterList.add(qfData);
        long id = (Long)this.getModel().getValue("id");
        if (id != 0L) {
            qFilterList.add(new QFilter("id", "!=", (Object)id));
        }
        if (exists = QueryServiceHelper.exists((String)"eb_receiveparameter", (QFilter[])qFilterList.toArray(new QFilter[0]))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0b\u5df2\u5b58\u5728\u8be5\u751f\u6548\u65e5\u671f\u81f3\u5931\u6548\u65e5\u671f\u7684\u63a5\u6536\u53c2\u6570\u3002", (String)"ReceiveParameterPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return exists;
    }

    @Override
    public Long getModelId() {
        Object model = this.getModel().getValue(MODEL);
        if (model == null) {
            return 0L;
        }
        return ((DynamicObject)model).getLong("id");
    }

    public String getCurrentDimNumber(String controlKey) {
        return "Version";
    }

    private boolean isValidatorDataRange(Date startdate, Date enddate) {
        long id = (Long)this.getModel().getValue("id");
        if (id == 0L) {
            return Boolean.TRUE;
        }
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_receiveparameter", (String)"startdate,enddate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (query == null) {
            return Boolean.TRUE;
        }
        Date startdate1 = query.getDate("startdate");
        Date enddate1 = this.getEndDate(query.getDate("enddate"));
        if (startdate1.equals(startdate) && enddate1.equals(enddate)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Date getEndDate(Date enddate) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(enddate);
        calendar1.set(calendar1.get(1), calendar1.get(2), calendar1.get(5), 23, 59, 59);
        enddate = calendar1.getTime();
        return new Timestamp(enddate.getTime());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (DISPLAY_REC_DIMS.equals(name)) {
            IDataModel dataModel = this.getModel();
            dataModel.deleteEntryData("recdims");
            String value = (String)dataModel.getValue(DISPLAY_REC_DIMS);
            if (StringUtils.isEmpty((String)value)) {
                return;
            }
            String[] split = (value = value.trim()).split(",");
            if (split.length == 0) {
                return;
            }
            dataModel.batchCreateNewEntryRow("recdims", split.length);
            dataModel.beginInit();
            for (int i = 0; i < split.length; ++i) {
                dataModel.setValue("recdim", (Object)split[i], i);
            }
            dataModel.endInit();
            dataModel.updateCache();
        }
    }

    private void loadRecDims() {
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = orCreate.getDimensionList();
        HashMap<String, String> recDims = new HashMap<String, String>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            if (dimension.isPreset()) continue;
            recDims.put(String.valueOf(dimension.getId()), dimension.getName());
        }
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl(DISPLAY_REC_DIMS);
        mulComboEdit.setComboItems(recDims.entrySet().stream().map(m -> new ComboItem(new LocaleString((String)m.getValue()), (String)m.getKey())).collect(Collectors.toList()));
        DynamicObjectCollection selectDims = (DynamicObjectCollection)this.getModel().getValue("recdims");
        ArrayList<String> select = new ArrayList<String>(selectDims.size());
        ArrayList<Integer> rows = new ArrayList<Integer>(selectDims.size());
        for (int i = 0; i < selectDims.size(); ++i) {
            String dimId = ((DynamicObject)selectDims.get(i)).getString("recdim.id");
            if (recDims.containsKey(dimId)) {
                select.add(dimId);
                continue;
            }
            rows.add(i);
        }
        if (rows.size() > 0) {
            this.getModel().deleteEntryRows("recdims", rows.stream().mapToInt(d -> d).toArray());
        }
        if (select.size() > 0) {
            this.getModel().setValue(DISPLAY_REC_DIMS, (Object)String.join((CharSequence)",", select));
            this.getModel().setDataChanged(false);
        }
    }
}

