/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataUpload.importandexport;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BaseImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static Log log = LogFactory.getLog(BaseImportPlugin.class);

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = null;
        urls = file_url == null ? new ArrayList(16) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        if (urls.size() > 0) {
            this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
        }
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String file_url = this.getPageCache().get("file_url");
        if (file_url == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }

    private void checkIsUpLoadFile() {
        String file_url = this.getPageCache().get("file_url");
        if (StringUtils.isEmpty((String)file_url)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u4e0a\u4f20\u8981\u5bfc\u5165\u7684\u6570\u636e\u6587\u4ef6\u3002", (String)"DimMemImportBasePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        if (urls.size() == 0) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u4e0a\u4f20\u8981\u5bfc\u5165\u7684\u6570\u636e\u6587\u4ef6\u3002", (String)"DimMemImportBasePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected List<XSSFWorkbook> getXSSFWorkbooks() {
        this.checkIsUpLoadFile();
        List<InputStream> inputStreams = this.getImportStreams();
        ArrayList<XSSFWorkbook> xssFWorkbooks = new ArrayList<XSSFWorkbook>();
        try {
            for (InputStream inportStream : inputStreams) {
                XSSFWorkbook xssFWorkbook = new XSSFWorkbook(inportStream);
                xssFWorkbooks.add(xssFWorkbook);
            }
        }
        catch (Exception e) {
            KDBizException kdBizException = new KDBizException(ResManager.loadResFormat((String)"\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u4e0d\u6b63\u786e\u7684\u683c\u5f0f\u6587\u4ef6\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u7684\u683c\u5f0f\u6a21\u677f\u3002", (String)"DimMemImportBasePlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            kdBizException.initCause((Throwable)e);
            throw kdBizException;
        }
        return xssFWorkbooks;
    }

    private List<InputStream> getImportStreams() {
        String file_url = this.getPageCache().get("file_url");
        TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        if (file_url != null) {
            List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
            try {
                for (String url : urls) {
                    String[] reqParams = new URL(url).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(4);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                    InputStream inputStream = content.getInputStream();
                    inputStreams.add(inputStream);
                }
            }
            catch (MalformedURLException e) {
                log.error((Throwable)e);
            }
        }
        return inputStreams;
    }
}

