/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataUpload.importandexport;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.common.utils.excel.ExcelImExportUtils;
import kd.epm.eb.formplugin.dataUpload.EbDataUploadEntity;
import kd.epm.eb.formplugin.dataUpload.importandexport.BaseImportPlugin;
import org.apache.commons.collections.CollectionUtils;

public class DataUploadAccountImportPlugin
extends BaseImportPlugin
implements UploadListener {
    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"newandcover"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "btnok": {
                this.importAccountMapping();
                break;
            }
            case "btndownload": {
                this.downloadTemplate();
                break;
            }
        }
    }

    private void importAccountMapping() {
        ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 3, 0, 9);
        String file_url = this.getPageCache().get("file_url");
        List read = ExcelImExportUtils.getInstance().read(file_url, sheet);
        List<EbDataUploadEntity> accountentryentity = this.convert(read);
        if (accountentryentity != null) {
            this.returnDataAndClose(accountentryentity);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u9519\u8bef\u8be6\u60c5\u3002", (String)"DataUploadAccountImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent ev) {
        if (MessageBoxResult.Yes.getValue() == ev.getResult().getValue()) {
            String cacheMark = this.getPageCache().get("cacheMark");
            List condition = JSON.parseArray((String)cacheMark, EbDataUploadEntity.class);
            this.returnDataAndClose(condition);
        }
    }

    private void returnDataAndClose(List<EbDataUploadEntity> condition) {
        if (condition.size() != 0) {
            this.getView().returnDataToParent(condition);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"DataUploadAccountImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u65e0\u53ef\u5bfc\u5165\u6570\u636e", (String)"DataUploadAccountImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().close();
    }

    private List<EbDataUploadEntity> convert(List<String[]> returnDatas) {
        if (returnDatas == null) {
            return Collections.emptyList();
        }
        String sourceAccountCache = (String)this.getView().getFormShowParameter().getCustomParam("sourceAccount");
        String targetAccountCache = (String)this.getView().getFormShowParameter().getCustomParam("targetAccount");
        String budgetPeriodCache = (String)this.getView().getFormShowParameter().getCustomParam("BudgetPeriodCache");
        Long modelId = this.getModelId();
        String dimensionNumber = SysDimensionEnum.Account.getNumber();
        Long srcBussModelId = (Long)this.getView().getFormShowParameter().getCustomParam("srcBussModel");
        DimMembPermType read = DimMembPermType.READ;
        Set srcPermMemNumberSet = DimMembPermHelper.getPermMembNumbers((String)dimensionNumber, (Long)modelId, (Long)srcBussModelId, (Long)0L, (DimMembPermType)read, (boolean)true);
        Long tarBussModelId = (Long)this.getView().getFormShowParameter().getCustomParam("tarBussModel");
        Set tarPermMemNumberSet = DimMembPermHelper.getPermMembNumbers((String)dimensionNumber, (Long)modelId, (Long)tarBussModelId, (Long)0L, (DimMembPermType)read, (boolean)true);
        List budgetPeriodNumbers = (List)SerializationUtils.deSerializeFromBase64((String)budgetPeriodCache);
        List sourceAccount = (List)SerializationUtils.fromJsonString((String)sourceAccountCache, List.class);
        List targetAccount = (List)SerializationUtils.fromJsonString((String)targetAccountCache, List.class);
        ArrayList<EbDataUploadEntity> listDoc = new ArrayList<EbDataUploadEntity>(16);
        ArrayList<ExcelImExportUtils.ErrorMark> errorMarkList = new ArrayList<ExcelImExportUtils.ErrorMark>(16);
        for (int i = 0; i < returnDatas.size(); ++i) {
            String[] returnData = returnDatas.get(i);
            String srcdimNumber = returnData[0];
            String trgdimNumber = returnData[2];
            String startDate = returnData[5];
            String endDate = returnData[7];
            String accountStatus = returnData[4];
            StringBuilder sb = new StringBuilder();
            if (CollectionUtils.isEmpty((Collection)sourceAccount) || !sourceAccount.contains(srcdimNumber)) {
                sb.append(ResManager.loadResFormat((String)"%1\u6e90\u79d1\u76ee\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"DataUploadAccountImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{srcdimNumber})).append("\uff1b");
            }
            if (srcPermMemNumberSet != null && CollectionUtils.isNotEmpty((Collection)sourceAccount) && sourceAccount.contains(srcdimNumber) && !srcPermMemNumberSet.contains(srcdimNumber)) {
                sb.append(ResManager.loadResFormat((String)"%1\u6e90\u79d1\u76ee\u65e0\u6743\uff01", (String)"DataUploadAccountImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{srcdimNumber})).append("\uff1b");
            }
            if (CollectionUtils.isEmpty((Collection)targetAccount) || !targetAccount.contains(trgdimNumber)) {
                sb.append(ResManager.loadResFormat((String)"%1\u76ee\u6807\u79d1\u76ee\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"DataUploadAccountImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{trgdimNumber})).append("\uff1b");
            }
            if (tarPermMemNumberSet != null && CollectionUtils.isNotEmpty((Collection)targetAccount) && targetAccount.contains(trgdimNumber) && !tarPermMemNumberSet.contains(trgdimNumber)) {
                sb.append(ResManager.loadResFormat((String)"%1\u76ee\u6807\u79d1\u76ee\u65e0\u6743\uff01", (String)"DataUploadAccountImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{trgdimNumber})).append("\uff1b");
            }
            if (budgetPeriodNumbers != null && budgetPeriodNumbers.size() > 0) {
                if (!budgetPeriodNumbers.contains(startDate)) {
                    sb.append(ResManager.loadResFormat((String)"%1\u751f\u6548\u8d77\u59cb\u671f\u95f4\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"DataUploadAccountImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{startDate})).append("\uff1b");
                }
                if (StringUtils.isNotEmpty((String)endDate) && !budgetPeriodNumbers.contains(endDate)) {
                    sb.append(ResManager.loadResFormat((String)"%1\u751f\u6548\u7ed3\u675f\u671f\u95f4\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"DataUploadAccountImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{endDate})).append("\uff1b");
                }
            }
            if (StringUtils.isNotEmpty((String)sb.toString())) {
                errorMarkList.add(new ExcelImExportUtils.ErrorMark(i, sb.substring(0, sb.length() - 1)));
                continue;
            }
            EbDataUploadEntity accountEntity = new EbDataUploadEntity();
            accountEntity.setSrcdimNumber(srcdimNumber);
            accountEntity.setTrgdimNumber(trgdimNumber);
            accountEntity.setStartDate(startDate);
            accountEntity.setEndDate(endDate);
            accountEntity.setAccountStatus(accountStatus);
            listDoc.add(accountEntity);
        }
        if (errorMarkList.isEmpty()) {
            return listDoc;
        }
        String tempPath = "dataupload/dataupload_error.xlsx";
        String filename = ResManager.loadKDString((String)"\u6570\u636e\u4e0a\u4f20\u79d1\u76ee\u6620\u5c04\u65b9\u6848\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", (String)"DataUploadAccountImportPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        ExcelImExportUtils.Sheet sheet = new ExcelImExportUtils.Sheet(0, 3, 1, 0);
        String url = ExcelImExportUtils.getInstance().writeWithError(tempPath, filename, returnDatas, sheet, errorMarkList);
        ExcelImExportUtils.getInstance().download(this.getView(), url);
        return null;
    }

    @Override
    public Long getModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
    }

    private void downloadTemplate() {
        String tempPath = "dataupload/dataupload_accountmapping.xlsx";
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath(tempPath);
        HashMap finalDataMap = Maps.newHashMapWithExpectedSize((int)10);
        finalDataMap.put("title", ResManager.loadKDString((String)"\u6570\u636e\u4e0a\u4f20\u79d1\u76ee\u6620\u5c04\u65b9\u6848\u5bfc\u51fa\u6a21\u677f", (String)"DataUploadAccountImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("tip", ResManager.loadKDString((String)"\u7ea2\u8272*\u5fc5\u586b", (String)"DataUploadAccountImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("srcAccNumber", ResManager.loadKDString((String)"*\u6e90\u79d1\u76ee\u7f16\u7801", (String)"DataUploadAccountImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("srcAccName", ResManager.loadKDString((String)"\u6e90\u79d1\u76ee\u540d\u79f0", (String)"DataUploadAccountImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("tarAccNumber", ResManager.loadKDString((String)"*\u76ee\u6807\u79d1\u76ee\u7f16\u7801", (String)"DataUploadAccountImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("tarAccName", ResManager.loadKDString((String)"\u76ee\u6807\u79d1\u76ee\u540d\u79f0", (String)"DataUploadAccountImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("status", ResManager.loadKDString((String)"*\u4f7f\u7528\u72b6\u6001\uff08\u4e0d\u586b\u9ed8\u8ba4\u4e3a\u542f\u7528\u72b6\u6001\uff09", (String)"DataUploadAccountImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        String[] statusOpt = new String[]{ResManager.loadKDString((String)"\u542f\u7528", (String)"DataUploadAccountImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5220\u9664", (String)"DataUploadAccountImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0])};
        excelWriter.setDropDownBox(statusOpt, Integer.valueOf(3), Integer.valueOf(100), Integer.valueOf(4), Integer.valueOf(4));
        finalDataMap.put("startBpNumber", ResManager.loadKDString((String)"*\u751f\u6548\u8d77\u59cb\u671f\u95f4\u7f16\u7801(\u683c\u5f0f:\u4f8b\uff1aFY2020.M01\uff09", (String)"DataUploadAccountImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("starBpName", ResManager.loadKDString((String)"\u751f\u6548\u8d77\u59cb\u671f\u95f4\u540d\u79f0(\u683c\u5f0f:\u4f8b\uff1a2020\u5e741\u6708\uff09", (String)"DataUploadAccountImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("endBpNumber", ResManager.loadKDString((String)"\u751f\u6548\u7ed3\u675f\u671f\u95f4\u7f16\u7801(\u683c\u5f0f:\u4f8b\uff1aFY2020.M01\uff09", (String)"DataUploadAccountImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        finalDataMap.put("endBpName", ResManager.loadKDString((String)"\u751f\u6548\u7ed3\u675f\u671f\u95f4\u540d\u79f0(\u683c\u5f0f:\u4f8b\uff1a2020\u5e741\u6708\uff09", (String)"DataUploadAccountImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        excelWriter.replaceFinalData((Map)finalDataMap);
        String fileName = ResManager.loadKDString((String)"\u6570\u636e\u4e0a\u4f20\u79d1\u76ee\u6620\u5c04\u65b9\u6848\u6a21\u677f\u5bfc\u51fa.xlsx", (String)"DataUploadAccountImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }
}

