/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataUpload.job;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.dataModelTrans.util.DataModelUtil;
import kd.epm.eb.formplugin.dataUpload.dto.ModelDataUploadRequest;
import kd.epm.eb.formplugin.dataUpload.service.ModelDataUploadService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ModelDataUploadTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ModelDataUploadTask.class);
    private Long transportLogId;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Object orgMapJson;
        Object periodMapJson;
        log.info("\u4f53\u7cfb\u5185\u6570\u636e\u4f20\u8f93\u5b9a\u65f6\u4efb\u52a1\u53c2\u6570\uff1a" + JSON.toJSONString(map));
        HashMap<String, String> returnData = new HashMap<String, String>(16);
        if (map == null) {
            this.feedbackProgress(100);
            return;
        }
        Long modelId = MapUtils.getLong(map, (Object)"modelId");
        if (modelId == null) {
            String modelNumber = MapUtils.getString(map, (Object)"modelNumber");
            DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id", (QFilter[])new QFilter("shownumber", "=", (Object)modelNumber).toArray());
            if (model == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u4f53\u7cfb\u4e0d\u5b58\u5728", (String)"DataIntegrationTaskBase_1", (String)"epm-eb-business", (Object[])new Object[]{modelNumber}));
            }
            modelId = model.getLong("id");
        }
        if (modelId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfbid\u4e0d\u5b58\u5728\u3002", (String)"ModelDataUploadTask_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ModelDataUploadRequest modelDataUploadRequest = new ModelDataUploadRequest();
        modelDataUploadRequest.setModelId(modelId);
        Boolean lock = MapUtils.getBoolean(map, (Object)"lock");
        modelDataUploadRequest.setLock(lock);
        String schemeString = (String)map.get("schemeNumbers");
        if (StringUtils.isNotEmpty((String)schemeString)) {
            List schemeNumberList = (List)SerializationUtils.fromJsonString((String)schemeString, List.class);
            modelDataUploadRequest.setSchemeNumbers(schemeNumberList);
        }
        if ((periodMapJson = map.get("periodMap")) != null) {
            Map periodMap = (Map)SerializationUtils.fromJsonString((String)periodMapJson.toString(), Map.class);
            modelDataUploadRequest.setPeriodMap(periodMap);
        }
        if ((orgMapJson = map.get("orgMap")) != null) {
            Map orgMap = (Map)SerializationUtils.fromJsonString((String)orgMapJson.toString(), Map.class);
            modelDataUploadRequest.setOrgMap(orgMap);
        }
        if (map.get("transportLogId") != null) {
            this.transportLogId = (Long)map.get("transportLogId");
            modelDataUploadRequest.setTransportLogId(this.transportLogId);
        }
        modelDataUploadRequest.setLoginIp((String)map.get("loginIp"));
        String errorMessage = "";
        try {
            List<String> schemeNumbers = modelDataUploadRequest.getSchemeNumbers();
            if (CollectionUtils.isEmpty(schemeNumbers)) {
                this.feedbackProgress(100);
                return;
            }
            ModelDataUploadService modelDataUploadService = new ModelDataUploadService(modelDataUploadRequest);
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u4f20\u8f93", (String)"ModelDataUploadTask_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), null);
            modelDataUploadService.modelDataUpload();
            returnData.put("status", "success");
            this.feedbackProgress(100);
            Thread.sleep(0L);
        }
        catch (Exception e) {
            DataModelUtil.doLog("export exception.", log);
            errorMessage = e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u4f53\u7cfb\u5185\u6570\u636e\u4f20\u8f93\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ModelDataUploadTask_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            returnData.put("status", "failed");
            returnData.put("exportResult", errorMessage);
            DataModelUtil.doLog("export exception.", log);
            log.error((Throwable)e);
        }
        this.feedbackCustomdata(returnData);
    }
}

