/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataUpload.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.BGCells;
import kd.epm.eb.common.olapdao.BgmdOlapReader;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.dataUpload.dto.ModelDataUploadRequest;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ModelDataUploadService {
    private static Log log = LogFactory.getLog(ModelDataUploadService.class);
    private String currOrgId;
    private Long currModelId;
    private String currPeriod;
    private DynamicObject currScheme;
    private String handleFlag;
    private ModelDataUploadRequest modelDataUploadRequest;

    public ModelDataUploadService(ModelDataUploadRequest modelDataUploadRequest) {
        this.modelDataUploadRequest = modelDataUploadRequest;
        this.currModelId = modelDataUploadRequest.getModelId();
    }

    public boolean modelDataUpload() {
        this.handleFlag = "delete";
        QFilter qFilter = new QFilter("model", "=", (Object)this.modelDataUploadRequest.getModelId()).and("number", "in", this.modelDataUploadRequest.getSchemeNumbers());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_datauploadscheme", (String)"id", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return true;
        }
        List<Long> schemeIds = dynamicObjects.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        DynamicObject[] schemeArry = (DynamicObject[])BusinessDataServiceHelper.load((Object[])schemeIds.toArray(new Long[schemeIds.size()]), (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"eb_datauploadscheme").getDataEntityType());
        Map<Long, DynamicObject> schemeMap = Arrays.stream(schemeArry).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        for (DynamicObject schemeDoc : schemeArry) {
            String org;
            Map<String, String> orgMap;
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)schemeDoc.getLong("model.id"));
            long id = schemeDoc.getLong("id");
            boolean taskstatus = schemeDoc.getBoolean("taskstatus");
            if (taskstatus) {
                orgMap = this.modelDataUploadRequest.getOrgMap();
                org = orgMap == null ? schemeDoc.getString("org") : orgMap.get(schemeDoc.getString("number"));
            } else {
                orgMap = this.modelDataUploadRequest.getOrgMap();
                if (orgMap == null) {
                    log.info("org is null :" + schemeDoc.getString("number"));
                    continue;
                }
                org = orgMap.get(schemeDoc.getString("number"));
            }
            if (StringUtils.isEmpty((CharSequence)org)) {
                log.info("org is null :" + schemeDoc.getString("number"));
                continue;
            }
            List orgList = (List)SerializationUtils.fromJsonString((String)org, List.class);
            for (String entity : orgList) {
                String[] orgStr = entity.split(",");
                this.currOrgId = orgStr[0];
                String tarOrg = orgStr[1];
                Member srcOrgMember = modelCache.getMemberByAnyView(Long.valueOf(schemeDoc.getLong("srcbusinessmodel.id")), SysDimensionEnum.Entity.getNumber(), tarOrg);
                if (srcOrgMember == null) continue;
                this.upload(schemeMap.get(id), tarOrg);
            }
        }
        log.info("execute finish!");
        return true;
    }

    private void upload(DynamicObject dym, String orgNumber) {
        List budgetperiod;
        this.currScheme = dym;
        boolean taskstatus = dym.getBoolean("taskstatus");
        if (taskstatus) {
            String period;
            Map<String, String> periodMap = this.modelDataUploadRequest.getPeriodMap();
            if (periodMap == null) {
                period = dym.getString("period");
            } else {
                period = periodMap.get(dym.getString("number"));
                if (StringUtils.isEmpty((CharSequence)period)) {
                    return;
                }
            }
            budgetperiod = (List)SerializationUtils.fromJsonString((String)period, List.class);
            budgetperiod = budgetperiod.stream().map(x -> x.split(",")[1]).collect(Collectors.toList());
            this.currPeriod = SerializationUtils.toJsonString(budgetperiod);
        } else {
            Map<String, String> periodMap = this.modelDataUploadRequest.getPeriodMap();
            if (periodMap == null) {
                return;
            }
            String period = periodMap.get(dym.getString("number"));
            if (StringUtils.isEmpty((CharSequence)period)) {
                return;
            }
            budgetperiod = (List)SerializationUtils.fromJsonString((String)period, List.class);
            budgetperiod = budgetperiod.stream().map(x -> x.split(",")[1]).collect(Collectors.toList());
            this.currPeriod = SerializationUtils.toJsonString(budgetperiod);
        }
        DynamicObjectCollection accountCol = dym.getDynamicObjectCollection("accountentryentity");
        Set<DynamicObject> accoutMapOfDelete = accountCol.stream().filter(e -> "1".equals(e.getString("entrystatus"))).collect(Collectors.toSet());
        Set<DynamicObject> accoutMapOfUsing = accountCol.stream().filter(e -> "0".equals(e.getString("entrystatus"))).collect(Collectors.toSet());
        if (accoutMapOfDelete != null && accoutMapOfDelete.size() > 0) {
            this.handleFlag = "delete";
            this.handleAccountMapData(dym, accoutMapOfDelete, accountCol, orgNumber);
        }
        if (accoutMapOfUsing != null && accoutMapOfUsing.size() > 0) {
            this.handleFlag = "using";
            this.handleAccountMapData(dym, accoutMapOfUsing, accountCol, orgNumber);
        }
    }

    private void handleAccountMapData(DynamicObject dym, Set<DynamicObject> accountMap, DynamicObjectCollection accountCol, String org) {
        DynamicObjectCollection dimCol = dym.getDynamicObjectCollection("entryentity");
        Set<Long> srcAccIds = accountCol.stream().map(e -> e.getLong("srcaccount.id")).collect(Collectors.toSet());
        DynamicObject[] srcAccCol = (DynamicObject[])BusinessDataServiceHelper.load((Object[])srcAccIds.toArray(new Long[srcAccIds.size()]), (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"epm_accountmembertree").getDataEntityType());
        Map<Long, DynamicObject> srcAccMap = Stream.of(srcAccCol).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        Set<Long> tarAccIds = accountCol.stream().map(e -> e.getLong("trgaccount.id")).collect(Collectors.toSet());
        DynamicObject[] tarAccCol = (DynamicObject[])BusinessDataServiceHelper.load((Object[])tarAccIds.toArray(new Long[srcAccIds.size()]), (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"epm_accountmembertree").getDataEntityType());
        Map<Long, DynamicObject> tarAccMap = Stream.of(tarAccCol).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)dym.getLong("model.id"));
        for (DynamicObject dymAccount : accountMap) {
            List<BGCell> newCells;
            StringBuilder msg = new StringBuilder();
            long srcAccountId = dymAccount.getLong("srcaccount.id");
            DynamicObject srcAccountDym = srcAccMap.get(srcAccountId);
            long srcDatasetId = srcAccountDym.getLong("dataset.id");
            List srcDimensionList = modelCache.getDimensionList(Long.valueOf(srcDatasetId));
            long tarAccountId = dymAccount.getLong("trgaccount.id");
            DynamicObject tarAccountDym = tarAccMap.get(tarAccountId);
            long tarDatasetId = tarAccountDym.getLong("dataset.id");
            Map<String, List<String>> srcInfoMap = this.getSelectCommandInfo(org, dimCol, modelCache, srcAccountDym, srcDimensionList, dymAccount, dym);
            if (srcInfoMap == null) continue;
            List<String> bgMembers = srcInfoMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
            if (bgMembers.size() < 1) {
                msg.append(ResManager.loadResFormat((String)"\u9884\u7b97\u671f\u95f4\u4e0d\u5728\u6709\u6548\u65f6\u95f4\u8303\u56f4\u5185:%1%2%3%4", (String)"EbDataUploadRecordPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getSrcAccount(), dymAccount.getString("srcaccount.name"), this.getTrgAccount(), dymAccount.getString("trgaccount.name")}));
                log.info(msg.toString());
                this.addUploadLog(msg.toString(), "", "");
                continue;
            }
            List srcDimensions = modelCache.getDimensionList(Long.valueOf(srcDatasetId));
            HashMap queryMemberMap = Maps.newHashMapWithExpectedSize((int)srcDimensions.size());
            for (Dimension dimension : srcDimensions) {
                if (srcInfoMap.get(dimension.getNumber()) == null) continue;
                queryMemberMap.put(dimension.getNumber(), new HashSet(srcInfoMap.get(dimension.getNumber())));
            }
            String[] dimensionNums = modelCache.getDimensionNums(Long.valueOf(srcDatasetId));
            ArrayList<BGCell> cells = new ArrayList<BGCell>(10);
            try (BgmdOlapReader reader = OlapManager.getInstance().queryReader(new QueryRequest(modelCache.getModelobj().getId(), Long.valueOf(srcDatasetId), (Map)queryMemberMap));){
                while (reader.hasNext()) {
                    Object[] row = reader.next();
                    if (row[0] == null) continue;
                    BGCell cell = BGCells.of((Object[])row, Arrays.asList(dimensionNums));
                    cells.add(cell);
                }
            }
            if (cells.isEmpty()) {
                String a = ResManager.loadResFormat((String)"\u5f53\u524d\u79d1\u76ee\u6620\u5c04\u4e0b\u672a\u627e\u5230\u6e90\u6570\u636e,%1%2%3%4", (String)"EbDataUploadRecordPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getSrcAccount(), dymAccount.getString("srcaccount.name"), this.getTrgAccount(), dymAccount.getString("trgaccount.name")});
                log.info(a);
                msg.append(a);
                this.addUploadLog(msg.toString(), "", "");
                continue;
            }
            List tarDimensionList = modelCache.getDimensionList(Long.valueOf(tarDatasetId));
            try {
                newCells = this.getMapperCells(modelCache, dimCol, dymAccount, cells, tarDimensionList, dym);
            }
            catch (Exception e2) {
                String s = ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5339\u914d\u62a5\u9519:", (String)"EbDataUploadRecordPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                log.error(s, (Throwable)e2);
                this.addUploadLog(s + e2.getMessage(), "", "");
                throw e2;
            }
            if (newCells.size() < 1) {
                log.info("\u7ef4\u5ea6\u6620\u5c04\u5339\u914d\u5931\u8d25\uff0c\u4fdd\u5b58\u6570\u4e3a0");
                msg.append(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6620\u5c04\u5339\u914d\u5931\u8d25\uff0c\u4fdd\u5b58\u6570\u4e3a0:%1%2%3%4", (String)"EbDataUploadRecordPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getSrcAccount(), dymAccount.getString("srcaccount.name"), this.getTrgAccount(), dymAccount.getString("trgaccount.name")}));
                this.addUploadLog(msg.toString(), String.valueOf(cells.size()), "");
                continue;
            }
            boolean isSuccess = this.saveToOlap(tarDatasetId, newCells, modelCache, dym.getString("number"));
            if (isSuccess) {
                this.addUploadLog(msg.toString(), String.valueOf(cells.size()), String.valueOf(newCells.size()));
            }
            newCells.clear();
        }
    }

    private List<BGCell> getMapperCells(IModelCacheHelper modelCache, DynamicObjectCollection dimCol, DynamicObject dymAccount, List<BGCell> cells, List<Dimension> tarDimensionList, DynamicObject scheme) {
        Map<String, DynamicObject> srcDimNumberMap = dimCol.stream().collect(Collectors.toMap(e -> e.getString("srcdimnumber"), e -> e, (v1, v2) -> v1));
        Set emptyCfgList = dimCol.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getString("srcdimmemnumber"))).collect(Collectors.toSet());
        HashMap tarMbrMap = new HashMap(16);
        HashMap<String, String> lackDimMap = new HashMap<String, String>(16);
        for (DynamicObject cfg : emptyCfgList) {
            String tarDimNumber = cfg.getString("trgdimnumber");
            lackDimMap.put(tarDimNumber, cfg.getString("trgdimmemnumber"));
            Map groupViewMap = modelCache.getViewGroupViewsByBusModel(Long.valueOf(scheme.getLong("trgbusinessmodel.id")));
            List viewList = (List)groupViewMap.get(tarDimNumber);
            List members = Lists.newArrayListWithCapacity((int)10);
            if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)viewList)) {
                members = modelCache.getMembers(null, tarDimNumber);
            } else {
                for (Long vid : viewList) {
                    List vMembers = modelCache.getMembers(vid, tarDimNumber);
                    List rawMembers = vMembers.stream().filter(e -> !ViewMemberSourceEnum.INNER_REF.getIndex().equals(e.getSource())).collect(Collectors.toList());
                    if (rawMembers.isEmpty()) continue;
                    members.addAll(rawMembers);
                }
            }
            tarMbrMap.put(tarDimNumber, members);
        }
        ArrayList<BGCell> newCells = new ArrayList<BGCell>(cells.size());
        for (BGCell cell : cells) {
            Map srcFieldMap = cell.getMemberMap();
            boolean flag = true;
            HashMap newMemberMap = Maps.newHashMapWithExpectedSize((int)srcFieldMap.size());
            for (Dimension dimension : tarDimensionList) {
                String tarDimNumber = dimension.getNumber();
                String srcMemberNumber = (String)srcFieldMap.get(tarDimNumber);
                if (StringUtils.isBlank((CharSequence)srcMemberNumber)) {
                    String tarMemberNumber = (String)lackDimMap.get(tarDimNumber);
                    if (StringUtils.isNotBlank((CharSequence)tarMemberNumber)) {
                        newMemberMap.put(tarDimNumber, tarMemberNumber);
                        continue;
                    }
                    newMemberMap.put(tarDimNumber, dimension.getNoneNumber());
                    continue;
                }
                if (StringUtils.equals((CharSequence)SysDimensionEnum.Account.getNumber(), (CharSequence)tarDimNumber)) {
                    newMemberMap.put(tarDimNumber, dymAccount.getString("trgaccount.number"));
                    continue;
                }
                if (StringUtils.equals((CharSequence)SysDimensionEnum.Entity.getNumber(), (CharSequence)tarDimNumber)) {
                    newMemberMap.put(tarDimNumber, srcMemberNumber);
                    continue;
                }
                if (StringUtils.equals((CharSequence)SysDimensionEnum.BudgetPeriod.getNumber(), (CharSequence)tarDimNumber)) {
                    newMemberMap.put(tarDimNumber, srcMemberNumber);
                    continue;
                }
                if (StringUtils.equals((CharSequence)SysDimensionEnum.Metric.getNumber(), (CharSequence)tarDimNumber)) {
                    newMemberMap.put(tarDimNumber, srcMemberNumber);
                    continue;
                }
                DynamicObject dimMap = srcDimNumberMap.get(tarDimNumber);
                String srcdimmemnumber = dimMap.getString("srcdimmemnumber");
                String trgdimnumber = dimMap.getString("trgdimnumber");
                String trgdimmemnumber = dimMap.getString("trgdimmemnumber");
                if (StringUtils.isBlank((CharSequence)srcdimmemnumber)) {
                    List members = (List)tarMbrMap.get(trgdimnumber);
                    boolean match = members.stream().anyMatch(e -> e.getNumber().equals(srcMemberNumber) && e.isLeaf());
                    if (!match) {
                        flag = false;
                        break;
                    }
                    newMemberMap.put(tarDimNumber, srcMemberNumber);
                    continue;
                }
                newMemberMap.put(tarDimNumber, trgdimmemnumber);
            }
            if (!flag) continue;
            BGCell newCell = new BGCell((Map)newMemberMap, cell.getValue());
            if ("delete".equals(this.handleFlag)) {
                newCell.setValue(null);
            }
            newCells.add(newCell);
            cell = null;
        }
        return newCells;
    }

    private String getSrcAccount() {
        return ResManager.loadKDString((String)"\u6e90\u79d1\u76ee:", (String)"EbDataUploadRecordPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private String getTrgAccount() {
        return ResManager.loadKDString((String)"\u76ee\u6807\u79d1\u76ee:", (String)"EbDataUploadRecordPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private boolean saveToOlap(long tarDatasetId, List<BGCell> newCells, IModelCacheHelper tarModelCache, String opTargetNum) {
        boolean isSuccess = true;
        try {
            log.info("loginIP:" + RequestContext.get().getLoginIP());
            RequestContext.get().setLoginIP(this.modelDataUploadRequest.getLoginIp());
            OlapTraceServiceHelper.setTraceOpInfo((String)opTargetNum);
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.DataUpload));
            OlapWriteOption olapWriteOption = new OlapWriteOption();
            olapWriteOption.setDataLockThrowErr(true);
            OlapManager.getInstance().saveList(new SaveRequest(tarModelCache.getModelobj().getId(), Long.valueOf(tarDatasetId), newCells), olapWriteOption);
        }
        catch (Exception e) {
            String s = ResManager.loadKDString((String)"\u6570\u636e\u4e0a\u4f20\u4fdd\u5b58\u9519\u8bef", (String)"ModelDataUploadService_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            log.error(s + e.getMessage(), (Throwable)e);
            this.addUploadLog(s + e.getMessage(), "", String.valueOf(newCells.size()));
            isSuccess = false;
        }
        return isSuccess;
    }

    private Map<String, List<String>> getSelectCommandInfo(String org, DynamicObjectCollection dimCol, IModelCacheHelper modelCache, DynamicObject srcAccountDym, List<Dimension> srcDimensionList, DynamicObject dymAccount, DynamicObject scheme) {
        Map<String, DynamicObject> srcDimNumberMap = dimCol.stream().collect(Collectors.toMap(e -> e.getString("srcdimnumber"), e -> e, (v1, v2) -> v1));
        long srcDatasetId = srcAccountDym.getLong("dataset.id");
        HashMap<String, List<String>> srcDimAndMemMap = new HashMap<String, List<String>>(16);
        for (Dimension dim : srcDimensionList) {
            DynamicObject dymDimMap;
            if (SysDimensionEnum.Entity.getNumber().equals(dim.getNumber()) || SysDimensionEnum.Account.getNumber().equals(dim.getNumber()) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dim.getNumber()) || SysDimensionEnum.Metric.getNumber().equals(dim.getNumber()) || (dymDimMap = srcDimNumberMap.get(dim.getNumber())) == null) continue;
            String srcdimnumber = dymDimMap.getString("srcdimnumber");
            String srcdimmemnumber = dymDimMap.getString("srcdimmemnumber");
            ArrayList<String> memList = new ArrayList<String>(1);
            if (StringUtils.isEmpty((CharSequence)srcdimmemnumber)) {
                Map groupViewMap = modelCache.getViewGroupViewsByBusModel(Long.valueOf(scheme.getLong("srcbusinessmodel.id")));
                List viewList = (List)groupViewMap.get(dim.getNumber());
                List members = Lists.newArrayListWithCapacity((int)10);
                if (CollectionUtils.isEmpty((Collection)viewList)) {
                    members = modelCache.getMembers(null, dim.getNumber());
                } else {
                    for (Long vid : viewList) {
                        List vMembers = modelCache.getMembers(vid, dim.getNumber());
                        List rawMembers = vMembers.stream().filter(e -> !ViewMemberSourceEnum.INNER_REF.getIndex().equals(e.getSource())).collect(Collectors.toList());
                        if (rawMembers.isEmpty()) continue;
                        members.addAll(rawMembers);
                    }
                }
                Set memberNumbers = members.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                Dataset dataset = Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)srcDatasetId));
                memberNumbers = ShrekOlapServiceHelper.getExistDataMember((Model)modelCache.getModelobj(), Collections.singletonList(dataset), (String)dim.getNumber(), memberNumbers);
                if (memberNumbers == null || memberNumbers.size() < 1) {
                    this.addUploadLog(ResManager.loadResFormat((String)"\u6e90\u6210\u5458\u7ec4\u5408\u4e0b\u6ca1\u6709\u6570\u636e\u79d1\u76ee%1\u3001\u7ef4\u5ea6%2\u3002", (String)"EbDataUploadRecordPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[]{dymAccount.getString("srcaccount.name"), srcdimnumber}), "", "");
                    return null;
                }
                srcDimAndMemMap.put(srcdimnumber, new ArrayList(memberNumbers));
                continue;
            }
            memList.add(srcdimmemnumber);
            srcDimAndMemMap.put(srcdimnumber, memList);
        }
        srcDimAndMemMap.put(SysDimensionEnum.Entity.getNumber(), Lists.newArrayList((Object[])new String[]{org}));
        srcDimAndMemMap.put(SysDimensionEnum.Account.getNumber(), Lists.newArrayList((Object[])new String[]{srcAccountDym.getString("number")}));
        List budgetperiod = (List)SerializationUtils.fromJsonString((String)this.currPeriod, List.class);
        List<String> bgFilterList = this.getBudgetperiodList(budgetperiod, dymAccount);
        srcDimAndMemMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), bgFilterList);
        List metricNumbers = modelCache.getMembers(null, SysDimensionEnum.Metric.getNumber()).stream().map(BaseCache::getNumber).collect(Collectors.toList());
        srcDimAndMemMap.put(SysDimensionEnum.Metric.getNumber(), metricNumbers);
        return srcDimAndMemMap;
    }

    private List<String> getBudgetperiodList(List<String> budgetperiod, DynamicObject dymAccount) {
        ArrayList<String> bgFilterList = new ArrayList<String>(budgetperiod.size());
        for (String date : budgetperiod) {
            String startDate = dymAccount.getString("startdate.number");
            int startYear = Integer.parseInt(startDate.split("\\.")[0].substring(2));
            int startMonth = Integer.parseInt(startDate.split("\\.")[1].substring(1));
            String endDate = dymAccount.getString("enddate.number");
            int endYear = 0;
            int endMonth = 0;
            int uploadYear = Integer.parseInt(date.split("\\.")[0].substring(2));
            int uploadMonth = Integer.parseInt(date.split("\\.")[1].substring(1));
            if (endDate != null) {
                endYear = Integer.parseInt(endDate.split("\\.")[0].substring(2));
                endMonth = Integer.parseInt(endDate.split("\\.")[1].substring(1));
                if (uploadYear < startYear || uploadYear > endYear || uploadMonth < startMonth || uploadMonth > endMonth) continue;
                bgFilterList.add(date);
                continue;
            }
            if (endDate != null || uploadYear < startYear || uploadMonth < startMonth) continue;
            bgFilterList.add(date);
        }
        return bgFilterList;
    }

    public void addUploadLog(String msg, String srcCellNums, String trgCellNums) {
        DynamicObject logDetail = BusinessDataServiceHelper.newDynamicObject((String)"eb_datauploadlog");
        logDetail.set("number", (Object)this.currScheme.getString("number"));
        logDetail.set("name", (Object)this.currScheme.getString("name"));
        logDetail.set("uploaduser", (Object)UserUtils.getUserId());
        logDetail.set("uploaddate", (Object)new Date());
        logDetail.set("entity", (Object)this.currOrgId);
        logDetail.set("description", (Object)msg);
        logDetail.set("model", (Object)this.currModelId);
        logDetail.set("budgetperiod", (Object)this.currPeriod);
        logDetail.set("srctotal", (Object)srcCellNums);
        logDetail.set("totalmapping", (Object)trgCellNums);
        if (StringUtils.isEmpty((CharSequence)msg)) {
            logDetail.set("uploadstatus", (Object)"1");
        } else {
            logDetail.set("uploadstatus", (Object)"2");
        }
        ArrayList<DynamicObject> logDocs = new ArrayList<DynamicObject>(16);
        logDocs.add(logDetail);
        SaveServiceHelper.save((DynamicObject[])logDocs.toArray(new DynamicObject[logDocs.size()]));
    }
}

