/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataanalyse;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.BizModelEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;

public abstract class BgBaseDataPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private IModelCacheHelper modelCacheHelper = null;
    private static final String CACHE_DIMENSION = "cache_dimension";
    public static final String CLOSE_BACK_SELECTMEMBERS = "selectmembers";

    public IModelCacheHelper getModelCacheHelper(Long modelId) {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = IDUtils.isNull((Long)modelId) ? ModelCacheContext.getOrCreate((Long)this.getModelId()) : ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCacheHelper;
    }

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"members"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("model");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        basedataEdit = (BasedataEdit)this.getControl("busmodel");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        basedataEdit = (BasedataEdit)this.getControl("dataset");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyKey;
        switch (propertyKey = e.getProperty().getName()) {
            case "model": {
                this.beforeF7Select_model(e);
                break;
            }
            case "busmodel": {
                this.beforeF7Select_busModel(e);
                break;
            }
            case "dataset": {
                this.beforeF7Select_dataset(e);
            }
        }
    }

    protected void beforeF7Select_model(BeforeF7SelectEvent event) {
        PluginUtils.setModelFilter(event, this.getView());
    }

    protected void beforeF7Select_busModel(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)event.getSource()).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>();
        }
        filters.add(new QFilter("model", "=", (Object)this.getModelId()));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
    }

    protected void beforeF7Select_dataset(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)event.getSource()).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>();
        }
        filters.add(new QFilter("model", "=", (Object)this.getModelId()));
        filters.add(new QFilter("businessmodel", "=", (Object)this.getBusModelId()));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyKey;
        super.propertyChanged(e);
        switch (propertyKey = e.getProperty().getName()) {
            case "model": {
                this.propertyChanged_model(e);
                break;
            }
            case "busmodel": {
                this.propertyChanged_busModel(e);
                break;
            }
            case "dataset": {
                this.propertyChanged_dataset(e);
                break;
            }
            case "members": {
                this.propertyChanged_members(e);
            }
        }
    }

    protected void propertyChanged_model(PropertyChangedArgs event) {
    }

    protected void propertyChanged_busModel(PropertyChangedArgs event) {
    }

    protected void propertyChanged_dataset(PropertyChangedArgs event) {
    }

    protected void propertyChanged_members(PropertyChangedArgs event) {
        ChangeData data;
        ChangeData[] datas = event.getChangeSet();
        if (datas != null && datas.length > 0 && (data = datas[0]) != null && (data.getNewValue() == null || "".equals(data.getNewValue()))) {
            EntryGrid entry = (EntryGrid)this.getControl("dimensions");
            this.getModel().setValue("data", null, entry.getEntryState().getFocusRow());
        }
    }

    protected Object getPropertyChangedValue(PropertyChangedArgs event) {
        ChangeData changeData;
        if (event == null || event.getChangeSet() == null) {
            return null;
        }
        ChangeData[] data = event.getChangeSet();
        if (data != null && data.length > 0 && (changeData = data[0]).getNewValue() != null) {
            return changeData.getNewValue();
        }
        return null;
    }

    protected void setDefaultBusModel(DynamicObject model) {
        if (model == null) {
            return;
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)model.getLong("id"));
        builder.add("number", "=", (Object)BizModelEnum.AUNNALBUDGET.getNumber());
        DynamicObject busModel = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (String)"id, name, number", (QFilter[])builder.toArrays());
        this.getModel().setValue("busmodel", (Object)busModel);
    }

    protected void setDefaultDataset(DynamicObject model, DynamicObject busModel) {
        if (model == null || busModel == null) {
            return;
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)model.getLong("id"));
        builder.add("businessmodel", "=", (Object)busModel.getLong("id"));
        builder.add("number", "=", (Object)"default");
        DynamicObject dataset = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_dataset", (String)"id, name, number", (QFilter[])builder.toArrays());
        this.getModel().setValue("dataset", (Object)dataset);
    }

    protected DynamicObject getBizModel() {
        return (DynamicObject)this.getModel().getValue("model");
    }

    @Override
    public Long getModelId() {
        DynamicObject model = this.getBizModel();
        return model != null ? model.getLong("id") : 0L;
    }

    protected DynamicObject getBusModel() {
        return (DynamicObject)this.getModel().getValue("busmodel");
    }

    protected Long getBusModelId() {
        DynamicObject busModel = this.getBusModel();
        return busModel != null ? busModel.getLong("id") : 0L;
    }

    protected DynamicObject getDataset() {
        return (DynamicObject)this.getModel().getValue("dataset");
    }

    protected Long getDatasetId() {
        DynamicObject dataset = this.getDataset();
        return dataset != null ? dataset.getLong("id") : 0L;
    }

    protected void loadDimension(DynamicObject model, DynamicObject dataset) {
        if (model != null && !BizModel.isEBByModel((DynamicObject)model) && dataset == null) {
            this.getModel().deleteEntryData("dimensions");
            return;
        }
        IDataModel dataModel = this.getModel();
        dataModel.beginInit();
        dataModel.deleteEntryData("dimensions");
        if (model != null) {
            IModelCacheHelper modelCache = this.getModelCacheHelper(model.getLong("id"));
            List dimensions = dataset == null ? modelCache.getDimensionList() : modelCache.getDimensionList(Long.valueOf(dataset.getLong("id")));
            if (dimensions != null) {
                BgBaseDataPlugin.cacheDimension1(this.getPageCache(), dimensions);
                int[] rows = dataModel.batchCreateNewEntryRow("dimensions", dimensions.size());
                int in = rows.length;
                for (int i = 0; i < in; ++i) {
                    Dimension dimension = (Dimension)dimensions.get(i);
                    dataModel.setValue("dimid", (Object)dimension.getId(), rows[i]);
                    dataModel.setValue("dimname", (Object)dimension.getName(), rows[i]);
                    dataModel.setValue("dimnumber", (Object)dimension.getNumber(), rows[i]);
                }
            }
        }
        dataModel.endInit();
        this.getView().updateView("dimensions");
    }

    public static void cacheDimension1(IPageCache pageCache, List<Dimension> dimensions) {
        if (pageCache == null) {
            return;
        }
        pageCache.remove(CACHE_DIMENSION);
        if (dimensions == null || dimensions.isEmpty()) {
            return;
        }
        HashMap dimensionMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
        for (Dimension dimension : dimensions) {
            dimensionMap.put(dimension.getNumber(), dimension.getId());
        }
        pageCache.put(CACHE_DIMENSION, SerializationUtils.toJsonString((Object)dimensionMap));
    }

    public static List<Dimension> getCacheDimension1(IPageCache pageCache, List<Dimension> dimensions) {
        Map dimensionMap;
        if (pageCache == null || dimensions == null) {
            return null;
        }
        String jsonStr = pageCache.get(CACHE_DIMENSION);
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)jsonStr) && (dimensionMap = (Map)SerializationUtils.fromJsonString((String)jsonStr, LinkedHashMap.class)) != null) {
            return dimensions.stream().filter(d -> dimensionMap.containsKey(d.getNumber())).collect(Collectors.toList());
        }
        return null;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        clickKey.getClass();
    }

    public void click(EventObject evt) {
        String clickKey;
        super.click(evt);
        switch (clickKey = ((Control)evt.getSource()).getKey()) {
            case "members": {
                this.click_selectMembers();
            }
        }
    }

    protected void click_selectMembers() {
        BgBaseDataPlugin.selectMembers(this.getView(), this.getModel(), (IFormPlugin)this, this.getModelId(), this.getBusModelId(), this.getDatasetId());
    }

    public static void selectMembers(IFormView view, IDataModel model, IFormPlugin plugin, Long modelId, Long busModelId, Long datasetId) {
        BgBaseDataPlugin.selectMembers(view, model, plugin, modelId, busModelId, datasetId, true);
    }

    public static void selectMembers(IFormView view, IDataModel model, IFormPlugin plugin, Long modelId, Long busModelId, Long datasetId, boolean multipleF7) {
        BgBaseDataPlugin.selectMembers(view, model, plugin, modelId, busModelId, datasetId, true, false);
    }

    public static void selectMembers(IFormView view, IDataModel model, IFormPlugin plugin, Long modelId, Long busModelId, Long datasetId, boolean multipleF7, boolean enableView) {
        List jsonList;
        if (view == null || model == null || IDUtils.isNull((Long)modelId)) {
            return;
        }
        EntryGrid entry = (EntryGrid)view.getControl("dimensions");
        DynamicObject entryData = model.getEntryRowEntity("dimensions", entry.getEntryState().getFocusRow());
        if (entryData == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"BgDataAnalysePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String dimNumber = entryData.getString("dimnumber");
        if (busModelId == null) {
            busModelId = datasetId != null ? DatasetServiceHelper.getBusModelIdByDataset((Long)datasetId) : Long.valueOf(0L);
        }
        LinkedHashSet ids = Sets.newLinkedHashSet();
        String memberStr = entryData.getString("data");
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)memberStr) && (jsonList = JSON.parseArray((String)memberStr, JSONObject.class)) != null && !jsonList.isEmpty()) {
            ids.addAll(jsonList.stream().map(obj -> IDUtils.toLong((Object)obj.getString("id"))).collect(Collectors.toSet()));
        }
        ArrayList<Long> datasetIds = new ArrayList<Long>();
        if (datasetId != null) {
            datasetIds.add(datasetId);
        } else {
            datasetIds.addAll(DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(busModelId));
        }
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
        f7Param.setMultiSelect(multipleF7);
        f7Param.setBusModelId(busModelId);
        f7Param.setDatasetIds(datasetIds);
        f7Param.setSelectIds((Set)ids);
        if ("AuditTrail".equals(dimNumber)) {
            f7Param.setShowNotEnable(true);
        }
        f7Param.setHideDecompose(false);
        if (SysDimensionEnum.ChangeType.getNumber().equals(dimNumber)) {
            f7Param.setEnableView(true);
        }
        f7Param.setEnableView(enableView);
        NewF7Utils.openF7((IFormView)view, (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack(plugin, CLOSE_BACK_SELECTMEMBERS));
    }

    protected boolean verifyModel() {
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"BgDataAnalysePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean verifyBusModel() {
        Long busModelId = this.getBusModelId();
        if (IDUtils.isNull((Long)busModelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"BgDataAnalysePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean verifyDataset() {
        Long datasetId = this.getDatasetId();
        if (IDUtils.isNull((Long)datasetId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6", (String)"BgDataAnalysePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getReturnData() == null) {
            return;
        }
        switch (evt.getActionId()) {
            case "selectmembers": {
                BgBaseDataPlugin.updateMemberData(this.getView(), evt.getReturnData());
                break;
            }
        }
    }

    public static void updateMemberData(IFormView view, Object obj) {
        String data = null;
        String memberShow = null;
        if (obj instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection members = (ListSelectedRowCollection)obj;
            ArrayList<JSONObject> _members = new ArrayList<JSONObject>(16);
            StringBuilder name = new StringBuilder();
            for (ListSelectedRow member : members) {
                JSONObject json = new JSONObject();
                json.fluentPut("id", member.getPrimaryKeyValue()).fluentPut("number", (Object)member.getNumber()).fluentPut("name", (Object)member.getName());
                _members.add(json);
                name.append(member.getName()).append(", ");
            }
            if (name.length() > 2) {
                name.setLength(name.length() - 2);
            }
            data = JSON.toJSONString(_members);
            memberShow = name.toString();
        }
        EntryGrid entry = (EntryGrid)view.getControl("dimensions");
        int rowIndex = entry.getEntryState().getFocusRow();
        view.getModel().setValue("data", data, rowIndex);
        view.getModel().setValue("members", memberShow, rowIndex);
    }

    protected Map<String, Set<Long>> getMembers() {
        return BgBaseDataPlugin.getMembers(this.getModel());
    }

    public static Map<String, Set<Long>> getMembers(IDataModel dataModel) {
        HashMap<String, Set<Long>> memberMap = new HashMap<String, Set<Long>>(16);
        DynamicObjectCollection dimensions = dataModel.getEntryEntity("dimensions");
        if (dimensions != null) {
            for (DynamicObject dimension : dimensions) {
                HashSet<Long> memberSet = new HashSet<Long>(16);
                memberMap.put(dimension.getString("dimnumber"), memberSet);
                String json = dimension.getString("data");
                if (!StringUtils.isNotEmpty((String)json)) continue;
                List jsonList = JSON.parseArray((String)json, JSONObject.class);
                for (JSONObject jsonObj : jsonList) {
                    memberSet.add(IDUtils.toLong((Object)jsonObj.getString("id")));
                }
            }
        }
        return memberMap;
    }

    protected Map<String, Set<String>> getMemberNums() {
        return BgBaseDataPlugin.getMemberNums(this.getModel());
    }

    public static Map<String, Set<String>> getMemberNums(IDataModel dataModel) {
        HashMap<String, Set<String>> memberMap = new HashMap<String, Set<String>>(16);
        DynamicObjectCollection dimensions = dataModel.getEntryEntity("dimensions");
        if (dimensions != null) {
            for (DynamicObject dimension : dimensions) {
                HashSet<String> memberSet = new HashSet<String>(16);
                String json = dimension.getString("data");
                if (!StringUtils.isNotEmpty((String)json)) continue;
                List jsonList = JSON.parseArray((String)json, JSONObject.class);
                for (JSONObject jsonObj : jsonList) {
                    memberSet.add(jsonObj.getString("number"));
                }
                memberMap.put(dimension.getString("dimnumber"), memberSet);
            }
        }
        return memberMap;
    }
}

