/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataanalyse;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.DeleteOlapDataLog;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.formplugin.dataanalyse.BgBaseDataPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BgDataAnalysePlugin
extends BgBaseDataPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(BgDataAnalysePlugin.class);
    private static final int MAX_ROW_SIZE = 50000;
    private static final int MAX_USER_DEFINED_SIZE = 8;
    private static final Map<String, String> fieldIndexMap = new LinkedHashMap<String, String>();
    private static final String BTN_QUERY_DATA = "btnquerydata";
    private static final String BTN_QUERY_CONTROL_DATA = "btncontroldata";
    private static final String BTN_QUERY_REMOVE_LOG = "btnqueryoperlog";
    private static final String BTN_RECOVER = "btnrecover";
    private static final String BTN_EXPORT_FILE = "btnexportfile";
    private static final String BTN_DELETE_DATA = "btncleardata";
    private static final String BTN_CLEAR_DATA = "btnsetzero";
    private static final String CHK_AGG = "chkagg";
    private Map<Long, String> userMap = Maps.newLinkedHashMap();

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("MODELID");
        if (modelId != null && modelId != 0L) {
            this.getModel().setValue("model", (Object)modelId);
            DynamicObject model = this.getBizModel();
            this.setDefaultBusModel(model);
            this.setDefaultDataset(model, this.getBusModel());
            DynamicObject dataset = this.getDataset();
            this.initEntry(model, dataset);
            this.loadDimension(model, dataset);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_CLEAR_DATA, BTN_DELETE_DATA, BTN_RECOVER});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"table", "modifier", "modifytime", "occperiod"});
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btnquerydata": {
                this.queryData();
                break;
            }
            case "btncontroldata": {
                this.queryControlData();
                break;
            }
            case "btnqueryoperlog": {
                this.queryOperationLog();
                break;
            }
            case "btnrecover": {
                this.recoverData();
                break;
            }
            case "btnexportfile": {
                this.exportToFile();
                break;
            }
            case "btncleardata": {
                this.beforeRemoveData();
                break;
            }
            case "btnsetzero": {
                this.beforeClearData();
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    @Override
    protected void propertyChanged_model(PropertyChangedArgs event) {
        this.getModel().deleteEntryData("dimensions");
        this.getModel().deleteEntryData("entryentity");
        Object object = this.getPropertyChangedValue(event);
        if (object instanceof DynamicObject) {
            this.setDefaultBusModel((DynamicObject)object);
        } else {
            this.getModel().setValue("busmodel", null);
        }
    }

    @Override
    protected void propertyChanged_busModel(PropertyChangedArgs event) {
        this.getModel().deleteEntryData("dimensions");
        this.getModel().deleteEntryData("entryentity");
        Object object = this.getPropertyChangedValue(event);
        if (object instanceof DynamicObject) {
            this.setDefaultDataset(this.getBizModel(), (DynamicObject)object);
        } else {
            this.getModel().setValue("dataset", null);
        }
    }

    @Override
    protected void propertyChanged_dataset(PropertyChangedArgs event) {
        DynamicObject model = this.getBizModel();
        DynamicObject dataset = this.getDataset();
        this.loadDimension(model, dataset);
        this.initEntry(model, dataset);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            switch (e.getCallBackId()) {
                case "btncleardata": {
                    this.removeData();
                    break;
                }
                case "btnsetzero": {
                    this.clearData();
                    break;
                }
            }
        }
    }

    private void clearEntry() {
        this.getModel().deleteEntryData("entryentity");
    }

    private void initEntry(DynamicObject model, DynamicObject dataset) {
        if (model == null || dataset == null) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model.getLong("id"));
        List dimensions = modelCacheHelper.getDimensionList(Long.valueOf(dataset.getLong("id")));
        if (dimensions != null) {
            String dimKey;
            int index = 1;
            HashSet<String> cusColumns = new HashSet<String>(8);
            HashSet<String> hideCusColumns = new HashSet<String>(8);
            Dimension icDim = null;
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            if (entry != null) {
                for (Dimension dimension : dimensions) {
                    if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                        dimKey = "userdefined" + index++;
                        cusColumns.add(dimKey);
                        entry.setColumnProperty(dimKey, "header", (Object)dimension.getName());
                        continue;
                    }
                    if (!SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) continue;
                    icDim = dimension;
                }
            }
            for (int i = 1; i <= 8; ++i) {
                dimKey = "userdefined" + i;
                if (cusColumns.contains(dimKey)) continue;
                hideCusColumns.add(dimKey);
            }
            this.getView().setVisible(Boolean.valueOf(icDim != null), new String[]{fieldIndexMap.get(SysDimensionEnum.InternalCompany.getNumber())});
            if (!cusColumns.isEmpty()) {
                this.getView().setVisible(Boolean.TRUE, cusColumns.toArray(new String[0]));
            }
            if (!hideCusColumns.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, hideCusColumns.toArray(new String[0]));
            }
        }
    }

    @Override
    protected void click_selectMembers() {
        BgDataAnalysePlugin.selectMembers(this.getView(), this.getModel(), (IFormPlugin)this, this.getModelId(), this.getBusModelId(), this.getDatasetId(), true, true);
    }

    private void queryShrek() {
        Object[] values;
        this.clearEntry();
        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_CLEAR_DATA, BTN_DELETE_DATA});
        this.getView().setVisible(Boolean.FALSE, new String[]{"table"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"occperiod"});
        Long modelId = this.getModelId();
        Long datasetId = this.getDatasetId();
        Dataset dataset = Dataset.of((DynamicObject)BusinessDataServiceHelper.loadSingleFromCache((Object)datasetId, (String)"eb_dataset"));
        IModelCacheHelper cacheHelper = this.getModelCacheHelper(modelId);
        List dimensions = cacheHelper.getDimensionList(datasetId);
        String[] dimNumbers = cacheHelper.getDimensionNums(datasetId);
        SelectCommandInfo query = new SelectCommandInfo();
        query.addDims(dimNumbers);
        query.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        query.setExcludeNull(true);
        query.setTop(50000);
        Map<String, Set<String>> members = this.getMemberNums();
        if (members != null) {
            members.entrySet().forEach(p -> {
                if (!((Set)p.getValue()).isEmpty()) {
                    query.addFilter((String)p.getKey(), ((Set)p.getValue()).toArray(new String[0]));
                }
            });
        }
        ArrayList allValues = Lists.newArrayListWithExpectedSize((int)50000);
        HashSet useColumns = Sets.newHashSetWithExpectedSize((int)dimensions.size());
        LogStats stats = new LogStats("budget-data-log : ");
        try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)cacheHelper.getModelobj(), (Dataset)dataset, (SelectCommandInfo)query, (boolean)this.hasAgg(), (LogStats)stats);){
            while (reader.hasNext()) {
                values = reader.next();
                if (values == null || values[0] == null) continue;
                allValues.add(values);
            }
        }
        if (allValues.isEmpty()) {
            return;
        }
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow("entryentity", allValues.size());
        int rowCount = allValues.size();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            values = (Object[])allValues.get(rowIndex);
            int userDefined = 1;
            DynamicObject object = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            object.set("id", null);
            object.set("table", (Object)"shrek");
            object.set("value", values[0]);
            object.set("modifier", null);
            object.set("modifytime", null);
            object.set("dimkey", null);
            int in = dimensions.size();
            for (int i = 0; i < in; ++i) {
                Dimension dimension = (Dimension)dimensions.get(i);
                String showColumn = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? "userdefined" + userDefined++ : fieldIndexMap.get(dimension.getNumber());
                useColumns.add(showColumn);
                Member member = this.getMemberByViewGroup(cacheHelper, datasetId, dimension.getNumber(), (String)values[i + 1]);
                if (member != null) {
                    object.set(showColumn, (Object)(member.getName() + "\r\n" + member.getNumber()));
                    if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                        object.set("orgid", (Object)member.getId());
                        continue;
                    }
                    if (!SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) continue;
                    object.set("accountid", (Object)member.getId());
                    continue;
                }
                object.set(showColumn, values[i + 1]);
            }
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private Member getMemberByViewGroup(IModelCacheHelper cacheHelper, Long dataset, String dimNumber, String memberNum) {
        List views = cacheHelper.getViewGroupViewsByDataSetAndDimNumber(dataset, dimNumber);
        if (CollectionUtils.isEmpty((Collection)views)) {
            return cacheHelper.getMember(dimNumber, null, memberNum);
        }
        for (Long viewId : views) {
            Member member = cacheHelper.getMember(dimNumber, viewId, memberNum);
            if (member == null) continue;
            return member;
        }
        return null;
    }

    protected boolean verify(boolean verifyDataset) {
        boolean re = this.verifyModel();
        if (!MemberPermHelper.isModelManager((Long)this.getModelId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u4f53\u7cfb\u7ba1\u7406\u5458\uff0c\u65e0\u6743\u9650\u64cd\u4f5c\u3002", (String)"RoleManagementListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (re && (re = this.verifyBusModel()) && verifyDataset) {
            re = this.verifyDataset();
        }
        return re;
    }

    protected boolean verify() {
        return this.verify(true);
    }

    public void queryData() {
        if (!this.verify()) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"modifier", "modifytime"});
        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_RECOVER});
        try {
            this.queryShrek();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u67e5\u8be2\u5f02\u5e38\uff0c\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002\u5f02\u5e38\u4fe1\u606f\uff1a%1\uff0c%2", (String)"BgDataAnalysePlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[]{RequestContext.get().getTraceId(), e.getMessage()}));
        }
    }

    public void queryControlData() {
        String field;
        this.clearEntry();
        if (!this.verify(false)) {
            return;
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_CLEAR_DATA, BTN_DELETE_DATA});
        this.getView().setVisible(Boolean.TRUE, new String[]{"table"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"occperiod", "modifier", "modifytime"});
        DynamicObject bizModel = this.getBizModel();
        Long busModelId = this.getBusModelId();
        Long datasetId = this.getDatasetId();
        QFBuilder builder = new QFBuilder();
        long modelId = bizModel.getLong("id");
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("businessmodel", "=", (Object)busModelId));
        DynamicObject ctrlDim = BusinessDataServiceHelper.loadSingle((String)"eb_bgmcontroldimension", (String)"id, entryentity.id, entryentity.dimensionid", (QFilter[])builder.toArrays());
        if (ctrlDim == null) {
            String tipMessage = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u6ca1\u6709\u8bbe\u7f6e\u63a7\u5236\u7ef4\u5ea6\u3002", (String)"BgDataAnalysePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if (NewEbAppUtil.isNewEbModel((Long)modelId)) {
                tipMessage = ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6ca1\u6709\u8bbe\u7f6e\u63a7\u5236\u7ef4\u5ea6", (String)"BgDataAnalysePlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            this.getView().showTipNotification(tipMessage);
            return;
        }
        Map<String, Set<String>> members = this.getMemberNums();
        if (members.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u63a7\u5236\u8bb0\u5f55\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"BgDataAnalysePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        IModelCacheHelper cacheHelper = this.getModelCacheHelper(this.getModelId());
        List dimensions = cacheHelper.getDimensionList(datasetId);
        Map dimensionMap = cacheHelper.getDimensionMap();
        Map dimensionIdMap = cacheHelper.getDimensionMapById();
        LinkedHashSet ctrlDims = Sets.newLinkedHashSet();
        for (Object entry : ctrlDim.getDynamicObjectCollection("entryentity")) {
            ctrlDims.add(((Dimension)dimensionIdMap.get(entry.getLong("dimensionid"))).getNumber());
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select top 50000 fid, fmodelid, fentitynumber, fbizid, fbiznumber, foperation, freqorgunitid, forgunitid, freqaccountid, faccountid, fbgperiodid, foccperiodid, fcurrencyid, fversionid, fatid, fctid, fdtid, fmetricid, famount, fcreatetime, fcreatorid, frefbizid", new Object[0]);
        for (Dimension dimension : dimensions) {
            if (!ctrlDims.contains(dimension.getNumber()) || !BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) && !SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) continue;
            if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                if (!ctrlDims.contains(dimension.getNumber())) continue;
                field = BgControlUtils.getUserDefinedIdField((Dimension)dimension);
            } else {
                field = (String)BgControlRecordUtils.getBgMdRecordFields().get(dimension.getNumber());
            }
            sql.append(", ", new Object[0]).append(field, new Object[0]);
        }
        String table = BgControlUtils.getBgControlRecordTable((Long)bizModel.getLong("id"), (Long)busModelId);
        if (!SqlBatchUtils.hasTable((DBRoute)BgBaseConstant.epm, (String)table)) {
            return;
        }
        BgControlRecordUtils.checkExistOccPeriodByRecord((String)table);
        sql.append(" from ", new Object[0]).append(table, new Object[0]);
        HashSet useColumns = Sets.newHashSetWithExpectedSize((int)dimensions.size());
        if (!members.isEmpty()) {
            boolean appAnd = false;
            boolean hasWhere = false;
            for (Map.Entry<String, Set<String>> dimMember : members.entrySet()) {
                Dimension _dimension = (Dimension)dimensionMap.get(dimMember.getKey());
                List views = cacheHelper.getViewGroupViewsByBusModelAndDimNumber(busModelId, _dimension.getNumber());
                List _members = cacheHelper.getMembersByViews(_dimension, (Collection)views, (Collection)dimMember.getValue());
                if (!ctrlDims.contains(_dimension.getNumber())) continue;
                if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)_dimension)) {
                    if (!ctrlDims.contains(_dimension.getNumber())) continue;
                    field = BgControlUtils.getUserDefinedIdField((Dimension)_dimension);
                } else {
                    field = (String)BgControlRecordUtils.getBgMdRecordFields().get(_dimension.getNumber());
                }
                if (_members == null || _members.isEmpty()) continue;
                if (!hasWhere) {
                    sql.append(" where ", new Object[0]);
                    hasWhere = true;
                }
                if (appAnd) {
                    sql.append(" and ", new Object[0]);
                } else {
                    appAnd = true;
                }
                sql.appendIn(field, _members.stream().map(BaseCache::getId).collect(Collectors.toList()));
            }
        }
        try (DataSet ds = DB.queryDataSet((String)"queryControlRecord", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                int rowIndex = 0;
                StringBuilder str = new StringBuilder();
                this.getModel().getDataEntity(true);
                this.getModel().beginInit();
                while (ds.hasNext()) {
                    Row row = ds.next();
                    int userDefined = 1;
                    rowIndex = this.getModel().createNewEntryRow("entryentity");
                    DynamicObject object = this.getModel().getEntryRowEntity("entryentity", rowIndex);
                    str.setLength(0);
                    str.append(table).append(',').append("\r\n");
                    str.append("bizNumber=").append(row.getString("fbiznumber")).append(',').append("\r\n");
                    str.append("bizId=").append(row.getString("fbizid"));
                    if (StringUtils.isNotEmpty((String)row.getString("frefbizid"))) {
                        str.append("\r\n").append("refbizid=").append(row.getString("frefbizid"));
                    }
                    object.set("id", (Object)row.getLong("fid"));
                    object.set("table", (Object)str.toString());
                    object.set("value", (Object)row.getBigDecimal("famount").stripTrailingZeros().toPlainString());
                    object.set("modifier", (Object)row.getLong("fcreatorid"));
                    object.set("modifytime", (Object)row.getTimestamp("fcreatetime"));
                    Long occPeriodId = row.getLong("foccperiodid");
                    for (Dimension dimension : dimensions) {
                        String showColumn;
                        String column;
                        if (!ctrlDims.contains(dimension.getNumber())) {
                            if (!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) continue;
                            ++userDefined;
                            continue;
                        }
                        if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                            column = BgControlUtils.getUserDefinedIdField((Dimension)dimension);
                            showColumn = "userdefined" + userDefined++;
                        } else {
                            column = (String)BgControlRecordUtils.getBgMdRecordFields().get(dimension.getNumber());
                            showColumn = fieldIndexMap.get(dimension.getNumber());
                        }
                        useColumns.add(showColumn);
                        Member _member = cacheHelper.getMemberByAnyView(busModelId, dimension.getNumber(), row.getLong(column));
                        if (_member != null) {
                            object.set(showColumn, (Object)(_member.getName() + "\r\n" + _member.getNumber()));
                            if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                                object.set("orgid", (Object)_member.getId());
                            } else if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
                                object.set("accountid", (Object)_member.getId());
                            }
                        }
                        if (!SysDimensionEnum.Period.getNumber().equals(dimension.getNumber()) && !SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber()) || occPeriodId == null || occPeriodId == 0L || (_member = cacheHelper.getMember(dimension.getNumber(), null, occPeriodId)) == null) continue;
                        object.set("occperiod", (Object)(_member.getName() + "\r\n" + _member.getNumber()));
                        this.getView().setVisible(Boolean.TRUE, new String[]{"occperiod"});
                    }
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity");
            }
        }
        catch (Exception ex) {
            log.error("query-control-data-error:", (Throwable)ex);
            this.getView().showTipNotification(ex.getMessage());
        }
    }

    public void beforeRemoveData() {
        Map<String, Set<String>> dimMembers = this.getMemberNums();
        if (dimMembers == null || dimMembers.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\uff0c\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u7ef4\u5ea6\u6210\u5458\u3002", (String)"BgDataAnalysePlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!dimMembers.containsKey(SysDimensionEnum.Version.getNumber())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u7248\u672c\u3002", (String)"BgDataAnalysePlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(BTN_DELETE_DATA, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u62e9\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\uff0c\u5173\u8054\u7684\u6570\u636e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u5220\u9664\uff1f", (String)"BgDataAnalysePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBack);
    }

    public void removeData() {
        if (!this.verify()) {
            return;
        }
        this.processShrekData(true);
        this.queryData();
    }

    public void beforeClearData() {
        Map<String, Set<String>> dimMembers = this.getMemberNums();
        if (dimMembers == null || dimMembers.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\uff0c\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u7ef4\u5ea6\u6210\u5458\u3002", (String)"BgDataAnalysePlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!dimMembers.containsKey(SysDimensionEnum.Version.getNumber())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u7248\u672c\u3002", (String)"BgDataAnalysePlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(BTN_CLEAR_DATA, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u82e5\u5c06\u5f53\u524d\u6240\u9009\u6570\u636e\u7684\u6570\u503c\u6e05\u9664\uff0c\u5219\u6570\u503c\u4e0d\u53ef\u6062\u590d\uff0c\u786e\u8ba4\u6e05\u9664\u6240\u9009\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u5173\u8054\u7684\u6570\u636e\uff1f", (String)"BgDataAnalysePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBack);
    }

    public void clearData() {
        if (!this.verify()) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"modifier", "modifytime"});
        this.processShrekData(false);
        this.queryData();
    }

    protected void processShrekData(boolean isClear) {
    }

    protected String getMemberKey(DynamicObject object, IModelCacheHelper modelCacheHelper, List<Dimension> dimensions) {
        if (object == null || modelCacheHelper == null || dimensions == null) {
            return null;
        }
        int userDefined = 1;
        StringBuilder str = new StringBuilder();
        for (Dimension dimension : dimensions) {
            String[] tmpStrs;
            String column = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? "userdefined" + userDefined++ : fieldIndexMap.get(dimension.getNumber());
            String tmpStr = object.getString(column);
            if (!StringUtils.isNotEmpty((String)tmpStr) || (tmpStrs = tmpStr.split("\r\n")).length <= 1) continue;
            str.append(dimension.getShortNumber()).append('@').append(tmpStrs[1]).append('!');
        }
        return str.toString();
    }

    protected void exportToFile() {
        XSSFCell cell;
        String column;
        if (!this.verify()) {
            return;
        }
        DynamicObjectCollection objs = this.getModel().getEntryEntity("entryentity");
        if (objs == null || objs.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u672a\u627e\u5230\u6570\u636e\uff0c\u65e0\u6cd5\u5bfc\u51fa\u6570\u636e\u3002", (String)"BgDataAnalysePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long modelId = this.getModelId();
        Long datasetId = this.getDatasetId();
        int userDefined = 1;
        IModelCacheHelper cacheHelper = this.getModelCacheHelper(modelId);
        List dimensions = cacheHelper.getDimensionList(datasetId);
        HashMap<String, String> dimName = new HashMap<String, String>(dimensions.size());
        LinkedHashSet columns = Sets.newLinkedHashSet();
        columns.add("table");
        columns.add("value");
        if (!ShrekOlapServiceHelper.isStartShrek()) {
            columns.add("modifier");
            columns.add("modifytime");
        }
        boolean hasOccPeriod = false;
        int in = objs.size();
        for (int i = 0; i < in; ++i) {
            DynamicObject obj = (DynamicObject)objs.get(i);
            if (!obj.containsProperty("occperiod") || StringUtils.isEmpty((String)obj.getString("occperiod"))) continue;
            hasOccPeriod = true;
        }
        for (Dimension dimension : dimensions) {
            if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                column = "userdefined" + userDefined++;
                dimName.put(column.toLowerCase(), dimension.getName());
            } else if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) {
                column = fieldIndexMap.get(dimension.getNumber());
                dimName.put(column, dimension.getName());
            } else {
                column = fieldIndexMap.get(dimension.getNumber());
                dimName.put(column.toLowerCase(), dimension.getName());
            }
            columns.add(column);
            if (!SysDimensionEnum.Period.getNumber().equals(dimension.getNumber()) && !SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber()) || !hasOccPeriod) continue;
            columns.add("occperiod");
            dimName.put("occperiod", ResManager.loadKDString((String)"\u51b2\u51cf\u671f\u95f4", (String)"BgDataAnalysePlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        XSSFWorkbook book = new XSSFWorkbook();
        XSSFSheet sheet = book.createSheet();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        List fieldEdits = entryGrid.getFieldEdits();
        ArrayList<String> fields = new ArrayList<String>(fieldEdits.size());
        XSSFRow row = sheet.createRow(0);
        int jn = fieldEdits.size();
        int index = 0;
        for (int j = 0; j < jn; ++j) {
            column = ((FieldEdit)fieldEdits.get(j)).getProperty().getName();
            if (!columns.contains(column)) continue;
            if (dimName.containsKey(column)) {
                cell = row.createCell(index++);
                cell.setCellValue(ResManager.loadResFormat((String)"%1\u7f16\u7801", (String)"BgDataAnalysePlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[]{dimName.get(column)}));
                fields.add(column);
                cell = row.createCell(index++);
                cell.setCellValue(ResManager.loadResFormat((String)"%1\u540d\u79f0", (String)"BgDataAnalysePlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[]{dimName.get(column)}));
                fields.add(column + "number");
                continue;
            }
            if ("value".equals(column)) {
                cell = row.createCell(index++);
                cell.setCellValue(ResManager.loadKDString((String)"\u6570\u503c", (String)"BgDataAnalysePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                fields.add(column);
                continue;
            }
            if ("table".equals(column)) {
                cell = row.createCell(index++);
                cell.setCellValue(ResManager.loadKDString((String)"\u6570\u636e\u8868", (String)"BgDataAnalysePlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                fields.add(column);
                cell = row.createCell(index++);
                cell.setCellValue(ResManager.loadKDString((String)"\u4e3b\u952e", (String)"BgDataAnalysePlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                fields.add("id");
                continue;
            }
            cell = row.createCell(index++);
            cell.setCellValue(column);
            fields.add(column);
        }
        int in2 = objs.size();
        for (int i = 0; i < in2; ++i) {
            DynamicObject obj = (DynamicObject)objs.get(i);
            row = sheet.createRow(i + 1);
            int jn2 = fields.size();
            for (int j = 0; j < jn2; ++j) {
                String value;
                String field = (String)fields.get(j);
                if (dimName.containsKey(field)) {
                    value = (String)DataType.convertValue((DataType)DataType.StringType, (Object)obj.get(field));
                    if (StringUtils.isNotEmpty((String)value) && value.contains("\r\n")) {
                        String[] parts = value.split("\r\n", 2);
                        value = parts[1];
                    }
                } else if (field.endsWith("number")) {
                    String substring = field.substring(0, field.length() - 6);
                    if (dimName.containsKey(substring)) {
                        value = (String)DataType.convertValue((DataType)DataType.StringType, (Object)obj.get(substring));
                        if (StringUtils.isNotEmpty((String)value) && value.contains("\r\n")) {
                            String[] parts = value.split("\r\n", 2);
                            value = parts[0];
                        }
                    } else {
                        value = (String)DataType.convertValue((DataType)DataType.StringType, (Object)obj.get(field));
                    }
                } else {
                    value = (String)DataType.convertValue((DataType)DataType.StringType, (Object)obj.get(field));
                }
                cell = row.createCell(j);
                cell.setCellValue((String)DataType.convertValue((DataType)DataType.StringType, (Object)value));
            }
        }
        try {
            String url = POIUtils.writeFile((Workbook)book, (String)ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa", (String)"BgDataAnalysePlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (StringUtils.isNotEmpty((String)url)) {
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    protected void queryOperationLog() {
        if (!this.verify()) {
            return;
        }
        this.clearEntry();
        this.getView().setVisible(Boolean.TRUE, new String[]{"modifier", "modifytime"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"table", "occperiod"});
        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_RECOVER});
        Long modelId = this.getModelId();
        Long datasetId = this.getDatasetId();
        String logTable = DeleteOlapDataLog.getInstance().getLogTable(modelId);
        if (!SqlBatchUtils.hasTable((String)logTable)) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select top 50000 fid, fmodifytime, fmodifierid, forgunitid, faccountid, fvalue, fdata, ftype from ", new Object[0]);
        sql.append(logTable, new Object[0]).append(" where 1=1 ", new Object[0]);
        Map<String, Set<Long>> members = this.getMembers();
        if (!members.isEmpty()) {
            Set<Long> accountIds;
            Set<Long> orgUnitIds = members.get(SysDimensionEnum.Entity.getNumber());
            if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
                sql.append(" and ", new Object[0]).appendIn("forgunitid", new ArrayList<Long>(orgUnitIds));
            }
            if ((accountIds = members.get(SysDimensionEnum.Account.getNumber())) != null && !accountIds.isEmpty()) {
                sql.append(" and ", new Object[0]).appendIn("faccountid", new ArrayList<Long>(accountIds));
            } else {
                sql.append(" and faccountid in (select fid from t_eb_structofaccount where fdataset = ?)", new Object[]{datasetId});
            }
        }
        sql.append("order by fmodifytime desc", new Object[0]);
        IModelCacheHelper cacheHelper = this.getModelCacheHelper(modelId);
        List allDims = cacheHelper.getDimensionList();
        HashMap dimMap = Maps.newHashMapWithExpectedSize((int)allDims.size());
        for (Dimension dimension : allDims) {
            dimMap.put(dimension.getShortNumber(), dimension);
        }
        Map viewIds = cacheHelper.getViewsByDataSet(datasetId);
        this.getModel().getDataEntity(true);
        this.getModel().beginInit();
        try (DataSet ds = DB.queryDataSet((String)"queryDataOperLog", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            for (Row row : ds) {
                Dimension dimension;
                String dataStr;
                String showColumn;
                int userDefined = 1;
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                DynamicObject object = this.getModel().getEntryRowEntity("entryentity", rowIndex);
                object.set("id", (Object)row.getLong("fid"));
                object.set("table", (Object)row.getString("fdata"));
                object.set("value", (Object)row.getBigDecimal("fvalue").stripTrailingZeros().toPlainString());
                object.set("modifier", (Object)this.getUserName(row.getLong("fmodifierid")));
                object.set("modifytime", (Object)row.getTimestamp("fmodifytime"));
                Member member = cacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), (Long)viewIds.get("Entity"), row.getLong("forgunitid"));
                if (member != null) {
                    showColumn = fieldIndexMap.get(SysDimensionEnum.Entity.getNumber());
                    object.set(showColumn, (Object)(member.getName() + "\r\n" + member.getNumber()));
                }
                if ((member = cacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, row.getLong("faccountid"))) != null) {
                    showColumn = fieldIndexMap.get(SysDimensionEnum.Account.getNumber());
                    object.set(showColumn, (Object)(member.getName() + "\r\n" + member.getNumber()));
                }
                if (!StringUtils.isNotEmpty((String)(dataStr = row.getString("fdata")))) continue;
                if (dataStr.contains("!") && dataStr.contains("@")) {
                    String[] strs = dataStr.split("!");
                    if (strs == null) continue;
                    for (String dimStr : strs) {
                        String[] keys = dimStr.split("@");
                        dimension = (Dimension)dimMap.get(keys[0]);
                        showColumn = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? "userdefined" + userDefined++ : fieldIndexMap.get(dimension.getNumber());
                        member = cacheHelper.getMember(dimension.getNumber(), (Long)viewIds.get(dimension.getNumber()), keys[1]);
                        if (member != null) {
                            object.set(showColumn, (Object)(member.getName() + "\r\n" + member.getNumber()));
                            continue;
                        }
                        object.set(showColumn, (Object)ResManager.loadResFormat((String)"%1(\u5df2\u5220\u9664)", (String)"BgDataAnalysePlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[]{keys[1]}));
                    }
                    continue;
                }
                Map map = (Map)JsonUtils.readValue((String)dataStr, Map.class);
                for (Map.Entry entry : map.entrySet()) {
                    String dimNumber = (String)entry.getKey();
                    String memNumber = (String)entry.getValue();
                    dimension = cacheHelper.getDimension(dimNumber);
                    showColumn = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? "userdefined" + userDefined++ : fieldIndexMap.get(dimNumber);
                    member = cacheHelper.getMember(dimension.getNumber(), (Long)viewIds.get(dimension.getNumber()), memNumber);
                    if (member != null) {
                        object.set(showColumn, (Object)(member.getName() + "\r\n" + member.getNumber()));
                        continue;
                    }
                    object.set(showColumn, (Object)ResManager.loadResFormat((String)"%1(\u5df2\u5220\u9664)", (String)"BgDataAnalysePlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[]{memNumber}));
                }
            }
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private String getUserName(Long userId) {
        if (IDUtils.isNull((Long)userId)) {
            return null;
        }
        return this.userMap.computeIfAbsent(userId, f -> {
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"id, name");
            if (user != null) {
                return user.getString("name");
            }
            return null;
        });
    }

    private void recoverData() {
        if (!this.verify()) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selRows = entryGrid.getSelectRows();
        if (selRows == null || selRows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6062\u590d\u7684\u6570\u636e\u3002", (String)"BgDataAnalysePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.add("begin-recoverData.");
        Long modelId = this.getModelId();
        Long datasetId = this.getDatasetId();
        DynamicObject dataset = this.getDataset();
        LinkedList recoverData = Lists.newLinkedList();
        IModelCacheHelper cacheHelper = this.getModelCacheHelper(modelId);
        List dimensions = cacheHelper.getDimensionList(datasetId);
        Map dimensionMap = cacheHelper.getDimensionMap(datasetId);
        LinkedHashMap shortDimMap = Maps.newLinkedHashMapWithExpectedSize((int)dimensions.size());
        for (Dimension dimension : dimensions) {
            shortDimMap.put(dimension.getShortNumber(), dimension);
        }
        Map<String, String> memberMap = null;
        int dataSize = dimensions.size() + 1;
        Dimension accDim = (Dimension)shortDimMap.get(SysDimensionEnum.Account.getShortNumber());
        Dimension metricDim = (Dimension)shortDimMap.get(SysDimensionEnum.Metric.getShortNumber());
        for (int selRow : selRows) {
            Dimension dimension;
            int j;
            String dataStr;
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", selRow);
            if (row == null || StringUtils.isEmpty((String)(dataStr = row.getString("table")))) continue;
            Object[] data = new Object[dataSize];
            if (memberMap == null) {
                memberMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
            }
            if (dataStr.contains("!") && dataStr.contains("@")) {
                String[] metas = dataStr.split("!");
                memberMap.clear();
                int jn = metas.length;
                for (j = 0; j < jn; ++j) {
                    String memberStr = metas[j];
                    String[] memberData = memberStr.split("@");
                    dimension = (Dimension)shortDimMap.get(memberData[0]);
                    if (dimension == null) continue;
                    memberMap.put(dimension.getNumber(), memberData[1]);
                }
            } else {
                memberMap = (Map)JsonUtils.readValue((String)dataStr, Map.class);
            }
            if (memberMap == null || memberMap.isEmpty()) continue;
            for (j = 0; j < dimensions.size(); ++j) {
                Member member;
                String dimNumber = ((Dimension)dimensions.get(j)).getNumber();
                String memNumber = (String)memberMap.get(dimNumber);
                if (StringUtils.isEmpty((String)memNumber)) {
                    dimension = (Dimension)dimensionMap.get(dimNumber);
                    if (SysDimensionEnum.InternalCompany.getNumber().equals(dimNumber)) {
                        memNumber = "ICNone";
                    } else if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                        memNumber = dimension.getShortNumber() + "None";
                    } else {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u6210\u5458\u201c%1\u201d\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u6062\u590d\u6570\u636e\u3002", (String)"BgDataAnalysePlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getName()}));
                    }
                }
                data[j + 1] = memNumber;
                if (SysDimensionEnum.Metric.getNumber().equals(dimNumber) && (member = metricDim.getMember(memNumber)) != null) {
                    data[0] = MetricUtils.isNumeric((String)member.getDatatype()) ? new BigDecimal(row.getString("value")) : row.getString("value");
                }
                if (!SysDimensionEnum.Account.getNumber().equals(dimNumber) || (member = accDim.getMember(memNumber)) == null || datasetId == null || datasetId.compareTo(member.getDatasetId()) == 0) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u6062\u590d\u6570\u636e\u7684\u79d1\u76ee\u4e0e\u6307\u5b9a\u7684\u4e1a\u52a1\u6a21\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BgDataAnalysePlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (data[0] == null) continue;
            recoverData.add(data);
        }
        if (!recoverData.isEmpty()) {
            Dataset dataset2 = Dataset.of((DynamicObject)dataset);
            try (IShrekSave save = ShrekOlapServiceHelper.saveData((Model)cacheHelper.getModelobj(), (Dataset)dataset2, (String[])cacheHelper.getDimensionNums(dataset2.getId()), (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));){
                for (Object[] _recover : recoverData) {
                    save.addValues(_recover);
                }
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6062\u590d\u5b8c\u6210", (String)"BgDataAnalysePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            stats.addInfo("recoverData is null.");
        }
        stats.addInfo("end-recoverData.");
        log.info(stats.toString());
    }

    private boolean hasAgg() {
        Boolean value = (Boolean)this.getModel().getValue(CHK_AGG);
        return value != null && value != false;
    }

    public String getBizCtrlRangeKey() {
        return "busmodel";
    }

    public String getBizModelKey() {
        return "dataset";
    }

    public void afterSetBgDefaultField() {
        super.afterSetBgDefaultField();
    }

    static {
        fieldIndexMap.put(SysDimensionEnum.Entity.getNumber(), "orgunit");
        fieldIndexMap.put(SysDimensionEnum.Account.getNumber(), "account");
        fieldIndexMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), "period");
        fieldIndexMap.put(SysDimensionEnum.Version.getNumber(), "version");
        fieldIndexMap.put(SysDimensionEnum.Currency.getNumber(), "currency");
        fieldIndexMap.put(SysDimensionEnum.DataType.getNumber(), "datatype");
        fieldIndexMap.put(SysDimensionEnum.ChangeType.getNumber(), "changetype");
        fieldIndexMap.put(SysDimensionEnum.AuditTrail.getNumber(), "audittrail");
        fieldIndexMap.put(SysDimensionEnum.Metric.getNumber(), "metric");
        fieldIndexMap.put(SysDimensionEnum.InternalCompany.getNumber(), "internalcompany");
    }
}

