/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataanalyse;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.util.TraceIdUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.BgmdShrekDao;
import kd.epm.eb.common.shrek.controller.EbShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.formplugin.dataanalyse.BgBaseDataPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.SaveRequest;

public class BgDataToolsPlugin
extends BgBaseDataPlugin {
    private static final Log log = LogFactory.getLog(BgDataToolsPlugin.class);
    private static final String FIELD_DATETIME = "datetime";
    private static final String FIELD_TRACE = "trace";
    private static final String FIELD_LOG_SIZE = "logsize";
    private static final String BTN_BACKUP = "btnbackup";
    private static final String BTN_QUERY_LOG = "btnquerylog";
    private static final String BTN_RECOVER_DATA = "btnrecoverdata";
    private static final String ENTRY_LOGS = "logs";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"commtoolbar"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_RECOVER_DATA});
        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_RECOVER_DATA});
        CalendarHelper helper = new CalendarHelper();
        helper.setDay(helper.getYear(), helper.getCurrentlyMonth(), helper.getCurrentlyDay() - 1);
        this.getModel().setValue(FIELD_DATETIME, (Object)helper.getTime());
    }

    @Override
    protected void beforeF7Select_model(BeforeF7SelectEvent event) {
        event.getFormShowParameter().setCustomParam("noNeedDefaultQFilter", (Object)"true");
    }

    @Override
    protected void propertyChanged_model(PropertyChangedArgs event) {
        super.propertyChanged_model(event);
        this.getModel().deleteEntryData("dimensions");
        this.getModel().deleteEntryData(ENTRY_LOGS);
        Object object = this.getPropertyChangedValue(event);
        if (object instanceof DynamicObject) {
            DynamicObject _model = (DynamicObject)object;
            if (BizModel.isEBByModel((DynamicObject)_model)) {
                this.getModel().setValue("busmodel", null);
                this.loadDimension(_model, null);
            } else {
                this.setDefaultBusModel((DynamicObject)object);
            }
        } else {
            this.getModel().setValue("busmodel", null);
        }
    }

    @Override
    protected void propertyChanged_busModel(PropertyChangedArgs event) {
        super.propertyChanged_busModel(event);
        this.getModel().deleteEntryData("dimensions");
        this.getModel().deleteEntryData(ENTRY_LOGS);
        Object object = this.getPropertyChangedValue(event);
        if (object instanceof DynamicObject) {
            this.setDefaultDataset(this.getBizModel(), (DynamicObject)object);
        } else {
            this.getModel().setValue("dataset", null);
        }
    }

    @Override
    protected void propertyChanged_dataset(PropertyChangedArgs event) {
        super.propertyChanged_dataset(event);
        this.loadDimension(this.getBizModel(), this.getDataset());
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btnbackup": {
                this.click_backup();
                break;
            }
            case "btnquerylog": {
                this.click_queryLog();
                break;
            }
            case "btnrecoverdata": {
                this.click_recoverData();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getResult() != MessageBoxResult.Yes) {
            return;
        }
        switch (event.getCallBackId()) {
            case "btnbackup": {
                this.callBack_backup();
                break;
            }
            case "btnrecoverdata": {
                this.callBack_recoverData();
            }
        }
    }

    protected boolean verify() {
        boolean re = this.verifyModel();
        if (re && !BizModel.isEBByModel((DynamicObject)this.getBizModel()) && (re = this.verifyBusModel())) {
            re = this.verifyDataset();
        }
        return re;
    }

    @Override
    protected void click_selectMembers() {
        BgDataToolsPlugin.selectMembers(this.getView(), this.getModel(), (IFormPlugin)this, this.getModelId(), this.getBusModelId(), this.getDatasetId(), true);
    }

    public void click_backup() {
        if (!this.verify()) {
            return;
        }
        DynamicObject model = this.getBizModel();
        if (!MemberPermHelper.getLimitedModelListByUser().contains(model.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7528\u6237\u975e%1\u4f53\u7cfb\u7684\u7ba1\u7406\u5458\u3002", (String)"BgmdModelList_11", (String)"epm-eb-formplugin", (Object[])new Object[]{model.getString("name")}));
            return;
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(BTN_BACKUP, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5907\u4efd\u5f53\u524d\u6570\u636e\u96c6\u7684\u6570\u636e\uff1f", (String)"BgDataToolsPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBack);
    }

    public void callBack_backup() {
        try {
            File file = ShrekOlapServiceHelper.backupCube((Long)this.getModelId(), (Long)this.getDatasetId());
            POIUtils.downloadFile((IFormView)this.getView(), (String)POIUtils.downloadFile((File)file));
        }
        catch (IOException ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    public void click_queryLog() {
        if (!this.verify()) {
            return;
        }
        DynamicObject model = this.getBizModel();
        DynamicObject dataset = this.getDataset();
        Long modelId = model.getLong("id");
        Long busModelId = this.getBusModelId();
        Long datasetId = dataset != null ? dataset.getLong("id") : 0L;
        Map<String, Set<String>> dimMembers = this.getMemberNums();
        if (dimMembers.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5904\u7406\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\uff0c\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u7ef4\u5ea6\u6210\u5458\u3002", (String)"BgDataAnalysePlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Date date = (Date)this.getModel().getValue(FIELD_DATETIME);
        if (date == null) {
            date = new Date();
        }
        Long traceId = null;
        String traceIdStr = (String)this.getModel().getValue(FIELD_TRACE);
        if (StringUtils.isNotEmpty((String)traceIdStr)) {
            try {
                traceId = TraceIdUtil.hexToId((String)traceIdStr);
            }
            catch (Exception ex) {
                log.warn("BgDataToolsPlugin-tran-traceId-error:" + traceIdStr);
            }
        }
        int logSize = (Integer)this.getModel().getValue(FIELD_LOG_SIZE);
        List trans = BgmdShrekDao.ShrekDB.queryCommandInfo(modelId, busModelId, datasetId, dimMembers, date, traceId, logSize, this.getModelCacheHelper(modelId));
        this.fullLogs(trans);
    }

    private void fullLogs(List<BgmdShrekDao.TransactionTraceInfo> trans) {
        this.getModel().deleteEntryData(ENTRY_LOGS);
        if (trans == null || trans.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e\u4fee\u6539\u8bb0\u5f55\uff0c\u8bf7\u7f29\u5c0f\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u518d\u7ee7\u7eed\u6216\u8005\u8c03\u6574\u8d77\u59cb\u65f6\u95f4\u3002", (String)"BgDataToolsPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Map<String, List<Map<String, Object>>> logsMap = this.queryOperationLog(trans);
        LinkedHashMap entityMap = Maps.newLinkedHashMapWithExpectedSize((int)100);
        int index = 0;
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow(ENTRY_LOGS, trans.size());
        for (BgmdShrekDao.TransactionTraceInfo _tran : trans) {
            Map<String, Object> logMap;
            this.getModel().setValue("value", _tran.value, index);
            this.getModel().setValue("time", _tran.tranTime != null ? _tran.tranTime : _tran.time, index);
            this.getModel().setValue("member", (Object)StringUtils.join((Object[])_tran.members, (char)','), index);
            this.getModel().setValue("storage", (Object)(_tran.storage != null ? _tran.storage.getName() : ""), index);
            this.getModel().setValue("command", (Object)_tran.command, index);
            this.getModel().setValue("traceid", (Object)_tran.traceStr, index);
            List<Map<String, Object>> logs = logsMap.get(_tran.traceStr);
            if (logs != null && !logs.isEmpty() && (logMap = logs.get(0)) != null) {
                this.getModel().setValue("user", logMap.get("creater.name"), index);
                this.getModel().setValue("operation", (Object)(logMap.get("operation") + "(" + logMap.get("description") + ")"), index);
                String entityName = entityMap.computeIfAbsent((String)logMap.get("entitynumber"), f -> {
                    try {
                        MainEntityType type = EntityMetadataCache.getDataEntityType((String)f);
                        if (type != null) {
                            return LanguageUtils.getLocaleValue((ILocaleString)type.getDisplayName());
                        }
                    }
                    catch (Exception ex) {
                        log.warn("parse-metadata-error", (Throwable)ex);
                    }
                    return f;
                });
                this.getModel().setValue("entitynumber", (Object)entityName, index);
            }
            ++index;
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_LOGS);
    }

    private Map<String, List<Map<String, Object>>> queryOperationLog(List<BgmdShrekDao.TransactionTraceInfo> trans) {
        if (trans == null || trans.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Set traceIds = trans.stream().filter(t -> t.traceStr != null).map(t -> t.traceStr).collect(Collectors.toSet());
        return OperationLogUtil.query(traceIds);
    }

    private void click_recoverData() {
        if (!this.verify()) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_LOGS);
        if (entryGrid.getSelectRows() == null || entryGrid.getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6062\u590d\u7684\u6570\u636e\u3002", (String)"BgDataToolsPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(BTN_RECOVER_DATA, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u6062\u590d\u5f53\u524d\u9009\u62e9\u7684\u6570\u636e\uff1f\u5982\u679c\u9009\u62e9\u7684\u7ef4\u5ea6\u6210\u5458\u76f8\u540c\u5219\u6309\u6570\u636e\u663e\u793a\u7684\u5148\u540e\u987a\u5e8f\u5904\u7406\u3002", (String)"BgDataToolsPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBack);
    }

    private void callBack_recoverData() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_LOGS);
        int[] rows = entryGrid.getSelectRows();
        if (entryGrid.getSelectRows() == null || entryGrid.getSelectRows().length == 0) {
            return;
        }
        LogStats stats = new LogStats("budget-data-log : ");
        stats.addInfo("begin-recoverData.");
        DynamicObject model = this.getBizModel();
        DynamicObject dataset = this.getDataset();
        Long modelId = model.getLong("id");
        Long datasetId = dataset != null ? dataset.getLong("id") : 0L;
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper(this.getModelId());
        List dimensions = modelCacheHelper.getModelobj().isModelByEB() ? modelCacheHelper.getDimensionList() : modelCacheHelper.getDimensionList(datasetId);
        Map viewIds = modelCacheHelper.getViewsByDataSet(datasetId);
        ArrayList cells = Lists.newArrayListWithExpectedSize((int)rows.length);
        Dimension metricDim = modelCacheHelper.getDimension(SysDimensionEnum.Metric.getNumber());
        for (int rowIndex : rows) {
            String metricNum;
            Member metric;
            DynamicObject data = this.getModel().getEntryRowEntity(ENTRY_LOGS, rowIndex);
            if (data == null) continue;
            String memberStr = data.getString("member");
            if (StringUtils.isEmpty((String)memberStr)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684\u7ef4\u5ea6\u6210\u5458\u6570\u636e\u4e3a\u7a7a\u3002", (String)"BgDataToolsPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex}));
                break;
            }
            String[] memberNums = memberStr.split(",");
            if (memberNums.length != dimensions.size()) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684\u7ef4\u5ea6\u6210\u5458\u6570\u636e\u4e2d\uff0c\u7ef4\u5ea6\u6570\u91cf\u4e0e\u4f53\u7cfb\u6216\u8005\u6570\u636e\u96c6\u5173\u8054\u7684\u7ef4\u5ea6\u4e0d\u4e00\u81f4\u3002", (String)"BgDataToolsPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex}));
                break;
            }
            HashMap memberNumMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
            int in = memberNums.length;
            for (int i = 0; i < in; ++i) {
                Dimension dimension = (Dimension)dimensions.get(i);
                if (dimension == null) continue;
                Member member = dimension.getMember((Long)viewIds.get(dimension.getNumber()), memberNums[i]);
                if (member == null) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u7684 %2 \u7ef4\u5ea6 %3 \u7f16\u7801\u7684\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"BgDataToolsPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex, dimension.getNumber(), memberNums[i]}));
                    break;
                }
                memberNumMap.put(dimension.getNumber(), memberNums[i]);
            }
            if ((metric = metricDim.getMember(metricNum = (String)memberNumMap.get(SysDimensionEnum.Metric.getNumber()))) == null) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a %1 \u7684\u5ea6\u91cf\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"BgDataToolsPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{metricNum}));
                break;
            }
            BGCell bgCell = new BGCell();
            bgCell.setMemberMap((Map)memberNumMap);
            if (MetricUtils.isNumeric((String)metric.getDatatype())) {
                bgCell.setValue((Object)Convert.toBigDecimal((Object)data.get("value")));
            } else if (MetricUtils.isString((String)metric.getDatatype())) {
                bgCell.setValue((Object)Convert.toStr((Object)data.get("value")));
            } else {
                throw new IllegalStateException();
            }
            cells.add(bgCell);
        }
        if (!cells.isEmpty()) {
            stats.addInfo("recoverData-size=" + cells.size());
            OperationLogUtil.log((String)"bgm", (String)"epm_datatools", (String)ResManager.loadKDString((String)"\u6570\u636e\u6062\u590d", (String)"BgDataToolsPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6570\u636e\u6062\u590d\u64cd\u4f5c", (String)"BgDataToolsPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            if (modelCacheHelper.getModelobj().isModelByEB()) {
                String[] dimensionNum = modelCacheHelper.getDimensionNums();
                try (IShrekSave save = EbShrekOlapServiceHelper.saveData((Model)modelCacheHelper.getModelobj(), (String[])dimensionNum, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));){
                    for (BGCell _cell : cells) {
                        save.add(_cell.getMeta(dimensionNum), _cell.getValue());
                    }
                }
            } else {
                SaveRequest request = new SaveRequest();
                request.setModelId(modelId);
                request.setDatasetId(datasetId);
                request.setDatas((List)cells);
                OlapCommService.getInstance().save(request);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u6062\u590d\u64cd\u4f5c\u5b8c\u6210\u3002", (String)"BgDataToolsPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
        }
        stats.addInfo("end-recoverData.");
        log.info(stats.toString());
    }
}

