/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.datadelete;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.datadelete.DataDeleteApproveStatusEnum;
import kd.epm.eb.common.datadelete.DataDeleteStatusEnum;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class DataDeletePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(DataDeletePlugin.class);
    private static final int MAX_ROW_SIZE = 10000;
    private static final Map<String, String> fieldIndexMap = new LinkedHashMap<String, String>();
    private static final String BTN_QUERY_DATA = "btnquerydata";
    private static final String BTN_QUERY_REMOVE_LOG = "btnqueryoperlog";
    private static final String BTN_DELETE_DATA = "btncleardata";
    private static final String FORM_DATA_DELETE = "eb_datadelete";
    private static final String FORM_DATA_DELETE_MEMBERSHOW = "eb_datadelete_membershow";
    private static final String BTN_APPROVE = "approve";
    private static final String BTN_REJECT = "reject";
    private IModelCacheHelper modelCacheHelper = null;
    public static final String CLOSE_BACK_SELECTMEMBERS = "selectmembers";
    private static final String CACHE_DIMENSION = "cache_dimension";

    public IModelCacheHelper getModelCacheHelper(Long modelId) {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = modelId == null || modelId == 0L ? ModelCacheContext.getOrCreate((Long)this.getModelId()) : ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCacheHelper;
    }

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"members"});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("model");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        basedataEdit = (BasedataEdit)this.getControl("busmodel");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        basedataEdit = (BasedataEdit)this.getControl("dataset");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("dimensions");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("MODELID");
        if (modelId != null && modelId != 0L) {
            this.getModel().setValue("model", (Object)modelId);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
    }

    public void afterBindData(EventObject e) {
        String approveStatus;
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"table", "modifier", "modifytime", "occperiod", "comments", BTN_APPROVE, BTN_REJECT, "userdefined1", "userdefined2", "userdefined3", "userdefined4", "userdefined5", "userdefined6", "userdefined7", "userdefined8"});
        if (this.getDataset() != null) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            List dimensions = modelCacheHelper.getDimensionList(Long.valueOf(this.getDataset().getLong("id")));
            this.setCustomDimColumnTitle(dimensions);
        }
        if ((approveStatus = (String)this.getModel().getValue("approveStatus")) != null) {
            boolean isApprover = IDUtils.equals((Object)this.getUserId(), (Object)this.getApproverId());
            if (isApprover) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"comments"});
                if (StringUtils.equals((String)approveStatus, (String)DataDeleteApproveStatusEnum.SUBMIT.getNumber())) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_APPROVE, BTN_REJECT, "comments"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_DELETE_DATA, BTN_QUERY_DATA});
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)FORM_DATA_DELETE);
                    dynamicObject.set("read", (Object)1);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    this.queryData();
                } else {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"comments"});
                }
            } else if (StringUtils.equals((String)approveStatus, (String)DataDeleteApproveStatusEnum.APPROVE.getNumber()) || StringUtils.equals((String)approveStatus, (String)DataDeleteApproveStatusEnum.REJECT.getNumber())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"comments"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"comments"});
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btnquerydata": {
                this.queryData();
                break;
            }
            case "btnqueryoperlog": {
                this.opendeleteLog();
                break;
            }
            case "btncleardata": {
                this.beforeRemoveData();
                break;
            }
            case "approve": {
                this.approve(DataDeleteApproveStatusEnum.APPROVE);
                break;
            }
            case "reject": {
                this.approve(DataDeleteApproveStatusEnum.REJECT);
                break;
            }
        }
    }

    private void approve(DataDeleteApproveStatusEnum status) {
        Long userId = this.getUserId();
        if (!IDUtils.equals((Object)userId, (Object)this.getApproverId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6743\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"DataDelete_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject datadelete = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)FORM_DATA_DELETE);
        String approveStatus = datadelete.getString("approveStatus");
        if (!StringUtils.equals((String)approveStatus, (String)DataDeleteApproveStatusEnum.SUBMIT.getNumber())) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u72b6\u6001\u4e3a%1\uff0c\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"DataDelete_5", (String)"epm-eb-formplugin", (Object[])new Object[]{DataDeleteApproveStatusEnum.getNameByNumber((String)approveStatus)}));
            return;
        }
        Date date = TimeServiceHelper.now();
        datadelete.set("modifier", (Object)userId);
        datadelete.set("modifydate", (Object)date);
        datadelete.set("approvedate", (Object)date);
        datadelete.set("approvestatus", (Object)status.getNumber());
        datadelete.set("comments", this.getModel().getValue("comments"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datadelete});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"DataDelete_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_APPROVE, BTN_REJECT});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"comments"});
        this.getModel().setDataChanged(false);
        try {
            long submitter = datadelete.getLong("submitter_id");
            String approveName = status == DataDeleteApproveStatusEnum.APPROVE ? ResManager.loadKDString((String)"\u540c\u610f", (String)"DataDelete_12", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9a73\u56de", (String)"DataDelete_13", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            this.sendMessageToSubmiter(submitter, approveName);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        if (status == DataDeleteApproveStatusEnum.APPROVE) {
            this.dataDetete(datadelete);
        }
    }

    private void dataDetete(DynamicObject datadelete) {
        String loginIP = RequestContext.getOrCreate().getLoginIP();
        boolean cubebackup = datadelete.getBoolean("cubebackup");
        int backupType = datadelete.getInt("backuptype");
        long model = datadelete.getLong("model_id");
        long dataset = datadelete.getLong("dataset_id");
        String reason = datadelete.getString("reasion");
        if (cubebackup) {
            if (backupType == 1) {
                this.fullBackup(model, dataset, datadelete);
            } else {
                this.incrementalBackup(model, dataset, datadelete);
            }
        }
        ThreadPools.executeOnce((String)"DataDeletePlugin", () -> {
            RequestContext.getOrCreate().setLoginIP(loginIP);
            HashMap memberMap = new HashMap(16);
            DynamicObjectCollection dimensions = datadelete.getDynamicObjectCollection("dimensions");
            HashSet metricMembers = new HashSet(16);
            IModelCacheHelper modelCache = this.getModelCacheHelper(this.getModelId());
            if (dimensions != null) {
                for (DynamicObject dimension : dimensions) {
                    String dimNumber = dimension.getString("dimnumber");
                    Long viewId = dimension.getLong("viewId");
                    String json = dimension.getString("membersjson");
                    List members = (List)JSON.parse((String)json);
                    String memberscope = dimension.getString("memberscope");
                    List memberConditionList = JSONArray.parseArray((String)memberscope, MemberCondition.class);
                    HashSet<String> memberSet = new HashSet<String>(16);
                    for (MemberCondition memberCondition : memberConditionList) {
                        if (!CollectionUtils.isNotEmpty((Collection)memberConditionList)) continue;
                        List memberList = modelCache.getMemberIncludeCosmic(dimNumber, viewId, memberCondition.getNumber(), Integer.parseInt(memberCondition.getRange()));
                        for (Member member : memberList) {
                            String number = member.getNumber();
                            if (!members.contains(number) && !number.endsWith("._inv")) continue;
                            memberSet.add(number);
                        }
                    }
                    if (StringUtils.equals((String)SysDimensionEnum.Metric.getNumber(), (String)dimNumber)) {
                        metricMembers = memberSet;
                        continue;
                    }
                    if (memberSet.isEmpty()) {
                        return;
                    }
                    memberMap.put(dimNumber, memberSet);
                }
            }
            try {
                datadelete.set("deletestatus", (Object)DataDeleteStatusEnum.SUCCESS.getNumber());
                datadelete.set("deletedate", (Object)TimeServiceHelper.now());
                OlapTraceServiceHelper.setTraceOpInfo((String)reason);
                OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.DataDelete));
                for (String metricMember : metricMembers) {
                    ShrekOlapServiceHelper.deleteData((Long)model, (Long)dataset, memberMap, (String)metricMember);
                }
            }
            catch (KDBizException e) {
                datadelete.set("deletestatus", (Object)DataDeleteStatusEnum.FAIL.getNumber());
                datadelete.set("errorinfo", (Object)e.getMessage());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datadelete});
        });
    }

    private void fullBackup(long model, long dataset, DynamicObject datadelete) {
        try {
            File file = ShrekOlapServiceHelper.backupCube((Long)model, (Long)dataset);
            IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            String downloadPath = this.downloadFile(file);
            service.addAction("download", (Object)downloadPath);
            datadelete.set("backuppath", (Object)downloadPath);
        }
        catch (IOException e) {
            datadelete.set("deletestatus", (Object)DataDeleteStatusEnum.FAIL.getNumber());
            datadelete.set("errorinfo", (Object)e.getMessage());
        }
    }

    private void incrementalBackup(long modelId, long datasetId, DynamicObject datadelete) {
        Dataset dataset = Dataset.of((DynamicObject)BusinessDataServiceHelper.loadSingleFromCache((Object)datasetId, (String)"eb_dataset"));
        IModelCacheHelper cacheHelper = this.getModelCacheHelper(modelId);
        String[] dimNumbers = cacheHelper.getDimensionNums(Long.valueOf(datasetId));
        try {
            StringBuilder csvContent = new StringBuilder();
            StringBuilder header = new StringBuilder();
            header.append("FMONEY").append(',');
            Arrays.stream(dimNumbers).forEach(d -> header.append((String)d).append(','));
            csvContent.append(this.endLine(header));
            SelectCommandInfo query = this.getSelectCommandInfo(dimNumbers, 10000);
            LogStats stats = new LogStats("budget-data-log : ");
            try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)cacheHelper.getModelobj(), (Dataset)dataset, (SelectCommandInfo)query, (boolean)false, (LogStats)stats);){
                while (reader.hasNext()) {
                    Object[] values = reader.next();
                    if (values == null || values[0] == null) continue;
                    StringBuilder sb = new StringBuilder();
                    Arrays.stream(values).forEach(d -> sb.append(d).append(','));
                    csvContent.append(this.endLine(sb));
                }
            }
            String fileName = "MDD" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".csv";
            try (ByteArrayInputStream inStream = new ByteArrayInputStream(csvContent.toString().getBytes(StandardCharsets.UTF_8));){
                String downloadPath = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
                datadelete.set("backuppath", (Object)downloadPath);
                IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                service.addAction("download", (Object)downloadPath);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            datadelete.set("deletestatus", (Object)DataDeleteStatusEnum.FAIL.getNumber());
            datadelete.set("errorinfo", (Object)e.getMessage());
        }
    }

    private String endLine(StringBuilder sb) {
        return sb.substring(0, sb.length() - 1) + BgBaseConstant.LINE_SEPARATOR;
    }

    public String downloadFile(File file) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        InputStream fis = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            outStream = new ByteArrayOutputStream();
            outStream.write(buffer);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        String fileName = file.getName();
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
    }

    public void click(EventObject evt) {
        String clickKey;
        super.click(evt);
        switch (clickKey = ((Control)evt.getSource()).getKey()) {
            case "members": {
                this.selectMembers(this.getView(), this.getModel(), (IFormPlugin)this, this.getModelId(), this.getBusModelId(), this.getDatasetId());
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.registerListener((EventObject)evt);
        switch (evt.getProperty().getName()) {
            case "busmodel": {
                this.beforeF7Select_busModel(evt);
                break;
            }
            case "dataset": {
                this.beforeF7Select_dataset(evt);
                break;
            }
        }
    }

    protected void beforeF7Select_busModel(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)event.getSource()).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>();
        }
        filters.add(new QFilter("model", "=", (Object)this.getModelId()));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
    }

    protected void beforeF7Select_dataset(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> filters = ((BasedataEdit)event.getSource()).getQFilters();
        if (filters == null) {
            filters = new ArrayList<QFilter>();
        }
        filters.add(new QFilter("model", "=", (Object)this.getModelId()));
        filters.add(new QFilter("businessmodel", "=", (Object)this.getBusModelId()));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "busmodel": {
                this.propertyChanged_busModel(e);
                break;
            }
            case "dataset": {
                this.propertyChanged_dataset(e);
                break;
            }
            case "members": {
                this.propertyChanged_members(e);
                break;
            }
        }
    }

    protected void propertyChanged_busModel(PropertyChangedArgs event) {
        this.getModel().deleteEntryData("dimensions");
        this.clearEntry();
        ChangeData[] data = event.getChangeSet();
        if (data != null && data.length > 0) {
            ChangeData changeData = data[0];
            DynamicObject dataset = null;
            if (changeData.getNewValue() != null) {
                Long modelId = this.getModelId();
                DynamicObject busModel = (DynamicObject)changeData.getNewValue();
                QFBuilder builder = new QFBuilder();
                builder.add(new QFilter("model", "=", (Object)modelId));
                builder.add(new QFilter("businessmodel", "=", (Object)busModel.getLong("id")));
                dataset = BusinessDataServiceHelper.loadSingle((String)"eb_dataset", (String)"id, name, number", (QFilter[])builder.toArrays());
            }
            this.getModel().setValue("dataset", dataset);
        }
    }

    protected void propertyChanged_dataset(PropertyChangedArgs event) {
        this.loadDimension(this.getDataset());
        this.clearEntry();
    }

    protected void propertyChanged_members(PropertyChangedArgs event) {
        ChangeData data;
        ChangeData[] datas = event.getChangeSet();
        if (datas != null && (data = datas[0]) != null && (data.getNewValue() == null || "".equals(data.getNewValue()))) {
            EntryGrid entry = (EntryGrid)this.getControl("dimensions");
            int rowIndex = entry.getEntryState().getFocusRow();
            this.getModel().setDataChanged(false);
            this.getModel().setValue("membersjson", null, rowIndex);
            this.getModel().setValue("memberscope", null, rowIndex);
            this.getModel().setValue("members", null, rowIndex);
            this.getModel().setDataChanged(true);
        }
    }

    public void selectMembers(IFormView view, IDataModel model, IFormPlugin plugin, Long modelId, Long busModelId, Long datasetId) {
        List list;
        if (view == null || model == null || modelId == null || modelId == 0L) {
            return;
        }
        EntryGrid entry = (EntryGrid)view.getControl("dimensions");
        DynamicObject entryData = model.getEntryRowEntity("dimensions", entry.getEntryState().getFocusRow());
        if (entryData == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"BgDataAnalysePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String dimNumber = entryData.getString("dimnumber");
        Long viewId = entryData.getLong("viewid");
        CloseCallBack closeCallBack = new CloseCallBack(plugin, CLOSE_BACK_SELECTMEMBERS);
        RangeF7Param param = new RangeF7Param();
        param.setCloseCallBack(closeCallBack);
        param.setNeedPermCheck(true);
        param.setEnableView(true);
        param.setBizModelId(busModelId);
        param.setQueryDecompose(true);
        QFBuilder builder = new QFBuilder();
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            builder.add(new QFilter("dataset", "=", (Object)datasetId));
            param.setqFilters(builder.toList());
            param.setDatasetId(datasetId);
        } else if (SysDimensionEnum.ChangeType.getNumber().equals(dimNumber)) {
            param.setEnableView(true);
            builder.add(new QFilter("number", "!=", (Object)"Occupation"));
            builder.add(new QFilter("number", "!=", (Object)"Execute"));
            param.setqFilters(builder.toList());
        }
        String membersStr = entryData.getString("memberscope");
        if (StringUtils.isNotEmpty((String)membersStr) && (list = JSONArray.parseArray((String)membersStr, MemberCondition.class)).size() > 0) {
            param.setCon_list(list);
        }
        CustomF7utils.openCustomF7Range((Long)modelId, (String)dimNumber, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
    }

    private Long getViewId(String dimNumber, Long datasetId) {
        IModelCacheHelper modelCache = this.getModelCacheHelper(this.getModelId());
        Map viewMap = modelCache.getViewsByDataSetIncludeBase(datasetId);
        return (Long)viewMap.get(dimNumber);
    }

    public Long sendMessageToApprover(Long shareUserId, String curTreeNodId) {
        MessageInfo messageInfo = this.getMessageInfo(shareUserId);
        LocaleString title = new LocaleString();
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        String userName = RequestContext.get().getUserName();
        OrmLocaleValue reasion = (OrmLocaleValue)this.getModel().getValue("reasion");
        title.setLocaleValue(ResManager.loadResFormat((String)"\u201c%1\u201d\u4f53\u7cfb\u7ba1\u7406\u5458\u201c%2\u201d\u7533\u8bf7\u6570\u636e\u5220\u9664\uff0c\u5220\u9664\u539f\u56e0\uff1a%3\u3002", (String)"DataDelete_9", (String)"epm-eb-formplugin", (Object[])new Object[]{model.getString("name"), userName, reasion.getLocaleValue()}));
        messageInfo.setMessageTitle((ILocaleString)title);
        messageInfo.setMessageContent((ILocaleString)title);
        messageInfo.setContentUrl(UrlService.getDomainContextUrl() + "/?formId=eb_datadelete&pkId=" + curTreeNodId);
        return MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public Long sendMessageToSubmiter(Long shareUserId, String approveName) {
        MessageInfo messageInfo = this.getMessageInfo(shareUserId);
        LocaleString title = new LocaleString();
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        String userName = RequestContext.get().getUserName();
        OrmLocaleValue comments = (OrmLocaleValue)this.getModel().getValue("comments");
        title.setLocaleValue(ResManager.loadResFormat((String)"\u4f60\u597d\uff0c\u7cfb\u7edf\u7ba1\u7406\u5458%1%2\u4f60\u63d0\u4ea4\u7684%3\u4f53\u7cfb\u7684\u6570\u636e\u5220\u9664\uff0c\u5ba1\u6279\u610f\u89c1\uff1a%4", (String)"DataDelete_10", (String)"epm-eb-formplugin", (Object[])new Object[]{userName, approveName, model.getString("name"), comments.getLocaleValue()}));
        messageInfo.setMessageTitle((ILocaleString)title);
        messageInfo.setMessageContent((ILocaleString)title);
        return MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private MessageInfo getMessageInfo(Long shareUserId) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setUserIds(Collections.singletonList(shareUserId));
        messageInfo.setSenderId(this.getUserId());
        messageInfo.setSendTime(new Date(System.currentTimeMillis()));
        LocaleString tag = new LocaleString();
        tag.setLocaleValue(ResManager.loadKDString((String)"\u6570\u636e\u5220\u9664", (String)"DataDelete_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        messageInfo.setMessageTag((ILocaleString)tag);
        return messageInfo;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "selectmembers": {
                DynamicObjectCollection rows;
                IModelCacheHelper modelCacheHelper = this.getModelCacheHelper(this.getModelId());
                IFormView view = this.getView();
                EntryGrid entry = (EntryGrid)view.getControl("dimensions");
                int rowIndex = entry.getEntryState().getFocusRow();
                DynamicObject entryData = this.getModel().getEntryRowEntity("dimensions", entry.getEntryState().getFocusRow());
                String dimNumber = entryData.getString("dimnumber");
                StringBuilder sb = new StringBuilder();
                StringBuilder msg = new StringBuilder();
                LinkedHashSet members = new LinkedHashSet(16);
                ArrayList<MemberCondition> list = new ArrayList<MemberCondition>();
                Long viewId = 0L;
                if (e.getReturnData() instanceof DynamicObjectCollection && (rows = (DynamicObjectCollection)e.getReturnData()) != null) {
                    for (DynamicObject row : rows) {
                        MemberCondition memberCondition = new MemberCondition();
                        memberCondition.setNumber(row.getString("number"));
                        memberCondition.setName(row.getString("name"));
                        memberCondition.setRange(row.getString("scope"));
                        this.buildMultiSelectF7ReturnValue(sb, row.getString("name"), row.getInt("scope"));
                        list.add(memberCondition);
                        viewId = row.getLong("viewid");
                        members.addAll(modelCacheHelper.getMember(dimNumber, viewId, memberCondition.getNumber(), Integer.parseInt(memberCondition.getRange())));
                    }
                }
                ArrayList<String> memberNumbers = new ArrayList<String>(members.size());
                for (Object member : members) {
                    String number = member.getNumber();
                    if (SysDimensionEnum.ChangeType.getNumber().equals(dimNumber) && ("Occupation".equals(number) || "Execute".equals(number)) || SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber) && "BudgetOccupation".equals(number)) continue;
                    memberNumbers.add(number);
                }
                ArrayList<String> queryMemberNumbers = new ArrayList<String>(10);
                if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
                    for (Member member : members) {
                        if (!"20".equals(member.getAuditTrailUse()) && !"40".equals(member.getAuditTrailUse())) continue;
                        msg.append(member.getName()).append(", ");
                        queryMemberNumbers.add(member.getNumber());
                    }
                }
                String dimName = entryData.getString("dimname");
                if (StringUtils.isNotEmpty((String)msg.toString())) {
                    String msgStr = msg.substring(0, msg.length() - 2);
                    Long modelId = this.getModelId();
                    Long datasetId = this.getDatasetId();
                    Dataset dataset = Dataset.of((DynamicObject)BusinessDataServiceHelper.loadSingleFromCache((Object)datasetId, (String)"eb_dataset"));
                    IModelCacheHelper cacheHelper = this.getModelCacheHelper(modelId);
                    String[] dimNumbers = cacheHelper.getDimensionNums(datasetId);
                    SelectCommandInfo query = new SelectCommandInfo();
                    query.addDims(dimNumbers);
                    query.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
                    query.setExcludeNull(true);
                    query.setTop(1);
                    query.addFilter(dimNumber, queryMemberNumbers.toArray(new String[0]));
                    LogStats stats = new LogStats("budget-data-log : ");
                    try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)cacheHelper.getModelobj(), (Dataset)dataset, (SelectCommandInfo)query, (boolean)false, (LogStats)stats);){
                        if (reader.hasNext()) {
                            view.showTipNotification(ResManager.loadResFormat((String)"\u5220\u9664%1\uff1a%2\u7684\u6570\u636e\u5f71\u54cd\u8f83\u5927\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002", (String)"DataDelete_19", (String)"epm-eb-formplugin", (Object[])new Object[]{dimName, msgStr}));
                        }
                    }
                }
                view.getModel().setValue("memberscope", (Object)SerializationUtils.toJsonString(list), rowIndex);
                view.getModel().setValue("membersjson", (Object)JSON.toJSONString(memberNumbers), rowIndex);
                view.getModel().setValue("viewid", (Object)viewId, rowIndex);
                view.getModel().setValue("members", (Object)this.getMultiSelectF7ReturnValue(sb), rowIndex);
                break;
            }
        }
    }

    private void buildMultiSelectF7ReturnValue(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.ONLY) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"BgTemplatePartitionSettingPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }

    private String getMultiSelectF7ReturnValue(StringBuilder sb) {
        return sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            switch (e.getCallBackId()) {
                case "btncleardata": {
                    this.submitRemoveData();
                    break;
                }
            }
        }
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        return model != null ? model.getLong("id") : 0L;
    }

    public DynamicObject getBusModel() {
        return (DynamicObject)this.getModel().getValue("busmodel");
    }

    public Long getBusModelId() {
        DynamicObject busModel = this.getBusModel();
        return busModel != null ? busModel.getLong("id") : 0L;
    }

    private DynamicObject getDataset() {
        return (DynamicObject)this.getModel().getValue("dataset");
    }

    private Long getDatasetId() {
        DynamicObject dataset = this.getDataset();
        return dataset != null ? dataset.getLong("id") : 0L;
    }

    private void clearEntry() {
        this.getModel().deleteEntryData("entryentity");
    }

    private SelectCommandInfo getSelectCommandInfo(String[] dimNumbers, int top) throws KDBizException {
        SelectCommandInfo query = new SelectCommandInfo();
        query.addDims(dimNumbers);
        query.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        query.setExcludeNull(true);
        query.setTop(top);
        Map<String, List<String>> members = this.getMemberNums();
        if (members != null) {
            members.entrySet().forEach(p -> {
                if (((List)p.getValue()).isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u65e0\u6570\u636e\u3002", (String)"DataDelete_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                query.addFilter((String)p.getKey(), ((List)p.getValue()).toArray(new String[0]));
            });
        }
        return query;
    }

    private void queryShrek() {
        this.clearEntry();
        this.getView().setVisible(Boolean.FALSE, new String[]{"table"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"occperiod"});
        Long modelId = this.getModelId();
        Long datasetId = this.getDatasetId();
        Dataset dataset = Dataset.of((DynamicObject)BusinessDataServiceHelper.loadSingleFromCache((Object)datasetId, (String)"eb_dataset"));
        IModelCacheHelper cacheHelper = this.getModelCacheHelper(modelId);
        List dimensions = cacheHelper.getDimensionList(datasetId);
        String[] dimNumbers = cacheHelper.getDimensionNums(datasetId);
        Map viewIds = cacheHelper.getViewsByDataSet(datasetId);
        int rowIndex = 0;
        IDataModel model = this.getModel();
        model.beginInit();
        try {
            SelectCommandInfo query = this.getSelectCommandInfo(dimNumbers, 10000);
            LogStats stats = new LogStats("budget-data-log : ");
            try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)cacheHelper.getModelobj(), (Dataset)dataset, (SelectCommandInfo)query, (boolean)false, (LogStats)stats);){
                while (reader.hasNext()) {
                    Object[] values = reader.next();
                    if (values == null || values[0] == null) continue;
                    int userDefined = 1;
                    rowIndex = model.createNewEntryRow("entryentity");
                    DynamicObject object = model.getEntryRowEntity("entryentity", rowIndex);
                    object.set("id", null);
                    object.set("table", (Object)"shrek");
                    object.set("value", values[0]);
                    object.set("dimkey", null);
                    int in = dimensions.size();
                    for (int i = 0; i < in; ++i) {
                        Dimension dimension = (Dimension)dimensions.get(i);
                        String showColumn = BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) ? "userdefined" + userDefined++ : fieldIndexMap.get(dimension.getNumber());
                        Member member = cacheHelper.getMember(dimension.getNumber(), (Long)viewIds.get(dimension.getNumber()), (String)values[i + 1]);
                        if (member == null) continue;
                        object.set(showColumn, (Object)(member.getName() + " " + member.getNumber()));
                    }
                }
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
            this.getModel().setDataChanged(false);
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    protected boolean verify() {
        Long modelId = this.getModelId();
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"BgDataAnalysePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long datasetId = this.getDatasetId();
        if (IDUtils.isNull((Long)datasetId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6", (String)"BgDataAnalysePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean verifyReason() {
        OrmLocaleValue reasion = (OrmLocaleValue)this.getModel().getValue("reasion");
        if (reasion.isEmpty() || StringUtils.isEmpty((String)reasion.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5220\u9664\u539f\u56e0\u3002", (String)"DataDelete_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean verifyMembers() {
        DynamicObjectCollection dimensions = this.getModel().getEntryEntity("dimensions");
        if (dimensions != null) {
            for (DynamicObject dimension : dimensions) {
                String dimname = dimension.getString("dimname");
                String json = dimension.getString("membersjson");
                if (!StringUtils.isEmpty((String)json)) continue;
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9%1\u7ef4\u5ea6\u7684\u6210\u5458\u3002", (String)"DataDelete_8", (String)"epm-eb-formplugin", (Object[])new Object[]{dimname}));
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean verifyData() {
        Long modelId = this.getModelId();
        Long datasetId = this.getDatasetId();
        Dataset dataset = Dataset.of((DynamicObject)BusinessDataServiceHelper.loadSingleFromCache((Object)datasetId, (String)"eb_dataset"));
        IModelCacheHelper cacheHelper = this.getModelCacheHelper(modelId);
        String[] dimNumbers = cacheHelper.getDimensionNums(datasetId);
        try {
            SelectCommandInfo query = this.getSelectCommandInfo(dimNumbers, 1);
            LogStats stats = new LogStats("budget-data-log : ");
            try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)cacheHelper.getModelobj(), (Dataset)dataset, (SelectCommandInfo)query, (boolean)false, (LogStats)stats);){
                if (reader.hasNext()) return true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u6ca1\u6709\u6570\u636e\uff0c\u65e0\u9700\u5220\u9664\u3002", (String)"DataDelete_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                boolean bl = false;
                return bl;
            }
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return false;
        }
    }

    private void opendeleteLog() {
        Long modelId = this.getModelId();
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(FORM_DATA_DELETE);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("model", (Object)modelId);
        param.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("model", "=", (Object)modelId)));
        this.getView().showForm((FormShowParameter)param);
    }

    private void openDeleteMemberShow(String dimName, String dimNumber, String memberScope, String membersJson, Long viewId) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(FORM_DATA_DELETE_MEMBERSHOW);
        param.setCaption(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458\u660e\u7ec6", (String)"DataDelete_15", (String)"epm-eb-formplugin", (Object[])new Object[]{dimName}));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("model", (Object)this.getModelId());
        param.setCustomParam("viewId", (Object)viewId);
        param.setCustomParam("dimNumber", (Object)dimNumber);
        param.setCustomParam("memberscope", (Object)memberScope);
        param.setCustomParam("membersjson", (Object)membersJson);
        this.getView().showForm(param);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String column = hyperLinkClickEvent.getFieldName();
        if ("members".equals(column)) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            if (rowIndex < 0) {
                return;
            }
            String dimName = (String)this.getModel().getValue("dimname", rowIndex);
            String dimNumber = (String)this.getModel().getValue("dimnumber", rowIndex);
            String memberScope = (String)this.getModel().getValue("memberscope", rowIndex);
            String membersJson = (String)this.getModel().getValue("membersjson", rowIndex);
            Long viewId = (Long)this.getModel().getValue("viewid", rowIndex);
            if (StringUtils.isNotEmpty((String)memberScope)) {
                this.openDeleteMemberShow(dimName, dimNumber, memberScope, membersJson, viewId);
            }
        }
    }

    public void queryData() {
        if (!this.verify()) {
            return;
        }
        this.queryShrek();
    }

    public void beforeRemoveData() {
        String backupType;
        if (!this.verifyReason()) {
            return;
        }
        if (!this.verify()) {
            return;
        }
        if (!this.verifyMembers()) {
            return;
        }
        String checkData = this.getView().getPageCache().get("checkData");
        if (!"0".equals(checkData) && !this.verifyData()) {
            return;
        }
        boolean cubebackup = (Boolean)this.getModel().getValue("cubebackup");
        String msg = !cubebackup ? ResManager.loadKDString((String)"\u672a\u540c\u6b65\u591a\u7ef4\u6570\u636e\u5e93\u5907\u4efd\u6570\u636e\u3002\u5220\u9664\u6570\u636e\u9700\u7ecf\u7cfb\u7edf\u7ba1\u7406\u5458\u540c\u610f\uff0c\u662f\u5426\u63d0\u4ea4\u5ba1\u6279\uff1f", (String)"DataDelete_3", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ("1".equals(backupType = (String)this.getModel().getValue("backuptype")) ? ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u9700\u8981\u7ba1\u7406\u5458\u540c\u610f\uff0c\u786e\u8ba4\u8981\u63d0\u4ea4\u5ba1\u6279\u5417\uff1f", (String)"DataDelete_1", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u636e\u5220\u9664\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u540c\u610f\uff0c\u786e\u8ba4\u63d0\u4ea4\u7cfb\u7edf\u7ba1\u7406\u5458\u5ba1\u6279\u5417\uff1f\uff08\u5f53\u524d\u9009\u62e9\u7684\u5907\u4efd\u65b9\u5f0f\u4e3a\u589e\u91cf\u5907\u4efd\uff1a\u5907\u4efd\u6210\u5458\u9009\u62e9\u8303\u56f4\u5185\u7684\u6570\u636e\u3002\u6ce8\u610f\uff1a\u82e5\u4f7f\u7528\u5907\u4efd\u8fd8\u539f\u6570\u636e\uff0c\u8fd8\u539f\u524d\u5148\u8fdb\u884c\u5907\u4efd\u64cd\u4f5c\u3002\uff09", (String)"DataDelete_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(BTN_DELETE_DATA, (IFormPlugin)this);
        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, callBack);
    }

    public void submitRemoveData() {
        DynamicObject datadelete = BusinessDataServiceHelper.newDynamicObject((String)FORM_DATA_DELETE);
        long id = GlobalIdUtil.genGlobalLongId();
        datadelete.set("id", (Object)id);
        datadelete.set("model", (Object)this.getModelId());
        datadelete.set("busmodel", (Object)this.getBusModelId());
        datadelete.set("dataset", (Object)this.getDatasetId());
        datadelete.set("reasion", this.getModel().getValue("reasion"));
        Long userId = UserUtils.getUserId();
        datadelete.set("creater", (Object)userId);
        datadelete.set("modifier", (Object)userId);
        datadelete.set("submitter", (Object)userId);
        datadelete.set("approver", (Object)this.getApproverId());
        Date date = TimeServiceHelper.now();
        datadelete.set("createdate", (Object)date);
        datadelete.set("modifydate", (Object)date);
        datadelete.set("approvedate", (Object)date);
        datadelete.set("approvestatus", (Object)DataDeleteApproveStatusEnum.SUBMIT.getNumber());
        datadelete.set("read", (Object)0);
        datadelete.set("cubebackup", this.getModel().getValue("cubebackup"));
        datadelete.set("backuptype", this.getModel().getValue("backuptype"));
        DynamicObjectCollection dataDeleteDims = datadelete.getDynamicObjectCollection("dimensions");
        DynamicObjectCollection dimensions = this.getModel().getEntryEntity("dimensions");
        if (dimensions != null) {
            int seq = 0;
            for (DynamicObject dimension : dimensions) {
                DynamicObject dataDeleteDim = new DynamicObject(dimensions.getDynamicObjectType());
                dataDeleteDim.set("seq", (Object)seq++);
                dataDeleteDim.set("dimid", (Object)dimension.getLong("dimid"));
                dataDeleteDim.set("viewid", (Object)dimension.getLong("viewid"));
                dataDeleteDim.set("dimname", (Object)dimension.getString("dimname"));
                dataDeleteDim.set("dimnumber", (Object)dimension.getString("dimnumber"));
                dataDeleteDim.set("members", (Object)dimension.getString("members"));
                dataDeleteDim.set("memberscope", (Object)dimension.getString("memberscope"));
                dataDeleteDim.set("membersjson", (Object)dimension.getString("membersjson"));
                dataDeleteDims.add((Object)dataDeleteDim);
            }
        }
        this.sendMessageToApprover(this.getApproverId(), String.valueOf(id));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datadelete});
        this.writeLog("delete", new MultiLangEnumBridge("\u6570\u636e\u5220\u9664", "DataDelete_11", "epm-eb-formplugin"), new MultiLangEnumBridge("\u63d0\u4ea4\u6570\u636e\u5220\u9664\u8bf7\u6c42", "DataDelete_21", "epm-eb-formplugin"));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"DataDelete_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private Long getApproverId() {
        return 1L;
    }

    protected void loadDimension(DynamicObject dataset) {
        IModelCacheHelper modelCacheHelper;
        List dimensions;
        IDataModel dataModel = this.getModel();
        dataModel.beginInit();
        dataModel.deleteEntryData("dimensions");
        if (dataset != null && (dimensions = (modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId())).getDimensionList(Long.valueOf(dataset.getLong("id")))) != null) {
            DataDeletePlugin.cacheDimension1(this.getPageCache(), dimensions);
            int[] rows = dataModel.batchCreateNewEntryRow("dimensions", dimensions.size());
            int in = rows.length;
            for (int i = 0; i < in; ++i) {
                Dimension dimension = (Dimension)dimensions.get(i);
                dataModel.setValue("dimid", (Object)dimension.getId(), rows[i]);
                dataModel.setValue("dimname", (Object)dimension.getName(), rows[i]);
                dataModel.setValue("dimnumber", (Object)dimension.getNumber(), rows[i]);
            }
            this.setCustomDimColumnTitle(dimensions);
        }
        dataModel.endInit();
        this.getView().updateView("dimensions");
    }

    private void setCustomDimColumnTitle(List<Dimension> dimensions) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int customdimNum = 1;
        IFormView view = this.getView();
        for (String value : fieldIndexMap.values()) {
            view.setVisible(Boolean.valueOf(false), new String[]{value});
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"userdefined1", "userdefined2", "userdefined3", "userdefined4", "userdefined5", "userdefined6", "userdefined7", "userdefined8"});
        for (Dimension dimension : dimensions) {
            if (!dimension.isPreset()) {
                String fieldKey = "userdefined" + customdimNum;
                view.setVisible(Boolean.valueOf(true), new String[]{fieldKey});
                entryGrid.setColumnProperty(fieldKey, "header", (Object)new LocaleString(dimension.getName()));
                ++customdimNum;
                continue;
            }
            view.setVisible(Boolean.valueOf(true), new String[]{fieldIndexMap.get(dimension.getNumber())});
        }
    }

    public static void cacheDimension1(IPageCache pageCache, List<Dimension> dimensions) {
        if (pageCache == null) {
            return;
        }
        pageCache.remove(CACHE_DIMENSION);
        if (dimensions == null || dimensions.isEmpty()) {
            return;
        }
        HashMap dimensionMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
        for (Dimension dimension : dimensions) {
            dimensionMap.put(dimension.getNumber(), dimension.getId());
        }
        pageCache.put(CACHE_DIMENSION, SerializationUtils.toJsonString((Object)dimensionMap));
    }

    protected Map<String, List<String>> getMemberNums() {
        return DataDeletePlugin.getMemberNums(this.getModel());
    }

    public static Map<String, List<String>> getMemberNums(IDataModel dataModel) {
        HashMap<String, List<String>> memberMap = new HashMap<String, List<String>>(16);
        DynamicObjectCollection dimensions = dataModel.getEntryEntity("dimensions");
        if (dimensions != null) {
            for (DynamicObject dimension : dimensions) {
                String json = dimension.getString("membersjson");
                if (!kd.bos.util.StringUtils.isNotEmpty((String)json)) continue;
                List members = (List)JSON.parse((String)json);
                memberMap.put(dimension.getString("dimnumber"), members);
            }
        }
        return memberMap;
    }

    public String getBizCtrlRangeKey() {
        return "busmodel";
    }

    public String getBizModelKey() {
        return "dataset";
    }

    public void afterSetBgDefaultField() {
        super.afterSetBgDefaultField();
        this.loadDimension(this.getDataset());
        this.clearEntry();
    }

    static {
        fieldIndexMap.put(SysDimensionEnum.Entity.getNumber(), "orgunit");
        fieldIndexMap.put(SysDimensionEnum.Account.getNumber(), "account");
        fieldIndexMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), "period");
        fieldIndexMap.put(SysDimensionEnum.Version.getNumber(), "version");
        fieldIndexMap.put(SysDimensionEnum.Currency.getNumber(), "currency");
        fieldIndexMap.put(SysDimensionEnum.DataType.getNumber(), "datatype");
        fieldIndexMap.put(SysDimensionEnum.ChangeType.getNumber(), "changetype");
        fieldIndexMap.put(SysDimensionEnum.AuditTrail.getNumber(), "audittrail");
        fieldIndexMap.put(SysDimensionEnum.Metric.getNumber(), "metric");
        fieldIndexMap.put(SysDimensionEnum.InternalCompany.getNumber(), "internalcompany");
    }
}

