/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.dataintegration.plugin;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.dataintegration.entity.IntegrationSchemeBaseInfo;
import kd.epm.eb.business.dataintegration.service.DataIntegrationQueryService;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dataintegration.DataIntegrationGetValType;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public abstract class AbstractDataIntegrationPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    protected static final String DATASET_KEY = "datasetid";
    protected static final String BIZMODEL_KEY = "bizmodel";
    protected static final String MODEL_KEY = "modelid";
    protected static final String INTER_RANGE_ENTRY = "interangeentry";
    protected static final String BASE_INFO_FLEX = "flexpanelap1";
    protected Map<String, Set<Long>> dimToDimMappingIdMap = new HashMap<String, Set<Long>>(16);
    protected Map<String, Long> interRangeMemberViewMap = new HashMap<String, Long>(16);

    public void initialize() {
        super.initialize();
        EntryGrid interRangeEntryGrid = (EntryGrid)this.getControl(INTER_RANGE_ENTRY);
        interRangeEntryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7SelectListener(this, new String[]{DATASET_KEY, this.getDimMappingFieldKey()});
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"rangememrange"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initBaseInfo();
    }

    private void initBaseInfo() {
        IntegrationSchemeBaseInfo baseInfo = (IntegrationSchemeBaseInfo)ObjectSerialUtil.deSerializedBytes((String)((String)this.getCustomFormParam("baseInfo")));
        this.getModel().setValue(BIZMODEL_KEY, this.getCustomFormParam("bizModelId"));
        this.getModel().setValue(MODEL_KEY, this.getCustomFormParam("modelId"));
        this.getModel().setValue("executescheme", (Object)IDUtils.toLong((Object)this.getCustomFormParam("executeSchemeId")));
        this.getModel().setValue(DATASET_KEY, (Object)this.getDefaultDataSetId());
        this.getModel().setValue("type", (Object)baseInfo.getIntegrationType().getVal());
        this.getModel().setValue("number", (Object)baseInfo.getNumber());
        this.getModel().setValue("name", (Object)baseInfo.getName());
        if (this.getDataIntegrationType() == DataIntegrationType.INPUT) {
            this.getModel().setValue("schemetype", (Object)baseInfo.getSchemeType().getVal());
        }
        this.getModel().setValue("status", (Object)baseInfo.getStatus());
    }

    public Long getDefaultDataSetId() {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dataset", (String)"id", (QFilter[])new QFilter("businessmodel", "=", (Object)this.getBizModelId()).toArray(), (String)"createdate, number");
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            return ((DynamicObject)query.get(0)).getLong("id");
        }
        return 0L;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BASE_INFO_FLEX});
        this.getView().setVisible(Boolean.valueOf(!this.isNewEbForm()), new String[]{DATASET_KEY});
        this.interRangeEntryBindData();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_baseinfo".equals(itemKey)) {
            this.openBaseInfoPage();
        }
    }

    protected void openBaseInfoPage() {
        DataIntegrationType integrationType = this.getDataIntegrationType();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_integration_baseinfo");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IntegrationSchemeBaseInfo baseInfo = new IntegrationSchemeBaseInfo();
        baseInfo.setIntegrationType(integrationType);
        baseInfo.setNumber((String)this.getModel().getValue("number"));
        baseInfo.setName((OrmLocaleValue)this.getModel().getValue("name"));
        baseInfo.setStatus(((Boolean)this.getModel().getValue("status")).booleanValue());
        if (integrationType == DataIntegrationType.INPUT) {
            baseInfo.setSchemeType(IntegrationSchemeType.getTypeByVal((String)((String)this.getModel().getValue("schemetype"))));
            showParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u91c7\u96c6\u65b9\u6848", (String)"DataIntegrationBasePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8f93\u51fa\u65b9\u6848", (String)"DataIntegrationOutPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        showParameter.setCustomParam("baseInfo", (Object)ObjectSerialUtil.toByteSerialized((Object)baseInfo));
        showParameter.setCustomParam("type", (Object)integrationType.getVal());
        showParameter.setCustomParam("source", (Object)"scheme");
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "baseInfoCloseCallBack"));
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String backKey = event.getActionId();
        if ("interRangeMemRangeSelectCloseBack".equals(backKey)) {
            this.interRangeMemRangeSelectCloseBack(event);
        } else if ("baseInfoCloseCallBack".equals(backKey)) {
            this.baseInfoCloseCallBack(event);
        }
    }

    protected void baseInfoCloseCallBack(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        if (returnData instanceof IntegrationSchemeBaseInfo) {
            IntegrationSchemeBaseInfo baseInfo = (IntegrationSchemeBaseInfo)returnData;
            this.getModel().setValue("number", (Object)baseInfo.getNumber());
            this.getModel().setValue("name", (Object)baseInfo.getName());
            this.getModel().setValue("status", (Object)baseInfo.getStatus());
        }
    }

    private void interRangeMemRangeSelectCloseBack(ClosedCallBackEvent event) {
        if (event.getReturnData() instanceof DynamicObjectCollection) {
            DynamicObjectCollection returnData = (DynamicObjectCollection)event.getReturnData();
            ArrayList<MemberCondition> conditions = new ArrayList<MemberCondition>(10);
            for (DynamicObject returnDatum : returnData) {
                Long id = returnDatum.getLong("mid");
                int scope = returnDatum.getInt("scope");
                String name = returnDatum.getString("name");
                String number = returnDatum.getString("number");
                String viewId = returnDatum.getString("viewid");
                MemberCondition memberCondition = new MemberCondition(id, number, name, "", String.valueOf(scope));
                memberCondition.setViewId(viewId);
                conditions.add(memberCondition);
            }
            this.getModel().setValue("rangememrange", (Object)((Object)conditions).toString());
            this.getModel().setValue("rangememrangejson", (Object)SerializationUtils.toJsonString(conditions));
        }
    }

    protected void checkInterRangeInfo() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INTER_RANGE_ENTRY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject object : entryEntity) {
                String dimNum = object.getString("rangedimnum");
                String way = object.getString("rangegetvalway");
                String memRange = object.getString("rangememrangejson");
                if (!DataIntegrationGetValType.SCHEME.getVal().equals(way)) continue;
                if (StringUtils.isEmpty((String)memRange)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u96c6\u6210\u8303\u56f4\u5206\u5f55\u4fe1\u606f\u5b58\u5728\u6309\u91c7\u96c6\u65b9\u6848\u53d6\u503c\u7684\u7ef4\u5ea6\u672a\u6307\u5b9a\u6210\u5458\u8303\u56f4\u3002", (String)"DataIntegrationBasePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (View.NoViewDimNums.contains(dimNum)) continue;
                List members = (List)ObjectSerialUtil.parseObject((String)memRange, (TypeReference)new TypeReference<List<MemberCondition>>(){}, (Feature[])new Feature[0]);
                this.interRangeMemberViewMap.put(dimNum, IDUtils.toLong((Object)((MemberCondition)members.get(0)).getViewId()));
            }
        }
    }

    protected void checkDimView() {
        if (this.dimToDimMappingIdMap.isEmpty()) {
            return;
        }
        IModelCacheHelper cacheHelper = this.getIModelCacheHelper();
        Map viewGroupViewsMap = cacheHelper.getViewGroupViewsByBusModel(this.getBizModelId());
        Map dimMappingViewMap = DataIntegrationQueryService.getInstance().getDimMappingView(this.dimToDimMappingIdMap, cacheHelper);
        for (Map.Entry entry : dimMappingViewMap.entrySet()) {
            String dimNumber = (String)entry.getKey();
            Set viewIds = (Set)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)viewIds)) continue;
            String dimName = cacheHelper.getDimension(dimNumber).getName();
            if (viewIds.size() > 1) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u7684\u9009\u62e9\u7684\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u7684\u89c6\u56fe\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GLDataIntegrationPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{dimName}));
            }
            Long viewId = (Long)viewIds.iterator().next();
            if (viewGroupViewsMap.get(dimNumber) == null || !((List)viewGroupViewsMap.get(dimNumber)).contains(viewId)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u7684\u9009\u62e9\u7684\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u7684\u89c6\u56fe\u4e0d\u5728\u5f53\u524d\u65b9\u6848\u4e1a\u52a1\u6a21\u578b\u7684\u89c6\u56fe\u7ec4\u5185\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GLDataIntegrationPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{dimName}));
            }
            if (!this.interRangeMemberViewMap.containsKey(dimNumber) || IDUtils.equals((Object)this.interRangeMemberViewMap.get(dimNumber), (Object)viewId)) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u7684\u9009\u62e9\u7684\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u4e0e\u96c6\u6210\u8303\u56f4\u6240\u9009\u6210\u5458\u7684\u89c6\u56fe\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GLDataIntegrationPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[]{dimName}));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if ("rangememrange".equals(sourceKey)) {
            this.interRangeMemRangeSelect();
        }
    }

    protected void interRangeMemRangeSelect() {
        String getValWay = (String)this.getModel().getValue("rangegetvalway");
        if (DataIntegrationGetValType.CONDITION.getVal().equals(getValWay)) {
            return;
        }
        String dimNum = (String)this.getModel().getValue("rangedimnum");
        if (StringUtils.isEmpty((String)dimNum)) {
            return;
        }
        Long dimView = this.getDimMappingEntryView(dimNum);
        String memRangeJson = (String)this.getModel().getValue("rangememrangejson");
        Long bizModelId = this.getBizModelId();
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        Long viewId = (Long)modelCache.getViewsByBusModelIncludeBase(bizModelId).get(dimNum);
        RangeF7Param param = new RangeF7Param();
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "interRangeMemRangeSelectCloseBack"));
        param.setNeedPermCheck(true);
        param.setBizModelId(bizModelId);
        param.setDatasetId(Long.valueOf(this.getDatasetId()));
        param.setEnableView(IDUtils.isNull((Long)dimView));
        EASDataIntegrationUtil.setF7PermParam((RangeF7Param)param, (Long)modelCache.getModelobj().getId(), (boolean)this.isInput());
        if (StringUtils.isNotEmpty((String)memRangeJson)) {
            List memberConditions = (List)ObjectSerialUtil.parseObject((String)memRangeJson, (TypeReference)new TypeReference<List<MemberCondition>>(){}, (Feature[])new Feature[0]);
            if (CollectionUtils.isNotEmpty((Collection)memberConditions)) {
                String viewId1 = ((MemberCondition)memberConditions.get(0)).getViewId();
                viewId = IDUtils.toLong((Object)viewId1);
            }
            param.setCon_list(memberConditions);
        }
        CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)dimNum, (Long)(IDUtils.isNull((Long)dimView) ? viewId : dimView), (IFormView)this.getView(), (RangeF7Param)param);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propKey = event.getProperty().getName();
        ListFilterParameter filterParameter = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter();
        if (DATASET_KEY.equals(propKey)) {
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId()).and("businessmodel", "=", (Object)this.getBizModelId());
            filterParameter.getQFilters().add(qFilter);
        } else if (this.getDimMappingFieldKey().equals(propKey)) {
            this.dimMemMappingBeforeF7(event);
        }
    }

    protected void dimMemMappingBeforeF7(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        BasedataEdit dimMappingControl = (BasedataEdit)this.getControl(this.getDimMappingFieldKey());
        if (dimMappingControl == null) {
            return;
        }
        QFilter dimMappingFilter = this.getDimMappingFilter();
        if (dimMappingFilter == null) {
            event.setCancel(true);
            return;
        }
        ArrayList<QFilter> qFilters = dimMappingControl.getQFilters();
        if (qFilters == null) {
            qFilters = new ArrayList<QFilter>(16);
        }
        qFilters.add(dimMappingFilter);
        showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("rangegetvalway".equals(propName)) {
            this.getValWayChanged();
        } else if ("rangememrange".equals(propName)) {
            this.interRangeMemberScopeChange();
        } else if (DATASET_KEY.equals(propName)) {
            this.getOrCacheDataSetDimNums(this.getDatasetId());
        }
    }

    protected void interRangeMemberScopeChange() {
        String value = (String)this.getModel().getValue("rangememrange");
        if (StringUtils.isEmpty((String)value)) {
            this.getModel().setValue("rangememrangejson", null);
        }
    }

    protected void getValWayChanged() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(INTER_RANGE_ENTRY);
        int focusRow = entryGrid.getEntryState().getFocusRow();
        Object value = this.getModel().getValue("rangegetvalway", focusRow);
        this.getModel().beginInit();
        if (DataIntegrationGetValType.CONDITION.getVal().equals(value)) {
            this.getModel().setValue("rangememrange", (Object)ResManager.loadKDString((String)"\u6267\u884c\u65f6\u9009\u62e9\u6b64\u7ef4\u5ea6\u8303\u56f4", (String)"DataIntegrationBasePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), focusRow);
            this.getModel().setValue("rangememrangejson", null);
        } else {
            this.getModel().setValue("rangememrange", null, focusRow);
        }
        this.getModel().endInit();
        this.getView().updateView(INTER_RANGE_ENTRY);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        String entryKey = entryGrid.getEntryKey();
        if (INTER_RANGE_ENTRY.equals(entryKey)) {
            this.interRangeEntryBindData();
        }
    }

    protected void interRangeEntryBindData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INTER_RANGE_ENTRY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            int row = 0;
            for (DynamicObject object : entryEntity) {
                String way = object.getString("rangegetvalway");
                this.getView().setEnable(Boolean.valueOf(DataIntegrationGetValType.SCHEME.getVal().equals(way)), row++, new String[]{"rangememrange"});
            }
        }
    }

    protected void updateIntegrationRangeEntry(boolean dataSetChanged) {
        List<Dimension> dimensions = this.getIntegrationRangeDimensions();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INTER_RANGE_ENTRY);
        HashMap<String, DynamicObject> previousData = new HashMap<String, DynamicObject>(16);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject object : entryEntity) {
                String dimNumber = object.getString("rangedimnum");
                if (StringUtils.isEmpty((String)dimNumber)) continue;
                previousData.put(dimNumber, object);
            }
        }
        this.getModel().deleteEntryData(INTER_RANGE_ENTRY);
        this.getModel().beginInit();
        if (CollectionUtils.isNotEmpty(dimensions)) {
            int[] index = this.getModel().batchCreateNewEntryRow(INTER_RANGE_ENTRY, dimensions.size());
            int i = 0;
            for (Dimension dimension : dimensions) {
                String dimNumber = dimension.getNumber();
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(INTER_RANGE_ENTRY, index[i++]);
                rowEntity.set("rangedimid", (Object)dimension.getId());
                rowEntity.set("rangedimnum", (Object)dimNumber);
                rowEntity.set("rangedimname", (Object)dimension.getName());
                boolean isDataSetChangedAccountDim = dataSetChanged && "Account".equals(dimNumber);
                DynamicObject object = (DynamicObject)previousData.get(dimNumber);
                if (object != null && !isDataSetChangedAccountDim) {
                    String way = object.getString("rangegetvalway");
                    rowEntity.set("rangegetvalway", (Object)way);
                    if (DataIntegrationGetValType.CONDITION.getVal().equals(way)) {
                        rowEntity.set("rangememrange", (Object)ResManager.loadKDString((String)"\u6267\u884c\u65f6\u9009\u62e9\u6b64\u7ef4\u5ea6\u8303\u56f4", (String)"DataIntegrationBasePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    String memRangeJson = object.getString("rangememrangejson");
                    if (StringUtils.isNotEmpty((String)memRangeJson)) {
                        List members = (List)ObjectSerialUtil.parseObject((String)memRangeJson, (TypeReference)new TypeReference<List<MemberCondition>>(){}, (Feature[])new Feature[0]);
                        rowEntity.set("rangememrange", (Object)members.toString());
                    }
                    rowEntity.set("rangememrangejson", (Object)memRangeJson);
                    continue;
                }
                rowEntity.set("rangememrange", (Object)ResManager.loadKDString((String)"\u6267\u884c\u65f6\u9009\u62e9\u6b64\u7ef4\u5ea6\u8303\u56f4", (String)"DataIntegrationBasePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        this.getModel().endInit();
        this.getView().updateView(INTER_RANGE_ENTRY);
    }

    protected void clearIntegrationRangeEntryWhenViewChange(String dimNum, Long viewId) {
        if (StringUtils.isEmpty((String)dimNum)) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INTER_RANGE_ENTRY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        DynamicObject dynamicObject = null;
        for (DynamicObject object : entryEntity) {
            if (!dimNum.equals(object.getString("rangedimnum"))) continue;
            dynamicObject = object;
            break;
        }
        if (dynamicObject != null) {
            String viewId1;
            List members;
            String way = dynamicObject.getString("rangegetvalway");
            if (DataIntegrationGetValType.CONDITION.getVal().equals(way)) {
                return;
            }
            String memRangeJson = dynamicObject.getString("rangememrangejson");
            if (StringUtils.isNotEmpty((String)memRangeJson) && CollectionUtils.isNotEmpty((Collection)(members = (List)ObjectSerialUtil.parseObject((String)memRangeJson, (TypeReference)new TypeReference<List<MemberCondition>>(){}, (Feature[])new Feature[0]))) && !IDUtils.toLong((Object)(viewId1 = ((MemberCondition)members.get(0)).getViewId())).equals(viewId)) {
                dynamicObject.set("rangememrangejson", null);
                dynamicObject.set("rangememrange", null);
            }
        }
        this.getView().updateView(INTER_RANGE_ENTRY);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(Boolean.FALSE.booleanValue());
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operation;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "save".equals(operation = ((FormOperate)args.getSource()).getOperateKey())) {
            try {
                this.beforeDoSave();
            }
            catch (Exception e) {
                this.getView().showTipNotification(e.getMessage());
                args.setCancel(true);
                log.error(CommonServiceHelper.getStackTraceStr((Throwable)e));
            }
        }
    }

    protected void beforeDoSave() {
        this.checkDataSetDimDeleted();
        this.checkNumberName();
    }

    protected void checkDataSetDimDeleted() {
        long datasetId = this.getDatasetId();
        if (IDUtils.isEmptyLong((Long)datasetId).booleanValue()) {
            return;
        }
        Set<String> cacheDataSetDimNums = this.getOrCacheDataSetDimNums(null);
        if (CollectionUtils.isEmpty(cacheDataSetDimNums)) {
            return;
        }
        Map dimensionMap = this.getIModelCacheHelper().getDimensionMap(Long.valueOf(datasetId));
        for (String cacheDataSetDimNum : cacheDataSetDimNums) {
            if (dimensionMap.containsKey(cacheDataSetDimNum)) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u5728\u6570\u636e\u96c6\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u96c6\u5237\u65b0\u754c\u9762\u6216\u9000\u51fa\u540e\u91cd\u8fdb\u3002", (String)"DataIntegrationBasePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{cacheDataSetDimNum}));
        }
    }

    protected Set<String> getOrCacheDataSetDimNums(Long dataSetId) {
        if (dataSetId != null) {
            if (IDUtils.isEmptyLong((Long)dataSetId).booleanValue()) {
                this.getPageCache().put("dataSetDimNumsCache", SerializationUtils.serializeToBase64(new HashSet(0)));
            } else {
                HashSet dataSetDimNums = new HashSet(this.getIModelCacheHelper().getDimensionMap(dataSetId).keySet());
                this.getPageCache().put("dataSetDimNumsCache", SerializationUtils.serializeToBase64(dataSetDimNums));
            }
        } else {
            String dataSetDimNumsCache = this.getPageCache().get("dataSetDimNumsCache");
            if (StringUtils.isNotEmpty((String)dataSetDimNumsCache)) {
                return (Set)SerializationUtils.deSerializeFromBase64((String)dataSetDimNumsCache);
            }
        }
        return new HashSet<String>(0);
    }

    protected void checkNumberName() {
        boolean exists;
        String number = (String)this.getModel().getValue("number");
        String checkNumber = NumberCheckUtils.checkNumberRule((String)number);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)checkNumber)) {
            throw new KDBizException(checkNumber);
        }
        Long id = (Long)this.getModel().getValue("id");
        QFilter qf = new QFilter("number", "=", (Object)number);
        qf.and(new QFilter("modelid.id", "=", (Object)this.getModelId()));
        if (id != null && id > 0L) {
            qf.and(new QFilter("id", "!=", (Object)id));
        }
        if (exists = QueryServiceHelper.exists((String)"eb_integration", (QFilter[])qf.toArray())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7f16\u7801\u3002", (String)"DataIntegrationBasePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (name == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)name.getLocaleValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u3002", (String)"DataIntegrationBasePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected <T> T getPropValueOfF7Obj(String f7Key, String propName) {
        DynamicObject f7Obj = (DynamicObject)this.getModel().getValue(f7Key);
        if (f7Obj == null) {
            throw new KDBizException("value of " + f7Key + " is null\u3002");
        }
        Object val = f7Obj.get(propName);
        return (T)val;
    }

    @Override
    public Long getModelId() {
        DynamicObject modelObj = (DynamicObject)this.getModel().getValue(MODEL_KEY);
        if (modelObj != null) {
            return modelObj.getLong("id");
        }
        return 0L;
    }

    public String getBizModelKey() {
        return BIZMODEL_KEY;
    }

    public Long getBizModelId() {
        DynamicObject object = (DynamicObject)this.getModel().getValue(BIZMODEL_KEY);
        if (object != null) {
            return object.getLong("id");
        }
        return 0L;
    }

    protected long getDatasetId() {
        DynamicObject datasetObj = (DynamicObject)this.getModel().getValue(DATASET_KEY);
        if (datasetObj != null) {
            return datasetObj.getLong("id");
        }
        return 0L;
    }

    abstract List<Dimension> getIntegrationRangeDimensions();

    abstract DataIntegrationType getDataIntegrationType();

    abstract QFilter getDimMappingFilter();

    abstract String getDimMappingFieldKey();

    abstract String getDimMappingEntryKey();

    abstract Long getDimMappingEntryView(String var1);

    abstract Long getpointTarEntryView(String var1);

    protected boolean isInput() {
        return this.getDataIntegrationType() == DataIntegrationType.INPUT;
    }
}

